/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands.stream;

import glide.api.models.GlideString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;

public abstract class StreamTrimOptions {
    public static final String TRIM_MAXLEN_VALKEY_API = "MAXLEN";
    public static final String TRIM_MINID_VALKEY_API = "MINID";
    public static final String TRIM_EXACT_VALKEY_API = "=";
    public static final String TRIM_NOT_EXACT_VALKEY_API = "~";
    public static final String TRIM_LIMIT_VALKEY_API = "LIMIT";
    protected Boolean exact;
    protected Long limit;

    protected abstract String getMethod();

    protected abstract String getThreshold();

    protected List<String> getValkeyApi() {
        ArrayList<String> optionArgs = new ArrayList<String>();
        optionArgs.add(this.getMethod());
        if (this.exact != null) {
            optionArgs.add(this.exact != false ? TRIM_EXACT_VALKEY_API : TRIM_NOT_EXACT_VALKEY_API);
        }
        optionArgs.add(this.getThreshold());
        if (this.limit != null) {
            optionArgs.add(TRIM_LIMIT_VALKEY_API);
            optionArgs.add(this.limit.toString());
        }
        return optionArgs;
    }

    public String[] toArgs() {
        ArrayList<String> optionArgs = new ArrayList<String>();
        if (this.getValkeyApi() != null) {
            optionArgs.addAll(this.getValkeyApi());
        }
        return optionArgs.toArray(new String[0]);
    }

    public GlideString[] toGlideStringArgs() {
        return (GlideString[])Arrays.stream(this.toArgs()).map(GlideString::gs).toArray(GlideString[]::new);
    }

    public static class MaxLen
    extends StreamTrimOptions {
        private final Long threshold;

        public MaxLen(long threshold) {
            this.threshold = threshold;
        }

        public MaxLen(boolean exact, long threshold) {
            this.threshold = threshold;
            this.exact = exact;
        }

        public MaxLen(long threshold, long limit) {
            this.exact = false;
            this.threshold = threshold;
            this.limit = limit;
        }

        @Override
        protected String getMethod() {
            return StreamTrimOptions.TRIM_MAXLEN_VALKEY_API;
        }

        @Override
        protected String getThreshold() {
            return this.threshold.toString();
        }
    }

    public static class MinId
    extends StreamTrimOptions {
        private final String threshold;

        public MinId(@NonNull String threshold) {
            if (threshold == null) {
                throw new NullPointerException("threshold is marked non-null but is null");
            }
            this.threshold = threshold;
        }

        public MinId(@NonNull GlideString threshold) {
            if (threshold == null) {
                throw new NullPointerException("threshold is marked non-null but is null");
            }
            this.threshold = threshold.getString();
        }

        public MinId(boolean exact, @NonNull String threshold) {
            if (threshold == null) {
                throw new NullPointerException("threshold is marked non-null but is null");
            }
            this.threshold = threshold;
            this.exact = exact;
        }

        public MinId(boolean exact, @NonNull GlideString threshold) {
            if (threshold == null) {
                throw new NullPointerException("threshold is marked non-null but is null");
            }
            this.threshold = threshold.getString();
            this.exact = exact;
        }

        public MinId(@NonNull String threshold, long limit) {
            if (threshold == null) {
                throw new NullPointerException("threshold is marked non-null but is null");
            }
            this.exact = false;
            this.threshold = threshold;
            this.limit = limit;
        }

        public MinId(@NonNull GlideString threshold, long limit) {
            if (threshold == null) {
                throw new NullPointerException("threshold is marked non-null but is null");
            }
            this.exact = false;
            this.threshold = threshold.getString();
            this.limit = limit;
        }

        @Override
        protected String getMethod() {
            return StreamTrimOptions.TRIM_MINID_VALKEY_API;
        }

        @Override
        protected String getThreshold() {
            return this.threshold;
        }
    }
}

