/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models;

import glide.api.models.GlideString;
import glide.ffi.resolvers.ScriptResolver;
import lombok.Generated;

public class Script
implements AutoCloseable {
    private final String hash;
    private final Boolean binaryOutput;
    private boolean dropped = false;

    public <T> Script(T code, Boolean binaryOutput) {
        this.hash = ScriptResolver.storeScript(GlideString.of(code).getBytes());
        this.binaryOutput = binaryOutput;
    }

    @Override
    public void close() throws Exception {
        if (!this.dropped) {
            ScriptResolver.dropScript(this.hash);
            this.dropped = true;
        }
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @Generated
    public Boolean getBinaryOutput() {
        return this.binaryOutput;
    }
}

