/*
 * Decompiled with CFR 0.152.
 */
package glide.api;

import glide.api.logging.Logger;
import glide.api.models.exceptions.ConfigurationError;
import glide.ffi.resolvers.OpenTelemetryResolver;
import java.util.Random;

public class OpenTelemetry {
    private static OpenTelemetry openTelemetry = null;
    private static OpenTelemetryConfig openTelemetryConfig = null;
    private static final Random random = new Random();

    public static synchronized void init(OpenTelemetryConfig config) {
        if (openTelemetry == null) {
            OpenTelemetry.internalInit(config);
            Logger.log(Logger.Level.INFO, "GlideOpenTelemetry", "OpenTelemetry initialized");
            return;
        }
        Logger.log(Logger.Level.WARN, "GlideOpenTelemetry", "OpenTelemetry already initialized");
    }

    private static void internalInit(OpenTelemetryConfig config) {
        long flushIntervalMs;
        int rc;
        openTelemetryConfig = config;
        String tracesEndpoint = null;
        int tracesSamplePercentage = -1;
        if (config.getTraces() == null && config.getMetrics() == null) {
            Logger.log(Logger.Level.INFO, "GlideOpenTelemetry", "Error: Both traces and metrics are null");
            throw new ConfigurationError("At least one of traces or metrics must be provided");
        }
        TracesConfig tracesConfig = config.getTraces();
        if (tracesConfig != null) {
            tracesEndpoint = tracesConfig.getEndpoint();
            if (tracesConfig.getSamplePercentage() != null) {
                tracesSamplePercentage = tracesConfig.getSamplePercentage();
            }
        }
        String metricsEndpoint = null;
        MetricsConfig metricsConfig = config.getMetrics();
        if (metricsConfig != null) {
            metricsEndpoint = metricsConfig.getEndpoint();
        }
        if ((rc = OpenTelemetryResolver.initOpenTelemetry(tracesEndpoint, tracesSamplePercentage, metricsEndpoint, flushIntervalMs = config.getFlushIntervalMs() != null ? config.getFlushIntervalMs() : 5000L)) != 0) {
            String msg;
            switch (rc) {
                case 1: {
                    msg = "Missing configuration";
                    break;
                }
                case 2: 
                case 3: {
                    msg = "Parse error";
                    break;
                }
                default: {
                    msg = "OpenTelemetry initialization failure";
                }
            }
            throw new ConfigurationError(msg);
        }
        openTelemetry = new OpenTelemetry();
    }

    public static boolean isInitialized() {
        return openTelemetry != null;
    }

    public static Integer getSamplePercentage() {
        if (openTelemetryConfig != null && openTelemetryConfig.getTraces() != null) {
            return openTelemetryConfig.getTraces().getSamplePercentage();
        }
        return null;
    }

    public static boolean shouldSample() {
        Integer percentage = OpenTelemetry.getSamplePercentage();
        return OpenTelemetry.isInitialized() && percentage != null && random.nextDouble() * 100.0 < (double)percentage.intValue();
    }

    public static void setSamplePercentage(int percentage) {
        if (openTelemetryConfig == null || OpenTelemetry.openTelemetryConfig.traces == null) {
            throw new ConfigurationError("OpenTelemetry config traces not initialized");
        }
        openTelemetryConfig.updateSamplePercentage(percentage);
    }

    public static class MetricsConfig {
        private String endpoint;

        public static Builder builder() {
            return new Builder();
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        MetricsConfig copy() {
            MetricsConfig clone = new MetricsConfig();
            clone.endpoint = this.endpoint;
            return clone;
        }

        public static class Builder {
            private String endpoint;

            public Builder endpoint(String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            public MetricsConfig build() {
                MetricsConfig config = new MetricsConfig();
                config.endpoint = this.endpoint;
                return config;
            }
        }
    }

    public static class TracesConfig {
        private String endpoint;
        private Integer samplePercentage;

        public static Builder builder() {
            return new Builder();
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public Integer getSamplePercentage() {
            return this.samplePercentage;
        }

        void setSamplePercentage(Integer samplePercentage) {
            if (samplePercentage < 0 || samplePercentage > 100) {
                throw new ConfigurationError("Sample percentage must be between 0 and 100");
            }
            this.samplePercentage = samplePercentage;
        }

        TracesConfig copy() {
            TracesConfig clone = new TracesConfig();
            clone.endpoint = this.endpoint;
            clone.samplePercentage = this.samplePercentage;
            return clone;
        }

        public static class Builder {
            private String endpoint;
            private Integer samplePercentage = 1;

            public Builder endpoint(String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            public Builder samplePercentage(Integer samplePercentage) {
                this.samplePercentage = samplePercentage;
                return this;
            }

            public TracesConfig build() {
                TracesConfig config = new TracesConfig();
                config.endpoint = this.endpoint;
                config.samplePercentage = this.samplePercentage;
                return config;
            }
        }
    }

    public static class OpenTelemetryConfig {
        private TracesConfig traces;
        private MetricsConfig metrics;
        private Long flushIntervalMs;

        public static Builder builder() {
            return new Builder();
        }

        public TracesConfig getTraces() {
            return this.traces == null ? null : this.traces.copy();
        }

        public MetricsConfig getMetrics() {
            return this.metrics == null ? null : this.metrics.copy();
        }

        public Long getFlushIntervalMs() {
            return this.flushIntervalMs;
        }

        private void updateSamplePercentage(int samplePercentage) {
            if (this.traces == null) {
                throw new ConfigurationError("Traces configuration is not initialized");
            }
            TracesConfig updated = this.traces.copy();
            updated.setSamplePercentage(samplePercentage);
            this.traces = updated;
        }

        public static class Builder {
            private TracesConfig traces;
            private MetricsConfig metrics;
            private Long flushIntervalMs = 5000L;

            public Builder traces(TracesConfig traces) {
                this.traces = traces != null ? traces.copy() : null;
                return this;
            }

            public Builder metrics(MetricsConfig metrics) {
                this.metrics = metrics != null ? metrics.copy() : null;
                return this;
            }

            public Builder flushIntervalMs(Long flushIntervalMs) {
                this.flushIntervalMs = flushIntervalMs;
                return this;
            }

            public OpenTelemetryConfig build() {
                OpenTelemetryConfig config = new OpenTelemetryConfig();
                config.traces = this.traces != null ? this.traces.copy() : null;
                config.metrics = this.metrics != null ? this.metrics.copy() : null;
                config.flushIntervalMs = this.flushIntervalMs;
                return config;
            }
        }
    }
}

