/*
 * Decompiled with CFR 0.152.
 */
package glide.utils;

import glide.api.models.GlideString;
import glide.api.models.commands.geospatial.GeospatialData;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ArrayTransformUtils {
    public static String[] convertMapToKeyValueStringArray(Map<String, ?> args) {
        return (String[])args.entrySet().stream().flatMap(entry -> Stream.of(entry.getKey(), entry.getValue())).toArray(String[]::new);
    }

    public static GlideString[] convertMapToKeyValueGlideStringArray(Map<GlideString, GlideString> args) {
        return (GlideString[])args.entrySet().stream().flatMap(entry -> Stream.of((GlideString)entry.getKey(), (GlideString)entry.getValue())).toArray(GlideString[]::new);
    }

    public static String[] convertNestedArrayToKeyValueStringArray(String[][] args) {
        for (String[] entry2 : args) {
            if (entry2.length == 2) continue;
            throw new IllegalArgumentException("Array entry had the wrong length. Expected length 2 but got length " + entry2.length);
        }
        return (String[])Arrays.stream(args).flatMap(entry -> Stream.of(entry[0], entry[1])).toArray(String[]::new);
    }

    public static GlideString[] convertNestedArrayToKeyValueGlideStringArray(GlideString[][] args) {
        for (GlideString[] entry2 : args) {
            if (entry2.length == 2) continue;
            throw new IllegalArgumentException("Array entry had the wrong length. Expected length 2 but got length " + entry2.length);
        }
        return (GlideString[])Arrays.stream(args).flatMap(entry -> Stream.of(entry[0], entry[1])).toArray(GlideString[]::new);
    }

    public static String[] convertMapToValueKeyStringArray(Map<String, Double> args) {
        return (String[])args.entrySet().stream().flatMap(entry -> Stream.of(((Double)entry.getValue()).toString(), (String)entry.getKey())).toArray(String[]::new);
    }

    public static GlideString[] convertMapToValueKeyStringArrayBinary(Map<GlideString, Double> args) {
        return (GlideString[])args.entrySet().stream().flatMap(entry -> Stream.of(GlideString.gs(((Double)entry.getValue()).toString()), (GlideString)entry.getKey())).toArray(GlideString[]::new);
    }

    public static String[] mapGeoDataToArray(Map<String, GeospatialData> args) {
        return (String[])args.entrySet().stream().flatMap(entry -> Stream.of(Double.toString(((GeospatialData)entry.getValue()).getLongitude()), Double.toString(((GeospatialData)entry.getValue()).getLatitude()), (String)entry.getKey())).toArray(String[]::new);
    }

    public static <ArgType> GlideString[] mapGeoDataToGlideStringArray(Map<ArgType, GeospatialData> args) {
        return (GlideString[])args.entrySet().stream().flatMap(entry -> Stream.of(GlideString.of(((GeospatialData)entry.getValue()).getLongitude()), GlideString.of(((GeospatialData)entry.getValue()).getLatitude()), GlideString.of(entry.getKey()))).toArray(GlideString[]::new);
    }

    public static <T, U extends T> U[] castArray(T[] objectArr, Class<U> clazz) {
        if (objectArr == null) {
            return null;
        }
        return Arrays.stream(objectArr).map(clazz::cast).toArray(size -> (Object[])Array.newInstance(clazz, size));
    }

    public static <T, U extends T> U[][] castArrayofArrays(T[] outerObjectArr, Class<U> clazz) {
        if (outerObjectArr == null) {
            return null;
        }
        Object[] convertedArr = new Object[outerObjectArr.length];
        for (int i = 0; i < outerObjectArr.length; ++i) {
            convertedArr[i] = ArrayTransformUtils.castArray((Object[])outerObjectArr[i], clazz);
        }
        return (Object[][])ArrayTransformUtils.castArray(convertedArr, Array.newInstance(clazz, 0).getClass());
    }

    public static <U> Map<String, Object> convertKeyValueArrayToMap(Object[] outerObjectArr, Class<U> clazz) {
        if (outerObjectArr == null) {
            return null;
        }
        String key = outerObjectArr[0].toString();
        Map values = (Map)outerObjectArr[1];
        LinkedHashMap<String, U> innerMap = new LinkedHashMap<String, U>();
        for (Map.Entry entry : values.entrySet()) {
            String subKey = entry.getKey().toString();
            U score = clazz.cast(entry.getValue());
            innerMap.put(subKey, score);
        }
        return Map.of(key, innerMap);
    }

    public static <U> Map<GlideString, Object> convertBinaryStringKeyValueArrayToMap(Object[] outerObjectArr, Class<U> clazz) {
        if (outerObjectArr == null) {
            return null;
        }
        GlideString key = GlideString.gs(outerObjectArr[0].toString());
        Map values = (Map)outerObjectArr[1];
        LinkedHashMap<GlideString, U> innerMap = new LinkedHashMap<GlideString, U>();
        for (Map.Entry entry : values.entrySet()) {
            GlideString subKey = GlideString.gs(entry.getKey().toString());
            U score = clazz.cast(entry.getValue());
            innerMap.put(subKey, score);
        }
        return Map.of(key, innerMap);
    }

    public static <T, U extends T> U[][][] cast3DArray(T[] outerObjectArr, Class<U> clazz) {
        if (outerObjectArr == null) {
            return null;
        }
        Object[] convertedArr = new Object[outerObjectArr.length];
        for (int i = 0; i < outerObjectArr.length; ++i) {
            convertedArr[i] = ArrayTransformUtils.castArrayofArrays((Object[])outerObjectArr[i], clazz);
        }
        return (Object[][][])ArrayTransformUtils.castArrayofArrays(convertedArr, Array.newInstance(clazz, 0).getClass());
    }

    public static <T> Map<String, T[]> castMapOfArrays(Map<String, Object[]> mapOfArrays, Class<T> clazz) {
        if (mapOfArrays == null) {
            return null;
        }
        return mapOfArrays.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ArrayTransformUtils.castArray((Object[])e.getValue(), clazz)));
    }

    public static <T> Map<GlideString, T[]> castBinaryStringMapOfArrays(Map<GlideString, Object[]> mapOfArrays, Class<T> clazz) {
        if (mapOfArrays == null) {
            return null;
        }
        return mapOfArrays.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ArrayTransformUtils.castArray((Object[])e.getValue(), clazz)));
    }

    public static <S, T> Map<S, T[][]> castMapOf2DArray(Map<S, Object[][]> mapOfArrays, Class<T> clazz) {
        if (mapOfArrays == null) {
            return null;
        }
        return mapOfArrays.entrySet().stream().collect(LinkedHashMap::new, (m, e) -> m.put(e.getKey(), ArrayTransformUtils.castArrayofArrays((Object[])e.getValue(), clazz)), HashMap::putAll);
    }

    @SafeVarargs
    public static <T> T[] concatenateArrays(T[] ... arrays) {
        return Stream.of(arrays).flatMap(Stream::of).toArray(size -> Arrays.copyOf(arrays[0], size));
    }

    public static GlideString[] flattenMapToGlideStringArray(Map<?, ?> args) {
        return (GlideString[])args.entrySet().stream().flatMap(entry -> Stream.of(GlideString.of(entry.getKey()), GlideString.of(entry.getValue()))).toArray(GlideString[]::new);
    }

    public static <T> GlideString[] flattenNestedArrayToGlideStringArray(T[][] args) {
        for (T[] entry2 : args) {
            if (entry2.length == 2) continue;
            throw new IllegalArgumentException("Array entry had the wrong length. Expected length 2 but got length " + entry2.length);
        }
        return (GlideString[])Arrays.stream(args).flatMap(entry -> Stream.of(GlideString.of(entry[0]), GlideString.of(entry[1]))).toArray(GlideString[]::new);
    }

    public static GlideString[] flattenMapToGlideStringArrayValueFirst(Map<?, ?> args) {
        return (GlideString[])args.entrySet().stream().flatMap(entry -> Stream.of(GlideString.of(entry.getValue()), GlideString.of(entry.getKey()))).toArray(GlideString[]::new);
    }

    public static GlideString[] flattenAllKeysFollowedByAllValues(Map<?, ?> args) {
        ArrayList<GlideString> keysList = new ArrayList<GlideString>();
        ArrayList<GlideString> valuesList = new ArrayList<GlideString>();
        for (Map.Entry<?, ?> entry : args.entrySet()) {
            keysList.add(GlideString.of(entry.getKey()));
            valuesList.add(GlideString.of(entry.getValue()));
        }
        return ArrayTransformUtils.concatenateArrays((GlideString[])keysList.toArray(GlideString[]::new), (GlideString[])valuesList.toArray(GlideString[]::new));
    }

    public static <ArgType> GlideString[] toGlideStringArray(ArgType[] args) {
        return (GlideString[])Arrays.stream(args).map(GlideString::of).toArray(GlideString[]::new);
    }

    public static Map<GlideString, GlideString> convertMapToGlideStringMap(Map<?, ?> inputMap) {
        if (inputMap == null) {
            return null;
        }
        return inputMap.entrySet().stream().collect(LinkedHashMap::new, (m, e) -> m.put(GlideString.of(e.getKey()), GlideString.of(e.getValue())), HashMap::putAll);
    }
}

