/*
 * Decompiled with CFR 0.152.
 */
package glide.api.commands.servermodules;

import glide.api.models.BaseBatch;
import glide.api.models.commands.ConditionalChange;
import glide.api.models.commands.json.JsonArrindexOptions;
import glide.api.models.commands.json.JsonGetOptions;
import glide.utils.ArgsBuilder;
import lombok.NonNull;

public class JsonBatch {
    private static final String JSON_PREFIX = "JSON.";
    private static final String JSON_SET = "JSON.SET";
    private static final String JSON_GET = "JSON.GET";
    private static final String JSON_MGET = "JSON.MGET";
    private static final String JSON_NUMINCRBY = "JSON.NUMINCRBY";
    private static final String JSON_NUMMULTBY = "JSON.NUMMULTBY";
    private static final String JSON_ARRAPPEND = "JSON.ARRAPPEND";
    private static final String JSON_ARRINSERT = "JSON.ARRINSERT";
    private static final String JSON_ARRINDEX = "JSON.ARRINDEX";
    private static final String JSON_ARRLEN = "JSON.ARRLEN";
    private static final String[] JSON_DEBUG_MEMORY = new String[]{"JSON.DEBUG", "MEMORY"};
    private static final String[] JSON_DEBUG_FIELDS = new String[]{"JSON.DEBUG", "FIELDS"};
    private static final String JSON_ARRPOP = "JSON.ARRPOP";
    private static final String JSON_ARRTRIM = "JSON.ARRTRIM";
    private static final String JSON_OBJLEN = "JSON.OBJLEN";
    private static final String JSON_OBJKEYS = "JSON.OBJKEYS";
    private static final String JSON_DEL = "JSON.DEL";
    private static final String JSON_FORGET = "JSON.FORGET";
    private static final String JSON_TOGGLE = "JSON.TOGGLE";
    private static final String JSON_STRAPPEND = "JSON.STRAPPEND";
    private static final String JSON_STRLEN = "JSON.STRLEN";
    private static final String JSON_CLEAR = "JSON.CLEAR";
    private static final String JSON_RESP = "JSON.RESP";
    private static final String JSON_TYPE = "JSON.TYPE";

    private JsonBatch() {
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> set(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path, @NonNull ArgType value) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        ArgsBuilder.checkTypeOrThrow(value);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_SET).add(key).add(path).add(value).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> set(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path, @NonNull ArgType value, @NonNull ConditionalChange setCondition) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (setCondition == null) {
            throw new NullPointerException("setCondition is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        ArgsBuilder.checkTypeOrThrow(value);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_SET).add(key).add(path).add(value).add(setCondition.getValkeyApi()).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> get(@NonNull BaseBatch<T> batch, @NonNull ArgType key) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_GET).add(key).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> get(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType[] paths) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (paths == null) {
            throw new NullPointerException("paths is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(paths);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_GET).add(key).add(paths).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> get(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull JsonGetOptions options) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_GET).add(key).add(options.toArgs()).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> get(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType[] paths, @NonNull JsonGetOptions options) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (paths == null) {
            throw new NullPointerException("paths is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(paths);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_GET).add(key).add(options.toArgs()).add(paths).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> mget(@NonNull BaseBatch<T> batch, @NonNull ArgType[] keys, @NonNull ArgType path) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        ArgsBuilder.checkTypeOrThrow(path);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_MGET).add(keys).add(path).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> arrappend(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path, @NonNull ArgType[] values) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        ArgsBuilder.checkTypeOrThrow(values);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_ARRAPPEND).add(key).add(path).add(values).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> arrinsert(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path, int index, @NonNull ArgType[] values) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        ArgsBuilder.checkTypeOrThrow(values);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_ARRINSERT).add(key).add(path).add(Integer.toString(index)).add(values).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> arrindex(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path, @NonNull ArgType scalar) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (scalar == null) {
            throw new NullPointerException("scalar is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        ArgsBuilder.checkTypeOrThrow(scalar);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_ARRINDEX).add(key).add(path).add(scalar).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> arrindex(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path, @NonNull ArgType scalar, @NonNull JsonArrindexOptions options) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (scalar == null) {
            throw new NullPointerException("scalar is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        ArgsBuilder.checkTypeOrThrow(scalar);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_ARRINDEX).add(key).add(path).add(scalar).add(options.toArgs()).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> arrlen(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_ARRLEN).add(key).add(path).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> arrlen(@NonNull BaseBatch<T> batch, @NonNull ArgType key) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_ARRLEN).add(key).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> debugMemory(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_DEBUG_MEMORY).add(key).add(path).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> debugMemory(@NonNull BaseBatch<T> batch, @NonNull ArgType key) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_DEBUG_MEMORY).add(key).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> debugFields(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_DEBUG_FIELDS).add(key).add(path).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> debugFields(@NonNull BaseBatch<T> batch, @NonNull ArgType key) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_DEBUG_FIELDS).add(key).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> arrpop(@NonNull BaseBatch<T> batch, @NonNull ArgType key) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_ARRPOP).add(key).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> arrpop(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_ARRPOP).add(key).add(path).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> arrpop(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path, long index) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_ARRPOP).add(key).add(path).add(Long.toString(index)).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> arrtrim(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path, int start, int end) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_ARRTRIM).add(key).add(path).add(Integer.toString(start)).add(Integer.toString(end)).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> numincrby(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path, Number number) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_NUMINCRBY).add(key).add(path).add(number.toString()).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> nummultby(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path, Number number) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_NUMMULTBY).add(key).add(path).add(number.toString()).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> objlen(@NonNull BaseBatch<T> batch, @NonNull ArgType key) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_OBJLEN).add(key).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> objlen(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_OBJLEN).add(key).add(path).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> objkeys(@NonNull BaseBatch<T> batch, @NonNull ArgType key) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_OBJKEYS).add(key).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> objkeys(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_OBJKEYS).add(key).add(path).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> del(@NonNull BaseBatch<T> batch, @NonNull ArgType key) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_DEL).add(key).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> del(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_DEL).add(key).add(path).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> forget(@NonNull BaseBatch<T> batch, @NonNull ArgType key) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_FORGET).add(key).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> forget(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_FORGET).add(key).add(path).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> toggle(@NonNull BaseBatch<T> batch, @NonNull ArgType key) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_TOGGLE).add(key).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> toggle(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_TOGGLE).add(key).add(path).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> strappend(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType value, @NonNull ArgType path) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(value);
        ArgsBuilder.checkTypeOrThrow(path);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_STRAPPEND).add(key).add(path).add(value).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> strappend(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType value) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(value);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_STRAPPEND).add(key).add(value).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> strlen(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_STRLEN).add(key).add(path).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> strlen(@NonNull BaseBatch<T> batch, @NonNull ArgType key) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_STRLEN).add(key).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> clear(@NonNull BaseBatch<T> batch, @NonNull ArgType key) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_CLEAR).add(key).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> clear(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_CLEAR).add(key).add(path).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> resp(@NonNull BaseBatch<T> batch, @NonNull ArgType key) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_RESP).add(key).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> resp(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_RESP).add(key).add(path).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> type(@NonNull BaseBatch<T> batch, @NonNull ArgType key) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_TYPE).add(key).toArray());
    }

    public static <ArgType, T extends BaseBatch<T>> BaseBatch<T> type(@NonNull BaseBatch<T> batch, @NonNull ArgType key, @NonNull ArgType path) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder.checkTypeOrThrow(path);
        return batch.customCommand(ArgsBuilder.newArgsBuilder().add(JSON_TYPE).add(key).add(path).toArray());
    }
}

