/*
 * Decompiled with CFR 0.152.
 */
package glide.connectors.resources;

import glide.api.logging.Logger;
import glide.connectors.resources.EpollResource;
import glide.connectors.resources.KQueuePoolResource;
import glide.connectors.resources.ThreadPoolResource;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.kqueue.KQueue;
import java.util.function.Supplier;

public final class Platform {
    private static String debugInfo = "Detailed report of checking platform capabilities\n";
    private static final Capabilities capabilities = new Capabilities(Platform.isKQueueAvailable(), Platform.isEPollAvailable(), false, false);

    private static boolean isKQueueAvailable() {
        try {
            debugInfo = debugInfo + "Checking KQUEUE...\n";
            Class.forName("io.netty.channel.kqueue.KQueue");
            debugInfo = debugInfo + "KQUEUE class found\n";
            boolean res = KQueue.isAvailable();
            debugInfo = debugInfo + "KQUEUE is" + (res ? " " : " not") + " available\n";
            if (!res) {
                debugInfo = debugInfo + "Reason: " + KQueue.unavailabilityCause() + "\n";
            }
            return res;
        }
        catch (ClassNotFoundException e) {
            debugInfo = debugInfo + "Exception checking KQUEUE:\n" + e + "\n";
            return false;
        }
    }

    private static boolean isEPollAvailable() {
        try {
            debugInfo = debugInfo + "Checking EPOLL...\n";
            Class.forName("io.netty.channel.epoll.Epoll");
            debugInfo = debugInfo + "EPOLL class found\n";
            boolean res = Epoll.isAvailable();
            debugInfo = debugInfo + "EPOLL is" + (res ? " " : " not") + " available\n";
            if (!res) {
                debugInfo = debugInfo + "Reason: " + Epoll.unavailabilityCause() + "\n";
            }
            return res;
        }
        catch (ClassNotFoundException e) {
            debugInfo = debugInfo + "Exception checking EPOLL\n" + e + "\n";
            return false;
        }
    }

    public static Supplier<ThreadPoolResource> getThreadPoolResourceSupplier() {
        if (capabilities.isKQueueAvailable()) {
            return KQueuePoolResource::new;
        }
        if (capabilities.isEPollAvailable()) {
            return EpollResource::new;
        }
        String errorMessage = String.format("Cannot load Netty native components for the current os version and arch: %s %s %s.\n", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        throw new RuntimeException(errorMessage + (Logger.getLoggerLevel() == Logger.Level.DEBUG ? debugInfo : ""));
    }

    private Platform() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static Capabilities getCapabilities() {
        return capabilities;
    }

    public static class Capabilities {
        private final boolean isKQueueAvailable;
        private final boolean isEPollAvailable;
        private final boolean isIOUringAvailable;
        private final boolean isNIOAvailable;

        public boolean isKQueueAvailable() {
            return this.isKQueueAvailable;
        }

        public boolean isEPollAvailable() {
            return this.isEPollAvailable;
        }

        public boolean isIOUringAvailable() {
            return this.isIOUringAvailable;
        }

        public boolean isNIOAvailable() {
            return this.isNIOAvailable;
        }

        private Capabilities(boolean isKQueueAvailable, boolean isEPollAvailable, boolean isIOUringAvailable, boolean isNIOAvailable) {
            this.isKQueueAvailable = isKQueueAvailable;
            this.isEPollAvailable = isEPollAvailable;
            this.isIOUringAvailable = isIOUringAvailable;
            this.isNIOAvailable = isNIOAvailable;
        }

        public String toString() {
            return "Platform.Capabilities(isKQueueAvailable=" + this.isKQueueAvailable() + ", isEPollAvailable=" + this.isEPollAvailable() + ", isIOUringAvailable=" + this.isIOUringAvailable() + ", isNIOAvailable=" + this.isNIOAvailable() + ")";
        }
    }
}

