/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.configuration;

import glide.api.models.configuration.AdvancedGlideClientConfiguration;
import glide.api.models.configuration.BackoffStrategy;
import glide.api.models.configuration.BaseClientConfiguration;
import glide.api.models.configuration.StandaloneSubscriptionConfiguration;

public class GlideClientConfiguration
extends BaseClientConfiguration {
    private final BackoffStrategy reconnectStrategy;
    private final Integer databaseId;
    private final StandaloneSubscriptionConfiguration subscriptionConfiguration;
    private final AdvancedGlideClientConfiguration advancedConfiguration;

    protected GlideClientConfiguration(GlideClientConfigurationBuilder<?, ?> b) {
        super(b);
        this.reconnectStrategy = b.reconnectStrategy;
        this.databaseId = b.databaseId;
        this.subscriptionConfiguration = b.subscriptionConfiguration;
        this.advancedConfiguration = b.advancedConfiguration;
    }

    public static GlideClientConfigurationBuilder<?, ?> builder() {
        return new GlideClientConfigurationBuilderImpl();
    }

    public BackoffStrategy getReconnectStrategy() {
        return this.reconnectStrategy;
    }

    public Integer getDatabaseId() {
        return this.databaseId;
    }

    @Override
    public StandaloneSubscriptionConfiguration getSubscriptionConfiguration() {
        return this.subscriptionConfiguration;
    }

    public AdvancedGlideClientConfiguration getAdvancedConfiguration() {
        return this.advancedConfiguration;
    }

    public String toString() {
        return "GlideClientConfiguration(reconnectStrategy=" + this.getReconnectStrategy() + ", databaseId=" + this.getDatabaseId() + ", subscriptionConfiguration=" + this.getSubscriptionConfiguration() + ", advancedConfiguration=" + this.getAdvancedConfiguration() + ")";
    }

    private static final class GlideClientConfigurationBuilderImpl
    extends GlideClientConfigurationBuilder<GlideClientConfiguration, GlideClientConfigurationBuilderImpl> {
        private GlideClientConfigurationBuilderImpl() {
        }

        @Override
        protected GlideClientConfigurationBuilderImpl self() {
            return this;
        }

        @Override
        public GlideClientConfiguration build() {
            return new GlideClientConfiguration(this);
        }
    }

    public static abstract class GlideClientConfigurationBuilder<C extends GlideClientConfiguration, B extends GlideClientConfigurationBuilder<C, B>>
    extends BaseClientConfiguration.BaseClientConfigurationBuilder<C, B> {
        private BackoffStrategy reconnectStrategy;
        private Integer databaseId;
        private StandaloneSubscriptionConfiguration subscriptionConfiguration;
        private AdvancedGlideClientConfiguration advancedConfiguration;

        public B reconnectStrategy(BackoffStrategy reconnectStrategy) {
            this.reconnectStrategy = reconnectStrategy;
            return (B)this.self();
        }

        public B databaseId(Integer databaseId) {
            this.databaseId = databaseId;
            return (B)this.self();
        }

        public B subscriptionConfiguration(StandaloneSubscriptionConfiguration subscriptionConfiguration) {
            this.subscriptionConfiguration = subscriptionConfiguration;
            return (B)this.self();
        }

        public B advancedConfiguration(AdvancedGlideClientConfiguration advancedConfiguration) {
            this.advancedConfiguration = advancedConfiguration;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "GlideClientConfiguration.GlideClientConfigurationBuilder(super=" + super.toString() + ", reconnectStrategy=" + this.reconnectStrategy + ", databaseId=" + this.databaseId + ", subscriptionConfiguration=" + this.subscriptionConfiguration + ", advancedConfiguration=" + this.advancedConfiguration + ")";
        }
    }
}

