/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.configuration;

import lombok.NonNull;

public class BackoffStrategy {
    @NonNull
    private final Integer numOfRetries;
    @NonNull
    private final Integer factor;
    @NonNull
    private final Integer exponentBase;

    BackoffStrategy(@NonNull Integer numOfRetries, @NonNull Integer factor, @NonNull Integer exponentBase) {
        if (numOfRetries == null) {
            throw new NullPointerException("numOfRetries is marked non-null but is null");
        }
        if (factor == null) {
            throw new NullPointerException("factor is marked non-null but is null");
        }
        if (exponentBase == null) {
            throw new NullPointerException("exponentBase is marked non-null but is null");
        }
        this.numOfRetries = numOfRetries;
        this.factor = factor;
        this.exponentBase = exponentBase;
    }

    public static BackoffStrategyBuilder builder() {
        return new BackoffStrategyBuilder();
    }

    @NonNull
    public Integer getNumOfRetries() {
        return this.numOfRetries;
    }

    @NonNull
    public Integer getFactor() {
        return this.factor;
    }

    @NonNull
    public Integer getExponentBase() {
        return this.exponentBase;
    }

    public String toString() {
        return "BackoffStrategy(numOfRetries=" + this.getNumOfRetries() + ", factor=" + this.getFactor() + ", exponentBase=" + this.getExponentBase() + ")";
    }

    public static class BackoffStrategyBuilder {
        private Integer numOfRetries;
        private Integer factor;
        private Integer exponentBase;

        BackoffStrategyBuilder() {
        }

        public BackoffStrategyBuilder numOfRetries(@NonNull Integer numOfRetries) {
            if (numOfRetries == null) {
                throw new NullPointerException("numOfRetries is marked non-null but is null");
            }
            this.numOfRetries = numOfRetries;
            return this;
        }

        public BackoffStrategyBuilder factor(@NonNull Integer factor) {
            if (factor == null) {
                throw new NullPointerException("factor is marked non-null but is null");
            }
            this.factor = factor;
            return this;
        }

        public BackoffStrategyBuilder exponentBase(@NonNull Integer exponentBase) {
            if (exponentBase == null) {
                throw new NullPointerException("exponentBase is marked non-null but is null");
            }
            this.exponentBase = exponentBase;
            return this;
        }

        public BackoffStrategy build() {
            return new BackoffStrategy(this.numOfRetries, this.factor, this.exponentBase);
        }

        public String toString() {
            return "BackoffStrategy.BackoffStrategyBuilder(numOfRetries=" + this.numOfRetries + ", factor=" + this.factor + ", exponentBase=" + this.exponentBase + ")";
        }
    }
}

