/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands.stream;

import glide.api.models.GlideString;
import glide.api.models.commands.stream.StreamRange;
import java.util.ArrayList;

public class StreamPendingOptionsBinary {
    public static final GlideString IDLE_TIME_VALKEY_API_GLIDE_STRING = GlideString.gs("IDLE");
    private final Long minIdleTime;
    private final GlideString consumer;

    public GlideString[] toArgs(StreamRange start, StreamRange end, long count) {
        ArrayList<GlideString> optionArgs = new ArrayList<GlideString>();
        if (this.minIdleTime != null) {
            optionArgs.add(IDLE_TIME_VALKEY_API_GLIDE_STRING);
            optionArgs.add(GlideString.gs(Long.toString(this.minIdleTime)));
        }
        optionArgs.add(GlideString.gs(start.getValkeyApi()));
        optionArgs.add(GlideString.gs(end.getValkeyApi()));
        optionArgs.add(GlideString.gs(Long.toString(count)));
        if (this.consumer != null) {
            optionArgs.add(this.consumer);
        }
        return optionArgs.toArray(new GlideString[0]);
    }

    StreamPendingOptionsBinary(Long minIdleTime, GlideString consumer) {
        this.minIdleTime = minIdleTime;
        this.consumer = consumer;
    }

    public static StreamPendingOptionsBinaryBuilder builder() {
        return new StreamPendingOptionsBinaryBuilder();
    }

    public static class StreamPendingOptionsBinaryBuilder {
        private Long minIdleTime;
        private GlideString consumer;

        StreamPendingOptionsBinaryBuilder() {
        }

        public StreamPendingOptionsBinaryBuilder minIdleTime(Long minIdleTime) {
            this.minIdleTime = minIdleTime;
            return this;
        }

        public StreamPendingOptionsBinaryBuilder consumer(GlideString consumer) {
            this.consumer = consumer;
            return this;
        }

        public StreamPendingOptionsBinary build() {
            return new StreamPendingOptionsBinary(this.minIdleTime, this.consumer);
        }

        public String toString() {
            return "StreamPendingOptionsBinary.StreamPendingOptionsBinaryBuilder(minIdleTime=" + this.minIdleTime + ", consumer=" + this.consumer + ")";
        }
    }
}

