/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands.stream;

import glide.api.models.commands.stream.StreamTrimOptions;
import java.util.ArrayList;

public final class StreamAddOptions {
    public static final String NO_MAKE_STREAM_VALKEY_API = "NOMKSTREAM";
    public static final String ID_WILDCARD_VALKEY_API = "*";
    private final String id;
    private final Boolean makeStream;
    private final StreamTrimOptions trim;

    public String[] toArgs() {
        ArrayList<String> optionArgs = new ArrayList<String>();
        if (this.makeStream != null && !this.makeStream.booleanValue()) {
            optionArgs.add(NO_MAKE_STREAM_VALKEY_API);
        }
        if (this.trim != null) {
            optionArgs.addAll(this.trim.getValkeyApi());
        }
        if (this.id != null) {
            optionArgs.add(this.id);
        } else {
            optionArgs.add(ID_WILDCARD_VALKEY_API);
        }
        return optionArgs.toArray(new String[0]);
    }

    StreamAddOptions(String id, Boolean makeStream, StreamTrimOptions trim) {
        this.id = id;
        this.makeStream = makeStream;
        this.trim = trim;
    }

    public static StreamAddOptionsBuilder builder() {
        return new StreamAddOptionsBuilder();
    }

    public static class StreamAddOptionsBuilder {
        private String id;
        private Boolean makeStream;
        private StreamTrimOptions trim;

        StreamAddOptionsBuilder() {
        }

        public StreamAddOptionsBuilder id(String id) {
            this.id = id;
            return this;
        }

        public StreamAddOptionsBuilder makeStream(Boolean makeStream) {
            this.makeStream = makeStream;
            return this;
        }

        public StreamAddOptionsBuilder trim(StreamTrimOptions trim) {
            this.trim = trim;
            return this;
        }

        public StreamAddOptions build() {
            return new StreamAddOptions(this.id, this.makeStream, this.trim);
        }

        public String toString() {
            return "StreamAddOptions.StreamAddOptionsBuilder(id=" + this.id + ", makeStream=" + this.makeStream + ", trim=" + this.trim + ")";
        }
    }
}

