/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands;

import glide.api.models.GlideString;
import glide.utils.ArgsBuilder;
import java.util.ArrayList;

public final class ZAddOptions {
    private final ConditionalChange conditionalChange;
    private final UpdateOptions updateOptions;

    public String[] toArgs() {
        if (this.conditionalChange == ConditionalChange.ONLY_IF_DOES_NOT_EXIST && this.updateOptions != null) {
            throw new IllegalArgumentException("The GT, LT, and NX options are mutually exclusive. Cannot choose both " + this.updateOptions.valkeyApi + " and NX.");
        }
        ArrayList<String> optionArgs = new ArrayList<String>();
        if (this.conditionalChange != null) {
            optionArgs.add(this.conditionalChange.valkeyApi);
        }
        if (this.updateOptions != null) {
            optionArgs.add(this.updateOptions.valkeyApi);
        }
        return optionArgs.toArray(new String[0]);
    }

    public GlideString[] toArgsBinary() {
        return new ArgsBuilder().add(this.toArgs()).toArray();
    }

    ZAddOptions(ConditionalChange conditionalChange, UpdateOptions updateOptions) {
        this.conditionalChange = conditionalChange;
        this.updateOptions = updateOptions;
    }

    public static ZAddOptionsBuilder builder() {
        return new ZAddOptionsBuilder();
    }

    public static class ZAddOptionsBuilder {
        private ConditionalChange conditionalChange;
        private UpdateOptions updateOptions;

        ZAddOptionsBuilder() {
        }

        public ZAddOptionsBuilder conditionalChange(ConditionalChange conditionalChange) {
            this.conditionalChange = conditionalChange;
            return this;
        }

        public ZAddOptionsBuilder updateOptions(UpdateOptions updateOptions) {
            this.updateOptions = updateOptions;
            return this;
        }

        public ZAddOptions build() {
            return new ZAddOptions(this.conditionalChange, this.updateOptions);
        }

        public String toString() {
            return "ZAddOptions.ZAddOptionsBuilder(conditionalChange=" + this.conditionalChange + ", updateOptions=" + this.updateOptions + ")";
        }
    }

    public static enum UpdateOptions {
        SCORE_LESS_THAN_CURRENT("LT"),
        SCORE_GREATER_THAN_CURRENT("GT");

        private final String valkeyApi;

        private UpdateOptions(String valkeyApi) {
            this.valkeyApi = valkeyApi;
        }
    }

    public static enum ConditionalChange {
        ONLY_IF_EXISTS("XX"),
        ONLY_IF_DOES_NOT_EXIST("NX");

        private final String valkeyApi;

        private ConditionalChange(String valkeyApi) {
            this.valkeyApi = valkeyApi;
        }
    }
}

