/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands;

import java.util.ArrayList;
import java.util.List;

public abstract class SortBaseOptions {
    public static final String LIMIT_COMMAND_STRING = "LIMIT";
    public static final String ALPHA_COMMAND_STRING = "ALPHA";
    public static final String STORE_COMMAND_STRING = "STORE";
    private final Limit limit;
    private final OrderBy orderBy;
    private final boolean isAlpha;

    public String[] toArgs() {
        ArrayList<String> optionArgs = new ArrayList<String>();
        if (this.limit != null) {
            optionArgs.addAll(List.of(LIMIT_COMMAND_STRING, Long.toString(this.limit.offset), Long.toString(this.limit.count)));
        }
        if (this.orderBy != null) {
            optionArgs.add(this.orderBy.toString());
        }
        if (this.isAlpha) {
            optionArgs.add(ALPHA_COMMAND_STRING);
        }
        return optionArgs.toArray(new String[0]);
    }

    protected SortBaseOptions(SortBaseOptionsBuilder<?, ?> b) {
        this.limit = b.limit;
        this.orderBy = b.orderBy;
        this.isAlpha = b.isAlpha;
    }

    public static enum OrderBy {
        ASC,
        DESC;

    }

    public static final class Limit {
        private final long offset;
        private final long count;

        public Limit(long offset, long count) {
            this.offset = offset;
            this.count = count;
        }
    }

    public static abstract class SortBaseOptionsBuilder<C extends SortBaseOptions, B extends SortBaseOptionsBuilder<C, B>> {
        private Limit limit;
        private OrderBy orderBy;
        private boolean isAlpha;

        public B alpha() {
            this.isAlpha = true;
            return this.self();
        }

        public B limit(Limit limit) {
            this.limit = limit;
            return this.self();
        }

        public B orderBy(OrderBy orderBy) {
            this.orderBy = orderBy;
            return this.self();
        }

        public B isAlpha(boolean isAlpha) {
            this.isAlpha = isAlpha;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "SortBaseOptions.SortBaseOptionsBuilder(limit=" + this.limit + ", orderBy=" + this.orderBy + ", isAlpha=" + this.isAlpha + ")";
        }
    }
}

