/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands;

import glide.api.models.commands.ScriptArgOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ScriptOptions
extends ScriptArgOptions {
    private final List<String> keys;

    protected ScriptOptions(ScriptOptionsBuilder<?, ?> b) {
        super(b);
        List<Object> keys;
        switch (b.keys == null ? 0 : b.keys.size()) {
            case 0: {
                keys = Collections.emptyList();
                break;
            }
            case 1: {
                keys = Collections.singletonList(b.keys.get(0));
                break;
            }
            default: {
                keys = Collections.unmodifiableList(new ArrayList<String>(b.keys));
            }
        }
        this.keys = keys;
    }

    public static ScriptOptionsBuilder<?, ?> builder() {
        return new ScriptOptionsBuilderImpl();
    }

    public List<String> getKeys() {
        return this.keys;
    }

    private static final class ScriptOptionsBuilderImpl
    extends ScriptOptionsBuilder<ScriptOptions, ScriptOptionsBuilderImpl> {
        private ScriptOptionsBuilderImpl() {
        }

        @Override
        protected ScriptOptionsBuilderImpl self() {
            return this;
        }

        @Override
        public ScriptOptions build() {
            return new ScriptOptions(this);
        }
    }

    public static abstract class ScriptOptionsBuilder<C extends ScriptOptions, B extends ScriptOptionsBuilder<C, B>>
    extends ScriptArgOptions.ScriptArgOptionsBuilder<C, B> {
        private ArrayList<String> keys;

        public B key(String key) {
            if (this.keys == null) {
                this.keys = new ArrayList();
            }
            this.keys.add(key);
            return (B)this.self();
        }

        public B keys(Collection<? extends String> keys) {
            if (keys == null) {
                throw new NullPointerException("keys cannot be null");
            }
            if (this.keys == null) {
                this.keys = new ArrayList();
            }
            this.keys.addAll(keys);
            return (B)this.self();
        }

        public B clearKeys() {
            if (this.keys != null) {
                this.keys.clear();
            }
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ScriptOptions.ScriptOptionsBuilder(super=" + super.toString() + ", keys=" + this.keys + ")";
        }
    }
}

