/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models;

import glide.api.models.GlideString;
import java.util.Optional;

public class PubSubMessage {
    private final GlideString message;
    private final GlideString channel;
    private final Optional<GlideString> pattern;

    public PubSubMessage(GlideString message, GlideString channel, GlideString pattern) {
        this.message = message;
        this.channel = channel;
        this.pattern = Optional.ofNullable(pattern);
    }

    public PubSubMessage(GlideString message, GlideString channel) {
        this.message = message;
        this.channel = channel;
        this.pattern = Optional.empty();
    }

    public String toString() {
        Object res = String.format("(%s, channel = %s", this.message, this.channel);
        if (this.pattern.isPresent()) {
            res = (String)res + ", pattern = " + this.pattern.get();
        }
        return (String)res + ")";
    }

    public GlideString getMessage() {
        return this.message;
    }

    public GlideString getChannel() {
        return this.channel;
    }

    public Optional<GlideString> getPattern() {
        return this.pattern;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PubSubMessage)) {
            return false;
        }
        PubSubMessage other = (PubSubMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GlideString this$message = this.getMessage();
        GlideString other$message = other.getMessage();
        if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
            return false;
        }
        GlideString this$channel = this.getChannel();
        GlideString other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
            return false;
        }
        Optional<GlideString> this$pattern = this.getPattern();
        Optional<GlideString> other$pattern = other.getPattern();
        return !(this$pattern == null ? other$pattern != null : !((Object)this$pattern).equals(other$pattern));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PubSubMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GlideString $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        GlideString $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
        Optional<GlideString> $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : ((Object)$pattern).hashCode());
        return result;
    }
}

