/*
 * Decompiled with CFR 0.152.
 */
package glide.api.logging;

import glide.ffi.resolvers.LoggerResolver;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Supplier;
import lombok.NonNull;

public final class Logger {
    private static Level loggerLevel;

    private static void initLogger(@NonNull Level level, String fileName) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        loggerLevel = Level.fromInt(LoggerResolver.initInternal(level.getLevel(), fileName));
    }

    public static void init(@NonNull Level level, String fileName) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (loggerLevel == null) {
            Logger.initLogger(level, fileName);
        }
    }

    public static void init(@NonNull String fileName) {
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        Logger.init(Level.DEFAULT, fileName);
    }

    public static void init() {
        Logger.init(Level.DEFAULT, null);
    }

    public static void init(@NonNull Level level) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        Logger.init(level, null);
    }

    public static void log(@NonNull Level level, @NonNull String logIdentifier, @NonNull Supplier<String> messageSupplier) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (logIdentifier == null) {
            throw new NullPointerException("logIdentifier is marked non-null but is null");
        }
        if (messageSupplier == null) {
            throw new NullPointerException("messageSupplier is marked non-null but is null");
        }
        if (loggerLevel == null) {
            Logger.initLogger(Level.DEFAULT, null);
        }
        if (level == Level.OFF) {
            return;
        }
        if (level.getLevel() > loggerLevel.getLevel()) {
            return;
        }
        LoggerResolver.logInternal(level.getLevel(), logIdentifier, messageSupplier.get());
    }

    public static void log(@NonNull Level level, @NonNull String logIdentifier, @NonNull String message) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (logIdentifier == null) {
            throw new NullPointerException("logIdentifier is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (loggerLevel == null) {
            Logger.initLogger(Level.DEFAULT, null);
        }
        if (level == Level.OFF) {
            return;
        }
        if (level.getLevel() > loggerLevel.getLevel()) {
            return;
        }
        LoggerResolver.logInternal(level.getLevel(), logIdentifier, message);
    }

    public static void log(@NonNull Level level, @NonNull String logIdentifier, @NonNull String message, @NonNull Throwable throwable) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (logIdentifier == null) {
            throw new NullPointerException("logIdentifier is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (throwable == null) {
            throw new NullPointerException("throwable is marked non-null but is null");
        }
        Logger.log(level, logIdentifier, () -> message + ": " + Logger.prettyPrintException(throwable));
    }

    public static void log(@NonNull Level level, @NonNull String logIdentifier, @NonNull Supplier<String> message, @NonNull Throwable throwable) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (logIdentifier == null) {
            throw new NullPointerException("logIdentifier is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (throwable == null) {
            throw new NullPointerException("throwable is marked non-null but is null");
        }
        Logger.log(level, logIdentifier, () -> (String)message.get() + ": " + Logger.prettyPrintException(throwable));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String prettyPrintException(@NonNull Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("throwable is marked non-null but is null");
        }
        try (StringWriter stringWriter = new StringWriter();){
            PrintWriter printWriter = new PrintWriter(stringWriter);
            try {
                throwable.printStackTrace(printWriter);
                String string = stringWriter.toString();
                printWriter.close();
                return string;
            }
            catch (Throwable throwable2) {
                try {
                    printWriter.close();
                }
                catch (Throwable throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void setLoggerConfig(@NonNull Level level, String fileName) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        Logger.initLogger(level, fileName);
    }

    public static void setLoggerConfig(@NonNull Level level) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        Logger.setLoggerConfig(level, null);
    }

    public static void setLoggerConfig(String fileName) {
        Logger.setLoggerConfig(Level.DEFAULT, fileName);
    }

    public static void setLoggerConfig() {
        Logger.setLoggerConfig(Level.DEFAULT, null);
    }

    public static Level getLoggerLevel() {
        return loggerLevel;
    }

    public static enum Level {
        DEFAULT(-1),
        ERROR(0),
        WARN(1),
        INFO(2),
        DEBUG(3),
        TRACE(4),
        OFF(5);

        private final int level;

        private Level(int level) {
            this.level = level;
        }

        public static Level fromInt(int i) {
            switch (i) {
                case 0: {
                    return ERROR;
                }
                case 1: {
                    return WARN;
                }
                case 2: {
                    return INFO;
                }
                case 3: {
                    return DEBUG;
                }
                case 4: {
                    return TRACE;
                }
                case 5: {
                    return OFF;
                }
            }
            return DEFAULT;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

