/*
 * Decompiled with CFR 0.152.
 */
package io.urf.surf;

import com.globalmentor.io.ParseIOException;
import com.globalmentor.io.ReaderParser;
import com.globalmentor.io.function.IOConsumer;
import com.globalmentor.iso.datetime.ISO8601;
import com.globalmentor.itu.TelephoneNumber;
import com.globalmentor.java.Characters;
import com.globalmentor.java.CodePointCharacter;
import com.globalmentor.model.UUIDs;
import com.globalmentor.net.ContentType;
import com.globalmentor.net.EmailAddress;
import com.globalmentor.text.ABNF;
import com.globalmentor.text.ASCII;
import io.urf.surf.SURF;
import io.urf.surf.SurfObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SurfParser {
    private final Map<Object, Object> labeledResources = new HashMap<Object, Object>();
    protected static final Characters WHITESPACE_EOL_CHARACTERS = SURF.WHITESPACE_CHARACTERS.add(Characters.EOL_CHARACTERS);

    public Optional<Object> findResourceByAlias(@Nonnull String alias) {
        return Optional.ofNullable(this.labeledResources.get(new Alias(alias)));
    }

    public Optional<SurfObject> findObjectByTag(@Nonnull URI tag) {
        return Optional.ofNullable((SurfObject)this.labeledResources.get(Objects.requireNonNull(tag)));
    }

    public Optional<SurfObject> findObjectById(@Nonnull String typeHandle, @Nonnull String id) {
        return Optional.ofNullable(this.getObjectById(typeHandle, id));
    }

    protected SurfObject getObjectById(@Nonnull String typeHandle, @Nonnull String id) {
        return (SurfObject)this.labeledResources.get(new AbstractMap.SimpleImmutableEntry<String, String>(Objects.requireNonNull(typeHandle), Objects.requireNonNull(id)));
    }

    public Optional<Object> parse(@Nonnull String string) throws IOException, ParseIOException {
        try (StringReader stringReader = new StringReader(string);){
            Optional<Object> optional = this.parse(stringReader);
            return optional;
        }
    }

    public Optional<Object> parse(@Nonnull InputStream inputStream) throws IOException, ParseIOException {
        return this.parse(new LineNumberReader(new InputStreamReader(inputStream, SURF.CHARSET)));
    }

    public Optional<Object> parse(@Nonnull Reader reader) throws IOException, ParseIOException {
        if (SurfParser.skipFiller(reader) < 0) {
            return Optional.empty();
        }
        Object resource = this.parseResource(reader);
        ReaderParser.checkParseIO((Reader)reader, (SurfParser.skipFiller(reader) < 0 ? 1 : 0) != 0, (String)"No content allowed after root resource.", (Object[])new Object[0]);
        return Optional.of(resource);
    }

    public static Object parseLabel(@Nonnull Reader reader) throws IOException, ParseIOException {
        Object label;
        ReaderParser.check((Reader)reader, (char)'|');
        switch (ReaderParser.peekRequired((Reader)reader)) {
            case '<': {
                try {
                    label = SURF.Tag.checkArgumentValid(SurfParser.parseIRI(reader));
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ParseIOException(reader, "Invalid tag.", (Throwable)illegalArgumentException);
                }
            }
            case '\"': {
                label = SurfParser.parseString(reader);
                break;
            }
            default: {
                label = new Alias(SurfParser.parseNameToken(reader));
            }
        }
        ReaderParser.check((Reader)reader, (char)'|');
        return label;
    }

    protected static String parseNameToken(@Nonnull Reader reader) throws IOException, ParseIOException {
        StringBuilder stringBuilder = new StringBuilder();
        int c = reader.read();
        if (!SURF.Name.isTokenBeginCharacter(c)) {
            ReaderParser.checkReaderNotEnd((Reader)reader, (int)c);
            throw new ParseIOException(reader, String.format("Expected name token begin character; found %s.", Characters.getLabel((int)c)));
        }
        do {
            stringBuilder.append((char)c);
            reader.mark(2);
        } while (SURF.Name.isTokenCharacter(c = reader.read()));
        if (c >= 0) {
            reader.reset();
        }
        String nameToken = stringBuilder.toString();
        ReaderParser.checkParseIO((Reader)reader, (boolean)SURF.Name.isValidToken(nameToken), (String)"Invalid name token %s.", (Object[])new Object[]{nameToken});
        return nameToken;
    }

    public static String parseHandle(@Nonnull Reader reader) throws IOException, ParseIOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SurfParser.parseNameToken(reader));
        while (ReaderParser.confirm((Reader)reader, (char)'-')) {
            stringBuilder.append('-');
            stringBuilder.append(SurfParser.parseNameToken(reader));
        }
        String handle = stringBuilder.toString();
        ReaderParser.checkParseIO((Reader)reader, (boolean)SURF.Handle.isValid(handle), (String)"Invalid handle %s.", (Object[])new Object[]{handle});
        return handle;
    }

    public Object parseResource(@Nonnull Reader reader) throws IOException {
        return this.parseResource(reader, true);
    }

    public Object parseResource(@Nonnull Reader reader, boolean allowDescription) throws IOException {
        Object resource;
        Object label = null;
        int c = ReaderParser.peek((Reader)reader);
        if (c == 124) {
            label = SurfParser.parseLabel(reader);
            if ((label instanceof URI || label instanceof Alias) && (resource = (Object)this.labeledResources.get(label)) != null) {
                return resource;
            }
            c = ReaderParser.skip((Reader)reader, (Characters)SURF.WHITESPACE_CHARACTERS);
        }
        switch (c) {
            case 42: {
                resource = this.parseObject(label, reader);
                break;
            }
            case 37: {
                resource = SurfParser.parseBinary(reader);
                break;
            }
            case 39: {
                resource = SurfParser.parseCharacter(reader);
                break;
            }
            case 102: 
            case 116: {
                resource = SurfParser.parseBoolean(reader);
                break;
            }
            case 94: {
                resource = SurfParser.parseEmailAddress(reader);
                break;
            }
            case 60: {
                resource = SurfParser.parseIRI(reader);
                break;
            }
            case 62: {
                resource = SurfParser.parseMediaType(reader);
                break;
            }
            case 36: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                resource = SurfParser.parseNumber(reader);
                break;
            }
            case 47: {
                resource = SurfParser.parseRegularExpression(reader);
                break;
            }
            case 34: {
                resource = SurfParser.parseString(reader);
                break;
            }
            case 43: {
                resource = SurfParser.parseTelephoneNumber(reader);
                break;
            }
            case 64: {
                resource = SurfParser.parseTemporal(reader);
                break;
            }
            case 38: {
                resource = SurfParser.parseUuid(reader);
                break;
            }
            case 91: {
                ReaderParser.checkParseIO((Reader)reader, (label == null || label instanceof Alias ? 1 : 0) != 0, (String)"Non-alias label |%s| cannot be used with collection.", (Object[])new Object[]{label});
                resource = this.parseList((Alias)label, reader);
                break;
            }
            case 123: {
                ReaderParser.checkParseIO((Reader)reader, (label == null || label instanceof Alias ? 1 : 0) != 0, (String)"Non-alias label |%s| cannot be used with collection.", (Object[])new Object[]{label});
                resource = this.parseMap((Alias)label, reader);
                break;
            }
            case 40: {
                ReaderParser.checkParseIO((Reader)reader, (label == null || label instanceof Alias ? 1 : 0) != 0, (String)"Non-alias label |%s| cannot be used with collection.", (Object[])new Object[]{label});
                resource = this.parseSet((Alias)label, reader);
                break;
            }
            default: {
                throw new ParseIOException(reader, "Expected resource; found character: " + Characters.getLabel((int)c));
            }
        }
        if (label instanceof URI) {
            ReaderParser.checkParseIO((Reader)reader, (boolean)(resource instanceof SurfObject), (String)"Tag |%s| can only be used with an object.", (Object[])new Object[]{label});
            assert (label.equals(((SurfObject)resource).getTag().orElse(null)));
            this.labeledResources.put(label, resource);
        } else if (label instanceof String) {
            String id = (String)label;
            ReaderParser.checkParseIO((Reader)reader, (boolean)(resource instanceof SurfObject), (String)"ID |%s| can only be used with an object.", (Object[])new Object[]{id});
            SurfObject surfObject = (SurfObject)resource;
            assert (id.equals(((SurfObject)resource).getId().orElse(null)));
            String typeHandle = surfObject.getTypeHandle().orElseThrow(() -> new AssertionError((Object)String.format("Object with ID %s should have required a type when parsing.", id)));
            this.labeledResources.put(new AbstractMap.SimpleImmutableEntry<String, String>(typeHandle, id), resource);
        } else if (label instanceof Alias) {
            ReaderParser.checkParseIO((Reader)reader, (resource != null ? 1 : 0) != 0, (String)"Cannot use alias |%s| with null.", (Object[])new Object[]{label});
            if (!(resource instanceof Collection)) {
                this.labeledResources.put(label, resource);
            }
            assert (this.findResourceByAlias(label.toString()).isPresent());
        }
        if (allowDescription && resource instanceof SurfObject && (c = ReaderParser.peek((Reader)reader)) == 58) {
            ReaderParser.checkParseIO((Reader)reader, (boolean)(resource instanceof SurfObject), (String)"SURF only allows objects to have a description.", (Object[])new Object[0]);
            this.parseDescription(reader, (SurfObject)resource);
        }
        return resource;
    }

    public SurfObject parseObject(@Nullable URI tag, @Nonnull Reader reader) throws IOException {
        return this.parseObject((Object)tag, reader);
    }

    protected SurfObject parseObject(@Nullable Object label, @Nonnull Reader reader) throws IOException {
        SurfObject resource;
        String typeHandle;
        ReaderParser.check((Reader)reader, (char)'*');
        int c = ReaderParser.skip((Reader)reader, (Characters)SURF.WHITESPACE_CHARACTERS);
        if (c >= 0 && SURF.Handle.isBeginCharacter((char)c)) {
            SurfObject objectById;
            typeHandle = SurfParser.parseHandle(reader);
            if (label instanceof String && (objectById = this.getObjectById(typeHandle, (String)label)) != null) {
                return objectById;
            }
            c = ReaderParser.skip((Reader)reader, (Characters)SURF.WHITESPACE_CHARACTERS);
        } else {
            typeHandle = null;
        }
        if (label instanceof URI) {
            resource = new SurfObject((URI)label, typeHandle);
        } else if (label instanceof String) {
            ReaderParser.checkParseIO((Reader)reader, (typeHandle != null ? 1 : 0) != 0, (String)"Object with ID %s does not indicate a type.", (Object[])new Object[]{label});
            resource = new SurfObject(typeHandle, (String)label);
        } else {
            resource = new SurfObject(typeHandle);
        }
        return resource;
    }

    protected SurfObject parseDescription(@Nonnull Reader reader, @Nonnull SurfObject resource) throws IOException {
        Objects.requireNonNull(resource);
        ReaderParser.check((Reader)reader, (char)':');
        SurfParser.parseSequence(reader, ';', (IOConsumer<Reader>)((IOConsumer)r -> {
            String propertyHandle = SurfParser.parseHandle(reader);
            SurfParser.skipFiller(reader);
            ReaderParser.check((Reader)reader, (char)'=');
            SurfParser.skipFiller(reader);
            Object value = this.parseResource(reader);
            Optional<Object> oldValue = resource.setPropertyValue(propertyHandle, value);
            ReaderParser.checkParseIO((Reader)reader, (!oldValue.isPresent() ? 1 : 0) != 0, (String)"Resource has duplicate definition for property %s.", (Object[])new Object[]{propertyHandle});
        }));
        ReaderParser.check((Reader)reader, (char)';');
        return resource;
    }

    public static byte[] parseBinary(@Nonnull Reader reader) throws IOException, ParseIOException {
        ReaderParser.check((Reader)reader, (char)'%');
        String base64String = ReaderParser.readWhile((Reader)reader, (Characters)SURF.BINARY_BASE64URL_CHARACTERS);
        try {
            return Base64.getUrlDecoder().decode(base64String);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseIOException(reader, "Invalid SURF binary Base64 (base64url) encoding: " + base64String, (Throwable)illegalArgumentException);
        }
    }

    public static Boolean parseBoolean(@Nonnull Reader reader) throws IOException {
        char c = ReaderParser.peekRequired((Reader)reader);
        switch (c) {
            case 'f': {
                ReaderParser.check((Reader)reader, (CharSequence)"false");
                return Boolean.FALSE;
            }
            case 't': {
                ReaderParser.check((Reader)reader, (CharSequence)"true");
                return Boolean.TRUE;
            }
        }
        ReaderParser.checkReaderNotEnd((Reader)reader, (int)c);
        throw new ParseIOException(reader, "Unrecognized start of boolean: " + (char)c);
    }

    public static CodePointCharacter parseCharacter(@Nonnull Reader reader) throws IOException, ParseIOException {
        ReaderParser.check((Reader)reader, (char)'\'');
        int codePoint = SurfParser.parseCharacterCodePoint(reader, '\'');
        ReaderParser.checkParseIO((Reader)reader, (codePoint >= 0 ? 1 : 0) != 0, (String)"Character literal cannot be empty.", (Object[])new Object[0]);
        ReaderParser.check((Reader)reader, (char)'\'');
        return CodePointCharacter.of((int)codePoint);
    }

    public static int parseCharacterCodePoint(@Nonnull Reader reader, char delimiter) throws IOException, ParseIOException {
        char c;
        block23: {
            block22: {
                c = ReaderParser.readRequired((Reader)reader);
                if (c == delimiter) {
                    return -1;
                }
                if (c != '\\') break block22;
                c = ReaderParser.readRequired((Reader)reader);
                switch (c) {
                    case '/': 
                    case '\\': {
                        break block23;
                    }
                    case 'b': {
                        c = '\b';
                        break block23;
                    }
                    case 'f': {
                        c = '\f';
                        break block23;
                    }
                    case 'n': {
                        c = '\n';
                        break block23;
                    }
                    case 'r': {
                        c = '\r';
                        break block23;
                    }
                    case 't': {
                        c = '\t';
                        break block23;
                    }
                    case 'v': {
                        c = '\u000b';
                        break block23;
                    }
                    case 'u': {
                        String unicodeString = ReaderParser.readRequiredCount((Reader)reader, (int)4);
                        try {
                            c = (char)Integer.parseInt(unicodeString, 16);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ParseIOException(reader, "Invalid Unicode escape sequence " + unicodeString + ".", (Throwable)numberFormatException);
                        }
                        if (Character.isHighSurrogate(c)) {
                            char c2;
                            ReaderParser.check((Reader)reader, (char)'\\');
                            ReaderParser.check((Reader)reader, (char)'u');
                            String unicodeString2 = ReaderParser.readRequiredCount((Reader)reader, (int)4);
                            try {
                                c2 = (char)Integer.parseInt(unicodeString2, 16);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new ParseIOException(reader, "Invalid Unicode escape sequence " + unicodeString2 + ".", (Throwable)numberFormatException);
                            }
                            if (!Character.isLowSurrogate(c2)) {
                                throw new ParseIOException(reader, "Unicode high surrogate character " + Characters.getLabel((int)c) + " must be followed by low surrogate character; found " + Characters.getLabel((int)c2));
                            }
                            return Character.toCodePoint(c, c2);
                        }
                        if (Character.isLowSurrogate(c)) {
                            throw new ParseIOException(reader, "Unicode character escape sequence cannot begin with low surrogate character " + Characters.getLabel((int)c));
                        }
                        break block23;
                    }
                    default: {
                        if (c != delimiter) {
                            throw new ParseIOException(reader, "Unknown escaped character: " + Characters.getLabel((int)c));
                        }
                        break block23;
                    }
                }
            }
            if (Character.isHighSurrogate(c)) {
                char c2 = ReaderParser.readRequired((Reader)reader);
                if (!Character.isLowSurrogate(c2)) {
                    throw new ParseIOException(reader, "Unicode high surrogate character " + Characters.getLabel((int)c) + " must be followed by low surrogate character; found " + Characters.getLabel((int)c2));
                }
                return Character.toCodePoint(c, c2);
            }
            if (Character.isLowSurrogate(c)) {
                throw new ParseIOException(reader, "Unicode character cannot begin with low surrogate character " + Characters.getLabel((int)c));
            }
        }
        return c;
    }

    public static EmailAddress parseEmailAddress(@Nonnull Reader reader) throws IOException, ParseIOException {
        ReaderParser.check((Reader)reader, (char)'^');
        String localPart = ReaderParser.readUntilRequired((Reader)reader, (char)'@');
        ReaderParser.check((Reader)reader, (char)'@');
        StringBuilder domainStringBuilder = new StringBuilder();
        if (ReaderParser.peek((Reader)reader) == 91) {
            domainStringBuilder.append(ReaderParser.check((Reader)reader, (char)'['));
            ReaderParser.readWhile((Reader)reader, (Characters)EmailAddress.DTEXT_CHARACTERS, (StringBuilder)domainStringBuilder);
            domainStringBuilder.append(ReaderParser.check((Reader)reader, (char)']'));
        } else {
            boolean hasAText;
            do {
                ReaderParser.readRequiredMinimumCount((Reader)reader, (Characters)EmailAddress.ATEXT_CHARACTERS, (int)1, (StringBuilder)domainStringBuilder);
                boolean bl = hasAText = ReaderParser.peek((Reader)reader) == 46;
                if (!hasAText) continue;
                domainStringBuilder.append(ReaderParser.check((Reader)reader, (char)'.'));
            } while (hasAText);
        }
        String domain = domainStringBuilder.toString();
        try {
            return EmailAddress.of((String)localPart, (String)domain);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseIOException(reader, "Invalid SURF email address format: " + localPart + '@' + domain, (Throwable)illegalArgumentException);
        }
    }

    public static URI parseIRI(@Nonnull Reader reader) throws IOException, ParseIOException {
        URI iri;
        ReaderParser.check((Reader)reader, (char)'<');
        switch (ReaderParser.peekRequired((Reader)reader)) {
            case '^': {
                iri = URI.create("mailto:" + SurfParser.parseEmailAddress(reader).toString());
                break;
            }
            case '+': {
                iri = URI.create("tel:" + SurfParser.parseTelephoneNumber(reader).getCanonicalString());
                break;
            }
            case '&': {
                iri = UUIDs.toURI((UUID)SurfParser.parseUuid(reader));
                break;
            }
            default: {
                String iriString = ReaderParser.readUntilRequired((Reader)reader, (char)'>');
                try {
                    iri = new URI(iriString);
                    break;
                }
                catch (URISyntaxException uriSyntaxException) {
                    throw new ParseIOException(reader, "Invalid IRI: " + iriString, (Throwable)uriSyntaxException);
                }
            }
        }
        ReaderParser.check((Reader)reader, (char)'>');
        return iri;
    }

    public static ContentType parseMediaType(@Nonnull Reader reader) throws IOException, ParseIOException {
        Set parameters;
        String subType;
        String primaryType;
        ReaderParser.check((Reader)reader, (char)'>');
        String firstToken = SurfParser.parseMediaTypeRestrictedName(reader);
        char c = ReaderParser.peekRequired((Reader)reader);
        if (c == '/') {
            ReaderParser.check((Reader)reader, (char)'/');
            primaryType = firstToken;
            subType = SurfParser.parseMediaTypeRestrictedName(reader);
            c = ReaderParser.peekRequired((Reader)reader);
        } else {
            primaryType = "text";
            subType = firstToken;
        }
        if (c == ';') {
            parameters = new HashSet();
            do {
                String parameterValue;
                ReaderParser.check((Reader)reader, (char)';');
                ReaderParser.skip((Reader)reader, (Characters)ABNF.WSP_CHARACTERS);
                String parameterName = SurfParser.parseMediaTypeRestrictedName(reader);
                ReaderParser.check((Reader)reader, (char)'=');
                c = ReaderParser.peekRequired((Reader)reader);
                if (c == '\"') {
                    StringBuilder parameterValueBuilder = new StringBuilder();
                    ReaderParser.check((Reader)reader, (char)'\"');
                    while ((c = ReaderParser.readRequired((Reader)reader)) != '\"') {
                        if (c == '\\') {
                            c = ReaderParser.readRequired((Reader)reader);
                        }
                        parameterValueBuilder.append(c);
                    }
                    parameterValue = parameterValueBuilder.toString();
                } else {
                    parameterValue = ReaderParser.readUntil((Reader)reader, (Characters)ContentType.ILLEGAL_TOKEN_CHARACTERS);
                }
                parameters.add(ContentType.Parameter.of((String)parameterName, (String)parameterValue));
            } while ((c = ReaderParser.peekRequired((Reader)reader)) == ';');
        } else {
            parameters = Collections.emptySet();
        }
        ReaderParser.check((Reader)reader, (char)'<');
        try {
            return ContentType.of((String)primaryType, (String)subType, parameters);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseIOException(reader, "Invalid SURF media type format and parameters: " + primaryType + '/' + subType + " " + parameters, (Throwable)illegalArgumentException);
        }
    }

    protected static String parseMediaTypeRestrictedName(@Nonnull Reader reader) throws IOException, ParseIOException {
        StringBuilder builder = new StringBuilder();
        builder.append(ReaderParser.check((Reader)reader, (Characters)ContentType.RESTRICTED_NAME_FIRST_CHARACTERS));
        ReaderParser.readWhile((Reader)reader, (Characters)ContentType.RESTRICTED_NAME_CHARACTERS, (StringBuilder)builder);
        int length = builder.length();
        ReaderParser.checkParseIO((Reader)reader, (builder.length() <= 127 ? 1 : 0) != 0, (String)"Media type restricted name `%s` of length %d is longer than the maximum length %d.", (Object[])new Object[]{builder, length, (byte)127});
        assert (ContentType.RESTRICTED_NAME_PATTERN.matcher(builder).matches());
        return builder.toString();
    }

    /*
     * Loose catch block
     */
    public static Number parseNumber(@Nonnull Reader reader) throws IOException, ParseIOException {
        String numberString;
        block13: {
            boolean isDecimal;
            int c = ReaderParser.peekRequired((Reader)reader);
            if (c == 36) {
                isDecimal = true;
                ReaderParser.check((Reader)reader, (char)'$');
                c = ReaderParser.peekRequired((Reader)reader);
            } else {
                isDecimal = false;
            }
            boolean hasFraction = false;
            boolean hasExponent = false;
            StringBuilder stringBuilder = new StringBuilder();
            if (c == 45) {
                stringBuilder.append(ReaderParser.check((Reader)reader, (char)'-'));
            }
            ReaderParser.readRequiredMinimumCount((Reader)reader, (Characters)ASCII.DIGIT_CHARACTERS, (int)1, (StringBuilder)stringBuilder);
            c = ReaderParser.peek((Reader)reader);
            if (c >= 0) {
                if (c == 46) {
                    hasFraction = true;
                    stringBuilder.append(ReaderParser.check((Reader)reader, (char)'.'));
                    ReaderParser.readRequiredMinimumCount((Reader)reader, (Characters)ASCII.DIGIT_CHARACTERS, (int)1, (StringBuilder)stringBuilder);
                    c = ReaderParser.peek((Reader)reader);
                }
                if (c >= 0 && SURF.NUMBER_EXPONENT_DELIMITER_CHARACTERS.contains((char)c)) {
                    hasExponent = true;
                    stringBuilder.append(ReaderParser.check((Reader)reader, (char)((char)c)));
                    c = ReaderParser.peek((Reader)reader);
                    if (c >= 0 && SURF.NUMBER_EXPONENT_SIGN_CHARACTERS.contains((char)c)) {
                        stringBuilder.append(ReaderParser.check((Reader)reader, (char)((char)c)));
                    }
                    ReaderParser.readRequiredMinimumCount((Reader)reader, (Characters)ASCII.DIGIT_CHARACTERS, (int)1, (StringBuilder)stringBuilder);
                }
            }
            numberString = stringBuilder.toString();
            if (isDecimal) {
                return new BigDecimal(numberString);
            }
            if (!hasFraction && !hasExponent) break block13;
            return Double.valueOf(numberString);
            {
                catch (NumberFormatException numberFormatException) {
                    throw new ParseIOException(reader, "Invalid number format: " + numberString, (Throwable)numberFormatException);
                }
            }
        }
        try {
            return Long.valueOf(numberString);
        }
        catch (NumberFormatException numberFormatException) {
            return new BigInteger(numberString);
        }
    }

    public static Pattern parseRegularExpression(@Nonnull Reader reader) throws IOException, ParseIOException {
        ReaderParser.check((Reader)reader, (char)'/');
        StringBuilder regexBuilder = new StringBuilder();
        char c = ReaderParser.readRequired((Reader)reader);
        while (c != '/') {
            if (c == '\\') {
                char next = ReaderParser.readRequired((Reader)reader);
                if (next != '/') {
                    regexBuilder.append(c);
                }
                c = next;
            }
            regexBuilder.append(c);
            c = ReaderParser.readRequired((Reader)reader);
        }
        return Pattern.compile(regexBuilder.toString());
    }

    public static String parseString(@Nonnull Reader reader) throws IOException, ParseIOException {
        int codePoint;
        ReaderParser.check((Reader)reader, (char)'\"');
        StringBuilder stringBuilder = new StringBuilder();
        while ((codePoint = SurfParser.parseCharacterCodePoint(reader, '\"')) >= 0) {
            stringBuilder.appendCodePoint(codePoint);
        }
        return stringBuilder.toString();
    }

    public static TelephoneNumber parseTelephoneNumber(@Nonnull Reader reader) throws IOException, ParseIOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ReaderParser.check((Reader)reader, (char)'+'));
        String telephoneNumberDigits = ReaderParser.readRequiredMinimumCount((Reader)reader, (Characters)ABNF.DIGIT_CHARACTERS, (int)1, (StringBuilder)stringBuilder).toString();
        try {
            return TelephoneNumber.parse((CharSequence)telephoneNumberDigits);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseIOException(reader, "Invalid SURF telephone number digits: " + telephoneNumberDigits, (Throwable)illegalArgumentException);
        }
    }

    public static TemporalAccessor parseTemporal(@Nonnull Reader reader) throws IOException, ParseIOException {
        ReaderParser.check((Reader)reader, (char)'@');
        StringBuilder stringBuilder = new StringBuilder();
        try {
            boolean hasZone;
            boolean hasOffset;
            boolean isUTC;
            boolean hasTime;
            boolean hasDate;
            int c = ReaderParser.peek((Reader)reader);
            if (c == 45) {
                return MonthDay.parse(ReaderParser.readRequiredCount((Reader)reader, (int)7));
            }
            String temporalStart = ReaderParser.readRequiredMinimumCount((Reader)reader, (Characters)ASCII.DIGIT_CHARACTERS, (int)1);
            int dateTimeStartLength = temporalStart.length();
            if (dateTimeStartLength == 4) {
                hasDate = true;
                stringBuilder.append(temporalStart);
                c = ReaderParser.peek((Reader)reader);
                if (c != 45) {
                    return Year.parse(stringBuilder.toString());
                }
                stringBuilder.append(ReaderParser.check((Reader)reader, (char)'-'));
                stringBuilder.append(ReaderParser.readRequiredCount((Reader)reader, (Characters)ASCII.DIGIT_CHARACTERS, (int)2));
                c = ReaderParser.peek((Reader)reader);
                if (c != 45) {
                    return YearMonth.parse(stringBuilder.toString());
                }
                stringBuilder.append(ReaderParser.check((Reader)reader, (char)'-'));
                stringBuilder.append(ReaderParser.readRequiredCount((Reader)reader, (Characters)ASCII.DIGIT_CHARACTERS, (int)2));
                c = ReaderParser.peek((Reader)reader);
                boolean bl = hasTime = c == 84;
                if (hasTime) {
                    stringBuilder.append(ReaderParser.check((Reader)reader, (char)'T'));
                    temporalStart = ReaderParser.readRequiredCount((Reader)reader, (Characters)ASCII.DIGIT_CHARACTERS, (int)2);
                }
            } else {
                hasDate = false;
                if (dateTimeStartLength == 2) {
                    hasTime = true;
                } else {
                    throw new ParseIOException(reader, "Incorrect start of a date, time, or date time: " + temporalStart);
                }
            }
            if (hasTime) {
                stringBuilder.append(temporalStart);
                stringBuilder.append(ReaderParser.check((Reader)reader, (char)':'));
                stringBuilder.append(ReaderParser.readRequiredCount((Reader)reader, (Characters)ASCII.DIGIT_CHARACTERS, (int)2));
                stringBuilder.append(ReaderParser.check((Reader)reader, (char)':'));
                stringBuilder.append(ReaderParser.readRequiredCount((Reader)reader, (Characters)ASCII.DIGIT_CHARACTERS, (int)2));
                c = ReaderParser.peek((Reader)reader);
                if (c == 46) {
                    stringBuilder.append(ReaderParser.check((Reader)reader, (char)'.'));
                    ReaderParser.readRequiredMinimumCount((Reader)reader, (Characters)ASCII.DIGIT_CHARACTERS, (int)1, (StringBuilder)stringBuilder);
                }
                isUTC = (c = ReaderParser.peek((Reader)reader)) == 90;
                boolean bl = hasOffset = !isUTC && c >= 0 && ISO8601.SIGNS.contains((char)c);
                if (isUTC) {
                    hasZone = false;
                    stringBuilder.append(ReaderParser.check((Reader)reader, (char)'Z'));
                } else if (hasOffset) {
                    stringBuilder.append(ReaderParser.check((Reader)reader, (char)((char)c)));
                    stringBuilder.append(ReaderParser.readRequiredCount((Reader)reader, (Characters)ASCII.DIGIT_CHARACTERS, (int)2));
                    stringBuilder.append(ReaderParser.check((Reader)reader, (char)':'));
                    stringBuilder.append(ReaderParser.readRequiredCount((Reader)reader, (Characters)ASCII.DIGIT_CHARACTERS, (int)2));
                    c = ReaderParser.peek((Reader)reader);
                    boolean bl2 = hasZone = c == 91;
                    if (hasZone) {
                        stringBuilder.append(ReaderParser.check((Reader)reader, (char)'['));
                        stringBuilder.append(ReaderParser.readUntilRequired((Reader)reader, (char)']'));
                        stringBuilder.append(ReaderParser.check((Reader)reader, (char)']'));
                    }
                } else {
                    hasZone = false;
                }
            } else {
                isUTC = false;
                hasOffset = false;
                hasZone = false;
            }
            String temporalString = stringBuilder.toString();
            if (hasDate) {
                if (hasTime) {
                    if (isUTC) {
                        assert (!hasOffset);
                        return Instant.parse(temporalString);
                    }
                    if (hasOffset) {
                        if (hasZone) {
                            return ZonedDateTime.parse(temporalString);
                        }
                        return OffsetDateTime.parse(temporalString);
                    }
                    return LocalDateTime.parse(temporalString);
                }
                return LocalDate.parse(temporalString);
            }
            assert (hasTime);
            assert (!isUTC);
            if (hasOffset) {
                return OffsetTime.parse(temporalString);
            }
            return LocalTime.parse(temporalString);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseIOException(reader, (Throwable)dateTimeParseException);
        }
    }

    public static UUID parseUuid(@Nonnull Reader reader) throws IOException, ParseIOException {
        ReaderParser.check((Reader)reader, (char)'&');
        StringBuilder stringBuilder = new StringBuilder();
        ReaderParser.checkCount((Reader)reader, (Characters)ASCII.HEX_CHARACTERS, (int)8, (StringBuilder)stringBuilder);
        stringBuilder.append(ReaderParser.check((Reader)reader, (char)'-'));
        ReaderParser.checkCount((Reader)reader, (Characters)ASCII.HEX_CHARACTERS, (int)4, (StringBuilder)stringBuilder);
        stringBuilder.append(ReaderParser.check((Reader)reader, (char)'-'));
        ReaderParser.checkCount((Reader)reader, (Characters)ASCII.HEX_CHARACTERS, (int)4, (StringBuilder)stringBuilder);
        stringBuilder.append(ReaderParser.check((Reader)reader, (char)'-'));
        ReaderParser.checkCount((Reader)reader, (Characters)ASCII.HEX_CHARACTERS, (int)4, (StringBuilder)stringBuilder);
        stringBuilder.append(ReaderParser.check((Reader)reader, (char)'-'));
        ReaderParser.checkCount((Reader)reader, (Characters)ASCII.HEX_CHARACTERS, (int)12, (StringBuilder)stringBuilder);
        try {
            return UUID.fromString(stringBuilder.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseIOException(reader, "Invalid SURF UUID contents: " + stringBuilder, (Throwable)illegalArgumentException);
        }
    }

    public List<Object> parseList(@Nullable Alias alias, @Nonnull Reader reader) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        if (alias != null) {
            this.labeledResources.put(alias, list);
        }
        ReaderParser.check((Reader)reader, (char)'[');
        SurfParser.parseSequence(reader, ']', (IOConsumer<Reader>)((IOConsumer)r -> list.add(this.parseResource((Reader)r))));
        ReaderParser.check((Reader)reader, (char)']');
        return list;
    }

    public Map<Object, Object> parseMap(@Nullable Alias alias, @Nonnull Reader reader) throws IOException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (alias != null) {
            this.labeledResources.put(alias, map);
        }
        ReaderParser.check((Reader)reader, (char)'{');
        SurfParser.parseSequence(reader, '}', (IOConsumer<Reader>)((IOConsumer)r -> {
            Object key;
            if (ReaderParser.peek((Reader)reader) == 92) {
                ReaderParser.check((Reader)reader, (char)'\\');
                key = this.parseResource(reader, true);
                ReaderParser.check((Reader)reader, (char)'\\');
            } else {
                key = this.parseResource(reader, false);
            }
            SurfParser.skipFiller(reader);
            ReaderParser.check((Reader)reader, (char)':');
            SurfParser.skipFiller(reader);
            Object value = this.parseResource(reader);
            map.put(key, value);
        }));
        ReaderParser.check((Reader)reader, (char)'}');
        return map;
    }

    public Set<Object> parseSet(@Nullable Alias alias, @Nonnull Reader reader) throws IOException {
        HashSet<Object> set = new HashSet<Object>();
        if (alias != null) {
            this.labeledResources.put(alias, set);
        }
        ReaderParser.check((Reader)reader, (char)'(');
        SurfParser.parseSequence(reader, ')', (IOConsumer<Reader>)((IOConsumer)r -> set.add(this.parseResource((Reader)r))));
        ReaderParser.check((Reader)reader, (char)')');
        return set;
    }

    protected static int parseSequence(@Nonnull Reader reader, char sequenceEnd, @Nonnull IOConsumer<Reader> itemParser) throws IOException {
        boolean nextItemRequired = false;
        int c = SurfParser.skipFiller(reader);
        while (c >= 0 && (nextItemRequired || c != sequenceEnd)) {
            itemParser.accept((Object)reader);
            Optional<Boolean> requireItem = SurfParser.skipSequenceDelimiters(reader);
            c = ReaderParser.peek((Reader)reader);
            if (!requireItem.isPresent()) break;
            nextItemRequired = requireItem.get();
        }
        return c;
    }

    protected static Optional<Boolean> skipSequenceDelimiters(@Nonnull Reader reader) throws IOException {
        int c = ReaderParser.skip((Reader)reader, (Characters)SURF.WHITESPACE_CHARACTERS);
        if (c == 33) {
            SurfParser.skipLineComment(reader);
            c = ReaderParser.peek((Reader)reader);
        }
        if (c < 0 || !SURF.SEQUENCE_SEPARATOR_CHARACTERS.contains((char)c)) {
            return Optional.empty();
        }
        boolean requireItem = false;
        do {
            if (c == 44) {
                requireItem = true;
                ReaderParser.check((Reader)reader, (char)',');
            }
            c = SurfParser.skipFiller(reader);
        } while (!requireItem && c >= 0 && SURF.SEQUENCE_SEPARATOR_CHARACTERS.contains((char)c));
        return Optional.of(requireItem);
    }

    protected static int skipFiller(@Nonnull Reader reader) throws IOException {
        int c;
        while ((c = ReaderParser.skip((Reader)reader, (Characters)WHITESPACE_EOL_CHARACTERS)) == 33) {
            SurfParser.skipLineComment(reader);
        }
        return c;
    }

    protected static void skipLineComment(@Nonnull Reader reader) throws IOException {
        ReaderParser.check((Reader)reader, (char)'!');
        ReaderParser.reach((Reader)reader, (Characters)Characters.EOL_CHARACTERS);
    }

    private static final class Alias {
        private final String string;

        private Alias(@Nonnull String string) {
            this.string = Objects.requireNonNull(string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            return object instanceof Alias && this.string.equals(((Alias)object).string);
        }

        public String toString() {
            return this.string;
        }
    }
}

