/*
 * Decompiled with CFR 0.152.
 */
package io.urf.surf;

import com.globalmentor.java.Characters;
import com.globalmentor.java.Conditions;
import com.globalmentor.net.ContentType;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class SURF {
    public static final ContentType CONTENT_TYPE = ContentType.of((String)"text", (String)"simple-urf", (ContentType.Parameter[])new ContentType.Parameter[0]);
    public static final String FILENAME_EXTENSION = "surf";
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    public static final Characters WHITESPACE_CHARACTERS = Characters.SPACE_SEPARATOR_CHARACTERS.add(new char[]{'\t', '\u000b', '\f', ' ', '\u00a0', '\ufeff'});
    public static final char SEQUENCE_DELIMITER = ',';
    public static final Characters SEQUENCE_SEPARATOR_CHARACTERS = Characters.EOL_CHARACTERS.add(new char[]{','});
    public static final char LINE_COMMENT_BEGIN = '!';
    public static final char LABEL_DELIMITER = '|';
    public static final char OBJECT_BEGIN = '*';
    public static final char DESCRIPTION_BEGIN = ':';
    public static final char DESCRIPTION_END = ';';
    public static final char PROPERTY_VALUE_DELIMITER = '=';
    public static final char BINARY_BEGIN = '%';
    public static final Characters BINARY_BASE64URL_CHARACTERS = Characters.of((Characters[])new Characters[]{Characters.ofRange((char)'A', (char)'Z'), Characters.ofRange((char)'a', (char)'z'), Characters.ofRange((char)'0', (char)'9'), Characters.of((char[])new char[]{'-', '_'})});
    public static final String BOOLEAN_FALSE_LEXICAL_FORM = "false";
    public static final String BOOLEAN_TRUE_LEXICAL_FORM = "true";
    public static final char BOOLEAN_FALSE_BEGIN = 'f';
    public static final char BOOLEAN_TRUE_BEGIN = 't';
    public static final char CHARACTER_DELIMITER = '\'';
    public static final char CHARACTER_ESCAPE = '\\';
    public static Characters CHARACTER_REQUIRED_ESCAPED_CHARACTERS = Characters.of((char[])new char[]{'\\', '\b', '\f', '\n', '\r', '\t', '\u000b'});
    public static Characters CHARACTER_OPTIONAL_ESCAPED_CHARACTERS = Characters.of((char[])new char[]{'/'});
    public static final char ESCAPED_BACKSPACE = 'b';
    public static final char ESCAPED_FORM_FEED = 'f';
    public static final char ESCAPED_LINE_FEED = 'n';
    public static final char ESCAPED_CARRIAGE_RETURN = 'r';
    public static final char ESCAPED_TAB = 't';
    public static final char ESCAPED_VERTICAL_TAB = 'v';
    public static final char ESCAPED_UNICODE = 'u';
    public static final char EMAIL_ADDRESS_BEGIN = '^';
    public static final char IRI_BEGIN = '<';
    public static final char IRI_END = '>';
    public static final char MEDIA_TYPE_BEGIN = '>';
    public static final char MEDIA_TYPE_END = '<';
    public static final char NUMBER_DECIMAL_BEGIN = '$';
    public static final char NUMBER_FRACTION_DELIMITER = '.';
    public static final Characters NUMBER_EXPONENT_DELIMITER_CHARACTERS = Characters.of((char[])new char[]{'e', 'E'});
    public static final Characters NUMBER_EXPONENT_SIGN_CHARACTERS = Characters.of((char[])new char[]{'-', '+'});
    public static final char NUMBER_NEGATIVE_SYMBOL = '-';
    public static final char REGULAR_EXPRESSION_DELIMITER = '/';
    public static final char REGULAR_EXPRESSION_ESCAPE = '\\';
    public static final char STRING_DELIMITER = '\"';
    public static final char TELEPHONE_NUMBER_BEGIN = '+';
    public static final char TEMPORAL_BEGIN = '@';
    public static final char TEMPORAL_ZONE_BEGIN = '[';
    public static final char TEMPORAL_ZONE_END = ']';
    public static final char UUID_BEGIN = '&';
    public static final char UUID_GROUP_DELIMITER = '-';
    public static final char LIST_BEGIN = '[';
    public static final char LIST_END = ']';
    public static final char MAP_BEGIN = '{';
    public static final char MAP_END = '}';
    public static final char MAP_KEY_DELIMITER = '\\';
    public static final char ENTRY_KEY_VALUE_DELIMITER = ':';
    public static final char SET_BEGIN = '(';
    public static final char SET_END = ')';

    public static final class Handle {
        public static final char SEGMENT_DELIMITER = '-';
        public static final Pattern PATTERN = Pattern.compile(String.format("(%s)(?:%s(%s))*", Name.TOKEN_PATTERN, Character.valueOf('-'), Name.TOKEN_PATTERN));

        public static final boolean isBeginCharacter(int c) {
            return Name.isTokenBeginCharacter(c);
        }

        public static boolean isValid(String string) {
            return PATTERN.matcher(Objects.requireNonNull(string)).matches();
        }

        public static String checkArgumentValid(String string) {
            Conditions.checkArgument((boolean)Handle.isValid(string), (String)"Invalid SURF handle \"%s\".", (Object[])new Object[]{string});
            return string;
        }
    }

    public static final class Name {
        public static final Pattern TOKEN_PATTERN;
        public static final Pattern PATTERN;

        public static boolean isValidToken(String string) {
            return TOKEN_PATTERN.matcher(Objects.requireNonNull(string)).matches();
        }

        public static String checkArgumentValidToken(String string) {
            Conditions.checkArgument((boolean)Name.isValidToken(string), (String)"Invalid SURF name token \"%s\".", (Object[])new Object[]{string});
            return string;
        }

        public static final boolean isTokenBeginCharacter(int c) {
            return Character.isLetter(c);
        }

        public static final boolean isTokenCharacter(int c) {
            return (8389630 >> Character.getType(c) & 1) != 0;
        }

        public static boolean isValid(String string) {
            return PATTERN.matcher(Objects.requireNonNull(string)).matches();
        }

        public static String checkArgumentValid(String string) {
            Conditions.checkArgument((boolean)Name.isValid(string), (String)"Invalid SURF name \"%s\".", (Object[])new Object[]{string});
            return string;
        }

        static {
            PATTERN = TOKEN_PATTERN = Pattern.compile("\\p{L}[\\p{L}\\p{M}\\p{N}\\p{Pc}]*");
        }
    }

    public static final class Tag {
        public static URI checkArgumentValid(@Nonnull URI tag) {
            Objects.requireNonNull(tag);
            Conditions.checkArgument((boolean)tag.isAbsolute(), (String)"SURF tag %s must be absolute.", (Object[])new Object[]{tag});
            Conditions.checkArgument((tag.getRawFragment() == null ? 1 : 0) != 0, (String)"SURF tag %s not allowed to have a fragment.", (Object[])new Object[]{tag});
            return tag;
        }
    }
}

