/*
 * Decompiled with CFR 0.152.
 */
package io.urf.surf;

import com.github.npathai.hamcrestopt.OptionalMatchers;
import com.globalmentor.io.ParseUnexpectedDataException;
import com.globalmentor.io.function.IOFunction;
import io.urf.surf.AbstractSimpleGraphSurfParserTest;
import io.urf.surf.SurfObject;
import io.urf.surf.SurfParser;
import io.urf.surf.SurfTestResources;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SurfParserTest
extends AbstractSimpleGraphSurfParserTest<SurfObject> {
    @Override
    protected Optional<Object> parseTestResource(@Nonnull InputStream inputStream) throws IOException {
        return new SurfParser().parse(inputStream);
    }

    @Override
    protected Class<SurfObject> getSurfObjectClass() {
        return SurfObject.class;
    }

    @Override
    public Optional<String> getTypeHandle(SurfObject surfObject) {
        return surfObject.getTypeHandle();
    }

    @Override
    protected int getPropertyCount(SurfObject surfObject) {
        return surfObject.getPropertyCount();
    }

    @Override
    public <T> Optional<T> getPropertyValue(SurfObject surfObject, String propertyHandle) {
        return surfObject.getPropertyValue(propertyHandle);
    }

    protected static <T> List<T> parseSequence(@Nonnull String input, char sequenceEnd, @Nonnull IOFunction<Reader, T> itemParser) throws IOException {
        ArrayList items = new ArrayList();
        SurfParser.parseSequence((Reader)new StringReader(input), (char)sequenceEnd, reader -> items.add(itemParser.apply(reader)));
        return items;
    }

    @Test
    public void testParseSequence() throws IOException {
        MatcherAssert.assertThat(SurfParserTest.parseSequence("true}", '}', SurfParser::parseBoolean), (Matcher)Matchers.contains((Object[])new Boolean[]{true}));
        MatcherAssert.assertThat(SurfParserTest.parseSequence("true, false}", '}', SurfParser::parseBoolean), (Matcher)Matchers.contains((Object[])new Boolean[]{true, false}));
        MatcherAssert.assertThat(SurfParserTest.parseSequence("true ", '}', SurfParser::parseBoolean), (Matcher)Matchers.contains((Object[])new Boolean[]{true}));
        MatcherAssert.assertThat(SurfParserTest.parseSequence("true\n", '}', SurfParser::parseBoolean), (Matcher)Matchers.contains((Object[])new Boolean[]{true}));
        MatcherAssert.assertThat(SurfParserTest.parseSequence("true, false", '}', SurfParser::parseBoolean), (Matcher)Matchers.contains((Object[])new Boolean[]{true, false}));
        MatcherAssert.assertThat(SurfParserTest.parseSequence("true false}", '}', SurfParser::parseBoolean), (Matcher)Matchers.contains((Object[])new Boolean[]{true}));
        MatcherAssert.assertThat(SurfParserTest.parseSequence("123, 234, 345}", '}', SurfParser::parseNumber), (Matcher)Matchers.contains((Object[])new Number[]{123L, 234L, 345L}));
        MatcherAssert.assertThat(SurfParserTest.parseSequence("123,234,345}", '}', SurfParser::parseNumber), (Matcher)Matchers.contains((Object[])new Number[]{123L, 234L, 345L}));
        Assertions.assertThrows(ParseUnexpectedDataException.class, () -> SurfParserTest.parseSequence("123,,234,345}", '}', SurfParser::parseNumber));
        Assertions.assertThrows(ParseUnexpectedDataException.class, () -> SurfParserTest.parseSequence("123\n,\n\t\n,234,345}", '}', SurfParser::parseNumber));
        Assertions.assertThrows(ParseUnexpectedDataException.class, () -> SurfParserTest.parseSequence("123,234,\n\n\n,345}", '}', SurfParser::parseNumber));
        MatcherAssert.assertThat(SurfParserTest.parseSequence("123\n234\n345}", '}', SurfParser::parseNumber), (Matcher)Matchers.contains((Object[])new Number[]{123L, 234L, 345L}));
        MatcherAssert.assertThat(SurfParserTest.parseSequence("123,234\n345}", '}', SurfParser::parseNumber), (Matcher)Matchers.contains((Object[])new Number[]{123L, 234L, 345L}));
        MatcherAssert.assertThat(SurfParserTest.parseSequence("123\n234,345}", '}', SurfParser::parseNumber), (Matcher)Matchers.contains((Object[])new Number[]{123L, 234L, 345L}));
        MatcherAssert.assertThat(SurfParserTest.parseSequence("123\n\n\n234  \n\n \t\n345}", '}', SurfParser::parseNumber), (Matcher)Matchers.contains((Object[])new Number[]{123L, 234L, 345L}));
        MatcherAssert.assertThat(SurfParserTest.parseSequence("123\n\t, \n 234 \n,345}", '}', SurfParser::parseNumber), (Matcher)Matchers.contains((Object[])new Number[]{123L, 234L, 345L}));
    }

    @Test
    public void testSkipSequenceDelimiters() throws IOException {
        MatcherAssert.assertThat((Object)SurfParser.skipSequenceDelimiters((Reader)new StringReader("")), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)SurfParser.skipSequenceDelimiters((Reader)new StringReader("   ")), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)SurfParser.skipSequenceDelimiters((Reader)new StringReader("\t")), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)SurfParser.skipSequenceDelimiters((Reader)new StringReader("!foo")), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)SurfParser.skipSequenceDelimiters((Reader)new StringReader("!foo,")), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)SurfParser.skipSequenceDelimiters((Reader)new StringReader("\t !foo")), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)SurfParser.skipSequenceDelimiters((Reader)new StringReader("foo")), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)SurfParser.skipSequenceDelimiters((Reader)new StringReader("foo !bar")), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)SurfParser.skipSequenceDelimiters((Reader)new StringReader("\n")), (Matcher)OptionalMatchers.isPresentAndIs((Object)false));
        MatcherAssert.assertThat((Object)SurfParser.skipSequenceDelimiters((Reader)new StringReader("   \n")), (Matcher)OptionalMatchers.isPresentAndIs((Object)false));
        MatcherAssert.assertThat((Object)SurfParser.skipSequenceDelimiters((Reader)new StringReader("\t\n")), (Matcher)OptionalMatchers.isPresentAndIs((Object)false));
        MatcherAssert.assertThat((Object)SurfParser.skipSequenceDelimiters((Reader)new StringReader("!foo\n")), (Matcher)OptionalMatchers.isPresentAndIs((Object)false));
        MatcherAssert.assertThat((Object)SurfParser.skipSequenceDelimiters((Reader)new StringReader("\t!foo\n")), (Matcher)OptionalMatchers.isPresentAndIs((Object)false));
        MatcherAssert.assertThat((Object)SurfParser.skipSequenceDelimiters((Reader)new StringReader(",")), (Matcher)OptionalMatchers.isPresentAndIs((Object)true));
        MatcherAssert.assertThat((Object)SurfParser.skipSequenceDelimiters((Reader)new StringReader("   ,")), (Matcher)OptionalMatchers.isPresentAndIs((Object)true));
        MatcherAssert.assertThat((Object)SurfParser.skipSequenceDelimiters((Reader)new StringReader("\t,")), (Matcher)OptionalMatchers.isPresentAndIs((Object)true));
    }

    @Test
    public void testOkLabels() throws IOException {
        try (InputStream inputStream = SurfTestResources.class.getResourceAsStream("ok-labels.surf");){
            SurfParser surfParser = new SurfParser();
            SurfObject root = (SurfObject)surfParser.parse(inputStream).get();
            Optional rootAliased = surfParser.findResourceByAlias("root");
            MatcherAssert.assertThat((Object)rootAliased, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.sameInstance((Object)root)));
            Object foo = root.getPropertyValue("foo").orElseThrow(AssertionError::new);
            MatcherAssert.assertThat(foo, (Matcher)Matchers.is((Object)123L));
            Optional numberAliased = surfParser.findResourceByAlias("number");
            MatcherAssert.assertThat((Object)numberAliased, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.sameInstance(foo)));
            Object value = root.getPropertyValue("value").orElseThrow(AssertionError::new);
            MatcherAssert.assertThat(value, (Matcher)Matchers.is((Object)false));
            Optional testAliased = surfParser.findResourceByAlias("test");
            MatcherAssert.assertThat((Object)testAliased, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.sameInstance(value)));
            SurfObject thing = (SurfObject)root.getPropertyValue("thing").orElseThrow(AssertionError::new);
            MatcherAssert.assertThat((Object)thing.getTypeHandle(), (Matcher)OptionalMatchers.isPresentAndIs((Object)"example-Type"));
            Optional objectAliased = surfParser.findResourceByAlias("object");
            MatcherAssert.assertThat((Object)objectAliased, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.sameInstance((Object)thing)));
            SurfObject foobar = (SurfObject)root.getPropertyValue("foobar").orElseThrow(AssertionError::new);
            MatcherAssert.assertThat((Object)foobar.getTypeHandle(), (Matcher)OptionalMatchers.isPresentAndIs((Object)"Bar"));
            MatcherAssert.assertThat((Object)foobar.getId(), (Matcher)OptionalMatchers.isPresentAndIs((Object)"foo"));
            MatcherAssert.assertThat((Object)foobar.getPropertyValue("prop"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"val"));
            Optional foobarIded = surfParser.findObjectById("Bar", "foo");
            MatcherAssert.assertThat((Object)foobarIded, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.sameInstance((Object)foobar)));
            List stuff = (List)thing.getPropertyValue("stuff").orElseThrow(AssertionError::new);
            MatcherAssert.assertThat((Object)stuff, (Matcher)Matchers.hasSize((int)4));
            MatcherAssert.assertThat(stuff.get(0), (Matcher)Matchers.is((Object)"one"));
            MatcherAssert.assertThat(stuff.get(1), (Matcher)Matchers.is((Object)123L));
            MatcherAssert.assertThat((Object)numberAliased, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.sameInstance(stuff.get(1))));
            MatcherAssert.assertThat(stuff.get(2), (Matcher)Matchers.is((Object)"three"));
            Object stuffElement4 = stuff.get(3);
            MatcherAssert.assertThat(stuffElement4, (Matcher)Matchers.instanceOf(this.getSurfObjectClass()));
            SurfObject exampleThing = (SurfObject)stuffElement4;
            MatcherAssert.assertThat((Object)exampleThing.getTypeHandle(), (Matcher)OptionalMatchers.isPresentAndIs((Object)"example-Thing"));
            MatcherAssert.assertThat((Object)exampleThing.getTag(), (Matcher)OptionalMatchers.isPresentAndIs((Object)URI.create("http://example.com/thing")));
            MatcherAssert.assertThat((Object)exampleThing.getPropertyValue("name"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"Example Thing"));
            Optional exampleThingTagged = surfParser.findObjectByTag(URI.create("http://example.com/thing"));
            MatcherAssert.assertThat((Object)exampleThingTagged, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.sameInstance((Object)exampleThing)));
            Map map = (Map)root.getPropertyValue("map").orElseThrow(AssertionError::new);
            MatcherAssert.assertThat(map.get(1L), (Matcher)Matchers.is((Object)"one"));
            MatcherAssert.assertThat(map.get(2L), (Matcher)Matchers.is((Matcher)Matchers.sameInstance(numberAliased.get())));
            MatcherAssert.assertThat(map.get(4L), (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)foobar)));
            MatcherAssert.assertThat(map.get(99L), (Matcher)Matchers.is((Matcher)Matchers.sameInstance(exampleThingTagged.get())));
            MatcherAssert.assertThat(map.get(100L), (Matcher)Matchers.is((Matcher)Matchers.sameInstance(objectAliased.get())));
            Set set = (Set)root.getPropertyValue("set").orElseThrow(AssertionError::new);
            MatcherAssert.assertThat((Object)set, (Matcher)Matchers.hasSize((int)5));
            MatcherAssert.assertThat((Object)set, (Matcher)Matchers.hasItem((Object)123L));
            MatcherAssert.assertThat((Object)set, (Matcher)Matchers.hasItem((Object)false));
            Optional newAliased = surfParser.findResourceByAlias("newThing");
            SurfObject newAliasedResource = (SurfObject)newAliased.orElseThrow(AssertionError::new);
            MatcherAssert.assertThat(this.getTypeHandle(newAliasedResource), (Matcher)OptionalMatchers.isPresentAndIs((Object)"example-Thing"));
            MatcherAssert.assertThat(this.getPropertyValue(newAliasedResource, "description"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"a new thing"));
            Optional anotherAliased = surfParser.findResourceByAlias("another");
            SurfObject anotherAliasedResource = (SurfObject)anotherAliased.orElseThrow(AssertionError::new);
            MatcherAssert.assertThat(this.getPropertyValue(anotherAliasedResource, "description"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"yet another thing"));
            MatcherAssert.assertThat((Object)set, (Matcher)Matchers.hasItem((Matcher)Matchers.sameInstance(numberAliased.get())));
            MatcherAssert.assertThat((Object)set, (Matcher)Matchers.hasItem((Matcher)Matchers.sameInstance(testAliased.get())));
            MatcherAssert.assertThat((Object)set, (Matcher)Matchers.hasItem((Matcher)Matchers.sameInstance(objectAliased.get())));
            MatcherAssert.assertThat((Object)set, (Matcher)Matchers.hasItem((Matcher)Matchers.sameInstance((Object)newAliasedResource)));
            MatcherAssert.assertThat((Object)set, (Matcher)Matchers.hasItem((Matcher)Matchers.sameInstance((Object)anotherAliasedResource)));
        }
    }
}

