/*
 * Decompiled with CFR 0.152.
 */
package io.urf.surf;

import com.globalmentor.collections.iterables.ConverterIterable;
import io.urf.surf.SURF;
import java.net.URI;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SurfObject {
    private final URI tag;
    private final String typeHandle;
    private final String id;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public Optional<URI> getTag() {
        return Optional.ofNullable(this.tag);
    }

    public Optional<String> getTypeHandle() {
        return Optional.ofNullable(this.typeHandle);
    }

    public Optional<String> getId() {
        return Optional.ofNullable(this.id);
    }

    public int getPropertyCount() {
        return this.properties.size();
    }

    public boolean hasDescription() {
        return !this.properties.isEmpty();
    }

    public Optional<Object> getPropertyValue(String propertyHandle) {
        return Optional.ofNullable(this.properties.get(Objects.requireNonNull(propertyHandle)));
    }

    public Optional<Object> setPropertyValue(String propertyHandle, Object value) {
        return Optional.ofNullable(this.properties.put(SURF.Handle.checkArgumentValid(propertyHandle), Objects.requireNonNull(value)));
    }

    public Iterable<Map.Entry<String, Object>> getProperties() {
        return new ConverterIterable(this.properties.entrySet(), AbstractMap.SimpleImmutableEntry::new);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public void setProperties(@Nonnull Map<String, ?> properties) {
        properties.forEach(this::setPropertyValue);
    }

    public SurfObject() {
        this((URI)null, null);
    }

    public SurfObject(@Nullable URI tag) {
        this(tag, null);
    }

    public SurfObject(@Nullable URI tag, @Nullable String typeHandle) {
        this.tag = tag != null ? SURF.Tag.checkArgumentValid(tag) : null;
        this.typeHandle = typeHandle != null ? SURF.Handle.checkArgumentValid(typeHandle) : null;
        this.id = null;
    }

    public SurfObject(@Nullable String typeHandle) {
        this((URI)null, typeHandle);
    }

    public SurfObject(@Nonnull String typeHandle, @Nullable String id) {
        this.tag = null;
        this.typeHandle = SURF.Handle.checkArgumentValid(typeHandle);
        this.id = id;
    }

    public int hashCode() {
        int propertiesHashCode = 0;
        for (Map.Entry<String, Object> propertyEntry : this.properties.entrySet()) {
            int propertyValueHashCode;
            Object propertyValue = propertyEntry.getValue();
            if (propertyValue instanceof SurfObject) {
                SurfObject surfObjectPropertyValue = (SurfObject)propertyValue;
                propertyValueHashCode = Objects.hash(surfObjectPropertyValue.tag, surfObjectPropertyValue.typeHandle, surfObjectPropertyValue.id, surfObjectPropertyValue.properties.size());
            } else {
                propertyValueHashCode = propertyValue instanceof Collection ? ((Collection)propertyValue).size() : (propertyValue instanceof Map ? ((Map)propertyValue).size() : propertyValue.hashCode());
            }
            propertiesHashCode += propertyEntry.getKey().hashCode() ^ propertyValueHashCode;
        }
        return Objects.hash(this.tag, this.typeHandle, this.id, propertiesHashCode);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SurfObject)) {
            return false;
        }
        SurfObject surfObject = (SurfObject)object;
        return this.getTag().equals(surfObject.getTag()) && this.getTypeHandle().equals(surfObject.getTypeHandle()) && this.getId().equals(surfObject.getId()) && this.properties.equals(surfObject.properties);
    }
}

