/*
 * Decompiled with CFR 0.152.
 */
package io.urf.surf;

import com.globalmentor.io.Close;
import com.globalmentor.io.ParseIOException;
import com.globalmentor.io.function.IOBiConsumer;
import com.globalmentor.itu.TelephoneNumber;
import com.globalmentor.java.CodePointCharacter;
import com.globalmentor.java.Conditions;
import com.globalmentor.net.EmailAddress;
import com.globalmentor.net.URIs;
import com.globalmentor.text.ASCII;
import io.urf.surf.SURF;
import io.urf.surf.SurfObject;
import io.urf.surf.SurfResources;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.temporal.TemporalAccessor;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.zalando.fauxpas.FauxPas;

public class SurfSerializer {
    public static final String GENERATED_ALIAS_PREFIX = "resource";
    private static final String ARRAY_LIST_CLASS_NAME = "java.util.ArrayList";
    private static final String BIG_DECIMAL_CLASS_NAME = "java.math.BigDecimal";
    private static final String BIG_INTEGER_CLASS_NAME = "java.math.BigInteger";
    private static final String BOOLEAN_CLASS_NAME = "java.lang.Boolean";
    private static final String BYTE_CLASS_NAME = "java.lang.Byte";
    private static final String BYTE_ARRAY_CLASS_NAME = "[B";
    private static final String CHARACTER_CLASS_NAME = "java.lang.Character";
    private static final String CODE_POINT_CHARACTER_CLASS_NAME = "com.globalmentor.java.CodePointCharacter";
    private static final String DATE_CLASS_NAME = "java.util.Date";
    private static final String DOUBLE_CLASS_NAME = "java.lang.Double";
    private static final String EMAIL_ADDRESS_CLASS_NAME = "com.globalmentor.net.EmailAddress";
    private static final String FLOAT_CLASS_NAME = "java.lang.Float";
    private static final String HASH_MAP_CLASS_NAME = "java.util.HashMap";
    private static final String HASH_SET_CLASS_NAME = "java.util.HashSet";
    private static final String INSTANT_CLASS_NAME = "java.time.Instant";
    private static final String INTEGER_CLASS_NAME = "java.lang.Integer";
    private static final String LINKED_HASH_MAP_CLASS_NAME = "java.util.LinkedHashMap";
    private static final String LINKED_HASH_SET_CLASS_NAME = "java.util.LinkedHashSet";
    private static final String LINKED_LIST_CLASS_NAME = "java.util.LinkedList";
    private static final String LOCAL_DATE_CLASS_NAME = "java.time.LocalDate";
    private static final String LOCAL_DATE_TIME_CLASS_NAME = "java.time.LocalDateTime";
    private static final String LOCAL_TIME_CLASS_NAME = "java.time.LocalTime";
    private static final String LONG_CLASS_NAME = "java.lang.Long";
    private static final String MONTH_DAY_CLASS_NAME = "java.time.MonthDay";
    private static final String OFFSET_DATE_TIME_CLASS_NAME = "java.time.OffsetDateTime";
    private static final String OFFSET_TIME_CLASS_NAME = "java.time.OffsetTime";
    private static final String PATTERN_CLASS_NAME = "java.util.regex.Pattern";
    private static final String SHORT_CLASS_NAME = "java.lang.Short";
    private static final String STRING_CLASS_NAME = "java.lang.String";
    private static final String STRING_BUILDER_CLASS_NAME = "java.lang.StringBuilder";
    private static final String TELEPHONE_NUMBER_CLASS_NAME = "com.globalmentor.itu.TelephoneNumber";
    private static final String TREE_MAP_CLASS_NAME = "java.util.TreeMap";
    private static final String TREE_SET_CLASS_NAME = "java.util.TreeSet";
    private static final String URI_CLASS_NAME = "java.net.URI";
    private static final String URL_CLASS_NAME = "java.net.URL";
    private static final String UUID_CLASS_NAME = "java.util.UUID";
    private static final String YEAR__CLASS_NAME = "java.time.Year";
    private static final String YEAR_MONTH_CLASS_NAME = "java.time.YearMonth";
    private static final String ZONED_DATE_TIME_CLASS_NAME = "java.time.ZonedDateTime";
    private boolean formatted = false;
    private CharSequence indentSequence = String.valueOf('\t');
    private int indentLevel = 0;
    private CharSequence lineSeparator = System.lineSeparator();
    private boolean sequenceSeparatorRequired = false;
    private final Map<Object, Boolean> resourceHasReferenceMap = new IdentityHashMap<Object, Boolean>();
    private final Map<Object, String> aliasesByCompoundResource = new IdentityHashMap<Object, String>();
    private final Map<Object, String> aliasesByValue = new HashMap<Object, String>();
    private long generatedAliasCount = 0L;
    private final Set<Object> serializedCompoundResources = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<Object> serializedValues = new HashSet<Object>();

    public boolean isFormatted() {
        return this.formatted;
    }

    public void setFormatted(boolean formatted) {
        this.formatted = formatted;
    }

    public CharSequence getIndentSequence() {
        return this.indentSequence;
    }

    public void setIndentSequence(@Nonnull CharSequence indentSequence) {
        this.indentSequence = Objects.requireNonNull(indentSequence);
    }

    protected Closeable increaseIndentLevel() {
        ++this.indentLevel;
        return Close.by(this::decreaseIndentLevel);
    }

    protected Appendable formatIndent(@Nonnull Appendable appendable) throws IOException {
        if (this.isFormatted()) {
            CharSequence indentSequence = this.getIndentSequence();
            for (int i = 0; i < this.indentLevel; ++i) {
                appendable.append(indentSequence);
            }
        }
        return appendable;
    }

    protected void decreaseIndentLevel() {
        --this.indentLevel;
    }

    public CharSequence getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(@Nonnull CharSequence lineSeparator) {
        this.lineSeparator = Objects.requireNonNull(lineSeparator);
    }

    protected boolean formatNewLine(@Nonnull Appendable appendable) throws IOException {
        boolean isNewlineAppended = this.isFormatted();
        if (isNewlineAppended) {
            appendable.append(this.lineSeparator);
        }
        return isNewlineAppended;
    }

    public boolean isSequenceSeparatorRequired() {
        return this.sequenceSeparatorRequired;
    }

    public void setSequenceSeparatorRequired(boolean sequenceSeparatorRequired) {
        this.sequenceSeparatorRequired = sequenceSeparatorRequired;
    }

    private boolean calculateResourceHasReference(@Nonnull Object resource) {
        boolean hasReference = this.resourceHasReferenceMap.containsKey(resource);
        this.resourceHasReferenceMap.put(resource, hasReference);
        return hasReference;
    }

    protected void discoverResourceReferences(@Nonnull Object resource) {
        Objects.requireNonNull(resource);
        if (resource instanceof SurfObject) {
            if (!this.calculateResourceHasReference(resource)) {
                ((SurfObject)resource).getProperties().forEach(propertyEntry -> this.discoverResourceReferences(propertyEntry.getValue()));
            }
        } else if (resource instanceof Collection) {
            if (!this.calculateResourceHasReference(resource)) {
                ((Collection)resource).forEach(this::discoverResourceReferences);
            }
        } else if (resource instanceof Map && !this.calculateResourceHasReference(resource)) {
            ((Map)resource).forEach((key, value) -> {
                this.discoverResourceReferences(key);
                this.discoverResourceReferences(value);
            });
        }
    }

    public Optional<String> getAliasForResource(@Nonnull Object resource) {
        Objects.requireNonNull(resource);
        if (SurfResources.isCompoundResource(resource)) {
            return Optional.ofNullable(this.aliasesByCompoundResource.get(resource));
        }
        return Optional.ofNullable(this.aliasesByValue.get(resource));
    }

    public void setAliasForResource(@Nonnull Object resource, @Nonnull String alias) {
        Objects.requireNonNull(resource);
        SURF.Name.checkArgumentValidToken(alias);
        if (SurfResources.isCompoundResource(resource)) {
            if (resource instanceof SurfObject) {
                SurfObject surfObject = (SurfObject)resource;
                Conditions.checkArgument((!surfObject.getTag().isPresent() ? 1 : 0) != 0, (String)"An alias cannot be specified for object with tag %s.", (Object[])new Object[]{surfObject.getTag().orElse(null)});
                Conditions.checkArgument((!surfObject.getId().isPresent() ? 1 : 0) != 0, (String)"An alias cannot be specified for object with ID %s for type %s.", (Object[])new Object[]{surfObject.getId().orElse(null), surfObject.getTypeHandle().orElse(null)});
            }
            this.aliasesByCompoundResource.put(resource, alias);
        } else {
            this.aliasesByValue.put(resource, alias);
        }
    }

    protected String determineAliasForResource(@Nonnull Object resource) {
        Objects.requireNonNull(resource);
        return this.getAliasForResource(resource).orElseGet(() -> {
            if (SurfResources.isCompoundResource(resource)) {
                SurfObject surfObject;
                if (resource instanceof SurfObject && ((surfObject = (SurfObject)resource).getTag().isPresent() || surfObject.getId().isPresent())) {
                    return null;
                }
                if (Boolean.TRUE.equals(this.resourceHasReferenceMap.get(resource))) {
                    long aliasNumber = ++this.generatedAliasCount;
                    String newAlias = GENERATED_ALIAS_PREFIX + aliasNumber;
                    this.setAliasForResource(resource, newAlias);
                    return newAlias;
                }
            }
            return null;
        });
    }

    protected boolean isSerialized(@Nonnull Object resource) {
        return (SurfResources.isCompoundResource(resource) ? this.serializedCompoundResources : this.serializedValues).contains(resource);
    }

    protected boolean setSerialized(@Nonnull Object resource) {
        return !(SurfResources.isCompoundResource(resource) ? this.serializedCompoundResources : this.serializedValues).add(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serialize(@Nonnull @Nullable Object root) throws IOException {
        this.discoverResourceReferences(root);
        try {
            try (StringWriter stringWriter = new StringWriter();){
                this.serialize(stringWriter, root);
            }
            String string = ((Object)stringWriter).toString();
            return string;
        }
        finally {
            this.resourceHasReferenceMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(@Nonnull OutputStream outputStream, @Nullable Object root) throws IOException {
        this.discoverResourceReferences(root);
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, SURF.CHARSET));
            this.serialize(writer, root);
            ((Writer)writer).flush();
        }
        finally {
            this.resourceHasReferenceMap.clear();
        }
    }

    public Appendable serialize(@Nonnull Appendable appendable, @Nullable Object root) throws IOException {
        if (root == null) {
            return appendable;
        }
        return this.serializeResource(appendable, root);
    }

    public Appendable serializeResource(@Nonnull Appendable appendable, @Nullable Object resource) throws IOException {
        SurfObject surfObject;
        boolean wasSerialized = this.setSerialized(resource);
        String alias = this.determineAliasForResource(resource);
        if (alias != null) {
            appendable.append('|').append(alias).append('|');
            if (wasSerialized) {
                return appendable;
            }
        }
        switch (resource.getClass().getName()) {
            case "[B": {
                SurfSerializer.serializeBinary(appendable, (byte[])resource);
                break;
            }
            case "java.lang.Boolean": {
                SurfSerializer.serializeBoolean(appendable, (Boolean)resource);
                break;
            }
            case "java.lang.Character": {
                SurfSerializer.serializeCharacter(appendable, ((Character)resource).charValue());
                break;
            }
            case "com.globalmentor.java.CodePointCharacter": {
                SurfSerializer.serializeCharacter(appendable, ((CodePointCharacter)resource).getCodePoint());
                break;
            }
            case "com.globalmentor.net.EmailAddress": {
                SurfSerializer.serializeEmailAddress(appendable, (EmailAddress)resource);
                break;
            }
            case "java.net.URI": {
                SurfSerializer.serializeIri(appendable, (URI)resource);
                break;
            }
            case "java.net.URL": {
                try {
                    SurfSerializer.serializeIri(appendable, ((URL)resource).toURI());
                    break;
                }
                catch (URISyntaxException uriURISyntaxException) {
                    throw new IllegalArgumentException(String.format("URL %s is not a valid URI.", resource), uriURISyntaxException);
                }
            }
            case "java.math.BigDecimal": 
            case "java.math.BigInteger": 
            case "java.lang.Byte": 
            case "java.lang.Double": 
            case "java.lang.Float": 
            case "java.lang.Integer": 
            case "java.lang.Long": 
            case "java.lang.Short": {
                SurfSerializer.serializeNumber(appendable, (Number)resource);
                break;
            }
            case "java.util.regex.Pattern": {
                SurfSerializer.serializeRegularExpression(appendable, (Pattern)resource);
                break;
            }
            case "java.lang.String": 
            case "java.lang.StringBuilder": {
                SurfSerializer.serializeString(appendable, (CharSequence)resource);
                break;
            }
            case "com.globalmentor.itu.TelephoneNumber": {
                SurfSerializer.serializeTelephoneNumber(appendable, (TelephoneNumber)resource);
                break;
            }
            case "java.util.Date": {
                SurfSerializer.serializeTemporal(appendable, ((Date)resource).toInstant());
                break;
            }
            case "java.time.Instant": 
            case "java.time.MonthDay": 
            case "java.time.LocalDate": 
            case "java.time.LocalDateTime": 
            case "java.time.LocalTime": 
            case "java.time.OffsetDateTime": 
            case "java.time.OffsetTime": 
            case "java.time.Year": 
            case "java.time.YearMonth": 
            case "java.time.ZonedDateTime": {
                SurfSerializer.serializeTemporal(appendable, (TemporalAccessor)resource);
                break;
            }
            case "java.util.UUID": {
                SurfSerializer.serializeUuid(appendable, (UUID)resource);
                break;
            }
            case "java.util.ArrayList": 
            case "java.util.LinkedList": {
                this.serializeList(appendable, (List)resource);
                break;
            }
            case "java.util.HashMap": 
            case "java.util.LinkedHashMap": 
            case "java.util.TreeMap": {
                this.serializeMap(appendable, (Map)resource);
                break;
            }
            case "java.util.HashSet": 
            case "java.util.LinkedHashSet": 
            case "java.util.TreeSet": {
                this.serializeSet(appendable, (Set)resource);
                break;
            }
            default: {
                if (resource instanceof SurfObject) {
                    SurfObject surfObject2 = (SurfObject)resource;
                    if (surfObject2.getTag().isPresent()) {
                        appendable.append('|');
                        SurfSerializer.serializeIri(appendable, surfObject2.getTag().get());
                        appendable.append('|');
                        if (wasSerialized) {
                            return appendable;
                        }
                    } else if (surfObject2.getId().isPresent()) {
                        appendable.append('|');
                        SurfSerializer.serializeString(appendable, surfObject2.getId().get());
                        appendable.append('|');
                    }
                    this.serializeObject(appendable, (SurfObject)resource);
                    if (!surfObject2.getId().isPresent() || !wasSerialized) break;
                    return appendable;
                }
                if (resource instanceof List) {
                    this.serializeList(appendable, (List)resource);
                    break;
                }
                if (resource instanceof Map) {
                    this.serializeMap(appendable, (Map)resource);
                    break;
                }
                if (resource instanceof Set) {
                    this.serializeSet(appendable, (Set)resource);
                    break;
                }
                if (resource instanceof ByteBuffer) {
                    SurfSerializer.serializeBinary(appendable, (ByteBuffer)resource);
                    break;
                }
                if (resource instanceof Number) {
                    SurfSerializer.serializeNumber(appendable, (Number)resource);
                    break;
                }
                if (resource instanceof CharSequence) {
                    SurfSerializer.serializeString(appendable, (CharSequence)resource);
                    break;
                }
                if (resource instanceof TelephoneNumber) {
                    SurfSerializer.serializeTelephoneNumber(appendable, (TelephoneNumber)resource);
                    break;
                }
                if (resource instanceof Date) {
                    SurfSerializer.serializeTemporal(appendable, (TemporalAccessor)resource);
                    break;
                }
                throw new UnsupportedOperationException("Unsupported SURF serialization type: " + resource.getClass().getName());
            }
        }
        if (resource instanceof SurfObject && (surfObject = (SurfObject)resource).getPropertyCount() > 0) {
            this.serializeDescription(appendable, surfObject);
        }
        return appendable;
    }

    public Appendable serializeObject(@Nonnull Appendable appendable, @Nonnull SurfObject surfObject) throws IOException {
        appendable.append('*');
        surfObject.getTypeHandle().ifPresent((Consumer<String>)FauxPas.throwingConsumer(appendable::append));
        return appendable;
    }

    public Appendable serializeDescription(@Nonnull Appendable appendable, @Nonnull SurfObject surfObject) throws IOException {
        appendable.append(':');
        this.formatNewLine(appendable);
        try (Closeable indention = this.increaseIndentLevel();){
            this.serializeSequence(appendable, surfObject.getProperties(), (out, property) -> {
                out.append((CharSequence)property.getKey());
                if (this.formatted) {
                    out.append(' ');
                }
                out.append('=');
                if (this.formatted) {
                    out.append(' ');
                }
                this.serializeResource((Appendable)out, property.getValue());
            });
        }
        this.formatIndent(appendable);
        return appendable.append(';');
    }

    public static Appendable serializeBinary(@Nonnull Appendable appendable, @Nonnull byte[] bytes) throws IOException {
        appendable.append('%');
        return appendable.append(Base64.getUrlEncoder().withoutPadding().encodeToString(bytes));
    }

    public static Appendable serializeBinary(@Nonnull Appendable appendable, @Nonnull ByteBuffer byteBuffer) throws IOException {
        byte[] base64Bytes;
        appendable.append('%');
        ByteBuffer base64ByteBuffer = Base64.getEncoder().withoutPadding().encode(byteBuffer);
        if (base64ByteBuffer.hasArray()) {
            base64Bytes = base64ByteBuffer.array();
        } else {
            base64Bytes = new byte[base64ByteBuffer.remaining()];
            base64ByteBuffer.get(base64Bytes);
        }
        return appendable.append(new String(base64Bytes, StandardCharsets.US_ASCII));
    }

    public static Appendable serializeBoolean(@Nonnull Appendable appendable, @Nonnull boolean bool) throws IOException {
        return appendable.append(bool ? "true" : "false");
    }

    public static Appendable serializeCharacter(@Nonnull Appendable appendable, @Nonnull int codePoint) throws IOException {
        Conditions.checkArgument((boolean)Character.isValidCodePoint(codePoint), (String)"The value %d does not represent is not a valid code point.", (Object[])new Object[]{codePoint});
        appendable.append('\'');
        SurfSerializer.serializeCharacterCodePoint(appendable, '\'', codePoint);
        return appendable.append('\'');
    }

    public static Appendable serializeCharacterCodePoint(@Nonnull Appendable appendable, char delimiter, int codePoint) throws IOException, ParseIOException {
        if (codePoint == delimiter || codePoint <= 65535 && SURF.CHARACTER_REQUIRED_ESCAPED_CHARACTERS.contains((char)codePoint)) {
            char escapeChar;
            appendable.append('\\');
            switch (codePoint) {
                case 92: {
                    escapeChar = '\\';
                    break;
                }
                case 8: {
                    escapeChar = 'b';
                    break;
                }
                case 12: {
                    escapeChar = 'f';
                    break;
                }
                case 10: {
                    escapeChar = 'n';
                    break;
                }
                case 13: {
                    escapeChar = 'r';
                    break;
                }
                case 9: {
                    escapeChar = 't';
                    break;
                }
                case 11: {
                    escapeChar = 'v';
                    break;
                }
                default: {
                    assert (codePoint == delimiter);
                    escapeChar = delimiter;
                }
            }
            return appendable.append(escapeChar);
        }
        if (Character.isSupplementaryCodePoint(codePoint)) {
            return appendable.append(Character.highSurrogate(codePoint)).append(Character.lowSurrogate(codePoint));
        }
        assert (Character.isBmpCodePoint(codePoint));
        return appendable.append((char)codePoint);
    }

    public static Appendable serializeEmailAddress(@Nonnull Appendable appendable, @Nonnull EmailAddress emailAddress) throws IOException {
        appendable.append('^');
        return appendable.append(emailAddress.toString());
    }

    public static Appendable serializeIri(@Nonnull Appendable appendable, @Nonnull URI iri) throws IOException {
        URIs.checkAbsolute((URI)iri);
        appendable.append('<');
        switch (ASCII.toLowerCase((CharSequence)iri.getScheme()).toString()) {
            case "mailto": {
                appendable.append('^').append(iri.getSchemeSpecificPart());
                break;
            }
            case "tel": {
                appendable.append(iri.getSchemeSpecificPart());
                break;
            }
            case "urn": {
                String ssp = iri.getSchemeSpecificPart();
                Matcher urnMatcher = URIs.URN_SSP_PATTERN.matcher(ssp);
                if (urnMatcher.matches() && ASCII.toLowerCase((CharSequence)urnMatcher.group(1)).equals("uuid")) {
                    appendable.append('&').append(urnMatcher.group(2));
                    break;
                }
            }
            default: {
                appendable.append(iri.toString());
            }
        }
        return appendable.append('>');
    }

    public static Appendable serializeNumber(@Nonnull Appendable appendable, @Nonnull Number number) throws IOException {
        boolean isDecimal = number instanceof BigDecimal;
        if (isDecimal) {
            appendable.append('$');
        }
        return appendable.append(number.toString());
    }

    public static Appendable serializeRegularExpression(@Nonnull Appendable appendable, @Nonnull Pattern regularExpression) throws IOException {
        appendable.append('/');
        String regexString = regularExpression.toString();
        if (regexString.indexOf(47) >= 0) {
            int regexLength = regexString.length();
            for (int i = 0; i < regexLength; ++i) {
                char c = regexString.charAt(i);
                if (c == '/') {
                    appendable.append('\\');
                }
                appendable.append(c);
            }
        } else {
            appendable.append(regexString);
        }
        return appendable.append('/');
    }

    public static Appendable serializeString(@Nonnull Appendable appendable, @Nonnull CharSequence charSequence) throws IOException {
        appendable.append('\"');
        int length = charSequence.length();
        for (int i = 0; i < length; ++i) {
            int codePoint;
            int c = charSequence.charAt(i);
            if (Character.isHighSurrogate((char)c)) {
                Conditions.checkArgument((c < length - 1 ? 1 : 0) != 0, (String)"Cannot serialize character sequence %s ending in high surrogate character.", (Object[])new Object[]{charSequence});
                codePoint = Character.toCodePoint((char)c, charSequence.charAt(++i));
            } else {
                Conditions.checkArgument((!Character.isLowSurrogate((char)c) ? 1 : 0) != 0, (String)"Cannot serialize character sequence %s with illegal surrogate character sequence.", (Object[])new Object[]{charSequence});
                codePoint = c;
            }
            SurfSerializer.serializeCharacterCodePoint(appendable, '\"', codePoint);
        }
        return appendable.append('\"');
    }

    public static Appendable serializeTelephoneNumber(@Nonnull Appendable appendable, @Nonnull TelephoneNumber telephoneNumber) throws IOException {
        Conditions.checkArgument((boolean)telephoneNumber.isGlobal(), (String)"Telephone number %s not in global form.", (Object[])new Object[]{telephoneNumber});
        return appendable.append(telephoneNumber.toString());
    }

    public static Appendable serializeTemporal(@Nonnull Appendable appendable, @Nonnull TemporalAccessor temporal) throws IOException {
        appendable.append('@');
        return appendable.append(temporal.toString());
    }

    public static Appendable serializeUuid(@Nonnull Appendable appendable, @Nonnull UUID uuid) throws IOException {
        appendable.append('&');
        return appendable.append(uuid.toString());
    }

    public Appendable serializeList(@Nonnull Appendable appendable, @Nonnull List<?> list) throws IOException {
        appendable.append('[');
        if (!list.isEmpty()) {
            this.formatNewLine(appendable);
            try (Closeable indention = this.increaseIndentLevel();){
                this.serializeSequence(appendable, list, this::serializeResource);
            }
            this.formatIndent(appendable);
        }
        return appendable.append(']');
    }

    public Appendable serializeMap(@Nonnull Appendable appendable, @Nonnull Map<?, ?> map) throws IOException {
        appendable.append('{');
        if (!map.isEmpty()) {
            this.formatNewLine(appendable);
            try (Closeable indention = this.increaseIndentLevel();){
                this.serializeSequence(appendable, map.entrySet(), (out, entry) -> {
                    boolean hasDescription;
                    Object key = entry.getKey();
                    boolean bl = hasDescription = key instanceof SurfObject && ((SurfObject)key).hasDescription();
                    if (hasDescription) {
                        out.append('\\');
                    }
                    this.serializeResource((Appendable)out, key);
                    if (hasDescription) {
                        out.append('\\');
                    }
                    out.append(':');
                    if (this.formatted) {
                        out.append(' ');
                    }
                    this.serializeResource((Appendable)out, entry.getValue());
                });
            }
            this.formatIndent(appendable);
        }
        return appendable.append('}');
    }

    public Appendable serializeSet(@Nonnull Appendable appendable, @Nonnull Set<?> set) throws IOException {
        appendable.append('(');
        if (!set.isEmpty()) {
            this.formatNewLine(appendable);
            try (Closeable indention = this.increaseIndentLevel();){
                this.serializeSequence(appendable, set, this::serializeResource);
            }
            this.formatIndent(appendable);
        }
        return appendable.append(')');
    }

    protected <I> Appendable serializeSequence(@Nonnull Appendable appendable, @Nonnull Iterable<I> sequence, @Nonnull IOBiConsumer<Appendable, I> itemSerializer) throws IOException {
        boolean sequenceSeparatorRequired = this.isSequenceSeparatorRequired();
        Iterator<I> iterator = sequence.iterator();
        while (iterator.hasNext()) {
            this.formatIndent(appendable);
            I item = iterator.next();
            itemSerializer.accept((Object)appendable, item);
            boolean hasNext = iterator.hasNext();
            if (sequenceSeparatorRequired && hasNext) {
                appendable.append(',');
            }
            if (this.formatNewLine(appendable) || sequenceSeparatorRequired || !hasNext) continue;
            appendable.append(',');
        }
        return appendable;
    }
}

