/*
 * Decompiled with CFR 0.152.
 */
package io.urf.surf;

import com.globalmentor.itu.TelephoneNumber;
import com.globalmentor.java.Bytes;
import com.globalmentor.java.CodePointCharacter;
import com.globalmentor.net.EmailAddress;
import io.clogr.Clogged;
import io.urf.surf.SURF;
import io.urf.surf.SurfObject;
import io.urf.surf.SurfParser;
import io.urf.surf.SurfSerializer;
import io.urf.surf.SurfTestResources;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class SurfSerializerTest
implements Clogged {
    protected static Optional<Object> parseTestResource(@Nonnull String testResourceName) throws IOException {
        try (InputStream inputStream = SurfTestResources.class.getResourceAsStream(testResourceName);){
            Optional optional = new SurfParser().parse(inputStream);
            return optional;
        }
    }

    @Ignore
    @Test
    public void testSerialize() throws IOException {
        SurfObject surfObject = new SurfObject(URI.create("urn:uuid:bb8e7dbe-f0b4-4d94-a1cf-46ed0e920832"), "User");
        surfObject.setPropertyValue("firstName", (Object)"Jane");
        surfObject.setPropertyValue("lastName", (Object)"Doe");
        surfObject.setPropertyValue("fullName", (Object)"Jane Doe");
        SurfObject name = new SurfObject();
        name.setPropertyValue("first", (Object)"Jane");
        name.setPropertyValue("last", (Object)"Doe");
        surfObject.setPropertyValue("name", (Object)name);
        SurfSerializer serializer = new SurfSerializer();
        serializer.setFormatted(true);
        this.getLogger().debug(serializer.serialize((Object)surfObject));
    }

    @Test
    public void testSerializeOutputStream() throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            new SurfSerializer().serialize((OutputStream)byteArrayOutputStream, (Object)new SurfObject());
        }
        Assert.assertThat((Object)byteArrayOutputStream.toString(SURF.CHARSET.name()), (Matcher)Matchers.equalTo((Object)"*"));
    }

    @Test
    public void testOkEmptyObjects() throws IOException {
        Assert.assertThat((Object)new SurfSerializer().serialize((Object)new SurfObject()), (Matcher)Matchers.equalTo((Object)"*"));
        Assert.assertThat((Object)new SurfSerializer().serialize((Object)new SurfObject("FooBar")), (Matcher)Matchers.equalTo((Object)"*FooBar"));
    }

    @Test
    public void testOkObjectNoProperties() throws IOException {
        SurfObject surfObject = new SurfObject();
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize((Object)surfObject);
            for (String okObjectNoPropertiesResourceName : SurfTestResources.OK_OBJECT_NO_PROPERTIES_RESOURCE_NAMES) {
                Assert.assertThat((String)okObjectNoPropertiesResourceName, (Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource(okObjectNoPropertiesResourceName)));
            }
        }
    }

    @Test
    public void testOkObjectOneProperty() throws IOException {
        SurfObject surfObject = new SurfObject();
        surfObject.setPropertyValue("one", (Object)"one");
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize((Object)surfObject);
            for (String okObjectOnePropertyResourceName : SurfTestResources.OK_OBJECT_ONE_PROPERTY_RESOURCE_NAMES) {
                Assert.assertThat((String)okObjectOnePropertyResourceName, (Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource(okObjectOnePropertyResourceName)));
            }
        }
    }

    @Test
    public void testOkObjectTwoProperties() throws IOException {
        SurfObject surfObject = new SurfObject();
        surfObject.setPropertyValue("one", (Object)"one");
        surfObject.setPropertyValue("two", (Object)"two");
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize((Object)surfObject);
            for (String okObjectTwoPropertiesResourceName : SurfTestResources.OK_OBJECT_TWO_PROPERTIES_RESOURCE_NAMES) {
                Assert.assertThat((String)okObjectTwoPropertiesResourceName, (Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource(okObjectTwoPropertiesResourceName)));
            }
        }
    }

    @Test
    public void testOkObjectType() throws IOException {
        SurfObject surfObject = new SurfObject("example-FooBar");
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize((Object)surfObject);
            for (String okObjectTypeResourceName : SurfTestResources.OK_OBJECT_TYPE_RESOURCE_NAMES) {
                Assert.assertThat((String)okObjectTypeResourceName, (Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource(okObjectTypeResourceName)));
            }
        }
    }

    @Test
    public void testOkBinary() throws IOException {
        ByteBuffer countByteBuffer = ByteBuffer.wrap(new byte[]{0, 17, 34, 51, 68, 85, 102, 119, -120, -103, -86, -69, -52, -35, -18, -1});
        Assert.assertThat((Object)new SurfSerializer().serialize((Object)countByteBuffer), (Matcher)Matchers.equalTo((Object)"%ABEiM0RVZneImaq7zN3u/w"));
        SurfObject surfObject = new SurfObject();
        surfObject.setPropertyValue("count", (Object)new byte[]{0, 17, 34, 51, 68, 85, 102, 119, -120, -103, -86, -69, -52, -35, -18, -1});
        surfObject.setPropertyValue("rfc4648Example1", (Object)new byte[]{20, -5, -100, 3, -39, 126});
        surfObject.setPropertyValue("rfc4648Example2", (Object)new byte[]{20, -5, -100, 3, -39});
        surfObject.setPropertyValue("rfc4648Example3", (Object)new byte[]{20, -5, -100, 3});
        surfObject.setPropertyValue("rfc4648TestVector1", (Object)Bytes.NO_BYTES);
        surfObject.setPropertyValue("rfc4648TestVector2", (Object)"f".getBytes(StandardCharsets.US_ASCII));
        surfObject.setPropertyValue("rfc4648TestVector3", (Object)"fo".getBytes(StandardCharsets.US_ASCII));
        surfObject.setPropertyValue("rfc4648TestVector4", (Object)"foo".getBytes(StandardCharsets.US_ASCII));
        surfObject.setPropertyValue("rfc4648TestVector5", (Object)"foob".getBytes(StandardCharsets.US_ASCII));
        surfObject.setPropertyValue("rfc4648TestVector6", (Object)"fooba".getBytes(StandardCharsets.US_ASCII));
        surfObject.setPropertyValue("rfc4648TestVector7", (Object)"foobar".getBytes(StandardCharsets.US_ASCII));
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
        }
    }

    @Test
    public void testOkBooleans() throws IOException {
        Assert.assertThat((Object)new SurfSerializer().serialize((Object)true), (Matcher)Matchers.equalTo((Object)"true"));
        Assert.assertThat((Object)new SurfSerializer().serialize((Object)false), (Matcher)Matchers.equalTo((Object)"false"));
    }

    @Test
    public void testOkBooleanFalse() throws IOException {
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize((Object)Boolean.FALSE);
            Assert.assertThat((Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource("ok-boolean-false.surf")));
        }
    }

    @Test
    public void testOkBooleanTrue() throws IOException {
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize((Object)Boolean.TRUE);
            Assert.assertThat((Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource("ok-boolean-true.surf")));
        }
    }

    @Test
    public void testOkCharacters() throws IOException {
        Assert.assertThat((Object)new SurfSerializer().serialize((Object)Character.valueOf('X')), (Matcher)Matchers.equalTo((Object)"'X'"));
        SurfObject surfObject = new SurfObject();
        surfObject.setPropertyValue("foo", (Object)CodePointCharacter.of((char)'|'));
        surfObject.setPropertyValue("quote", (Object)CodePointCharacter.of((char)'\"'));
        surfObject.setPropertyValue("apostrophe", (Object)CodePointCharacter.of((char)'\''));
        surfObject.setPropertyValue("backslash", (Object)CodePointCharacter.of((char)'\\'));
        surfObject.setPropertyValue("solidus", (Object)CodePointCharacter.of((char)'/'));
        surfObject.setPropertyValue("backspace", (Object)CodePointCharacter.of((char)'\b'));
        surfObject.setPropertyValue("ff", (Object)CodePointCharacter.of((char)'\f'));
        surfObject.setPropertyValue("lf", (Object)CodePointCharacter.of((char)'\n'));
        surfObject.setPropertyValue("cr", (Object)CodePointCharacter.of((char)'\r'));
        surfObject.setPropertyValue("tab", (Object)CodePointCharacter.of((char)'\t'));
        surfObject.setPropertyValue("vtab", (Object)CodePointCharacter.of((char)'\u000b'));
        surfObject.setPropertyValue("devanagari-ma", (Object)CodePointCharacter.of((char)'\u092e'));
        surfObject.setPropertyValue("devanagari-maEscaped", (Object)CodePointCharacter.of((char)'\u092e'));
        surfObject.setPropertyValue("tearsOfJoy", (Object)CodePointCharacter.of((int)128514));
        surfObject.setPropertyValue("tearsOfJoyEscaped", (Object)CodePointCharacter.of((int)128514));
        Assert.assertThat((Object)surfObject, (Matcher)Matchers.equalTo((Object)SurfSerializerTest.parseTestResource("ok-characters.surf").get()));
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize((Object)surfObject);
            Assert.assertThat((Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource("ok-characters.surf")));
        }
    }

    @Test
    public void testOkEmailAddresses() throws IOException {
        SurfObject surfObject = new SurfObject();
        surfObject.setPropertyValue("example", (Object)EmailAddress.fromString((String)"jdoe@example.com"));
        surfObject.setPropertyValue("dot", (Object)EmailAddress.fromString((String)"jane.doe@example.com"));
        surfObject.setPropertyValue("tag", (Object)EmailAddress.fromString((String)"jane.doe+tag@example.com"));
        surfObject.setPropertyValue("dash", (Object)EmailAddress.fromString((String)"jane.doe-foo@example.com"));
        surfObject.setPropertyValue("x", (Object)EmailAddress.fromString((String)"x@example.com"));
        surfObject.setPropertyValue("dashedDomain", (Object)EmailAddress.fromString((String)"foo-bar@strange-example.com"));
        surfObject.setPropertyValue("longTLD", (Object)EmailAddress.fromString((String)"example@s.solutions"));
        Assert.assertThat((Object)surfObject, (Matcher)Matchers.equalTo((Object)SurfSerializerTest.parseTestResource("ok-email-addresses.surf").get()));
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize((Object)surfObject);
            Assert.assertThat((Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource("ok-email-addresses.surf")));
        }
    }

    @Test
    public void testOkIris() throws IOException {
        Assert.assertThat((Object)new SurfSerializer().serialize((Object)new URL("http://www.example.com/")), (Matcher)Matchers.equalTo((Object)"<http://www.example.com/>"));
        Assert.assertThat((Object)new SurfSerializer().serialize((Object)URI.create("mailto:jdoe@example.com")), (Matcher)Matchers.equalTo((Object)"<^jdoe@example.com>"));
        Assert.assertThat((Object)new SurfSerializer().serialize((Object)URI.create("tel:+12015550123")), (Matcher)Matchers.equalTo((Object)"<+12015550123>"));
        Assert.assertThat((Object)new SurfSerializer().serialize((Object)URI.create("urn:uuid:5623962b-22b1-4680-ae1c-7174a46144fc")), (Matcher)Matchers.equalTo((Object)"<&5623962b-22b1-4680-ae1c-7174a46144fc>"));
        Assert.assertThat((Object)new SurfSerializer().serialize((Object)URI.create("urn:isbn:0-395-36341-1")), (Matcher)Matchers.equalTo((Object)"<urn:isbn:0-395-36341-1>"));
        SurfObject surfObject = new SurfObject();
        surfObject.setPropertyValue("example", (Object)URI.create("http://www.example.com/"));
        surfObject.setPropertyValue("iso_8859_1", (Object)URI.create("http://www.example.org/D\u00fcrst"));
        surfObject.setPropertyValue("encodedForbidden", (Object)URI.create("http://xn--99zt52a.example.org/%E2%80%AE"));
        surfObject.setPropertyValue("mailto", (Object)URI.create("mailto:jdoe@example.com"));
        surfObject.setPropertyValue("tel", (Object)URI.create("tel:+12015550123"));
        surfObject.setPropertyValue("urn_uuid", (Object)URI.create("urn:uuid:5623962b-22b1-4680-ae1c-7174a46144fc"));
        surfObject.setPropertyValue("isbn", (Object)URI.create("urn:isbn:0-395-36341-1"));
        Assert.assertThat((Object)surfObject, (Matcher)Matchers.equalTo((Object)SurfSerializerTest.parseTestResource("ok-iris.surf").get()));
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize((Object)surfObject);
            Assert.assertThat((Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource("ok-iris.surf")));
        }
    }

    @Test
    public void testOkNumbers() throws IOException {
        SurfObject surfObject = new SurfObject();
        surfObject.setPropertyValue("zero", (Object)0);
        surfObject.setPropertyValue("zeroFraction", (Object)0.0);
        surfObject.setPropertyValue("one", (Object)1);
        surfObject.setPropertyValue("oneFraction", (Object)1.0);
        surfObject.setPropertyValue("integer", (Object)123);
        surfObject.setPropertyValue("negative", (Object)-123);
        surfObject.setPropertyValue("long", (Object)3456789123L);
        surfObject.setPropertyValue("fraction", (Object)12345.6789);
        surfObject.setPropertyValue("scientific1", (Object)12300.0);
        surfObject.setPropertyValue("scientific2", (Object)0.00123);
        surfObject.setPropertyValue("scientific3", (Object)-1.234E7);
        surfObject.setPropertyValue("scientific4", (Object)-3.2145E-10);
        surfObject.setPropertyValue("scientific5", (Object)4.567E90);
        surfObject.setPropertyValue("decimal", (Object)new BigDecimal("0.3"));
        surfObject.setPropertyValue("money", (Object)new BigDecimal("1.23"));
        surfObject.setPropertyValue("decimalZero", (Object)BigInteger.ZERO);
        surfObject.setPropertyValue("decimalZeroFraction", (Object)new BigDecimal("0.0"));
        surfObject.setPropertyValue("decimalOne", (Object)BigInteger.ONE);
        surfObject.setPropertyValue("decimalOneFraction", (Object)new BigDecimal("1.0"));
        surfObject.setPropertyValue("decimalInteger", (Object)new BigInteger("123"));
        surfObject.setPropertyValue("decimalNegative", (Object)new BigInteger("-123"));
        surfObject.setPropertyValue("decimalLong", (Object)new BigInteger("3456789123"));
        surfObject.setPropertyValue("decimalFraction", (Object)new BigDecimal("12345.6789"));
        surfObject.setPropertyValue("decimalScientific1", (Object)new BigDecimal("1.23e+4"));
        surfObject.setPropertyValue("decimalScientific2", (Object)new BigDecimal("12.3e-4"));
        surfObject.setPropertyValue("decimalScientific3", (Object)new BigDecimal("-123.4e+5"));
        surfObject.setPropertyValue("decimalScientific4", (Object)new BigDecimal("-321.45e-12"));
        surfObject.setPropertyValue("decimalScientific5", (Object)new BigDecimal("45.67e+89"));
        Assert.assertThat((Object)surfObject, (Matcher)Matchers.equalTo((Object)SurfSerializerTest.parseTestResource("ok-numbers.surf").get()));
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize((Object)surfObject);
            Assert.assertThat((Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource("ok-numbers.surf")));
        }
    }

    @Ignore
    @Test
    public void testOkRegularExpressions() throws IOException {
        SurfObject surfObject = new SurfObject();
        surfObject.setPropertyValue("empty", (Object)Pattern.compile(""));
        surfObject.setPropertyValue("abc", (Object)Pattern.compile("abc"));
        surfObject.setPropertyValue("regexEscape", (Object)Pattern.compile("ab\\.c"));
        surfObject.setPropertyValue("doubleBackslash", (Object)Pattern.compile("\\\\"));
        surfObject.setPropertyValue("slash", (Object)Pattern.compile("/"));
        Assert.assertThat((Object)surfObject, (Matcher)Matchers.equalTo((Object)SurfSerializerTest.parseTestResource("ok-regular-expressions.surf").get()));
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize((Object)surfObject);
            Assert.assertThat((Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource("ok-regular-expressions.surf")));
        }
    }

    @Test
    public void testOkStringFoobar() throws IOException {
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize((Object)"foobar");
            Assert.assertThat((Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource("ok-string-foobar.surf")));
        }
    }

    @Test
    public void testOkTelephoneNumbers() throws IOException {
        SurfObject surfObject = new SurfObject();
        surfObject.setPropertyValue("rfc3966Example", (Object)TelephoneNumber.parse((CharSequence)"+12015550123"));
        surfObject.setPropertyValue("brazil", (Object)TelephoneNumber.parse((CharSequence)"+552187654321"));
        Assert.assertThat((Object)surfObject, (Matcher)Matchers.equalTo((Object)SurfSerializerTest.parseTestResource("ok-telephone-numbers.surf").get()));
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize((Object)surfObject);
            Assert.assertThat((Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource("ok-telephone-numbers.surf")));
        }
    }

    @Test
    public void testOkTemporals() throws IOException {
        Date nowDate = new Date();
        Assert.assertThat((Object)new SurfSerializer().serialize((Object)nowDate), (Matcher)Matchers.equalTo((Object)("@" + nowDate.toInstant().toString())));
        SurfObject surfObject = new SurfObject();
        surfObject.setPropertyValue("instant", (Object)Instant.parse("2017-02-12T23:29:18.829Z"));
        surfObject.setPropertyValue("zonedDateTime", (Object)ZonedDateTime.parse("2017-02-12T15:29:18.829-08:00[America/Los_Angeles]"));
        surfObject.setPropertyValue("offsetDateTime", (Object)OffsetDateTime.parse("2017-02-12T15:29:18.829-08:00"));
        surfObject.setPropertyValue("offsetTime", (Object)OffsetTime.parse("15:29:18.829-08:00"));
        surfObject.setPropertyValue("localDateTime", (Object)LocalDateTime.parse("2017-02-12T15:29:18.829"));
        surfObject.setPropertyValue("localDate", (Object)LocalDate.parse("2017-02-12"));
        surfObject.setPropertyValue("localTime", (Object)LocalTime.parse("15:29:18.829"));
        surfObject.setPropertyValue("yearMonth", (Object)YearMonth.parse("2017-02"));
        surfObject.setPropertyValue("monthDay", (Object)MonthDay.parse("--02-12"));
        surfObject.setPropertyValue("year", (Object)Year.parse("2017"));
        Assert.assertThat((Object)surfObject, (Matcher)Matchers.equalTo((Object)SurfSerializerTest.parseTestResource("ok-temporals.surf").get()));
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize((Object)surfObject);
            Assert.assertThat((Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource("ok-temporals.surf")));
        }
    }

    @Test
    public void testOkUuid() throws IOException {
        UUID uuid = UUID.fromString("f81d4fae-7dec-11d0-a765-00a0c91e6bf6");
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize((Object)uuid);
            Assert.assertThat((Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource("ok-uuid.surf")));
        }
    }

    @Test
    public void testOkListEmpty() throws IOException {
        List list = Collections.emptyList();
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize(list);
            for (String okListEmptyResourceName : SurfTestResources.OK_LIST_EMPTY_RESOURCE_NAMES) {
                Assert.assertThat((String)okListEmptyResourceName, (Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource(okListEmptyResourceName)));
            }
        }
    }

    @Test
    public void testOkListOneItem() throws IOException {
        List<String> list = Arrays.asList("one");
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize(list);
            for (String okListOneItemResourceName : SurfTestResources.OK_LIST_ONE_ITEM_RESOURCE_NAMES) {
                Assert.assertThat((String)okListOneItemResourceName, (Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource(okListOneItemResourceName)));
            }
        }
    }

    @Test
    public void testOkListTwoItems() throws IOException {
        List<String> list = Arrays.asList("one", "two");
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize(list);
            for (String okListTwoItemsResourceName : SurfTestResources.OK_LIST_TWO_ITEMS_RESOURCE_NAMES) {
                Assert.assertThat((String)okListTwoItemsResourceName, (Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource(okListTwoItemsResourceName)));
            }
        }
    }

    @Test
    public void testOkMaps() throws IOException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put("foo", "bar");
        map.put(123, "number");
        map.put(false, "Boolean");
        map.put(true, "Boolean");
        map.put(Arrays.asList(1, 2, 3), new BigDecimal("1.23"));
        HashMap<String, List<CodePointCharacter>> pingPong = new HashMap<String, List<CodePointCharacter>>();
        pingPong.put("ping", Arrays.asList(CodePointCharacter.of((char)'p'), CodePointCharacter.of((char)'o'), CodePointCharacter.of((char)'n'), CodePointCharacter.of((char)'g')));
        map.put("map", pingPong);
        map.put(new HashSet<Serializable>(Arrays.asList("foo", false)), true);
        map.put(new SurfObject("Game", "pingpong"), "ping pong");
        SurfObject bullsEye = new SurfObject("Point");
        bullsEye.setPropertyValue("x", (Object)0);
        bullsEye.setPropertyValue("y", (Object)0);
        map.put(bullsEye, "Bull's Eye");
        HashMap<String, String> abbrMap = new HashMap<String, String>();
        abbrMap.put("ITTF", "International Table Tennis Federation");
        map.put(abbrMap, "abbr");
        Assert.assertThat(map, (Matcher)Matchers.equalTo((Object)SurfSerializerTest.parseTestResource("ok-maps.surf").get()));
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize(map);
            Assert.assertThat((Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource("ok-maps.surf")));
        }
    }

    @Test
    public void testOkMapEmpty() throws IOException {
        Map map = Collections.emptyMap();
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize(map);
            for (String okMapEmptyResourceName : SurfTestResources.OK_MAP_EMPTY_RESOURCE_NAMES) {
                Assert.assertThat((String)okMapEmptyResourceName, (Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource(okMapEmptyResourceName)));
            }
        }
    }

    @Test
    public void testOkMapOneEntry() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("I", "one");
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize(map);
            for (String okMapOneEntryResourceName : SurfTestResources.OK_MAP_ONE_ENTRY_RESOURCE_NAMES) {
                Assert.assertThat((String)okMapOneEntryResourceName, (Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource(okMapOneEntryResourceName)));
            }
        }
    }

    @Test
    public void testOkMapTwoEntries() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("I", "one");
        map.put("II", "two");
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize(map);
            for (String okMapTwoEntriesResourceName : SurfTestResources.OK_MAP_TWO_ENTRIES_RESOURCE_NAMES) {
                Assert.assertThat((String)okMapTwoEntriesResourceName, (Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource(okMapTwoEntriesResourceName)));
            }
        }
    }

    @Test
    public void testOkSetEmpty() throws IOException {
        Set set = Collections.emptySet();
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize(set);
            for (String okSetEmptyResourceName : SurfTestResources.OK_SET_EMPTY_RESOURCE_NAMES) {
                Assert.assertThat((String)okSetEmptyResourceName, (Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource(okSetEmptyResourceName)));
            }
        }
    }

    @Test
    public void testOkSetOneItem() throws IOException {
        HashSet<String> set = new HashSet<String>(Arrays.asList("one"));
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize(set);
            for (String okSetOneItemResourceName : SurfTestResources.OK_SET_ONE_ITEM_RESOURCE_NAMES) {
                Assert.assertThat((String)okSetOneItemResourceName, (Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource(okSetOneItemResourceName)));
            }
        }
    }

    @Test
    public void testOkSetTwoItems() throws IOException {
        HashSet<String> set = new HashSet<String>(Arrays.asList("one", "two"));
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize(set);
            for (String okSetTwoItemsResourceName : SurfTestResources.OK_SET_TWO_ITEMS_RESOURCE_NAMES) {
                Assert.assertThat((String)okSetTwoItemsResourceName, (Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource(okSetTwoItemsResourceName)));
            }
        }
    }

    @Test
    public void testOkLabels() throws IOException {
        SurfObject root = new SurfObject();
        root.setPropertyValue("foo", (Object)123);
        root.setPropertyValue("value", (Object)false);
        SurfObject object = new SurfObject("example-Type");
        SurfObject exampleThing = new SurfObject(URI.create("http://example.com/thing"), "example-Thing");
        exampleThing.setPropertyValue("name", (Object)"Example Thing");
        object.setPropertyValue("stuff", Arrays.asList("one", 123, "three", exampleThing));
        root.setPropertyValue("thing", (Object)object);
        SurfObject fooBar = new SurfObject("Bar", "foo");
        fooBar.setPropertyValue("prop", (Object)"val");
        root.setPropertyValue("foobar", (Object)fooBar);
        HashMap<Integer, Object> me = new HashMap<Integer, Object>();
        me.put(1, "one");
        me.put(2, 123);
        me.put(4, fooBar);
        me.put(99, exampleThing);
        me.put(100, object);
        root.setPropertyValue("map", me);
        HashSet<Constable> these = new HashSet<Constable>();
        these.add(Integer.valueOf(123));
        these.add(Boolean.valueOf(false));
        these.add((Constable)object);
        SurfObject newThing = new SurfObject("example-Thing");
        newThing.setPropertyValue("description", (Object)"a new thing");
        these.add((Constable)newThing);
        SurfObject another = new SurfObject();
        another.setPropertyValue("description", (Object)"yet another thing");
        these.add((Constable)another);
        root.setPropertyValue("set", these);
        Assert.assertThat((Object)root, (Matcher)Matchers.equalTo((Object)SurfSerializerTest.parseTestResource("ok-labels.surf").get()));
        for (boolean formatted : Arrays.asList(false, true)) {
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(formatted);
            String serialization = serializer.serialize((Object)root);
            Assert.assertThat((Object)new SurfParser().parse(serialization), (Matcher)Matchers.equalTo(SurfSerializerTest.parseTestResource("ok-labels.surf")));
        }
    }
}

