/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.UndertowLogger;
import io.undertow.protocols.http2.AbstractHttp2StreamSinkChannel;
import io.undertow.protocols.http2.AbstractHttp2StreamSourceChannel;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.protocols.http2.Http2HeadersStreamSinkChannel;
import io.undertow.protocols.http2.Http2PushPromiseStreamSinkChannel;
import io.undertow.protocols.http2.Http2StreamSinkChannel;
import io.undertow.server.protocol.framed.FramePriority;
import io.undertow.server.protocol.framed.SendFrameHeader;
import java.io.Closeable;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.xnio.IoUtils;

class Http2FramePriority
implements FramePriority<Http2Channel, AbstractHttp2StreamSourceChannel, AbstractHttp2StreamSinkChannel> {
    private int nextId;

    Http2FramePriority(int nextId) {
        this.nextId = nextId;
    }

    @Override
    public boolean insertFrame(AbstractHttp2StreamSinkChannel newFrame, List<AbstractHttp2StreamSinkChannel> pendingFrames) {
        boolean incrementIfAccepted = false;
        if (((Http2Channel)newFrame.getChannel()).isClient() && newFrame instanceof Http2HeadersStreamSinkChannel || newFrame instanceof Http2PushPromiseStreamSinkChannel) {
            if (newFrame instanceof Http2PushPromiseStreamSinkChannel) {
                streamId = ((Http2PushPromiseStreamSinkChannel)newFrame).getPushedStreamId();
                if (streamId > this.nextId) {
                    return false;
                }
                if (streamId == this.nextId) {
                    incrementIfAccepted = true;
                }
            } else {
                streamId = ((Http2HeadersStreamSinkChannel)newFrame).getStreamId();
                if (streamId > this.nextId) {
                    return false;
                }
                if (streamId == this.nextId) {
                    incrementIfAccepted = true;
                }
            }
        }
        if (newFrame instanceof Http2StreamSinkChannel) {
            if (newFrame.isBroken() || !newFrame.isOpen()) {
                return true;
            }
            try {
                SendFrameHeader header = ((Http2StreamSinkChannel)newFrame).generateSendFrameHeader();
                if (header.getByteBuffer() == null) {
                    ((Http2StreamSinkChannel)newFrame).clearHeader();
                    return false;
                }
            }
            catch (Exception e) {
                UndertowLogger.REQUEST_LOGGER.debugf("Failed to generate header %s", (Object)newFrame);
            }
        }
        pendingFrames.add(newFrame);
        if (incrementIfAccepted) {
            this.nextId += 2;
        }
        return true;
    }

    @Override
    public void frameAdded(AbstractHttp2StreamSinkChannel addedFrame, List<AbstractHttp2StreamSinkChannel> pendingFrames, Deque<AbstractHttp2StreamSinkChannel> holdFrames) {
        Iterator<AbstractHttp2StreamSinkChannel> it = holdFrames.iterator();
        while (it.hasNext()) {
            SendFrameHeader header;
            AbstractHttp2StreamSinkChannel pending = it.next();
            boolean incrementNextId = false;
            if (((Http2Channel)pending.getChannel()).isClient() && pending instanceof Http2HeadersStreamSinkChannel || pending instanceof Http2PushPromiseStreamSinkChannel) {
                if (pending instanceof Http2PushPromiseStreamSinkChannel) {
                    int streamId = ((Http2PushPromiseStreamSinkChannel)pending).getPushedStreamId();
                    if (streamId > this.nextId) continue;
                    if (streamId == this.nextId) {
                        incrementNextId = true;
                    }
                } else {
                    int streamId = ((Http2HeadersStreamSinkChannel)pending).getStreamId();
                    if (streamId > this.nextId) continue;
                    if (streamId == this.nextId) {
                        incrementNextId = true;
                    }
                }
            }
            if (!pending.isOpen() || !(pending instanceof Http2StreamSinkChannel)) continue;
            try {
                header = ((Http2StreamSinkChannel)pending).generateSendFrameHeader();
            }
            catch (IllegalStateException e) {
                it.remove();
                if (!pending.isOpen()) continue;
                IoUtils.safeClose((Closeable)pending);
                throw e;
            }
            if (header.getByteBuffer() != null) {
                pendingFrames.add(pending);
                it.remove();
                it = holdFrames.iterator();
                if (!incrementNextId) continue;
                this.nextId += 2;
                continue;
            }
            ((Http2StreamSinkChannel)pending).clearHeader();
        }
    }
}

