/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.Cookie;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.PushBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PushBuilderImpl
implements PushBuilder {
    private static final Set<HttpString> IGNORE;
    private static final Set<HttpString> CONDITIONAL;
    private static final Set<String> INVALID_METHOD;
    private final HttpServletRequestImpl servletRequest;
    private String method;
    private String queryString;
    private String sessionId;
    private final HeaderMap headers = new HeaderMap();
    private String path;

    public PushBuilderImpl(HttpServletRequestImpl servletRequest) {
        this.servletRequest = servletRequest;
        this.method = "GET";
        this.queryString = servletRequest.getQueryString();
        HttpSession session = servletRequest.getSession(false);
        this.sessionId = session != null ? session.getId() : servletRequest.getRequestedSessionId();
        for (HeaderValues header : servletRequest.getExchange().getRequestHeaders()) {
            if (IGNORE.contains(header.getHeaderName())) continue;
            this.headers.addAll(header.getHeaderName(), header);
        }
        if (servletRequest.getQueryString() == null) {
            this.headers.add(Headers.REFERER, servletRequest.getRequestURL().toString());
        } else {
            this.headers.add(Headers.REFERER, String.valueOf(servletRequest.getRequestURL()) + "?" + servletRequest.getQueryString());
        }
        this.path = null;
        for (Cookie cookie : servletRequest.getExchange().responseCookies()) {
            if (cookie.getMaxAge() != null && cookie.getMaxAge() <= 0) {
                HeaderValues existing = this.headers.get(Headers.COOKIE);
                if (existing == null) continue;
                Iterator<String> it = existing.iterator();
                while (it.hasNext()) {
                    String val = it.next();
                    if (!val.startsWith(cookie.getName() + "=")) continue;
                    it.remove();
                }
                continue;
            }
            if (cookie.getName().equals(servletRequest.getServletContext().getSessionCookieConfig().getName())) continue;
            this.headers.add(Headers.COOKIE, cookie.getName() + "=" + cookie.getValue());
        }
    }

    @Override
    public PushBuilder method(String method) {
        if (method == null) {
            throw UndertowServletMessages.MESSAGES.paramCannotBeNullNPE("method");
        }
        if (INVALID_METHOD.contains(method)) {
            throw UndertowServletMessages.MESSAGES.invalidMethodForPushRequest(method);
        }
        this.method = method;
        return this;
    }

    @Override
    public PushBuilder queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    @Override
    public PushBuilder sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @Override
    public PushBuilder setHeader(String name, String value) {
        this.headers.put(new HttpString(name), value);
        return this;
    }

    @Override
    public PushBuilder addHeader(String name, String value) {
        this.headers.add(new HttpString(name), value);
        return this;
    }

    @Override
    public PushBuilder removeHeader(String name) {
        this.headers.remove(name);
        return this;
    }

    @Override
    public PushBuilder path(String path) {
        this.path = path;
        return this;
    }

    @Override
    public void push() {
        if (this.path == null) {
            throw UndertowServletMessages.MESSAGES.pathWasNotSet();
        }
        ServerConnection con = this.servletRequest.getExchange().getConnection();
        if (con.isPushSupported()) {
            Object path;
            HeaderMap newHeaders = new HeaderMap();
            for (HeaderValues entry : this.headers) {
                newHeaders.addAll(entry.getHeaderName(), entry);
            }
            if (this.sessionId != null) {
                newHeaders.put(Headers.COOKIE, "JSESSIONID=" + this.sessionId);
            }
            if (!((String)(path = this.path)).startsWith("/")) {
                path = this.servletRequest.getContextPath() + "/" + (String)path;
            }
            if (this.queryString != null && !this.queryString.isEmpty()) {
                path = ((String)path).contains("?") ? (String)path + "&" + this.queryString : (String)path + "?" + this.queryString;
            }
            con.pushResource((String)path, new HttpString(this.method), newHeaders);
        }
        this.path = null;
        for (HttpString h : CONDITIONAL) {
            this.headers.remove(h);
        }
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public Set<String> getHeaderNames() {
        HashSet<String> names = new HashSet<String>();
        for (HeaderValues name : this.headers) {
            names.add(name.getHeaderName().toString());
        }
        return names;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.getFirst(name);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    static {
        HashSet<HttpString> ignore = new HashSet<HttpString>();
        ignore.add(Headers.IF_MATCH);
        ignore.add(Headers.IF_NONE_MATCH);
        ignore.add(Headers.IF_MODIFIED_SINCE);
        ignore.add(Headers.IF_UNMODIFIED_SINCE);
        ignore.add(Headers.IF_RANGE);
        ignore.add(Headers.RANGE);
        ignore.add(Headers.ACCEPT_RANGES);
        ignore.add(Headers.EXPECT);
        ignore.add(Headers.REFERER);
        IGNORE = Collections.unmodifiableSet(ignore);
        HashSet<HttpString> conditional = new HashSet<HttpString>();
        conditional.add(Headers.IF_MATCH);
        conditional.add(Headers.IF_NONE_MATCH);
        conditional.add(Headers.IF_MODIFIED_SINCE);
        conditional.add(Headers.IF_UNMODIFIED_SINCE);
        conditional.add(Headers.IF_RANGE);
        CONDITIONAL = Collections.unmodifiableSet(conditional);
        HashSet<String> invalid = new HashSet<String>();
        invalid.add("OPTIONS");
        invalid.add("PUT");
        invalid.add("POST");
        invalid.add("DELETE");
        invalid.add("CONNECT");
        invalid.add("TRACE");
        invalid.add("");
        INVALID_METHOD = Collections.unmodifiableSet(invalid);
    }
}

