/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.ssl;

import io.undertow.UndertowLogger;
import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.protocols.ssl.UndertowSslConnection;
import io.undertow.server.DefaultByteBufferPool;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitReadableByteChannel;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.ReadReadyHandler;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.conduits.WriteReadyHandler;

public class SslConduit
implements StreamSourceConduit,
StreamSinkConduit {
    public static final int MAX_READ_LISTENER_INVOCATIONS = Integer.getInteger("io.undertow.ssl.max-read-listener-invocations", 100);
    private static final int FLAG_READ_REQUIRES_WRITE = 1;
    private static final int FLAG_WRITE_REQUIRES_READ = 2;
    private static final int FLAG_READS_RESUMED = 4;
    private static final int FLAG_WRITES_RESUMED = 8;
    private static final int FLAG_DATA_TO_UNWRAP = 16;
    private static final int FLAG_READ_SHUTDOWN = 32;
    private static final int FLAG_WRITE_SHUTDOWN = 64;
    private static final int FLAG_ENGINE_INBOUND_SHUTDOWN = 128;
    private static final int FLAG_ENGINE_OUTBOUND_SHUTDOWN = 256;
    private static final int FLAG_DELEGATE_SINK_SHUTDOWN = 512;
    private static final int FLAG_DELEGATE_SOURCE_SHUTDOWN = 1024;
    private static final int FLAG_IN_HANDSHAKE = 2048;
    private static final int FLAG_CLOSED = 4096;
    private static final int FLAG_WRITE_CLOSED = 8192;
    private static final int FLAG_READ_CLOSED = 16384;
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private static volatile ByteBufferPool expandedBufferPool;
    private final UndertowSslConnection connection;
    private final StreamConnection delegate;
    private final Executor delegatedTaskExecutor;
    private SSLEngine engine;
    private final StreamSinkConduit sink;
    private final StreamSourceConduit source;
    private final ByteBufferPool bufferPool;
    private final Runnable handshakeCallback;
    private volatile int state = 0;
    private volatile int outstandingTasks = 0;
    private volatile PooledByteBuffer wrappedData;
    private volatile PooledByteBuffer dataToUnwrap;
    private volatile PooledByteBuffer unwrappedData;
    private SslWriteReadyHandler writeReadyHandler;
    private SslReadReadyHandler readReadyHandler;
    private int readListenerInvocationCount;
    private boolean invokingReadListenerHandshake = false;
    private final Runnable runReadListenerCommand = new Runnable(){

        @Override
        public void run() {
            int count = SslConduit.this.readListenerInvocationCount;
            try {
                SslConduit.this.readReadyHandler.readReady();
            }
            finally {
                if (count == SslConduit.this.readListenerInvocationCount) {
                    SslConduit.this.readListenerInvocationCount = 0;
                }
            }
        }
    };
    private final Runnable runReadListenerAndResumeCommand = new Runnable(){

        @Override
        public void run() {
            if (Bits.allAreSet((int)SslConduit.this.state, (int)4)) {
                SslConduit.this.delegate.getSourceChannel().resumeReads();
            }
            SslConduit.this.runReadListenerCommand.run();
        }
    };

    SslConduit(UndertowSslConnection connection, StreamConnection delegate, SSLEngine engine, Executor delegatedTaskExecutor, ByteBufferPool bufferPool, Runnable handshakeCallback) {
        this.connection = connection;
        this.delegate = delegate;
        this.handshakeCallback = handshakeCallback;
        this.sink = delegate.getSinkChannel().getConduit();
        this.source = delegate.getSourceChannel().getConduit();
        this.engine = engine;
        this.delegatedTaskExecutor = this.delegate.getWorker() != delegatedTaskExecutor ? delegatedTaskExecutor : null;
        this.bufferPool = bufferPool;
        this.readReadyHandler = new SslReadReadyHandler(null);
        delegate.getSourceChannel().getConduit().setReadReadyHandler((ReadReadyHandler)this.readReadyHandler);
        this.writeReadyHandler = new SslWriteReadyHandler(null);
        delegate.getSinkChannel().getConduit().setWriteReadyHandler((WriteReadyHandler)this.writeReadyHandler);
        this.state = engine.getUseClientMode() ? 2049 : 2050;
    }

    public void terminateReads() throws IOException {
        this.state |= 0x20;
        this.notifyReadClosed();
    }

    public boolean isReadShutdown() {
        return Bits.anyAreSet((int)this.state, (int)32);
    }

    public void resumeReads() {
        if (Bits.anyAreSet((int)this.state, (int)4)) {
            return;
        }
        this.resumeReads(false);
    }

    public void suspendReads() {
        this.state &= 0xFFFFFFFB;
        if (!Bits.allAreSet((int)this.state, (int)10)) {
            this.delegate.getSourceChannel().suspendReads();
        }
    }

    public void wakeupReads() {
        this.resumeReads(true);
    }

    private void resumeReads(boolean wakeup) {
        this.state |= 4;
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            this.delegate.getSinkChannel().resumeWrites();
        } else if (Bits.anyAreSet((int)this.state, (int)16) || wakeup || this.unwrappedData != null) {
            this.runReadListener(true);
        } else {
            this.delegate.getSourceChannel().resumeReads();
        }
    }

    private void runReadListener(boolean resumeInListener) {
        try {
            if (this.readListenerInvocationCount++ == MAX_READ_LISTENER_INVOCATIONS) {
                UndertowLogger.REQUEST_LOGGER.sslReadLoopDetected(this);
                IoUtils.safeClose((Closeable[])new Closeable[]{this.connection, this.delegate});
                this.close();
                return;
            }
            if (resumeInListener) {
                this.delegate.getIoThread().execute(this.runReadListenerAndResumeCommand);
            } else {
                this.delegate.getIoThread().execute(this.runReadListenerCommand);
            }
        }
        catch (Throwable e) {
            IoUtils.safeClose((Closeable[])new Closeable[]{this.connection, this.delegate});
            UndertowLogger.REQUEST_IO_LOGGER.debugf(e, "Failed to queue read listener invocation", new Object[0]);
        }
    }

    private void runWriteListener() {
        try {
            this.delegate.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    SslConduit.this.writeReadyHandler.writeReady();
                }
            });
        }
        catch (Throwable e) {
            IoUtils.safeClose((Closeable[])new Closeable[]{this.connection, this.delegate});
            UndertowLogger.REQUEST_IO_LOGGER.debugf(e, "Failed to queue read listener invocation", new Object[0]);
        }
    }

    public boolean isReadResumed() {
        return Bits.anyAreSet((int)this.state, (int)4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitReadable() throws IOException {
        SslConduit sslConduit = this;
        synchronized (sslConduit) {
            if (this.outstandingTasks > 0) {
                try {
                    this.wait();
                    return;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
        }
        if (this.unwrappedData != null) {
            return;
        }
        if (Bits.anyAreSet((int)this.state, (int)16)) {
            return;
        }
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            this.awaitWritable();
            return;
        }
        this.source.awaitReadable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        SslConduit sslConduit = this;
        synchronized (sslConduit) {
            if (this.outstandingTasks > 0) {
                try {
                    this.wait(timeUnit.toMillis(time));
                    return;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
        }
        if (this.unwrappedData != null) {
            return;
        }
        if (Bits.anyAreSet((int)this.state, (int)16)) {
            return;
        }
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            this.awaitWritable(time, timeUnit);
            return;
        }
        this.source.awaitReadable(time, timeUnit);
    }

    public XnioIoThread getReadThread() {
        return this.delegate.getIoThread();
    }

    public void setReadReadyHandler(ReadReadyHandler handler) {
        this.readReadyHandler = new SslReadReadyHandler(handler);
        this.delegate.getSourceChannel().getConduit().setReadReadyHandler((ReadReadyHandler)this.readReadyHandler);
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)64)) {
            throw new ClosedChannelException();
        }
        return src.transferTo(position, count, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)64)) {
            throw new ClosedChannelException();
        }
        return IoUtils.transfer((ReadableByteChannel)source, (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public int write(ByteBuffer src) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)64)) {
            throw new ClosedChannelException();
        }
        return (int)this.doWrap(new ByteBuffer[]{src}, 0, 1);
    }

    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)64)) {
            throw new ClosedChannelException();
        }
        return this.doWrap(srcs, offs, len);
    }

    public int writeFinal(ByteBuffer src) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)64)) {
            throw new ClosedChannelException();
        }
        return Conduits.writeFinalBasic((StreamSinkConduit)this, (ByteBuffer)src);
    }

    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic((StreamSinkConduit)this, (ByteBuffer[])srcs, (int)offset, (int)length);
    }

    public void terminateWrites() throws IOException {
        this.state |= 0x40;
    }

    public boolean isWriteShutdown() {
        return false;
    }

    public void resumeWrites() {
        this.state |= 8;
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            this.delegate.getSourceChannel().resumeReads();
        } else {
            this.delegate.getSinkChannel().resumeWrites();
        }
    }

    public void suspendWrites() {
        this.state &= 0xFFFFFFF7;
        if (!Bits.allAreSet((int)this.state, (int)5)) {
            this.delegate.getSinkChannel().suspendWrites();
        }
    }

    public void wakeupWrites() {
        this.state |= 8;
        this.getWriteThread().execute(new Runnable(){

            @Override
            public void run() {
                SslConduit.this.resumeWrites();
                SslConduit.this.writeReadyHandler.writeReady();
            }
        });
    }

    public boolean isWriteResumed() {
        return Bits.anyAreSet((int)this.state, (int)8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitWritable() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)64)) {
            return;
        }
        if (this.outstandingTasks > 0) {
            SslConduit sslConduit = this;
            synchronized (sslConduit) {
                if (this.outstandingTasks > 0) {
                    try {
                        this.wait();
                        return;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedIOException();
                    }
                }
            }
        }
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            this.awaitReadable();
            return;
        }
        this.sink.awaitWritable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)64)) {
            return;
        }
        if (this.outstandingTasks > 0) {
            SslConduit sslConduit = this;
            synchronized (sslConduit) {
                if (this.outstandingTasks > 0) {
                    try {
                        this.wait(timeUnit.toMillis(time));
                        return;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedIOException();
                    }
                }
            }
        }
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            this.awaitReadable(time, timeUnit);
            return;
        }
        this.sink.awaitWritable();
    }

    public XnioIoThread getWriteThread() {
        return this.delegate.getIoThread();
    }

    public void setWriteReadyHandler(WriteReadyHandler handler) {
        this.writeReadyHandler = new SslWriteReadyHandler(handler);
        this.delegate.getSinkChannel().getConduit().setWriteReadyHandler((WriteReadyHandler)this.writeReadyHandler);
    }

    public void truncateWrites() throws IOException {
        try {
            this.notifyWriteClosed();
        }
        finally {
            this.delegate.getSinkChannel().close();
        }
    }

    public boolean flush() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)512)) {
            return this.sink.flush();
        }
        if (this.wrappedData != null) {
            this.doWrap(null, 0, 0);
            if (this.wrappedData != null) {
                return false;
            }
        }
        if (Bits.allAreSet((int)this.state, (int)64)) {
            boolean result;
            if (Bits.allAreClear((int)this.state, (int)256)) {
                this.state |= 0x100;
                this.engine.closeOutbound();
                this.doWrap(null, 0, 0);
                if (this.wrappedData != null) {
                    return false;
                }
            } else if (this.wrappedData != null && Bits.allAreClear((int)this.state, (int)512)) {
                this.doWrap(null, 0, 0);
                if (this.wrappedData != null) {
                    return false;
                }
            }
            if (Bits.allAreClear((int)this.state, (int)512)) {
                this.sink.terminateWrites();
                this.state |= 0x200;
                this.notifyWriteClosed();
            }
            if ((result = this.sink.flush()) && Bits.anyAreSet((int)this.state, (int)16384)) {
                this.closed();
            }
            return result;
        }
        return this.sink.flush();
    }

    public long transferTo(long position, long count, FileChannel target) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)32)) {
            return -1L;
        }
        return target.transferFrom((ReadableByteChannel)new ConduitReadableByteChannel((StreamSourceConduit)this), position, count);
    }

    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)32)) {
            return -1L;
        }
        return IoUtils.transfer((ReadableByteChannel)new ConduitReadableByteChannel((StreamSourceConduit)this), (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)target);
    }

    public int read(ByteBuffer dst) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)32)) {
            return -1;
        }
        return (int)this.doUnwrap(new ByteBuffer[]{dst}, 0, 1);
    }

    public long read(ByteBuffer[] dsts, int offs, int len) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)32)) {
            return -1L;
        }
        return this.doUnwrap(dsts, offs, len);
    }

    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    private Executor getDelegatedTaskExecutor() {
        return this.delegatedTaskExecutor == null ? this.getWorker() : this.delegatedTaskExecutor;
    }

    void notifyWriteClosed() {
        if (Bits.anyAreSet((int)this.state, (int)8192)) {
            return;
        }
        boolean runListener = this.isWriteResumed() && Bits.anyAreSet((int)this.state, (int)4096);
        this.connection.writeClosed();
        this.engine.closeOutbound();
        this.state |= 0x2100;
        if (Bits.anyAreSet((int)this.state, (int)16384)) {
            this.closed();
        }
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            this.notifyReadClosed();
        }
        this.state &= 0xFFFFFFFD;
        if (runListener) {
            this.runWriteListener();
        }
    }

    void notifyReadClosed() {
        boolean runListener;
        block6: {
            if (Bits.anyAreSet((int)this.state, (int)16384)) {
                return;
            }
            runListener = this.isReadResumed() && Bits.anyAreSet((int)this.state, (int)4096);
            this.connection.readClosed();
            try {
                this.engine.closeInbound();
            }
            catch (SSLException e) {
                UndertowLogger.REQUEST_IO_LOGGER.trace("Exception closing read side of SSL channel", e);
                if (!Bits.allAreClear((int)this.state, (int)8192) || !this.isWriteResumed()) break block6;
                this.runWriteListener();
            }
        }
        this.state |= 0x40A0;
        if (Bits.anyAreSet((int)this.state, (int)8192)) {
            this.closed();
        }
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            this.notifyWriteClosed();
        }
        if (runListener) {
            this.runReadListener(false);
        }
    }

    public void startHandshake() throws SSLException {
        this.state |= 1;
        this.engine.beginHandshake();
    }

    public SSLSession getSslSession() {
        return this.engine.getSession();
    }

    private void doHandshake() throws IOException {
        this.doUnwrap(null, 0, 0);
        this.doWrap(null, 0, 0);
    }

    private SSLEngineResult engineUnwrap(ByteBuffer src, ByteBuffer[] dsts, int off, int len, AccumulativeOrBoolean bytesProduced) throws IOException {
        SSLEngineResult result;
        do {
            bytesProduced.add((result = this.engine.unwrap(src, dsts, off, len)).bytesProduced() > 0);
        } while (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && result.getStatus() == SSLEngineResult.Status.OK && src.hasRemaining());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long doUnwrap(ByteBuffer[] userBuffers, int off, int len) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)4096)) {
            throw new ClosedChannelException();
        }
        if (this.outstandingTasks > 0) {
            return 0L;
        }
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            this.doWrap(null, 0, 0);
            if (Bits.allAreClear((int)this.state, (int)2)) {
                return 0L;
            }
        }
        AccumulativeOrBoolean bytesProduced = new AccumulativeOrBoolean();
        PooledByteBuffer unwrappedData = this.unwrappedData;
        if (unwrappedData != null && userBuffers != null) {
            long copied = Buffers.copy((ByteBuffer[])userBuffers, (int)off, (int)len, (ByteBuffer)unwrappedData.getBuffer());
            if (!unwrappedData.getBuffer().hasRemaining()) {
                unwrappedData.close();
                this.unwrappedData = null;
            }
            if (copied > 0L) {
                this.readListenerInvocationCount = 0;
            }
            return copied;
        }
        try {
            SSLEngineResult result;
            if (Bits.allAreClear((int)this.state, (int)16)) {
                int res;
                if (this.dataToUnwrap == null) {
                    this.dataToUnwrap = this.bufferPool.allocate();
                }
                try {
                    res = this.source.read(this.dataToUnwrap.getBuffer());
                }
                catch (IOException | Error | RuntimeException e) {
                    this.dataToUnwrap.close();
                    this.dataToUnwrap = null;
                    throw e;
                }
                this.dataToUnwrap.getBuffer().flip();
                if (res == -1) {
                    this.dataToUnwrap.close();
                    this.dataToUnwrap = null;
                    this.notifyReadClosed();
                    long l = -1L;
                    return l;
                }
                if (res == 0 && this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                    if (!this.dataToUnwrap.getBuffer().hasRemaining()) {
                        this.dataToUnwrap.close();
                        this.dataToUnwrap = null;
                    }
                    long l = 0L;
                    return l;
                }
            }
            int dataToUnwrapLength = this.dataToUnwrap.getBuffer().remaining();
            long original = 0L;
            if (userBuffers != null) {
                original = Buffers.remaining((Buffer[])userBuffers);
            }
            boolean unwrapBufferUsed = false;
            try {
                if (userBuffers != null) {
                    result = this.engineUnwrap(this.dataToUnwrap.getBuffer(), userBuffers, off, len, bytesProduced);
                    if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        unwrappedData = this.bufferPool.allocate();
                        ByteBuffer[] d = new ByteBuffer[len + 1];
                        System.arraycopy(userBuffers, off, d, 0, len);
                        d[len] = unwrappedData.getBuffer();
                        result = this.engineUnwrap(this.dataToUnwrap.getBuffer(), d, 0, d.length, bytesProduced);
                        unwrapBufferUsed = true;
                    }
                } else {
                    unwrapBufferUsed = true;
                    if (unwrappedData == null) {
                        unwrappedData = this.bufferPool.allocate();
                    } else {
                        unwrappedData.getBuffer().compact();
                    }
                    result = this.engineUnwrap(this.dataToUnwrap.getBuffer(), new ByteBuffer[]{unwrappedData.getBuffer()}, 0, 1, bytesProduced);
                }
            }
            finally {
                if (unwrapBufferUsed) {
                    unwrappedData.getBuffer().flip();
                    if (!unwrappedData.getBuffer().hasRemaining()) {
                        unwrappedData.close();
                        unwrappedData = null;
                    }
                }
                this.unwrappedData = unwrappedData;
            }
            if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                if (this.dataToUnwrap != null) {
                    this.dataToUnwrap.close();
                    this.dataToUnwrap = null;
                }
                this.notifyReadClosed();
                long d = -1L;
                return d;
            }
            if (!this.handleHandshakeResult(result)) {
                this.state = this.dataToUnwrap.getBuffer().hasRemaining() && result.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW && this.dataToUnwrap.getBuffer().remaining() != dataToUnwrapLength ? (this.state |= 0x10) : (this.state &= 0xFFFFFFEF);
                long d = 0L;
                return d;
            }
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                this.state &= 0xFFFFFFEF;
            } else if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                UndertowLogger.REQUEST_LOGGER.sslBufferOverflow(this);
                IoUtils.safeClose((Closeable)this.delegate);
            } else {
                this.state = this.dataToUnwrap.getBuffer().hasRemaining() && this.dataToUnwrap.getBuffer().remaining() != dataToUnwrapLength ? (this.state |= 0x10) : (this.state &= 0xFFFFFFEF);
            }
            if (userBuffers == null) {
                long d = 0L;
                return d;
            }
            long res = original - Buffers.remaining((Buffer[])userBuffers);
            if (res > 0L) {
                this.readListenerInvocationCount = 0;
            }
            long l = res;
            return l;
        }
        catch (SSLException e) {
            try {
                try {
                    this.clearWriteRequiresRead();
                    this.doWrap(null, 0, 0);
                    this.flush();
                }
                catch (Exception e2) {
                    UndertowLogger.REQUEST_LOGGER.debug("Failed to write out final SSL record", e2);
                }
                this.close();
            }
            catch (Throwable ex) {
                UndertowLogger.REQUEST_LOGGER.debug("Exception closing SSLConduit after exception in doUnwrap", ex);
            }
            throw e;
        }
        catch (IOException | Error | RuntimeException e) {
            try {
                this.close();
            }
            catch (Throwable ex) {
                UndertowLogger.REQUEST_LOGGER.debug("Exception closing SSLConduit after exception in doUnwrap", ex);
            }
            throw e;
        }
        finally {
            boolean requiresListenerInvocation = false;
            if (bytesProduced.get() || unwrappedData != null && unwrappedData.isOpen() && unwrappedData.getBuffer().hasRemaining()) {
                requiresListenerInvocation = true;
            }
            if (this.dataToUnwrap != null) {
                if (!this.dataToUnwrap.getBuffer().hasRemaining() || Bits.anyAreSet((int)this.state, (int)4096)) {
                    this.dataToUnwrap.close();
                    this.dataToUnwrap = null;
                    this.state &= 0xFFFFFFEF;
                } else if (Bits.allAreClear((int)this.state, (int)16)) {
                    this.dataToUnwrap.getBuffer().compact();
                } else {
                    requiresListenerInvocation = true;
                }
            }
            if (requiresListenerInvocation && (Bits.anyAreSet((int)this.state, (int)4) || Bits.allAreSet((int)this.state, (int)10)) && !this.invokingReadListenerHandshake) {
                this.runReadListener(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private synchronized long doWrap(ByteBuffer[] userBuffers, int off, int len) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)4096)) {
            throw new ClosedChannelException();
        }
        if (this.outstandingTasks > 0) {
            return 0L;
        }
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            this.doUnwrap(null, 0, 0);
            if (Bits.allAreClear((int)this.state, (int)1)) {
                return 0L;
            }
        }
        if (this.wrappedData != null) {
            int res = this.sink.write(this.wrappedData.getBuffer());
            if (res == 0) return 0L;
            if (this.wrappedData.getBuffer().hasRemaining()) {
                return 0L;
            }
            this.wrappedData.getBuffer().clear();
        } else {
            this.wrappedData = this.bufferPool.allocate();
        }
        try {
            SSLEngineResult result = this.wrapAndFlip(userBuffers, off, len);
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                throw new IOException("underflow");
            }
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW && !this.wrappedData.getBuffer().hasRemaining()) {
                if (this.wrappedData.getBuffer().capacity() >= this.engine.getSession().getPacketBufferSize()) throw new IOException("overflow");
                this.wrappedData.close();
                int bufferSize = this.engine.getSession().getPacketBufferSize();
                UndertowLogger.REQUEST_IO_LOGGER.tracev("Expanded buffer enabled due to overflow with empty buffer, buffer size is %s", bufferSize);
                if (expandedBufferPool == null || expandedBufferPool.getBufferSize() < bufferSize) {
                    Class<SslConduit> clazz = SslConduit.class;
                    // MONITORENTER : io.undertow.protocols.ssl.SslConduit.class
                    if (expandedBufferPool == null || expandedBufferPool.getBufferSize() < bufferSize) {
                        expandedBufferPool = new DefaultByteBufferPool(false, bufferSize, -1, 12);
                    }
                    // MONITOREXIT : clazz
                }
                this.wrappedData = expandedBufferPool.allocate();
                result = this.wrapAndFlip(userBuffers, off, len);
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW && !this.wrappedData.getBuffer().hasRemaining()) {
                    throw new IOException("overflow");
                }
            }
            if (this.wrappedData.getBuffer().hasRemaining()) {
                this.sink.write(this.wrappedData.getBuffer());
            }
            if (this.wrappedData.getBuffer().hasRemaining()) {
                long bufferSize = result.bytesConsumed();
                return bufferSize;
            }
            if (!this.handleHandshakeResult(result)) {
                long bufferSize = 0L;
                return bufferSize;
            }
            if (result.getStatus() == SSLEngineResult.Status.CLOSED && userBuffers != null) {
                this.notifyWriteClosed();
                throw new ClosedChannelException();
            }
            long bufferSize = result.bytesConsumed();
            return bufferSize;
        }
        catch (IOException | Error | RuntimeException e) {
            try {
                this.close();
                throw e;
            }
            catch (Throwable ex) {
                UndertowLogger.REQUEST_LOGGER.debug("Exception closing SSLConduit after exception in doWrap()", ex);
            }
            throw e;
        }
        finally {
            if (this.wrappedData != null && (!this.wrappedData.getBuffer().hasRemaining() || Bits.anyAreSet((int)this.state, (int)4096))) {
                this.wrappedData.close();
                this.wrappedData = null;
            }
        }
    }

    private SSLEngineResult wrapAndFlip(ByteBuffer[] userBuffers, int off, int len) throws IOException {
        SSLEngineResult result = null;
        int totalConsumedBytes = 0;
        while (result == null || result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP && result.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW && !this.engine.isInboundDone()) {
            result = userBuffers == null ? this.engine.wrap(EMPTY_BUFFER, this.wrappedData.getBuffer()) : this.engine.wrap(userBuffers, off, len, this.wrappedData.getBuffer());
            totalConsumedBytes += result.bytesConsumed();
        }
        if (totalConsumedBytes != result.bytesConsumed()) {
            result = new SSLEngineResult(result.getStatus(), result.getHandshakeStatus(), totalConsumedBytes, result.bytesProduced());
        }
        this.wrappedData.getBuffer().flip();
        return result;
    }

    private boolean handleHandshakeResult(SSLEngineResult result) throws IOException {
        switch (result.getHandshakeStatus()) {
            case NEED_TASK: {
                this.state |= 0x800;
                this.clearReadRequiresWrite();
                this.clearWriteRequiresRead();
                this.runTasks();
                return false;
            }
            case NEED_UNWRAP: {
                this.clearReadRequiresWrite();
                this.state |= 0x802;
                this.sink.suspendWrites();
                if (Bits.anyAreSet((int)this.state, (int)8)) {
                    this.source.resumeReads();
                }
                return false;
            }
            case NEED_WRAP: {
                this.clearWriteRequiresRead();
                this.state |= 0x801;
                this.source.suspendReads();
                if (Bits.anyAreSet((int)this.state, (int)4)) {
                    this.sink.resumeWrites();
                }
                return false;
            }
            case FINISHED: {
                if (!Bits.anyAreSet((int)this.state, (int)2048)) break;
                this.state &= 0xFFFFF7FF;
                this.handshakeCallback.run();
            }
        }
        this.clearReadRequiresWrite();
        this.clearWriteRequiresRead();
        return true;
    }

    private void clearReadRequiresWrite() {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            this.state &= 0xFFFFFFFE;
            if (Bits.anyAreSet((int)this.state, (int)4)) {
                this.resumeReads(false);
            }
            if (Bits.allAreClear((int)this.state, (int)8)) {
                this.sink.suspendWrites();
            }
        }
    }

    private void clearWriteRequiresRead() {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            this.state &= 0xFFFFFFFD;
            if (Bits.anyAreSet((int)this.state, (int)8)) {
                this.wakeupWrites();
            }
            if (Bits.allAreClear((int)this.state, (int)4)) {
                this.source.suspendReads();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closed() {
        if (Bits.anyAreSet((int)this.state, (int)4096)) {
            return;
        }
        SslConduit sslConduit = this;
        synchronized (sslConduit) {
            this.state |= 0x1660;
            this.notifyReadClosed();
            this.notifyWriteClosed();
            if (this.dataToUnwrap != null) {
                this.dataToUnwrap.close();
                this.dataToUnwrap = null;
            }
            if (this.unwrappedData != null) {
                this.unwrappedData.close();
                this.unwrappedData = null;
            }
            if (this.wrappedData != null) {
                this.wrappedData.close();
                this.wrappedData = null;
            }
            if (Bits.allAreClear((int)this.state, (int)256)) {
                this.engine.closeOutbound();
            }
            if (Bits.allAreClear((int)this.state, (int)128)) {
                try {
                    this.engine.closeInbound();
                }
                catch (SSLException e) {
                    UndertowLogger.REQUEST_LOGGER.ioException(e);
                }
                catch (Throwable t) {
                    UndertowLogger.REQUEST_LOGGER.handleUnexpectedFailure(t);
                }
            }
        }
        IoUtils.safeClose((Closeable)this.delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTasks() throws IOException {
        this.delegate.getSinkChannel().suspendWrites();
        this.delegate.getSourceChannel().suspendReads();
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        Runnable t = this.engine.getDelegatedTask();
        while (t != null) {
            tasks.add(t);
            t = this.engine.getDelegatedTask();
        }
        SslConduit sslConduit = this;
        synchronized (sslConduit) {
            this.outstandingTasks += tasks.size();
            for (final Runnable task : tasks) {
                Runnable wrappedTask = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        SslConduit sslConduit;
                        try {
                            task.run();
                            sslConduit = SslConduit.this;
                        }
                        catch (Throwable throwable) {
                            SslConduit sslConduit2 = SslConduit.this;
                            synchronized (sslConduit2) {
                                if (SslConduit.this.outstandingTasks == 1) {
                                    SslConduit.this.getWriteThread().execute(new Runnable(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        @Override
                                        public void run() {
                                            SslConduit sslConduit = SslConduit.this;
                                            synchronized (sslConduit) {
                                                SslConduit.this.notifyAll();
                                                --SslConduit.this.outstandingTasks;
                                                try {
                                                    SslConduit.this.doHandshake();
                                                }
                                                catch (IOException | Error | RuntimeException e) {
                                                    UndertowLogger.REQUEST_LOGGER.debug("Closing SSLConduit after exception on handshake", e);
                                                    IoUtils.safeClose((Closeable)((Object)SslConduit.this.connection));
                                                }
                                                if (Bits.anyAreSet((int)SslConduit.this.state, (int)4)) {
                                                    SslConduit.this.wakeupReads();
                                                }
                                                if (Bits.anyAreSet((int)SslConduit.this.state, (int)8)) {
                                                    SslConduit.this.resumeWrites();
                                                }
                                            }
                                        }
                                    });
                                } else {
                                    --SslConduit.this.outstandingTasks;
                                }
                            }
                            throw throwable;
                        }
                        synchronized (sslConduit) {
                            if (SslConduit.this.outstandingTasks == 1) {
                                SslConduit.this.getWriteThread().execute(new /* invalid duplicate definition of identical inner class */);
                            } else {
                                --SslConduit.this.outstandingTasks;
                            }
                        }
                    }
                };
                try {
                    if (this.delegate.getIoThread().equals(Thread.currentThread()) && this.delegatedTaskExecutor == null) {
                        wrappedTask.run();
                        continue;
                    }
                    this.getDelegatedTaskExecutor().execute(wrappedTask);
                }
                catch (RejectedExecutionException e) {
                    UndertowLogger.REQUEST_IO_LOGGER.sslEngineDelegatedTaskRejected(e);
                    IoUtils.safeClose((Closeable)((Object)this.connection));
                    throw DelegatedTaskRejectedClosedChannelException.INSTANCE;
                }
            }
        }
    }

    public SSLEngine getSSLEngine() {
        return this.engine;
    }

    public void close() {
        this.closed();
    }

    public void setSslEngine(SSLEngine engine) {
        this.engine = engine;
    }

    public String toString() {
        return "SslConduit{state=" + this.state + ", outstandingTasks=" + this.outstandingTasks + ", wrappedData=" + String.valueOf(this.wrappedData) + ", dataToUnwrap=" + String.valueOf(this.dataToUnwrap) + ", unwrappedData=" + String.valueOf(this.unwrappedData) + "}";
    }

    private class SslReadReadyHandler
    implements ReadReadyHandler {
        private final ReadReadyHandler delegateHandler;

        private SslReadReadyHandler(ReadReadyHandler delegateHandler) {
            this.delegateHandler = delegateHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readReady() {
            if (Bits.anyAreSet((int)SslConduit.this.state, (int)2) && Bits.anyAreSet((int)SslConduit.this.state, (int)12) && !Bits.anyAreSet((int)SslConduit.this.state, (int)128)) {
                try {
                    SslConduit.this.invokingReadListenerHandshake = true;
                    SslConduit.this.doHandshake();
                }
                catch (IOException e) {
                    UndertowLogger.REQUEST_LOGGER.ioException(e);
                    IoUtils.safeClose((Closeable)SslConduit.this.delegate);
                }
                catch (Throwable t) {
                    UndertowLogger.REQUEST_IO_LOGGER.handleUnexpectedFailure(t);
                    IoUtils.safeClose((Closeable)SslConduit.this.delegate);
                }
                finally {
                    SslConduit.this.invokingReadListenerHandshake = false;
                }
                if (!Bits.anyAreSet((int)SslConduit.this.state, (int)4) && !Bits.allAreSet((int)SslConduit.this.state, (int)10)) {
                    SslConduit.this.delegate.getSourceChannel().suspendReads();
                }
            }
            boolean noProgress = false;
            int initialDataToUnwrap = -1;
            int initialUnwrapped = -1;
            if (Bits.anyAreSet((int)SslConduit.this.state, (int)4)) {
                if (this.delegateHandler == null) {
                    ChannelListener readListener = SslConduit.this.connection.getSourceChannel().getReadListener();
                    if (readListener == null) {
                        SslConduit.this.suspendReads();
                    } else {
                        if (Bits.anyAreSet((int)SslConduit.this.state, (int)16)) {
                            initialDataToUnwrap = SslConduit.this.dataToUnwrap.getBuffer().remaining();
                        }
                        if (SslConduit.this.unwrappedData != null) {
                            initialUnwrapped = SslConduit.this.unwrappedData.getBuffer().remaining();
                        }
                        ChannelListeners.invokeChannelListener((Channel)SslConduit.this.connection.getSourceChannel(), (ChannelListener)readListener);
                        if (Bits.anyAreSet((int)SslConduit.this.state, (int)16) && initialDataToUnwrap == SslConduit.this.dataToUnwrap.getBuffer().remaining()) {
                            noProgress = true;
                        } else if (SslConduit.this.unwrappedData != null && SslConduit.this.unwrappedData.getBuffer().remaining() == initialUnwrapped) {
                            noProgress = true;
                        }
                    }
                } else {
                    this.delegateHandler.readReady();
                }
            }
            if (Bits.anyAreSet((int)SslConduit.this.state, (int)4) && (SslConduit.this.unwrappedData != null || Bits.anyAreSet((int)SslConduit.this.state, (int)16))) {
                if (Bits.anyAreSet((int)SslConduit.this.state, (int)16384)) {
                    SslConduit sslConduit = SslConduit.this;
                    synchronized (sslConduit) {
                        if (SslConduit.this.unwrappedData != null) {
                            SslConduit.this.unwrappedData.close();
                        }
                        if (SslConduit.this.dataToUnwrap != null) {
                            SslConduit.this.dataToUnwrap.close();
                        }
                        SslConduit.this.unwrappedData = null;
                        SslConduit.this.dataToUnwrap = null;
                    }
                } else if (!(Bits.anyAreSet((int)SslConduit.this.state, (int)1) && SslConduit.this.wrappedData != null || SslConduit.this.outstandingTasks != 0 || noProgress)) {
                    SslConduit.this.runReadListener(false);
                }
            }
        }

        public void forceTermination() {
            try {
                if (this.delegateHandler != null) {
                    this.delegateHandler.forceTermination();
                }
            }
            finally {
                IoUtils.safeClose((Closeable)SslConduit.this.delegate);
            }
        }

        public void terminated() {
            ChannelListeners.invokeChannelListener((Channel)SslConduit.this.connection.getSourceChannel(), (ChannelListener)SslConduit.this.connection.getSourceChannel().getCloseListener());
        }
    }

    private class SslWriteReadyHandler
    implements WriteReadyHandler {
        private final WriteReadyHandler delegateHandler;

        private SslWriteReadyHandler(WriteReadyHandler delegateHandler) {
            this.delegateHandler = delegateHandler;
        }

        public void forceTermination() {
            try {
                if (this.delegateHandler != null) {
                    this.delegateHandler.forceTermination();
                }
            }
            finally {
                IoUtils.safeClose((Closeable)SslConduit.this.delegate);
            }
        }

        public void terminated() {
            ChannelListeners.invokeChannelListener((Channel)SslConduit.this.connection.getSinkChannel(), (ChannelListener)SslConduit.this.connection.getSinkChannel().getCloseListener());
        }

        public void writeReady() {
            if (Bits.anyAreSet((int)SslConduit.this.state, (int)1)) {
                if (Bits.anyAreSet((int)SslConduit.this.state, (int)4)) {
                    SslConduit.this.readReadyHandler.readReady();
                } else {
                    try {
                        SslConduit.this.doHandshake();
                    }
                    catch (IOException e) {
                        UndertowLogger.REQUEST_LOGGER.ioException(e);
                        IoUtils.safeClose((Closeable)SslConduit.this.delegate);
                    }
                    catch (Throwable t) {
                        UndertowLogger.REQUEST_LOGGER.handleUnexpectedFailure(t);
                        IoUtils.safeClose((Closeable)SslConduit.this.delegate);
                    }
                }
            }
            if (Bits.anyAreSet((int)SslConduit.this.state, (int)8)) {
                if (this.delegateHandler == null) {
                    ChannelListener writeListener = SslConduit.this.connection.getSinkChannel().getWriteListener();
                    if (writeListener == null) {
                        SslConduit.this.suspendWrites();
                    } else {
                        ChannelListeners.invokeChannelListener((Channel)SslConduit.this.connection.getSinkChannel(), (ChannelListener)writeListener);
                    }
                } else {
                    this.delegateHandler.writeReady();
                }
            }
            if (!Bits.anyAreSet((int)SslConduit.this.state, (int)9)) {
                SslConduit.this.delegate.getSinkChannel().suspendWrites();
            }
        }
    }

    private static class AccumulativeOrBoolean {
        private boolean value = false;

        private AccumulativeOrBoolean() {
        }

        public void add(boolean value) {
            this.value = this.value || value;
        }

        public boolean get() {
            return this.value;
        }
    }

    private static final class DelegatedTaskRejectedClosedChannelException
    extends ClosedChannelException {
        private static final DelegatedTaskRejectedClosedChannelException INSTANCE = new DelegatedTaskRejectedClosedChannelException();

        private DelegatedTaskRejectedClosedChannelException() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }

        @Override
        public Throwable initCause(Throwable ignored) {
            return this;
        }

        @Override
        public void setStackTrace(StackTraceElement[] ignored) {
        }
    }
}

