/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.profile.ProfilerFactory;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.BenchmarkResultMetaData;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.results.format.ResultFormatFactory;
import org.openjdk.jmh.runner.Action;
import org.openjdk.jmh.runner.ActionMode;
import org.openjdk.jmh.runner.ActionPlan;
import org.openjdk.jmh.runner.ActionType;
import org.openjdk.jmh.runner.BaseRunner;
import org.openjdk.jmh.runner.BenchmarkException;
import org.openjdk.jmh.runner.BenchmarkList;
import org.openjdk.jmh.runner.BenchmarkListEntry;
import org.openjdk.jmh.runner.CompilerHints;
import org.openjdk.jmh.runner.Defaults;
import org.openjdk.jmh.runner.ForkedMain;
import org.openjdk.jmh.runner.IterationType;
import org.openjdk.jmh.runner.NoBenchmarksException;
import org.openjdk.jmh.runner.OutputFormatAdapter;
import org.openjdk.jmh.runner.PrintPropertiesMain;
import org.openjdk.jmh.runner.ProfilersFailedException;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.WorkloadParams;
import org.openjdk.jmh.runner.format.OutputFormat;
import org.openjdk.jmh.runner.format.OutputFormatFactory;
import org.openjdk.jmh.runner.link.BinaryLinkServer;
import org.openjdk.jmh.runner.options.CommandLineOptions;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.ProfilerConfig;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.util.FileUtils;
import org.openjdk.jmh.util.HashMultimap;
import org.openjdk.jmh.util.InputStreamDrainer;
import org.openjdk.jmh.util.Multimap;
import org.openjdk.jmh.util.Optional;
import org.openjdk.jmh.util.TempFile;
import org.openjdk.jmh.util.TreeMultimap;
import org.openjdk.jmh.util.UnCloseablePrintStream;
import org.openjdk.jmh.util.Utils;
import org.openjdk.jmh.util.Version;

public class Runner
extends BaseRunner {
    private static final int TAIL_LINES_ON_ERROR = Integer.getInteger("jmh.tailLines", 20);
    private static final String JMH_LOCK_FILE = System.getProperty("java.io.tmpdir") + "/jmh.lock";
    private static final Boolean JMH_LOCK_IGNORE = Boolean.getBoolean("jmh.ignoreLock");
    private final BenchmarkList list = BenchmarkList.defaultList();
    private int cpuCount;

    public Runner(Options options, OutputFormat format) {
        super(options, format);
    }

    public Runner(Options options) {
        this(options, Runner.createOutputFormat(options));
    }

    private static OutputFormat createOutputFormat(Options options) {
        PrintStream out;
        if (options == null) {
            throw new IllegalArgumentException("Options not allowed to be null.");
        }
        if (options.getOutput().hasValue()) {
            try {
                out = new PrintStream(options.getOutput().get());
            }
            catch (FileNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
        }
        try {
            out = new UnCloseablePrintStream((OutputStream)System.out, Utils.guessConsoleEncoding());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
        return OutputFormatFactory.createFormatInstance(out, options.verbosity().orElse(Defaults.VERBOSITY));
    }

    public void list() {
        SortedSet<BenchmarkListEntry> benchmarks = this.list.find(this.out, this.options.getIncludes(), this.options.getExcludes());
        this.out.println("Benchmarks: ");
        for (BenchmarkListEntry benchmark : benchmarks) {
            this.out.println(benchmark.getUsername());
        }
    }

    public void listWithParams(CommandLineOptions options) {
        SortedSet<BenchmarkListEntry> benchmarks = this.list.find(this.out, options.getIncludes(), options.getExcludes());
        this.out.println("Benchmarks: ");
        for (BenchmarkListEntry benchmark : benchmarks) {
            this.out.println(benchmark.getUsername());
            Optional<Map<String, String[]>> params = benchmark.getParams();
            if (!params.hasValue()) continue;
            for (Map.Entry<String, String[]> e : params.get().entrySet()) {
                String param = e.getKey();
                Collection values = options.getParameter(param).orElse(Arrays.asList((Object[])e.getValue()));
                this.out.println("  param \"" + param + "\" = {" + Utils.join(values, ", ") + "}");
            }
        }
    }

    public RunResult runSingle() throws RunnerException {
        SortedSet<BenchmarkListEntry> benchmarks = this.list.find(this.out, this.options.getIncludes(), this.options.getExcludes());
        if (benchmarks.size() == 1) {
            Collection<RunResult> values = this.run();
            if (values.size() == 1) {
                return values.iterator().next();
            }
            throw new RunnerException("No results returned");
        }
        if (benchmarks.size() > 1) {
            throw new RunnerException("More than single benchmark are matching the options: " + benchmarks);
        }
        throw new NoBenchmarksException();
    }

    public Collection<RunResult> run() throws RunnerException {
        FileChannel channel = null;
        FileLock lock = null;
        try {
            Object msg;
            File file = new File(JMH_LOCK_FILE);
            file.createNewFile();
            file.setWritable(true, false);
            channel = new RandomAccessFile(file, "rw").getChannel();
            try {
                lock = channel.tryLock();
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                // empty catch block
            }
            if (lock == null) {
                msg = "Unable to acquire the JMH lock (" + JMH_LOCK_FILE + "): already taken by another JMH instance";
                if (JMH_LOCK_IGNORE.booleanValue()) {
                    this.out.println("# WARNING: " + (String)msg + ", ignored by user's request.");
                } else {
                    throw new RunnerException("ERROR: " + (String)msg + ", exiting. Use -Djmh.ignoreLock=true to forcefully continue.");
                }
            }
            msg = this.internalRun();
            return msg;
        }
        catch (IOException e) {
            String msg = "Exception while trying to acquire the JMH lock (" + JMH_LOCK_FILE + "): " + e.getMessage();
            if (JMH_LOCK_IGNORE.booleanValue()) {
                this.out.println("# WARNING: " + msg + ", ignored by user's request.");
                Collection<RunResult> collection = this.internalRun();
                return collection;
            }
            throw new RunnerException("ERROR: " + msg + ", exiting. Use -Djmh.ignoreLock=true to forcefully continue.");
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            catch (IOException iOException) {}
            FileUtils.safelyClose(channel);
        }
    }

    private Collection<RunResult> internalRun() throws RunnerException {
        ArrayList<BenchmarkListEntry> newBenchmarks;
        SortedSet<BenchmarkListEntry> benchmarks;
        HashSet<String> profilerClasses = new HashSet<String>();
        boolean someProfilersFail = false;
        for (ProfilerConfig p : this.options.getProfilers()) {
            if (!profilerClasses.add(p.getKlass())) {
                throw new RunnerException("Cannot instantiate the same profiler more than once: " + p.getKlass());
            }
            try {
                ProfilerFactory.getProfilerOrException(p);
            }
            catch (ProfilerException e) {
                this.out.println(e.getMessage());
                someProfilersFail = true;
            }
            if (!someProfilersFail) continue;
            throw new ProfilersFailedException();
        }
        String resultFile = null;
        if (this.options.getResult().hasValue() || this.options.getResultFormat().hasValue()) {
            resultFile = this.options.getResult().orElse("jmh-result." + this.options.getResultFormat().orElse(Defaults.RESULT_FORMAT).toString().toLowerCase());
            try {
                FileUtils.touch(resultFile);
            }
            catch (IOException e) {
                throw new RunnerException("Can not touch the result file: " + resultFile);
            }
        }
        if ((benchmarks = this.list.find(this.out, this.options.getIncludes(), this.options.getExcludes())).isEmpty()) {
            this.out.flush();
            this.out.close();
            throw new NoBenchmarksException();
        }
        if (!this.options.getBenchModes().isEmpty()) {
            newBenchmarks = new ArrayList<BenchmarkListEntry>();
            for (BenchmarkListEntry br : benchmarks) {
                for (Mode m : this.options.getBenchModes()) {
                    newBenchmarks.add(br.cloneWith(m));
                }
            }
            benchmarks.clear();
            benchmarks.addAll(newBenchmarks);
        }
        newBenchmarks = new ArrayList();
        for (BenchmarkListEntry br : benchmarks) {
            if (br.getMode() == Mode.All) {
                for (Mode mode : Mode.values()) {
                    if (mode == Mode.All) continue;
                    newBenchmarks.add(br.cloneWith(mode));
                }
                continue;
            }
            newBenchmarks.add(br);
        }
        benchmarks.clear();
        benchmarks.addAll(newBenchmarks);
        newBenchmarks = new ArrayList();
        for (BenchmarkListEntry br : benchmarks) {
            if (br.getParams().hasValue()) {
                for (WorkloadParams p : this.explodeAllParams(br)) {
                    newBenchmarks.add(br.cloneWith(p));
                }
                continue;
            }
            newBenchmarks.add(br);
        }
        benchmarks.clear();
        benchmarks.addAll(newBenchmarks);
        Collection<RunResult> results = this.runBenchmarks(benchmarks);
        if (resultFile != null) {
            ResultFormatFactory.getInstance(this.options.getResultFormat().orElse(Defaults.RESULT_FORMAT), resultFile).writeOut(results);
            this.out.println("");
            this.out.println("Benchmark result is saved to " + resultFile);
        }
        this.out.flush();
        this.out.close();
        return results;
    }

    private List<ActionPlan> getActionPlans(Set<BenchmarkListEntry> benchmarks) {
        ActionPlan base = new ActionPlan(ActionType.FORKED);
        LinkedHashSet<BenchmarkListEntry> warmupBenches = new LinkedHashSet<BenchmarkListEntry>();
        List<String> warmupMicrosRegexp = this.options.getWarmupIncludes();
        if (warmupMicrosRegexp != null && !warmupMicrosRegexp.isEmpty()) {
            warmupBenches.addAll(this.list.find(this.out, warmupMicrosRegexp, Collections.emptyList()));
        }
        if (this.options.getWarmupMode().orElse(Defaults.WARMUP_MODE).isBulk()) {
            warmupBenches.addAll(benchmarks);
        }
        for (BenchmarkListEntry wr : warmupBenches) {
            base.add(this.newAction(wr, ActionMode.WARMUP));
        }
        ActionPlan embeddedPlan = new ActionPlan(ActionType.EMBEDDED);
        embeddedPlan.mixIn(base);
        boolean addEmbedded = false;
        ArrayList<ActionPlan> result = new ArrayList<ActionPlan>();
        for (BenchmarkListEntry br : benchmarks) {
            BenchmarkParams params = this.newBenchmarkParams(br, ActionMode.UNDEF);
            if (params.getForks() <= 0) {
                if (this.options.getWarmupMode().orElse(Defaults.WARMUP_MODE).isIndi()) {
                    embeddedPlan.add(this.newAction(br, ActionMode.WARMUP_MEASUREMENT));
                } else {
                    embeddedPlan.add(this.newAction(br, ActionMode.MEASUREMENT));
                }
                addEmbedded = true;
            }
            if (params.getForks() <= 0) continue;
            ActionPlan r = new ActionPlan(ActionType.FORKED);
            r.mixIn(base);
            if (this.options.getWarmupMode().orElse(Defaults.WARMUP_MODE).isIndi()) {
                r.add(this.newAction(br, ActionMode.WARMUP_MEASUREMENT));
            } else {
                r.add(this.newAction(br, ActionMode.MEASUREMENT));
            }
            result.add(r);
        }
        if (addEmbedded) {
            result.add(embeddedPlan);
        }
        return result;
    }

    private Action newAction(BenchmarkListEntry br, ActionMode mode) {
        return new Action(this.newBenchmarkParams(br, mode), mode);
    }

    private BenchmarkParams newBenchmarkParams(BenchmarkListEntry benchmark, ActionMode mode) {
        IterationParams measurement;
        boolean synchIterations;
        int[] threadGroups = this.options.getThreadGroups().orElse(benchmark.getThreadGroups());
        int threads = this.options.getThreads().orElse(benchmark.getThreads().orElse(1));
        if (threads == -1) {
            if (this.cpuCount == 0) {
                this.out.print("# Detecting actual CPU count: ");
                this.cpuCount = Utils.figureOutHotCPUs();
                this.out.println(this.cpuCount + " detected");
            }
            threads = this.cpuCount;
        }
        threads = Utils.roundUp(threads, Utils.sum(threadGroups));
        boolean bl = synchIterations = benchmark.getMode() != Mode.SingleShotTime && this.options.shouldSyncIterations().orElse(true) != false;
        IterationParams iterationParams = mode.doMeasurement() ? new IterationParams(IterationType.MEASUREMENT, this.options.getMeasurementIterations().orElse(benchmark.getMeasurementIterations().orElse(benchmark.getMode() == Mode.SingleShotTime ? 1 : 5)), this.options.getMeasurementTime().orElse(benchmark.getMeasurementTime().orElse(benchmark.getMode() == Mode.SingleShotTime ? TimeValue.NONE : Defaults.MEASUREMENT_TIME)), this.options.getMeasurementBatchSize().orElse(benchmark.getMeasurementBatchSize().orElse(1))) : (measurement = new IterationParams(IterationType.MEASUREMENT, 0, TimeValue.NONE, 1));
        IterationParams warmup = mode.doWarmup() ? new IterationParams(IterationType.WARMUP, this.options.getWarmupIterations().orElse(benchmark.getWarmupIterations().orElse(benchmark.getMode() == Mode.SingleShotTime ? 0 : 5)), this.options.getWarmupTime().orElse(benchmark.getWarmupTime().orElse(benchmark.getMode() == Mode.SingleShotTime ? TimeValue.NONE : Defaults.WARMUP_TIME)), this.options.getWarmupBatchSize().orElse(benchmark.getWarmupBatchSize().orElse(1))) : new IterationParams(IterationType.WARMUP, 0, TimeValue.NONE, 1);
        int forks = this.options.getForkCount().orElse(benchmark.getForks().orElse(5));
        int warmupForks = this.options.getWarmupForkCount().orElse(benchmark.getWarmupForks().orElse(0));
        TimeUnit timeUnit = this.options.getTimeUnit().orElse(benchmark.getTimeUnit().orElse(Defaults.OUTPUT_TIMEUNIT));
        int opsPerInvocation = this.options.getOperationsPerInvocation().orElse(benchmark.getOperationsPerInvocation().orElse(Defaults.OPS_PER_INVOCATION));
        String jvm = this.options.getJvm().orElse(benchmark.getJvm().orElse(Utils.getCurrentJvm()));
        Properties targetProperties = jvm.equals(Utils.getCurrentJvm()) ? Utils.getRecordedSystemProperties() : Utils.readPropertiesFromCommand(this.getPrintPropertiesCommand(jvm));
        ArrayList<String> jvmArgs = new ArrayList<String>();
        jvmArgs.addAll(this.options.getJvmArgsPrepend().orElse(benchmark.getJvmArgsPrepend().orElse(Collections.emptyList())));
        jvmArgs.addAll((Collection)this.options.getJvmArgs().orElse(benchmark.getJvmArgs().orElse(ManagementFactory.getRuntimeMXBean().getInputArguments())));
        jvmArgs.addAll(this.options.getJvmArgsAppend().orElse(benchmark.getJvmArgsAppend().orElse(Collections.emptyList())));
        TimeValue timeout = this.options.getTimeout().orElse(benchmark.getTimeout().orElse(Defaults.TIMEOUT));
        String jdkVersion = targetProperties.getProperty("java.version");
        String vmVersion = targetProperties.getProperty("java.vm.version");
        String vmName = targetProperties.getProperty("java.vm.name");
        return new BenchmarkParams(benchmark.getUsername(), benchmark.generatedTarget(), synchIterations, threads, threadGroups, benchmark.getThreadGroupLabels().orElse(Collections.emptyList()), forks, warmupForks, warmup, measurement, benchmark.getMode(), benchmark.getWorkloadParams(), timeUnit, opsPerInvocation, jvm, jvmArgs, jdkVersion, vmName, vmVersion, Version.getPlainVersion(), timeout);
    }

    private List<WorkloadParams> explodeAllParams(BenchmarkListEntry br) throws RunnerException {
        Map benchParams = br.getParams().orElse(Collections.emptyMap());
        ArrayList<WorkloadParams> ps = new ArrayList<WorkloadParams>();
        for (Map.Entry e : benchParams.entrySet()) {
            String k = (String)e.getKey();
            String[] vals = (String[])e.getValue();
            Collection values = this.options.getParameter(k).orElse(Arrays.asList(vals));
            if (values.isEmpty()) {
                throw new RunnerException("Benchmark \"" + br.getUsername() + "\" defines the parameter \"" + k + "\", but no default values.\nDefine the default values within the annotation, or provide the parameter values at runtime.");
            }
            if (ps.isEmpty()) {
                int idx = 0;
                for (String v : values) {
                    WorkloadParams al = new WorkloadParams();
                    al.put(k, v, idx);
                    ps.add(al);
                    ++idx;
                }
                continue;
            }
            ArrayList<WorkloadParams> newPs = new ArrayList<WorkloadParams>();
            for (WorkloadParams p : ps) {
                int idx = 0;
                for (String v : values) {
                    WorkloadParams al = p.copy();
                    al.put(k, v, idx);
                    newPs.add(al);
                    ++idx;
                }
            }
            ps = newPs;
        }
        return ps;
    }

    private Collection<RunResult> runBenchmarks(SortedSet<BenchmarkListEntry> benchmarks) throws RunnerException {
        this.out.startRun();
        TreeMultimap<BenchmarkParams, BenchmarkResult> results = new TreeMultimap<BenchmarkParams, BenchmarkResult>();
        List<ActionPlan> plan = this.getActionPlans(benchmarks);
        this.etaBeforeBenchmarks(plan);
        try {
            for (ActionPlan r : plan) {
                Multimap<BenchmarkParams, BenchmarkResult> res;
                switch (r.getType()) {
                    case EMBEDDED: {
                        res = this.runBenchmarksEmbedded(r);
                        break;
                    }
                    case FORKED: {
                        res = this.runSeparate(r);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown action plan type: " + (Object)((Object)r.getType()));
                    }
                }
                for (BenchmarkParams br : res.keys()) {
                    results.putAll(br, res.get(br));
                }
            }
            this.etaAfterBenchmarks();
            SortedSet<RunResult> runResults = this.mergeRunResults(results);
            this.out.endRun(runResults);
            return runResults;
        }
        catch (BenchmarkException be) {
            throw new RunnerException("Benchmark caught the exception", be);
        }
    }

    private SortedSet<RunResult> mergeRunResults(Multimap<BenchmarkParams, BenchmarkResult> results) {
        TreeSet<RunResult> result = new TreeSet<RunResult>(RunResult.DEFAULT_SORT_COMPARATOR);
        for (BenchmarkParams key : results.keys()) {
            result.add(new RunResult(key, results.get(key)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Multimap<BenchmarkParams, BenchmarkResult> runSeparate(ActionPlan actionPlan) {
        HashMultimap<BenchmarkParams, BenchmarkResult> results = new HashMultimap<BenchmarkParams, BenchmarkResult>();
        if (actionPlan.getMeasurementActions().size() != 1) {
            throw new IllegalStateException("Expect only single benchmark in the action plan, but was " + actionPlan.getMeasurementActions().size());
        }
        BinaryLinkServer server = null;
        try {
            server = new BinaryLinkServer(this.options, this.out);
            server.setPlan(actionPlan);
            BenchmarkParams params = actionPlan.getMeasurementActions().get(0).getParams();
            List<ExternalProfiler> profilers = ProfilerFactory.getSupportedExternal(this.options.getProfilers());
            boolean printOut = true;
            boolean printErr = true;
            for (ExternalProfiler prof : profilers) {
                printOut &= prof.allowPrintOut();
                printErr &= prof.allowPrintErr();
            }
            ArrayList<ExternalProfiler> profilersRev = new ArrayList<ExternalProfiler>(profilers);
            Collections.reverse(profilersRev);
            boolean forcePrint = this.options.verbosity().orElse(Defaults.VERBOSITY).equalsOrHigherThan(VerboseMode.EXTRA);
            printOut = forcePrint || printOut;
            printErr = forcePrint || printErr;
            this.out.startBenchmark(params);
            this.out.println("");
            int forkCount = params.getForks();
            int warmupForkCount = params.getWarmupForks();
            int totalForks = warmupForkCount + forkCount;
            for (int i = 0; i < totalForks; ++i) {
                boolean warmupFork = i < warmupForkCount;
                List<String> forkedString = this.getForkedMainCommand(params, profilers, server.getHost(), server.getPort());
                this.etaBeforeBenchmark();
                if (warmupFork) {
                    this.out.verbosePrintln("Warmup forking using command: " + forkedString);
                    this.out.println("# Warmup Fork: " + (i + 1) + " of " + warmupForkCount);
                } else {
                    this.out.verbosePrintln("Forking using command: " + forkedString);
                    this.out.println("# Fork: " + (i + 1 - warmupForkCount) + " of " + forkCount);
                }
                TempFile stdErr = FileUtils.weakTempFile("stderr");
                TempFile stdOut = FileUtils.weakTempFile("stdout");
                if (!profilers.isEmpty()) {
                    this.out.print("# Preparing profilers: ");
                    for (ExternalProfiler profiler : profilers) {
                        this.out.print(profiler.getClass().getSimpleName() + " ");
                        profiler.beforeTrial(params);
                    }
                    this.out.println("");
                    ArrayList<String> consumed = new ArrayList<String>();
                    if (!printOut) {
                        consumed.add("stdout");
                    }
                    if (!printErr) {
                        consumed.add("stderr");
                    }
                    if (!consumed.isEmpty()) {
                        this.out.println("# Profilers consume " + Utils.join(consumed, " and ") + " from target VM, use -v " + (Object)((Object)VerboseMode.EXTRA) + " to copy to console");
                    }
                }
                long startTime = System.currentTimeMillis();
                List<IterationResult> result = this.doFork(server, forkedString, stdOut.file(), stdErr.file(), printOut, printErr);
                if (!result.isEmpty()) {
                    long pid = server.getClientPid();
                    BenchmarkResultMetaData md = server.getMetadata();
                    if (md != null) {
                        md.adjustStart(startTime);
                    }
                    BenchmarkResult br = new BenchmarkResult(params, result, md);
                    if (!profilersRev.isEmpty()) {
                        this.out.print("# Processing profiler results: ");
                        for (ExternalProfiler profiler : profilersRev) {
                            this.out.print(profiler.getClass().getSimpleName() + " ");
                            for (Result result2 : profiler.afterTrial(br, pid, stdOut.file(), stdErr.file())) {
                                br.addBenchmarkResult(result2);
                            }
                        }
                        this.out.println("");
                    }
                    if (!warmupFork) {
                        results.put(params, br);
                    }
                }
                this.etaAfterBenchmark(params);
                this.out.println("");
                stdOut.delete();
                stdErr.delete();
            }
            this.out.endBenchmark(new RunResult(params, results.get(params)).getAggregatedResult());
        }
        catch (IOException e) {
            results.clear();
            throw new BenchmarkException(e);
        }
        catch (BenchmarkException e) {
            results.clear();
            if (this.options.shouldFailOnError().orElse(false).booleanValue()) {
                this.out.println("Benchmark had encountered error, and fail on error was requested");
                throw e;
            }
        }
        finally {
            if (server != null) {
                server.terminate();
            }
            FileUtils.purgeTemps();
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<IterationResult> doFork(BinaryLinkServer reader, List<String> commandString, File stdOut, File stdErr, boolean printOut, boolean printErr) {
        try (FileOutputStream fosErr = new FileOutputStream(stdErr);){
            int ecode;
            Throwable throwable;
            FileOutputStream fosOut;
            block31: {
                List<IterationResult> list;
                block32: {
                    BenchmarkException exception;
                    fosOut = new FileOutputStream(stdOut);
                    throwable = null;
                    ProcessBuilder pb = new ProcessBuilder(commandString);
                    Process p = pb.start();
                    InputStreamDrainer errDrainer = new InputStreamDrainer(p.getErrorStream(), fosErr);
                    InputStreamDrainer outDrainer = new InputStreamDrainer(p.getInputStream(), fosOut);
                    if (printErr) {
                        errDrainer.addOutputStream(new OutputFormatAdapter(this.out));
                    }
                    if (printOut) {
                        outDrainer.addOutputStream(new OutputFormatAdapter(this.out));
                    }
                    errDrainer.start();
                    outDrainer.start();
                    ecode = p.waitFor();
                    errDrainer.join();
                    outDrainer.join();
                    reader.waitFinish();
                    if (ecode != 0) {
                        this.out.println("<forked VM failed with exit code " + ecode + ">");
                        this.out.println("<stdout last='" + TAIL_LINES_ON_ERROR + " lines'>");
                        for (String l : FileUtils.tail(stdOut, TAIL_LINES_ON_ERROR)) {
                            this.out.println(l);
                        }
                        this.out.println("</stdout>");
                        this.out.println("<stderr last='" + TAIL_LINES_ON_ERROR + " lines'>");
                        for (String l : FileUtils.tail(stdErr, TAIL_LINES_ON_ERROR)) {
                            this.out.println(l);
                        }
                        this.out.println("</stderr>");
                        this.out.println("");
                    }
                    if ((exception = reader.getException()) != null) throw exception;
                    if (ecode != 0) break block31;
                    list = reader.getResults();
                    if (fosOut == null) return list;
                    if (throwable == null) break block32;
                    try {
                        fosOut.close();
                        return list;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return list;
                    }
                }
                fosOut.close();
                return list;
            }
            try {
                try {
                    throw new BenchmarkException(new IllegalStateException("Forked VM failed with exit code " + ecode));
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                if (fosOut == null) throw throwable4;
                if (throwable == null) {
                    fosOut.close();
                    throw throwable4;
                }
                try {
                    fosOut.close();
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                    throw throwable4;
                }
            }
        }
        catch (IOException ex) {
            this.out.println("<failed to invoke the VM, caught IOException: " + ex.getMessage() + ">");
            this.out.println("");
            throw new BenchmarkException(ex);
        }
        catch (InterruptedException ex) {
            this.out.println("<host VM has been interrupted waiting for forked VM: " + ex.getMessage() + ">");
            this.out.println("");
            throw new BenchmarkException(ex);
        }
    }

    List<String> getForkedMainCommand(BenchmarkParams benchmark, List<ExternalProfiler> profilers, String host, int port) {
        ArrayList<String> javaInvokeOptions = new ArrayList<String>();
        ArrayList<String> javaOptions = new ArrayList<String>();
        for (ExternalProfiler prof : profilers) {
            javaInvokeOptions.addAll(prof.addJVMInvokeOptions(benchmark));
            javaOptions.addAll(prof.addJVMOptions(benchmark));
        }
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(javaInvokeOptions);
        command.add(benchmark.getJvm());
        command.addAll(benchmark.getJvmArgs());
        command.addAll(javaOptions);
        CompilerHints.addCompilerHints(command);
        this.addClasspath(command);
        command.add(ForkedMain.class.getName());
        command.add(host);
        command.add(String.valueOf(port));
        return command;
    }

    private List<String> getPrintPropertiesCommand(String jvm) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(jvm);
        this.addClasspath(command);
        command.add(PrintPropertiesMain.class.getName());
        return command;
    }

    private void addClasspath(List<String> command) {
        command.add("-cp");
        String cpProp = System.getProperty("java.class.path");
        File tmpFile = null;
        String jvmargs = "" + this.options.getJvmArgs().orElse(Collections.emptyList()) + this.options.getJvmArgsPrepend().orElse(Collections.emptyList()) + this.options.getJvmArgsAppend().orElse(Collections.emptyList());
        if (Boolean.getBoolean("jmh.separateClasspathJAR") || jvmargs.contains("jmh.separateClasspathJAR=true")) {
            try {
                tmpFile = FileUtils.tempFile("classpath.jar");
                Path tmpFileDir = tmpFile.toPath().getParent();
                StringBuilder sb = new StringBuilder();
                for (String cp : cpProp.split(File.pathSeparator)) {
                    String rel = tmpFileDir.relativize(new File(cp).getAbsoluteFile().toPath()).toString();
                    sb.append(rel.replace('\\', '/').replace(" ", "%20"));
                    if (!cp.endsWith(".jar")) {
                        sb.append('/');
                    }
                    sb.append(" ");
                }
                String classPath = sb.toString().trim();
                Manifest manifest = new Manifest();
                Attributes attrs = manifest.getMainAttributes();
                attrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
                attrs.putValue("Class-Path", classPath);
                try (JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(tmpFile), manifest);){
                    jos.putNextEntry(new ZipEntry("META-INF/"));
                }
            }
            catch (IOException ex) {
                tmpFile = null;
            }
        }
        if (tmpFile != null) {
            if (Utils.isWindows()) {
                command.add("\"" + tmpFile.getAbsolutePath() + "\"");
            } else {
                command.add(tmpFile.getAbsolutePath());
            }
        } else if (Utils.isWindows()) {
            command.add('\"' + cpProp + '\"');
        } else {
            command.add(cpProp);
        }
    }
}

