/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.benchmarks;

import java.io.IOException;
import java.nio.ByteBuffer;

public class AsciiEncoders {

    public static enum NonBatchMutableBufferOffsetAsciiEncoder implements AsciiEncoder
    {
        Instance;


        @Override
        public int writeAndFlushAscii(BufferFlusher flusher, ByteBuffer buffer, char[] chars, int start, int end) throws IOException {
            int remaining = buffer.remaining();
            boolean ok = true;
            int i = start;
            int flushPos = i + remaining;
            while (ok && i < end) {
                int realEnd = Math.min(end, flushPos);
                while (i < realEnd) {
                    char c = chars[i];
                    if (c > '\u007f') {
                        ok = false;
                        break;
                    }
                    buffer.put((byte)c);
                    ++i;
                }
                if (i != flushPos) continue;
                flusher.flushBuffer(buffer);
                flushPos = i + buffer.remaining();
            }
            if (ok) {
                return end - start;
            }
            return -1;
        }
    }

    public static enum NonBatchFixedBufferOffsetAsciiEncoder implements AsciiEncoder
    {
        Instance;


        @Override
        public int writeAndFlushAscii(BufferFlusher flusher, ByteBuffer buffer, char[] chars, int start, int end) throws IOException {
            int i = start;
            while (i < end) {
                int bufferPos = buffer.position();
                int bufferRemaining = buffer.remaining();
                int sRemaining = end - i;
                int remaining = Math.min(sRemaining, bufferRemaining);
                int written = NonBatchFixedBufferOffsetAsciiEncoder.setAscii(buffer, bufferPos, chars, i, remaining);
                i += written;
                buffer.position(bufferPos + written);
                if (!buffer.hasRemaining()) {
                    flusher.flushBuffer(buffer);
                }
                if (written >= remaining) continue;
                return i;
            }
            return i;
        }

        private static int setAscii(ByteBuffer buffer, int out, char[] chars, int off, int len) {
            for (int i = 0; i < len; ++i) {
                char c = chars[off + i];
                if (c > '\u007f') {
                    return i;
                }
                buffer.put(out + i, (byte)c);
            }
            return len;
        }
    }

    public static enum BatchFixedBufferOffsetAsciiEncoder implements AsciiEncoder
    {
        Instance;


        @Override
        public int writeAndFlushAscii(BufferFlusher flusher, ByteBuffer buffer, char[] chars, int start, int end) throws IOException {
            int i = start;
            while (i < end) {
                int bufferPos = buffer.position();
                int bufferRemaining = buffer.remaining();
                int sRemaining = end - i;
                int remaining = Math.min(sRemaining, bufferRemaining);
                int written = BatchFixedBufferOffsetAsciiEncoder.setAsciiBE(buffer, bufferPos, chars, i, remaining);
                i += written;
                buffer.position(bufferPos + written);
                if (!buffer.hasRemaining()) {
                    flusher.flushBuffer(buffer);
                }
                if (written >= remaining) continue;
                return i;
            }
            return i;
        }

        private static int setAsciiBE(ByteBuffer buffer, int out, char[] chars, int off, int len) {
            int longRounds = len >>> 3;
            for (int i = 0; i < longRounds; ++i) {
                long batch1 = (long)chars[off] << 48 | (long)chars[off + 2] << 32 | (long)(chars[off + 4] << 16) | (long)chars[off + 6];
                long batch2 = (long)chars[off + 1] << 48 | (long)chars[off + 3] << 32 | (long)(chars[off + 5] << 16) | (long)chars[off + 7];
                if (((batch1 | batch2) & 0xFF80FF80FF80FF80L) != 0L) {
                    return i << 3;
                }
                long batch = batch1 << 8 | batch2;
                buffer.putLong(out, batch);
                out += 8;
                off += 8;
            }
            int byteRounds = len & 7;
            if (byteRounds > 0) {
                for (int i = 0; i < byteRounds; ++i) {
                    char c = chars[off + i];
                    if (c > '\u007f') {
                        return (longRounds << 3) + i;
                    }
                    buffer.put(out + i, (byte)c);
                }
            }
            return len;
        }
    }

    public static interface AsciiEncoder {
        public int writeAndFlushAscii(BufferFlusher var1, ByteBuffer var2, char[] var3, int var4, int var5) throws IOException;
    }

    public static interface BufferFlusher {
        public void flushBuffer(ByteBuffer var1) throws IOException;
    }
}

