/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.trtc.adapter;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.device.TXDeviceManager;
import com.tencent.liteav.trtc.TRTCCloudImpl;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.trtc.TRTCCloud;
import com.tencent.trtc.TRTCCloudDef;
import com.tencent.trtc.TRTCCloudListener;
import com.tencent.trtc.TRTCStatistics;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@JNINamespace(value="tuikit::engine::trtc")
public class TRTCMethodChannel {
    private static final String TAG = "TRTCMethodChannel";
    private static final int METHOD_ID_ENTER_ROOM = 100;
    private static final int METHOD_ID_EXIT_ROOM = 101;
    private static final int METHOD_ID_UPDATE_LOCAL_VIEW = 102;
    private static final int METHOD_ID_UPDATE_REMOTE_VIEW = 103;
    private static final int METHOD_ID_SWITCH_ROLE = 104;
    private static final int METHOD_ID_START_LOCAL_AUDIO = 105;
    private static final int METHOD_ID_STOP_LOCAL_AUDIO = 106;
    private static final int METHOD_ID_MUTE_LOCAL_VIDEO = 107;
    private static final int METHOD_ID_MUTE_LOCAL_AUDIO = 108;
    private static final int METHOD_ID_SET_VIDEO_ENCODER_PARAM = 109;
    private static final int METHOD_ID_SET_AUDIO_QUALITY = 110;
    private static final int METHOD_ID_SELECT_SCREEN_CAPTURE_TARGET = 111;
    private static final int METHOD_ID_START_SCREEN_SHARE = 114;
    private static final int METHOD_ID_STOP_SCREEN_SHARE = 115;
    private static final int METHOD_ID_START_REMOTE_VIEW = 116;
    private static final int METHOD_ID_STOP_REMOTE_VIEW = 117;
    private static final int METHOD_ID_WRITE_LOG = 118;
    private static final int METHOD_ID_ENABLE_AUDIO_VOLUME_EVALUATION = 119;
    private static final int METHOD_ID_GET_SCREEN_CAPTURE_SOURCES = 120;
    private static final int METHOD_ID_DESTROY_TRTC = 121;
    private static final int METHOD_ID_MUTE_REMOTE_AUDIO = 122;
    private static final int METHOD_ID_CALL_EXPERIMENTAL_API = 123;
    private static final int METHOD_ID_ENABLE_SMALL_VIDEO_STREAM = 124;
    private static final int METHOD_ID_START_LOCAL_PREVIEW = 127;
    private static final int METHOD_ID_STOP_LOCAL_PREVIEW = 128;
    private static final int METHOD_ID_SET_REMOTE_RENDER_PARAMS = 129;
    private static final int METHOD_ID_ADD_CALLBACK = 130;
    private static final int METHOD_ID_REMOVE_CALLBACK = 131;
    private static final int METHOD_ID_SET_SUB_STREAM_ENCODER_PARAM = 132;
    private static final int METHOD_ID_ENABLE_GRAVITY_SENSOR = 133;
    private static final int METHOD_ID_GET_SDK_VERSION = 134;
    private static final int METHOD_ID_START_SYSTEM_AUDIO_LOOPBACK = 140;
    private static final int METHOD_ID_STOP_SYSTEM_AUDIO_LOOPBACK = 141;
    private static final int METHOD_ID_SET_LOCAL_RENDER_PARAMS = 142;
    private static final int METHOD_ID_SET_DEFAULT_STREAM_RECV_MODE = 143;
    private static final int METHOD_ID_IS_FRONT_CAMERA = 200;
    private static final int METHOD_ID_SWITCH_CAMERA = 201;
    private static final int METHOD_ID_IS_AUTO_FOCUS_ENABLED = 202;
    private static final int METHOD_ID_ENABLE_CAMERA_AUTO_FOCUS = 203;
    private static final int METHOD_ID_ENABLE_CAMERA_TORCH = 204;
    private static final int METHOD_ID_SET_AUDIO_ROUTE = 205;
    private static final String METHOD_PARAMS_TRTC_PARAMS = "trtcParams";
    private static final String METHOD_PARAMS_TRTC_SCENE = "trtcScene";
    private static final String METHOD_PARAMS_ROLE = "role";
    private static final String METHOD_PARAMS_SDK_APP_ID = "sdkAppId";
    private static final String METHOD_PARAMS_USER_ID = "userId";
    private static final String METHOD_PARAMS_USER_SIG = "userSig";
    private static final String METHOD_PARAMS_ROOM_ID = "roomId";
    private static final String METHOD_PARAMS_STR_ROOM_ID = "strRoomId";
    private static final String METHOD_PARAMS_CAMERA_ID = "cameraId";
    private static final String METHOD_PARAMS_VIEW_ID = "viewId";
    private static final String METHOD_PARAMS_VIDEO_RESOLUTION = "videoResolution";
    private static final String METHOD_PARAMS_VIDEO_FPS = "videoFps";
    private static final String METHOD_PARAMS_VIDEO_BITRATE = "videoBitrate";
    private static final String METHOD_PARAMS_RES_MODE = "resMode";
    private static final String METHOD_PARAMS_QUALITY = "quality";
    private static final String METHOD_PARAMS_MUTE = "mute";
    private static final String METHOD_PARAMS_STREAM_TYPE = "streamType";
    private static final String METHOD_PARAMS_MIN_VIDEO_BITRATE = "minVideoBitrate";
    private static final String METHOD_PARAMS_ENABLE_ADJUST_RES = "enableAdjustRes";
    private static final String METHOD_PARAMS_ENC_PARAM = "encParam";
    private static final String METHOD_PARAMS_ROTATION = "rotation";
    private static final String METHOD_PARAMS_FILL_MODE = "fillMode";
    private static final String METHOD_PARAMS_MIRROR_TYPE = "mirrorType";
    private static final String METHOD_PARAMS_RENDER_PARAMS = "renderParams";
    private static final String METHOD_PARAMS_INTERVAL = "interval";
    private static final String METHOD_PARAMS_ENABLE = "enable";
    private static final String METHOD_PARAMS_WIDTH = "width";
    private static final String METHOD_PARAMS_HEIGHT = "height";
    private static final String METHOD_PARAMS_THUMB_SIZE = "thumbSize";
    private static final String METHOD_PARAMS_ICON_SIZE = "iconSize";
    private static final String METHOD_PARAMS_TARGET_ID = "targetId";
    private static final String METHOD_PARAMS_STREAM_ID = "streamId";
    private static final String METHOD_PARAMS_USER_DEFINE_RECORD_ID = "userDefineRecordId";
    private static final String METHOD_PARAMS_PRIVATE_MAP_KEY = "privateMapKey";
    private static final String METHOD_PARAMS_BUSINESS_INFO = "businessInfo";
    private static final String METHOD_PARAMS_IS_FRONT_CAMERA = "frontCamera";
    private static final String METHOD_PARAMS_ROUTE = "route";
    private static final String METHOD_PARAMS_AUTO_RECV_AUDIO = "autoRecvAudio";
    private static final String METHOD_PARAMS_AUTO_RECV_VIDEO = "autoRecvVideo";
    private static final int CAMERA_ID_FRONT = 1;
    private static final int CAMERA_ID_BACK = 0;
    private long mNativeTRTCMethodChannelAndroid;
    private final Map<String, TXCloudVideoView> mViewMap = new HashMap<String, TXCloudVideoView>();
    private TRTCCloud mTRTCCloud;
    private boolean mIsMainTRTC;
    private int mCurrentCameraId = 1;
    private final TRTCCloudListener mTrtcCloudListener = new TRTCCloudListener(){

        public void onError(int errCode, String errMsg, Bundle extraInfo) {
            if (TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid == 0L) {
                return;
            }
            TRTCMethodChannel.nativeOnError(TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid, errCode, errMsg);
        }

        public void onWarning(int warningCode, String warningMsg, Bundle extraInfo) {
            if (TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid == 0L) {
                return;
            }
            TRTCMethodChannel.nativeOnWarning(TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid, warningCode, warningMsg);
        }

        public void onEnterRoom(long result) {
            if (TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid == 0L) {
                return;
            }
            TRTCMethodChannel.nativeOnEnterRoom(TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid, result);
        }

        public void onExitRoom(int reason) {
            if (TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid == 0L) {
                return;
            }
            TRTCMethodChannel.nativeOnExitRoom(TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid, reason);
        }

        public void onSwitchRole(int errCode, String errMsg) {
            if (TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid == 0L) {
                return;
            }
            TRTCMethodChannel.nativeOnSwitchRole(TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid, errCode, errMsg);
        }

        public void onRemoteUserEnterRoom(String userId) {
            if (TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid == 0L) {
                return;
            }
            TRTCMethodChannel.nativeOnRemoteUserEnterRoom(TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid, userId);
        }

        public void onRemoteUserLeaveRoom(String userId, int reason) {
            if (TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid == 0L) {
                return;
            }
            TRTCMethodChannel.nativeOnRemoteUserLeaveRoom(TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid, userId, reason);
        }

        public void onUserVideoAvailable(String userId, boolean available) {
            if (TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid == 0L) {
                return;
            }
            TRTCMethodChannel.nativeOnUserVideoAvailable(TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid, userId, available);
        }

        public void onUserSubStreamAvailable(String userId, boolean available) {
            if (TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid == 0L) {
                return;
            }
            TRTCMethodChannel.nativeOnUserSubStreamAvailable(TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid, userId, available);
        }

        public void onUserAudioAvailable(String userId, boolean available) {
            if (TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid == 0L) {
                return;
            }
            TRTCMethodChannel.nativeOnUserAudioAvailable(TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid, userId, available);
        }

        public void onFirstVideoFrame(String userId, int streamType, int width, int height) {
            if (TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid == 0L) {
                return;
            }
            TRTCMethodChannel.nativeOnFirstVideoFrame(TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid, userId, streamType, width, height);
        }

        public void onSendFirstLocalVideoFrame(int streamType) {
            if (TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid == 0L) {
                return;
            }
            TRTCMethodChannel.nativeOnSendFirstLocalVideoFrame(TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid, streamType);
        }

        public void onSendFirstLocalAudioFrame() {
            if (TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid == 0L) {
                return;
            }
            TRTCMethodChannel.nativeOnSendFirstLocalAudioFrame(TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid);
        }

        public void onNetworkQuality(TRTCCloudDef.TRTCQuality localQuality, ArrayList<TRTCCloudDef.TRTCQuality> remoteQuality) {
            if (TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid == 0L) {
                return;
            }
            TRTCMethodChannel.nativeOnNetworkQuality(TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid, localQuality.quality, remoteQuality);
        }

        public void onStatistics(TRTCStatistics statistics) {
            if (TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid == 0L) {
                return;
            }
            String json = TRTCMethodChannel.convertStatisticsToJson(statistics);
            TRTCMethodChannel.nativeOnStatistics(TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid, json);
        }

        public void onCameraDidReady() {
            if (TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid == 0L) {
                return;
            }
            TRTCMethodChannel.nativeOnCameraDidReady(TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid);
        }

        public void onMicDidReady() {
            if (TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid == 0L) {
                return;
            }
            TRTCMethodChannel.nativeOnMicDidReady(TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid);
        }

        public void onUserVoiceVolume(ArrayList<TRTCCloudDef.TRTCVolumeInfo> userVolumes, int totalVolume) {
            if (TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid == 0L) {
                return;
            }
            TRTCMethodChannel.nativeOnUserVoiceVolume(TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid, userVolumes, totalVolume);
        }

        public void onScreenCapturePaused() {
            if (TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid == 0L) {
                return;
            }
            TRTCMethodChannel.nativeOnScreenCapturePaused(TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid, 0);
        }

        public void onScreenCaptureResumed() {
            if (TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid == 0L) {
                return;
            }
            TRTCMethodChannel.nativeOnScreenCaptureResumed(TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid, 0);
        }

        public void onScreenCaptureStopped(int reason) {
            if (TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid == 0L) {
                return;
            }
            TRTCMethodChannel.nativeOnScreenCaptureStopped(TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid, reason);
        }

        public void onRecvSEIMsg(String userId, byte[] data) {
            if (TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid == 0L) {
                return;
            }
            TRTCMethodChannel.nativeOnRecvSEIMsg(TRTCMethodChannel.this.mNativeTRTCMethodChannelAndroid, userId, data);
        }
    };

    @CalledByNative
    public TRTCMethodChannel(long nativeTRTCMethodChannelAndroid, boolean isMainTRTC) {
        this.mNativeTRTCMethodChannelAndroid = nativeTRTCMethodChannelAndroid;
        this.mIsMainTRTC = isMainTRTC;
    }

    @CalledByNative
    private TRTCCloud getTRTCCloud() {
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            ContextUtils.initContextFromNative((String)"liteav");
            context = ContextUtils.getApplicationContext();
        }
        if (this.mIsMainTRTC) {
            return TRTCCloud.sharedInstance((Context)context);
        }
        if (this.mTRTCCloud == null) {
            this.mTRTCCloud = TRTCCloudImpl.createInstance((Context)context);
        }
        return this.mTRTCCloud;
    }

    @CalledByNative
    public void destroyInstance() {
        this.mViewMap.clear();
        this.mNativeTRTCMethodChannelAndroid = 0L;
        if (this.mTRTCCloud != null && !this.mIsMainTRTC) {
            TRTCCloudImpl.destroyInstance((TRTCCloud)this.mTRTCCloud);
        }
    }

    @CalledByNative
    public static void callStaticExperimentalAPI(String paramJson) {
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            ContextUtils.initContextFromNative((String)"liteav");
            context = ContextUtils.getApplicationContext();
        }
        TRTCCloud.sharedInstance((Context)context).callExperimentalAPI(paramJson);
    }

    @CalledByNative
    public static String getSdkVersion() {
        return TRTCCloud.getSDKVersion();
    }

    @CalledByNative
    public String invokeMethod(int methodId, String paramJson) {
        switch (methodId) {
            case 123: {
                return this.callExperimentalAPI(paramJson);
            }
            case 100: {
                this.enterRoom(paramJson);
                break;
            }
            case 101: {
                this.exitRoom();
                break;
            }
            case 104: {
                this.switchRole(paramJson);
                break;
            }
            case 102: {
                this.updateLocalView(paramJson);
                break;
            }
            case 103: {
                this.updateRemoteView(paramJson);
                break;
            }
            case 127: {
                this.startLocalPreview(paramJson);
                break;
            }
            case 128: {
                this.stopLocalPreview();
                break;
            }
            case 119: {
                this.enableAudioVolumeEvaluation(paramJson);
                break;
            }
            case 105: {
                this.startLocalAudio(paramJson);
                break;
            }
            case 106: {
                this.stopLocalAudio();
                break;
            }
            case 108: {
                this.muteLocalAudio(paramJson);
                break;
            }
            case 107: {
                this.muteLocalVideo(paramJson);
                break;
            }
            case 122: {
                this.muteRemoteAudio(paramJson);
                break;
            }
            case 114: {
                this.startScreenShare();
                break;
            }
            case 115: {
                this.stopScreenShare();
                break;
            }
            case 142: {
                this.setLocalRenderParams(paramJson);
                break;
            }
            case 129: {
                this.setRemoteRenderParams(paramJson);
                break;
            }
            case 116: {
                this.startRemoteView(paramJson);
                break;
            }
            case 117: {
                this.stopRemoteView(paramJson);
                break;
            }
            case 124: {
                this.enableSmallVideoStream(paramJson);
                break;
            }
            case 130: {
                this.addCallback();
                break;
            }
            case 131: {
                this.removeCallback();
                break;
            }
            case 109: {
                this.setVideoEncoderParam(paramJson);
                break;
            }
            case 132: {
                this.setSubStreamEncoderParam(paramJson);
                break;
            }
            case 133: {
                this.enableGravitySensor(paramJson);
                break;
            }
            case 201: {
                this.switchCamera(paramJson);
                break;
            }
            case 203: {
                this.enableCameraAutoFocus(paramJson);
                break;
            }
            case 204: {
                this.enableCameraTorch(paramJson);
                break;
            }
            case 205: {
                this.setAudioRoute(paramJson);
                break;
            }
            case 140: {
                this.startSystemAudioLoopback();
                break;
            }
            case 141: {
                this.stopSystemAudioLoopback();
                break;
            }
            case 143: {
                this.setDefaultStreamRecvMode(paramJson);
                break;
            }
        }
        return "";
    }

    @CalledByNative
    public boolean invokeMethodWithBoolReturn(int methodId) {
        switch (methodId) {
            case 200: {
                return this.isFrontCamera();
            }
            case 202: {
                return this.isAutoFocusEnabled();
            }
        }
        return false;
    }

    @CalledByNative
    public int invokeGetCameraId() {
        return this.mCurrentCameraId;
    }

    @CalledByNative
    public void addViewForKey(String key, TXCloudVideoView view) {
        this.mViewMap.put(key, view);
    }

    @CalledByNative
    public void removeViewForKey(String key) {
        this.mViewMap.remove(key);
    }

    @CalledByNative
    public void clearAllViewForKey() {
        this.mViewMap.clear();
    }

    private String callExperimentalAPI(String paramJson) {
        return this.getTRTCCloud().callExperimentalAPI(paramJson);
    }

    private void enterRoom(String paramJson) {
        try {
            JSONObject jsonObject = new JSONObject(paramJson);
            int scene = jsonObject.getInt(METHOD_PARAMS_TRTC_SCENE);
            JSONObject paramsObject = jsonObject.getJSONObject(METHOD_PARAMS_TRTC_PARAMS);
            TRTCCloudDef.TRTCParams params = new TRTCCloudDef.TRTCParams();
            params.sdkAppId = paramsObject.getInt(METHOD_PARAMS_SDK_APP_ID);
            params.userId = paramsObject.getString(METHOD_PARAMS_USER_ID);
            params.userSig = paramsObject.getString(METHOD_PARAMS_USER_SIG);
            params.strRoomId = paramsObject.getString(METHOD_PARAMS_STR_ROOM_ID);
            params.role = paramsObject.getInt(METHOD_PARAMS_ROLE);
            if (paramsObject.has(METHOD_PARAMS_ROOM_ID)) {
                params.roomId = paramsObject.getInt(METHOD_PARAMS_ROOM_ID);
            }
            if (paramsObject.has(METHOD_PARAMS_STREAM_ID)) {
                params.streamId = paramsObject.getString(METHOD_PARAMS_STREAM_ID);
            }
            if (paramsObject.has(METHOD_PARAMS_USER_DEFINE_RECORD_ID)) {
                params.userDefineRecordId = paramsObject.getString(METHOD_PARAMS_USER_DEFINE_RECORD_ID);
            }
            if (paramsObject.has(METHOD_PARAMS_PRIVATE_MAP_KEY)) {
                params.privateMapKey = paramsObject.getString(METHOD_PARAMS_PRIVATE_MAP_KEY);
            }
            if (paramsObject.has(METHOD_PARAMS_BUSINESS_INFO)) {
                params.businessInfo = paramsObject.getString(METHOD_PARAMS_BUSINESS_INFO);
            }
            this.getTRTCCloud().enterRoom(params, scene);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    private void exitRoom() {
        this.getTRTCCloud().exitRoom();
    }

    private void switchRole(String paramJson) {
        try {
            JSONObject jsonObject = new JSONObject(paramJson);
            int role = jsonObject.getInt(METHOD_PARAMS_ROLE);
            this.getTRTCCloud().switchRole(role);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    private void updateLocalView(String paramJson) {
        try {
            JSONObject jsonObject = new JSONObject(paramJson);
            String viewId = jsonObject.getString(METHOD_PARAMS_VIEW_ID);
            TXCloudVideoView view = this.mViewMap.get(viewId);
            this.getTRTCCloud().updateLocalView(view);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    private void updateRemoteView(String paramJson) {
        try {
            JSONObject jsonObject = new JSONObject(paramJson);
            String viewId = jsonObject.getString(METHOD_PARAMS_VIEW_ID);
            String userId = jsonObject.getString(METHOD_PARAMS_USER_ID);
            int streamType = jsonObject.getInt(METHOD_PARAMS_STREAM_TYPE);
            TXCloudVideoView view = this.mViewMap.get(viewId);
            this.getTRTCCloud().updateRemoteView(userId, streamType, view);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    private void startLocalPreview(String paramJson) {
        try {
            int cameraId;
            JSONObject jsonObject = new JSONObject(paramJson);
            this.mCurrentCameraId = cameraId = jsonObject.getInt(METHOD_PARAMS_CAMERA_ID);
            String viewId = jsonObject.getString(METHOD_PARAMS_VIEW_ID);
            TXCloudVideoView view = this.mViewMap.get(viewId);
            this.getTRTCCloud().startLocalPreview(cameraId == 1, view);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    private void stopLocalPreview() {
        this.getTRTCCloud().stopLocalPreview();
    }

    private void enableAudioVolumeEvaluation(String paramJson) {
        try {
            JSONObject jsonObject = new JSONObject(paramJson);
            int interval = jsonObject.getInt(METHOD_PARAMS_INTERVAL);
            this.getTRTCCloud().enableAudioVolumeEvaluation(interval, interval > 0);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    private void startLocalAudio(String paramJson) {
        try {
            JSONObject jsonObject = new JSONObject(paramJson);
            int quality = jsonObject.getInt(METHOD_PARAMS_QUALITY);
            this.getTRTCCloud().startLocalAudio(quality);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    private void stopLocalAudio() {
        this.getTRTCCloud().stopLocalAudio();
    }

    private void muteLocalAudio(String paramJson) {
        try {
            JSONObject jsonObject = new JSONObject(paramJson);
            boolean mute = jsonObject.getBoolean(METHOD_PARAMS_MUTE);
            this.getTRTCCloud().muteLocalAudio(mute);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    private void muteLocalVideo(String paramJson) {
        try {
            JSONObject jsonObject = new JSONObject(paramJson);
            int streamType = jsonObject.getInt(METHOD_PARAMS_STREAM_TYPE);
            boolean mute = jsonObject.getBoolean(METHOD_PARAMS_MUTE);
            this.getTRTCCloud().muteLocalVideo(streamType, mute);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    private void muteRemoteAudio(String paramJson) {
        try {
            JSONObject jsonObject = new JSONObject(paramJson);
            String userId = jsonObject.getString(METHOD_PARAMS_USER_ID);
            boolean mute = jsonObject.getBoolean(METHOD_PARAMS_MUTE);
            this.getTRTCCloud().muteRemoteAudio(userId, mute);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    private void startScreenShare() {
        TRTCCloudDef.TRTCVideoEncParam videoEncParam = new TRTCCloudDef.TRTCVideoEncParam();
        videoEncParam.videoResolution = 112;
        videoEncParam.videoResolutionMode = 1;
        videoEncParam.videoFps = 10;
        videoEncParam.enableAdjustRes = true;
        videoEncParam.videoBitrate = 1500;
        TRTCCloudDef.TRTCScreenShareParams shareParams = new TRTCCloudDef.TRTCScreenShareParams();
        this.getTRTCCloud().startScreenCapture(2, videoEncParam, shareParams);
    }

    private void stopScreenShare() {
        this.getTRTCCloud().stopScreenCapture();
    }

    private void setLocalRenderParams(String paramJson) {
        try {
            JSONObject jsonObject = new JSONObject(paramJson);
            JSONObject paramObject = jsonObject.getJSONObject(METHOD_PARAMS_RENDER_PARAMS);
            TRTCCloudDef.TRTCRenderParams params = new TRTCCloudDef.TRTCRenderParams();
            params.rotation = paramObject.getInt(METHOD_PARAMS_ROTATION);
            params.fillMode = paramObject.getInt(METHOD_PARAMS_FILL_MODE);
            params.mirrorType = paramObject.getInt(METHOD_PARAMS_MIRROR_TYPE);
            this.getTRTCCloud().setLocalRenderParams(params);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    private void setRemoteRenderParams(String paramJson) {
        try {
            JSONObject jsonObject = new JSONObject(paramJson);
            int streamType = jsonObject.getInt(METHOD_PARAMS_STREAM_TYPE);
            String userId = jsonObject.getString(METHOD_PARAMS_USER_ID);
            JSONObject paramObject = jsonObject.getJSONObject(METHOD_PARAMS_RENDER_PARAMS);
            TRTCCloudDef.TRTCRenderParams params = new TRTCCloudDef.TRTCRenderParams();
            params.rotation = paramObject.getInt(METHOD_PARAMS_ROTATION);
            params.fillMode = paramObject.getInt(METHOD_PARAMS_FILL_MODE);
            params.mirrorType = paramObject.getInt(METHOD_PARAMS_MIRROR_TYPE);
            this.getTRTCCloud().setRemoteRenderParams(userId, streamType, params);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    private void startRemoteView(String paramJson) {
        try {
            JSONObject jsonObject = new JSONObject(paramJson);
            String viewId = jsonObject.getString(METHOD_PARAMS_VIEW_ID);
            String userId = jsonObject.getString(METHOD_PARAMS_USER_ID);
            int streamType = jsonObject.getInt(METHOD_PARAMS_STREAM_TYPE);
            TXCloudVideoView view = this.mViewMap.get(viewId);
            this.getTRTCCloud().startRemoteView(userId, streamType, view);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    private void stopRemoteView(String paramJson) {
        try {
            JSONObject jsonObject = new JSONObject(paramJson);
            String userId = jsonObject.getString(METHOD_PARAMS_USER_ID);
            int streamType = jsonObject.getInt(METHOD_PARAMS_STREAM_TYPE);
            this.getTRTCCloud().stopRemoteView(userId, streamType);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    private void enableSmallVideoStream(String paramJson) {
        try {
            JSONObject jsonObject = new JSONObject(paramJson);
            boolean enable = jsonObject.getBoolean(METHOD_PARAMS_ENABLE);
            JSONObject paramObject = jsonObject.getJSONObject(METHOD_PARAMS_ENC_PARAM);
            TRTCCloudDef.TRTCVideoEncParam encParam = new TRTCCloudDef.TRTCVideoEncParam();
            encParam.videoResolution = paramObject.getInt(METHOD_PARAMS_VIDEO_RESOLUTION);
            encParam.videoFps = paramObject.getInt(METHOD_PARAMS_VIDEO_FPS);
            encParam.videoBitrate = paramObject.getInt(METHOD_PARAMS_VIDEO_BITRATE);
            if (paramObject.has(METHOD_PARAMS_RES_MODE)) {
                encParam.videoResolutionMode = paramObject.getInt(METHOD_PARAMS_RES_MODE);
            }
            if (paramObject.has(METHOD_PARAMS_MIN_VIDEO_BITRATE)) {
                encParam.minVideoBitrate = paramObject.getInt(METHOD_PARAMS_MIN_VIDEO_BITRATE);
            }
            if (paramObject.has(METHOD_PARAMS_ENABLE_ADJUST_RES)) {
                encParam.enableAdjustRes = paramObject.getBoolean(METHOD_PARAMS_ENABLE_ADJUST_RES);
            }
            this.getTRTCCloud().enableEncSmallVideoStream(enable, encParam);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    private void setSubStreamEncoderParam(String paramJson) {
        TRTCCloudDef.TRTCVideoEncParam encParam = this.convertJsonToVideoEncParams(paramJson);
        if (encParam == null) {
            return;
        }
        this.getTRTCCloud().setSubStreamEncoderParam(encParam);
    }

    private void setVideoEncoderParam(String paramJson) {
        TRTCCloudDef.TRTCVideoEncParam encParam = this.convertJsonToVideoEncParams(paramJson);
        if (encParam == null) {
            return;
        }
        this.getTRTCCloud().setVideoEncoderParam(encParam);
    }

    private TRTCCloudDef.TRTCVideoEncParam convertJsonToVideoEncParams(String paramJson) {
        try {
            JSONObject jsonObject = new JSONObject(paramJson);
            TRTCCloudDef.TRTCVideoEncParam encParam = new TRTCCloudDef.TRTCVideoEncParam();
            encParam.videoResolution = jsonObject.getInt(METHOD_PARAMS_VIDEO_RESOLUTION);
            encParam.videoFps = jsonObject.getInt(METHOD_PARAMS_VIDEO_FPS);
            encParam.videoBitrate = jsonObject.getInt(METHOD_PARAMS_VIDEO_BITRATE);
            if (jsonObject.has(METHOD_PARAMS_RES_MODE)) {
                encParam.videoResolutionMode = jsonObject.getInt(METHOD_PARAMS_RES_MODE);
            }
            if (jsonObject.has(METHOD_PARAMS_MIN_VIDEO_BITRATE)) {
                encParam.minVideoBitrate = jsonObject.getInt(METHOD_PARAMS_MIN_VIDEO_BITRATE);
            }
            if (jsonObject.has(METHOD_PARAMS_ENABLE_ADJUST_RES)) {
                encParam.enableAdjustRes = jsonObject.getBoolean(METHOD_PARAMS_ENABLE_ADJUST_RES);
            }
            return encParam;
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
            return null;
        }
    }

    private void enableGravitySensor(String paramJson) {
        try {
            JSONObject jsonObject = new JSONObject(paramJson);
            boolean enable = jsonObject.getBoolean(METHOD_PARAMS_ENABLE);
            int sensorMode = enable ? 1 : 0;
            this.getTRTCCloud().setGSensorMode(sensorMode);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    private int switchCamera(String paramJson) {
        try {
            JSONObject jsonObject = new JSONObject(paramJson);
            boolean isFrontCamera = jsonObject.getBoolean(METHOD_PARAMS_IS_FRONT_CAMERA);
            this.mCurrentCameraId = isFrontCamera ? 1 : 0;
            return this.getTRTCCloud().getDeviceManager().switchCamera(isFrontCamera);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage());
            return -1;
        }
    }

    private boolean isFrontCamera() {
        return this.getTRTCCloud().getDeviceManager().isFrontCamera();
    }

    private boolean isAutoFocusEnabled() {
        return this.getTRTCCloud().getDeviceManager().isAutoFocusEnabled();
    }

    private int enableCameraAutoFocus(String paramJson) {
        try {
            JSONObject jsonObject = new JSONObject(paramJson);
            boolean enable = jsonObject.getBoolean(METHOD_PARAMS_ENABLE);
            return this.getTRTCCloud().getDeviceManager().enableCameraAutoFocus(enable);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage());
            return -1;
        }
    }

    private int enableCameraTorch(String paramJson) {
        try {
            JSONObject jsonObject = new JSONObject(paramJson);
            boolean enable = jsonObject.getBoolean(METHOD_PARAMS_ENABLE);
            if (this.getTRTCCloud().getDeviceManager().enableCameraTorch(enable)) {
                return 0;
            }
            return -1;
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage());
            return -1;
        }
    }

    private int setAudioRoute(String paramJson) {
        try {
            JSONObject jsonObject = new JSONObject(paramJson);
            int routeValue = jsonObject.getInt(METHOD_PARAMS_ROUTE);
            TXDeviceManager.TXAudioRoute route = TXDeviceManager.TXAudioRoute.TXAudioRouteSpeakerphone;
            if (routeValue == 1) {
                route = TXDeviceManager.TXAudioRoute.TXAudioRouteEarpiece;
            }
            this.getTRTCCloud().getDeviceManager().setAudioRoute(route);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage());
        }
        return -1;
    }

    private void startSystemAudioLoopback() {
        this.getTRTCCloud().startSystemAudioLoopback();
    }

    private void stopSystemAudioLoopback() {
        this.getTRTCCloud().stopSystemAudioLoopback();
    }

    private void setDefaultStreamRecvMode(String paramJson) {
        try {
            JSONObject jsonObject = new JSONObject(paramJson);
            boolean autoRecvAudio = jsonObject.getBoolean(METHOD_PARAMS_AUTO_RECV_AUDIO);
            boolean autoRecvVideo = jsonObject.getBoolean(METHOD_PARAMS_AUTO_RECV_VIDEO);
            this.getTRTCCloud().setDefaultStreamRecvMode(autoRecvAudio, autoRecvVideo);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    private void addCallback() {
        try {
            Class<?> clz = Class.forName("com.tencent.trtc.TRTCCloud");
            Method method = clz.getDeclaredMethod("addListener", TRTCCloudListener.class);
            method.invoke((Object)this.getTRTCCloud(), this.mTrtcCloudListener);
        }
        catch (NoSuchMethodException e) {
            this.getTRTCCloud().setListener(this.mTrtcCloudListener);
        }
        catch (Exception e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    private void removeCallback() {
        this.getTRTCCloud().setListener(null);
    }

    private static native void nativeOnError(long var0, int var2, String var3);

    private static native void nativeOnWarning(long var0, int var2, String var3);

    private static native void nativeOnEnterRoom(long var0, long var2);

    private static native void nativeOnExitRoom(long var0, int var2);

    private static native void nativeOnSwitchRole(long var0, int var2, String var3);

    private static native void nativeOnRemoteUserEnterRoom(long var0, String var2);

    private static native void nativeOnRemoteUserLeaveRoom(long var0, String var2, int var3);

    private static native void nativeOnUserVideoAvailable(long var0, String var2, boolean var3);

    private static native void nativeOnUserSubStreamAvailable(long var0, String var2, boolean var3);

    private static native void nativeOnUserAudioAvailable(long var0, String var2, boolean var3);

    private static native void nativeOnFirstVideoFrame(long var0, String var2, int var3, int var4, int var5);

    private static native void nativeOnSendFirstLocalVideoFrame(long var0, int var2);

    private static native void nativeOnSendFirstLocalAudioFrame(long var0);

    private static native void nativeOnNetworkQuality(long var0, int var2, ArrayList<TRTCCloudDef.TRTCQuality> var3);

    private static native void nativeOnStatistics(long var0, String var2);

    private static native void nativeOnCameraDidReady(long var0);

    private static native void nativeOnMicDidReady(long var0);

    private static native void nativeOnUserVoiceVolume(long var0, ArrayList<TRTCCloudDef.TRTCVolumeInfo> var2, int var3);

    private static native void nativeOnScreenCapturePaused(long var0, int var2);

    private static native void nativeOnScreenCaptureResumed(long var0, int var2);

    private static native void nativeOnScreenCaptureStopped(long var0, int var2);

    private static native void nativeOnRecvSEIMsg(long var0, String var2, byte[] var3);

    @CalledByNative
    public static int[] getQualityArray(List<TRTCCloudDef.TRTCQuality> qualityList) {
        int[] qualityArray = new int[qualityList.size()];
        for (int i = 0; i < qualityList.size(); ++i) {
            qualityArray[i] = qualityList.get((int)i).quality;
        }
        return qualityArray;
    }

    @CalledByNative
    public static String[] getUserIdArray(List<TRTCCloudDef.TRTCQuality> qualityList) {
        String[] userIdArray = new String[qualityList.size()];
        for (int i = 0; i < qualityList.size(); ++i) {
            userIdArray[i] = qualityList.get((int)i).userId;
        }
        return userIdArray;
    }

    @CalledByNative
    public static String[] getVolumeInfoUserIdArray(List<TRTCCloudDef.TRTCVolumeInfo> volumeInfoList) {
        String[] userIdArray = new String[volumeInfoList.size()];
        for (int i = 0; i < volumeInfoList.size(); ++i) {
            userIdArray[i] = volumeInfoList.get((int)i).userId;
        }
        return userIdArray;
    }

    @CalledByNative
    public static int[] getVolumeInfoVolumeArray(List<TRTCCloudDef.TRTCVolumeInfo> volumeInfoList) {
        int[] volumeArray = new int[volumeInfoList.size()];
        for (int i = 0; i < volumeInfoList.size(); ++i) {
            volumeArray[i] = volumeInfoList.get((int)i).volume;
        }
        return volumeArray;
    }

    @CalledByNative
    public static int[] getVolumeInfoVadArray(List<TRTCCloudDef.TRTCVolumeInfo> volumeInfoList) {
        int[] vadArray = new int[volumeInfoList.size()];
        for (int i = 0; i < volumeInfoList.size(); ++i) {
            vadArray[i] = volumeInfoList.get((int)i).vad;
        }
        return vadArray;
    }

    @CalledByNative
    public static float[] getVolumeInfoSpectrumDataArray(List<TRTCCloudDef.TRTCVolumeInfo> volumeInfoList, int index) {
        if (index < 0 || index > volumeInfoList.size()) {
            return null;
        }
        return volumeInfoList.get((int)index).spectrumData;
    }

    private static String convertStatisticsToJson(TRTCStatistics statistics) {
        try {
            JSONObject json = new JSONObject();
            json.put("appCpu", statistics.appCpu);
            json.put("systemCpu", statistics.systemCpu);
            json.put("upLoss", statistics.upLoss);
            json.put("downLoss", statistics.downLoss);
            json.put("rtt", statistics.rtt);
            json.put("gatewayRtt", statistics.gatewayRtt);
            json.put("sendBytes", statistics.sendBytes);
            json.put("receiveBytes", statistics.receiveBytes);
            JSONArray localArrayJson = new JSONArray();
            for (TRTCStatistics.TRTCLocalStatistics localStatistics : statistics.localArray) {
                JSONObject localStatisticsJson = new JSONObject();
                localStatisticsJson.put(METHOD_PARAMS_WIDTH, localStatistics.width);
                localStatisticsJson.put(METHOD_PARAMS_HEIGHT, localStatistics.height);
                localStatisticsJson.put("frameRate", localStatistics.frameRate);
                localStatisticsJson.put(METHOD_PARAMS_VIDEO_BITRATE, localStatistics.videoBitrate);
                localStatisticsJson.put("audioSampleRate", localStatistics.audioSampleRate);
                localStatisticsJson.put("audioBitrate", localStatistics.audioBitrate);
                localStatisticsJson.put(METHOD_PARAMS_STREAM_TYPE, localStatistics.streamType);
                localStatisticsJson.put("audioCaptureState", localStatistics.audioCaptureState);
                localArrayJson.put((Object)localStatisticsJson);
            }
            json.put("localArray", (Object)localArrayJson);
            JSONArray remoteArrayJson = new JSONArray();
            for (TRTCStatistics.TRTCRemoteStatistics remoteStatistics : statistics.remoteArray) {
                JSONObject remoteStatisticsJson = new JSONObject();
                remoteStatisticsJson.put(METHOD_PARAMS_USER_ID, (Object)remoteStatistics.userId);
                remoteStatisticsJson.put("audioPacketLoss", remoteStatistics.audioPacketLoss);
                remoteStatisticsJson.put("videoPacketLoss", remoteStatistics.videoPacketLoss);
                remoteStatisticsJson.put(METHOD_PARAMS_WIDTH, remoteStatistics.width);
                remoteStatisticsJson.put(METHOD_PARAMS_HEIGHT, remoteStatistics.height);
                remoteStatisticsJson.put("frameRate", remoteStatistics.frameRate);
                remoteStatisticsJson.put(METHOD_PARAMS_VIDEO_BITRATE, remoteStatistics.videoBitrate);
                remoteStatisticsJson.put("audioSampleRate", remoteStatistics.audioSampleRate);
                remoteStatisticsJson.put("audioBitrate", remoteStatistics.audioBitrate);
                remoteStatisticsJson.put("jitterBufferDelay", remoteStatistics.jitterBufferDelay);
                remoteStatisticsJson.put("point2PointDelay", remoteStatistics.point2PointDelay);
                remoteStatisticsJson.put("audioTotalBlockTime", remoteStatistics.audioTotalBlockTime);
                remoteStatisticsJson.put("audioBlockRate", remoteStatistics.audioBlockRate);
                remoteStatisticsJson.put("videoTotalBlockTime", remoteStatistics.videoTotalBlockTime);
                remoteStatisticsJson.put("videoBlockRate", remoteStatistics.videoBlockRate);
                remoteStatisticsJson.put("finalLoss", remoteStatistics.finalLoss);
                remoteStatisticsJson.put("remoteNetworkUplinkLoss", remoteStatistics.remoteNetworkUplinkLoss);
                remoteStatisticsJson.put("remoteNetworkRTT", remoteStatistics.remoteNetworkRTT);
                remoteStatisticsJson.put(METHOD_PARAMS_STREAM_TYPE, remoteStatistics.streamType);
                remoteArrayJson.put((Object)remoteStatisticsJson);
            }
            json.put("remoteArray", (Object)remoteArrayJson);
            return json.toString();
        }
        catch (JSONException e) {
            return "";
        }
    }
}

