/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.impl.utils;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.liteav.base.util.LiteavLog;
import java.io.File;
import java.lang.reflect.Method;

public class PathUtils {
    private static final String TAG = "PathUtils";

    public static String getSDKInitPath(Context context) {
        if (null == context) {
            return "";
        }
        String initPath = context.getFilesDir().toString();
        String mainProcessName = context.getPackageName();
        String currentProcessName = PathUtils.getCurrentProcessName();
        if (!TextUtils.isEmpty((CharSequence)currentProcessName) && !mainProcessName.equals(currentProcessName)) {
            try {
                String pathSuffix = currentProcessName;
                int index = currentProcessName.lastIndexOf(":");
                if (index < 0) {
                    index = currentProcessName.lastIndexOf(".");
                }
                if (index >= 0) {
                    pathSuffix = currentProcessName.substring(index + 1);
                }
                initPath = initPath + File.separator + pathSuffix + File.separator;
            }
            catch (Exception e) {
                LiteavLog.e((String)TAG, (String)("getSDKInitPath exception = " + e));
            }
        }
        Log.d((String)TAG, (String)("SDK Init Path: " + initPath));
        return initPath;
    }

    public static String getSDKLogPath(Context context) {
        if (null == context) {
            return "";
        }
        String logPath = "";
        File filesDir = context.getExternalFilesDir(null);
        logPath = filesDir == null ? "/sdcard/Android/data/" + context.getPackageName() + "/log/tencent/imsdk" : filesDir.getAbsolutePath() + File.separator + "log" + File.separator + "tencent" + File.separator + "imsdk";
        File file = new File(logPath);
        if (!file.exists() && !file.mkdirs()) {
            file = context.getFilesDir();
            LiteavLog.e((String)TAG, (String)"create log folder failed");
        }
        logPath = file.getAbsolutePath() + File.separator;
        String mainProcessName = context.getPackageName();
        String currentProcessName = PathUtils.getCurrentProcessName();
        if (!TextUtils.isEmpty((CharSequence)currentProcessName) && !mainProcessName.equals(currentProcessName)) {
            try {
                String pathSuffix = currentProcessName;
                int index = currentProcessName.lastIndexOf(":");
                if (index < 0) {
                    index = currentProcessName.lastIndexOf(".");
                }
                if (index >= 0) {
                    pathSuffix = currentProcessName.substring(index + 1);
                }
                logPath = logPath + pathSuffix + File.separator;
            }
            catch (Exception e) {
                LiteavLog.e((String)TAG, (String)("getSDKLogPath exception = " + e));
            }
        }
        Log.d((String)TAG, (String)("SDK LOG Path: " + logPath));
        return logPath;
    }

    public static String getCurrentProcessName() {
        String currentProcessName = "";
        if (Build.VERSION.SDK_INT >= 28) {
            currentProcessName = Application.getProcessName();
            return currentProcessName;
        }
        try {
            Method declaredMethod = Class.forName("android.app.ActivityThread", false, Application.class.getClassLoader()).getDeclaredMethod("currentProcessName", new Class[0]);
            declaredMethod.setAccessible(true);
            Object invoke = declaredMethod.invoke(null, new Object[0]);
            if (invoke instanceof String) {
                currentProcessName = (String)invoke;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return currentProcessName;
    }
}

