/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.impl.pipelinebridge;

import com.tencent.cloud.tuikit.engine.common.TUICommonDefine;
import com.tencent.cloud.tuikit.engine.impl.pipelinebridge.TUIPipelineBridgeDefine;
import com.tencent.cloud.tuikit.engine.impl.pipelinebridge.TUIPipelineBridgeObserver;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@JNINamespace(value="tuikit::engine")
public class TUIPipelineBridge {
    private static final String TAG = "TUIPipelineBridge";
    private long mNativePipelineBridge;
    private final List<TUIPipelineBridgeObserver> mObserverList = new CopyOnWriteArrayList<TUIPipelineBridgeObserver>();

    public TUIPipelineBridge(TUIPipelineBridgeDefine.PipelineType pipelineType, boolean createdBySharedInstance) {
        this.mNativePipelineBridge = TUIPipelineBridge.nativeCreatePipelineBridge(this, pipelineType.getValue(), createdBySharedInstance);
    }

    public void destroy() {
        if (this.mNativePipelineBridge != 0L) {
            TUIPipelineBridge.nativeDestroyPipelineBridge(this.mNativePipelineBridge);
            this.mNativePipelineBridge = 0L;
        }
    }

    public void addObserver(TUIPipelineBridgeObserver observer) {
        if (observer != null && !this.mObserverList.contains(observer)) {
            this.mObserverList.add(observer);
        }
    }

    public void removeObserver(TUIPipelineBridgeObserver observer) {
        if (observer != null && this.mObserverList.contains(observer)) {
            this.mObserverList.remove(observer);
        }
    }

    public void callAPI(String apiName, String jsonParam, TUIPipelineBridgeDefine.APICallRespondCallback callback) {
        if (!this.checkPipelineBridge(callback)) {
            return;
        }
        TUIPipelineBridge.nativeCallAPI(this.mNativePipelineBridge, apiName, jsonParam, new APICallRespondCallback(callback));
    }

    public long getNativePipelineBridge() {
        return this.mNativePipelineBridge;
    }

    private boolean checkPipelineBridge() {
        return this.mNativePipelineBridge != 0L;
    }

    private boolean checkPipelineBridge(TUIPipelineBridgeDefine.APICallRespondCallback callback) {
        if (this.mNativePipelineBridge == 0L) {
            if (callback != null) {
                callback.onCallback(TUICommonDefine.Error.FAILED, "bridge is destroyed", "");
            }
            return false;
        }
        return true;
    }

    private List<TUIPipelineBridgeObserver> copyOnReadObservers() {
        CopyOnWriteArrayList<TUIPipelineBridgeObserver> arrayList = new CopyOnWriteArrayList<TUIPipelineBridgeObserver>(this.mObserverList);
        return arrayList;
    }

    @CalledByNative
    void onReceiveEventFromPipeline(String eventName, String jsonData) {
        for (TUIPipelineBridgeObserver observer : this.copyOnReadObservers()) {
            observer.onReceiveEventFromPipeline(eventName, jsonData);
        }
    }

    private static native long nativeCreatePipelineBridge(TUIPipelineBridge var0, int var1, boolean var2);

    private static native void nativeDestroyPipelineBridge(long var0);

    private static native void nativeCallAPI(long var0, String var2, String var3, APICallRespondCallback var4);

    static class APICallRespondCallback {
        private final TUIPipelineBridgeDefine.APICallRespondCallback mCallback;

        public APICallRespondCallback(TUIPipelineBridgeDefine.APICallRespondCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="APICallRespondCallback")
        public void onCallback(int code, String message, String jsonData) {
            if (this.mCallback != null) {
                this.mCallback.onCallback(TUICommonDefine.Error.fromInt(code), message, jsonData);
            }
        }
    }
}

