/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.impl.call;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.tencent.cloud.tuikit.engine.call.TUICallDefine;
import com.tencent.cloud.tuikit.engine.call.TUICallObserver;
import com.tencent.cloud.tuikit.engine.common.TUICommonDefine;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$1;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$10;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$11;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$12;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$13;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$14;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$15;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$16;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$17;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$18;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$19;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$2;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$20;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$21;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$22;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$23;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$24;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$3;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$4;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$5;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$6;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$7;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$8;
import com.tencent.cloud.tuikit.engine.impl.call.TUICallObserverProxy$$Lambda$9;
import com.tencent.cloud.tuikit.engine.impl.pipelinebridge.TUIPipelineBridgeObserver;
import com.tencent.cloud.tuikit.engine.impl.utils.ParamsParse;
import com.tencent.liteav.base.util.LiteavLog;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class TUICallObserverProxy
extends TUIPipelineBridgeObserver {
    private static final String TAG = "TUICallObserverProxy";
    private final Handler mMainHandler;
    private final List<TUICallObserver> mObserverList = new CopyOnWriteArrayList<TUICallObserver>();
    private final HashMap<String, String> mFunctionMap = new HashMap();

    public TUICallObserverProxy() {
        this.mMainHandler = new Handler(Looper.getMainLooper());
        this.registerEventHandler();
    }

    public void destroy() {
        this.mObserverList.clear();
        this.mFunctionMap.clear();
    }

    public void addObserver(TUICallObserver observer) {
        if (observer != null && !this.mObserverList.contains(observer)) {
            this.mObserverList.add(observer);
        }
    }

    public void removeObserver(TUICallObserver observer) {
        if (observer != null) {
            this.mObserverList.remove(observer);
        }
    }

    private void registerEventHandler() {
        this.bindEventHandler("onError", "onErrorHandler");
        this.bindEventHandler("onCallReceived", "onCallReceivedHandler");
        this.bindEventHandler("onCallNotConnected", "onCallNotConnectedHandler");
        this.bindEventHandler("onCallBegin", "onCallBeginHandler");
        this.bindEventHandler("onCallEnd", "onCallEndHandler");
        this.bindEventHandler("onCallMediaTypeChanged", "onCallMediaTypeChangedHandler");
        this.bindEventHandler("onUserReject", "onUserRejectHandler");
        this.bindEventHandler("onUserNoResponse", "onUserNoResponseHandler");
        this.bindEventHandler("onUserInviting", "onUserInvitingHandler");
        this.bindEventHandler("onUserLineBusy", "onUserLineBusyHandler");
        this.bindEventHandler("onUserJoin", "onUserJoinHandler");
        this.bindEventHandler("onUserLeave", "onUserLeaveHandler");
        this.bindEventHandler("onUserVideoAvailable", "onUserVideoAvailableHandler");
        this.bindEventHandler("onUserAudioAvailable", "onUserAudioAvailableHandler");
        this.bindEventHandler("onUserVoiceVolumeChanged", "onUserVoiceVolumeChangedHandler");
        this.bindEventHandler("onUserNetworkQualityChanged", "onUserNetworkQualityChangedHandler");
        this.bindEventHandler("onKickedOffline", "onKickedOfflineHandler");
        this.bindEventHandler("onUserSigExpired", "onUserSigExpiredHandler");
    }

    private void onErrorHandler(String jsonData) {
        JSONArray params = ParamsParse.StringToJSONArray(jsonData);
        Integer code = ParamsParse.getParamFromJSONArray(params, 0, Integer.class);
        String message = ParamsParse.getParamFromJSONArray(params, 1, String.class);
        LiteavLog.e((String)TAG, (String)("call_engine - onError code:" + code + ", message:" + message));
        this.notifyObservers(TUICallObserverProxy$$Lambda$1.lambdaFactory$(code, message));
    }

    private void onCallReceivedHandler(String jsonData) {
        JSONArray params = ParamsParse.StringToJSONArray(jsonData);
        String callerId = ParamsParse.getParamFromJSONArray(params, 0, String.class);
        JSONArray calleeIdListJSON = ParamsParse.getParamFromJSONArray(params, 1, JSONArray.class);
        List<String> calleeIdList = ParamsParse.JSONArrayToList(calleeIdListJSON, String.class);
        String groupId = ParamsParse.getParamFromJSONArray(params, 2, String.class);
        TUICallDefine.MediaType mediaType = ParamsParse.getParamFromJSONArray(params, 3, TUICallDefine.MediaType.class);
        String userData = ParamsParse.getParamFromJSONArray(params, 4, String.class);
        TUICommonDefine.RoomId roomId = ParamsParse.getParamFromJSONArray(params, 5, TUICommonDefine.RoomId.class);
        String callId = ParamsParse.getParamFromJSONArray(params, 7, String.class);
        TUICallDefine.Role callRole = ParamsParse.getParamFromJSONArray(params, 8, TUICallDefine.Role.class);
        TUICallDefine.CallObserverExtraInfo extraInfo = new TUICallDefine.CallObserverExtraInfo();
        extraInfo.roomId = roomId;
        extraInfo.role = callRole;
        extraInfo.userData = userData;
        extraInfo.chatGroupId = groupId;
        LiteavLog.i((String)TAG, (String)("call_engine - onCallReceived callId:" + callId + ", callerId:" + callerId + ", calleeIdList:" + calleeIdList + ", mediaType:" + (Object)((Object)mediaType) + ", extraInfo:" + extraInfo));
        this.notifyObservers(TUICallObserverProxy$$Lambda$2.lambdaFactory$(callId, callerId, calleeIdList, mediaType, extraInfo));
        this.notifyObservers(TUICallObserverProxy$$Lambda$3.lambdaFactory$(callerId, calleeIdList, groupId, mediaType, userData));
        this.notifyObservers(TUICallObserverProxy$$Lambda$4.lambdaFactory$(callerId, calleeIdList, groupId, mediaType));
    }

    private void onCallNotConnectedHandler(String jsonData) {
        JSONArray params = ParamsParse.StringToJSONArray(jsonData);
        String userId = ParamsParse.getParamFromJSONArray(params, 0, String.class);
        String callId = ParamsParse.getParamFromJSONArray(params, 1, String.class);
        TUICommonDefine.RoomId roomId = ParamsParse.getParamFromJSONArray(params, 2, TUICommonDefine.RoomId.class);
        TUICallDefine.MediaType mediaType = ParamsParse.getParamFromJSONArray(params, 4, TUICallDefine.MediaType.class);
        TUICallDefine.Role callRole = ParamsParse.getParamFromJSONArray(params, 5, TUICallDefine.Role.class);
        TUICallDefine.CallEndReason reason = ParamsParse.getParamFromJSONArray(params, 6, TUICallDefine.CallEndReason.class);
        String groupId = ParamsParse.getParamFromJSONArray(params, 7, String.class);
        TUICallDefine.CallObserverExtraInfo extraInfo = new TUICallDefine.CallObserverExtraInfo();
        extraInfo.roomId = roomId;
        extraInfo.role = callRole;
        extraInfo.chatGroupId = groupId;
        LiteavLog.i((String)TAG, (String)("call_engine - onCallNotConnected callId:" + callId + ", mediaType:" + (Object)((Object)mediaType) + ", reason:" + (Object)((Object)reason) + ", userId:" + userId + ", extraInfo:" + extraInfo));
        this.notifyObservers(TUICallObserverProxy$$Lambda$5.lambdaFactory$(callId, mediaType, reason, userId, extraInfo));
        this.notifyObservers(TUICallObserverProxy$$Lambda$6.lambdaFactory$(userId));
    }

    private void onCallBeginHandler(String jsonData) {
        JSONArray params = ParamsParse.StringToJSONArray(jsonData);
        TUICommonDefine.RoomId roomId = ParamsParse.getParamFromJSONArray(params, 0, TUICommonDefine.RoomId.class);
        TUICallDefine.MediaType mediaType = ParamsParse.getParamFromJSONArray(params, 2, TUICallDefine.MediaType.class);
        TUICallDefine.Role callRole = ParamsParse.getParamFromJSONArray(params, 3, TUICallDefine.Role.class);
        String callId = ParamsParse.getParamFromJSONArray(params, 4, String.class);
        String groupId = ParamsParse.getParamFromJSONArray(params, 5, String.class);
        TUICallDefine.CallObserverExtraInfo extraInfo = new TUICallDefine.CallObserverExtraInfo();
        extraInfo.roomId = roomId;
        extraInfo.role = callRole;
        extraInfo.chatGroupId = groupId;
        LiteavLog.i((String)TAG, (String)("call_engine - onCallBegin callId:" + callId + ", mediaType:" + (Object)((Object)mediaType) + ", extraInfo:" + extraInfo));
        this.notifyObservers(TUICallObserverProxy$$Lambda$7.lambdaFactory$(callId, mediaType, extraInfo));
        this.notifyObservers(TUICallObserverProxy$$Lambda$8.lambdaFactory$(roomId, mediaType, callRole));
    }

    private void onCallEndHandler(String jsonData) {
        JSONArray params = ParamsParse.StringToJSONArray(jsonData);
        TUICommonDefine.RoomId roomId = ParamsParse.getParamFromJSONArray(params, 0, TUICommonDefine.RoomId.class);
        TUICallDefine.MediaType mediaType = ParamsParse.getParamFromJSONArray(params, 2, TUICallDefine.MediaType.class);
        TUICallDefine.Role callRole = ParamsParse.getParamFromJSONArray(params, 3, TUICallDefine.Role.class);
        String callId = ParamsParse.getParamFromJSONArray(params, 4, String.class);
        Integer totalTimeInt = ParamsParse.getParamFromJSONArray(params, 5, Integer.class);
        TUICallDefine.CallEndReason reason = ParamsParse.getParamFromJSONArray(params, 6, TUICallDefine.CallEndReason.class);
        String userId = ParamsParse.getParamFromJSONArray(params, 7, String.class);
        String groupId = ParamsParse.getParamFromJSONArray(params, 8, String.class);
        long totalTime = totalTimeInt != null ? totalTimeInt.longValue() : 0L;
        TUICallDefine.CallObserverExtraInfo extraInfo = new TUICallDefine.CallObserverExtraInfo();
        extraInfo.roomId = roomId;
        extraInfo.role = callRole;
        extraInfo.chatGroupId = groupId;
        LiteavLog.i((String)TAG, (String)("call_engine - onCallEnd callId:" + callId + ", mediaType:" + (Object)((Object)mediaType) + ", reason:" + (Object)((Object)reason) + ", userId:" + userId + ", extraInfo:" + extraInfo));
        this.notifyObservers(TUICallObserverProxy$$Lambda$9.lambdaFactory$(callId, mediaType, reason, userId, totalTime, extraInfo));
        this.notifyObservers(TUICallObserverProxy$$Lambda$10.lambdaFactory$(roomId, mediaType, callRole, totalTime));
    }

    private void onCallMediaTypeChangedHandler(String jsonData) {
        JSONArray params = ParamsParse.StringToJSONArray(jsonData);
        TUICallDefine.MediaType oldMediaType = ParamsParse.getParamFromJSONArray(params, 0, TUICallDefine.MediaType.class);
        TUICallDefine.MediaType newMediaType = ParamsParse.getParamFromJSONArray(params, 1, TUICallDefine.MediaType.class);
        LiteavLog.i((String)TAG, (String)("call_engine - onCallMediaTypeChanged oldMediaType:" + (Object)((Object)oldMediaType) + ", newMediaType:" + (Object)((Object)newMediaType)));
        this.notifyObservers(TUICallObserverProxy$$Lambda$11.lambdaFactory$(oldMediaType, newMediaType));
    }

    private void onUserRejectHandler(String jsonData) {
        JSONArray params = ParamsParse.StringToJSONArray(jsonData);
        String userId = ParamsParse.getParamFromJSONArray(params, 0, String.class);
        LiteavLog.i((String)TAG, (String)("call_engine - onUserReject userId:" + userId));
        this.notifyObservers(TUICallObserverProxy$$Lambda$12.lambdaFactory$(userId));
    }

    private void onUserNoResponseHandler(String jsonData) {
        JSONArray params = ParamsParse.StringToJSONArray(jsonData);
        JSONArray userIdList = ParamsParse.getParamFromJSONArray(params, 0, JSONArray.class);
        int item = 0;
        while (true) {
            JSONArray jSONArray = userIdList;
            jSONArray.getClass();
            if (item >= jSONArray.length()) break;
            String userId = userIdList.optString(item);
            LiteavLog.i((String)TAG, (String)("call_engine - onUserNoResponse userId:" + userId));
            this.notifyObservers(TUICallObserverProxy$$Lambda$13.lambdaFactory$(userId));
            ++item;
        }
    }

    private void onUserInvitingHandler(String jsonData) {
        JSONArray params = ParamsParse.StringToJSONArray(jsonData);
        String userId = ParamsParse.getParamFromJSONArray(params, 0, String.class);
        LiteavLog.i((String)TAG, (String)("call_engine - onUserInviting userId:" + userId));
        this.notifyObservers(TUICallObserverProxy$$Lambda$14.lambdaFactory$(userId));
    }

    private void onUserLineBusyHandler(String jsonData) {
        JSONArray params = ParamsParse.StringToJSONArray(jsonData);
        String userId = ParamsParse.getParamFromJSONArray(params, 0, String.class);
        LiteavLog.i((String)TAG, (String)("call_engine - onUserLineBusy userId:" + userId));
        this.notifyObservers(TUICallObserverProxy$$Lambda$15.lambdaFactory$(userId));
    }

    private void onUserJoinHandler(String jsonData) {
        JSONArray params = ParamsParse.StringToJSONArray(jsonData);
        String userId = ParamsParse.getParamFromJSONArray(params, 0, String.class);
        LiteavLog.i((String)TAG, (String)("call_engine - onUserJoin userId:" + userId));
        this.notifyObservers(TUICallObserverProxy$$Lambda$16.lambdaFactory$(userId));
    }

    private void onUserLeaveHandler(String jsonData) {
        JSONArray params = ParamsParse.StringToJSONArray(jsonData);
        String userId = ParamsParse.getParamFromJSONArray(params, 0, String.class);
        LiteavLog.i((String)TAG, (String)("call_engine - onUserLeave userId:" + userId));
        this.notifyObservers(TUICallObserverProxy$$Lambda$17.lambdaFactory$(userId));
    }

    private void onUserVideoAvailableHandler(String jsonData) {
        JSONArray params = ParamsParse.StringToJSONArray(jsonData);
        String userId = ParamsParse.getParamFromJSONArray(params, 0, String.class);
        boolean isVideoAvailable = Boolean.TRUE.equals(ParamsParse.getParamFromJSONArray(params, 1, Boolean.class));
        LiteavLog.i((String)TAG, (String)("call_engine - onUserVideoAvailable userId:" + userId + ", isVideoAvailable:" + isVideoAvailable));
        this.notifyObservers(TUICallObserverProxy$$Lambda$18.lambdaFactory$(userId, isVideoAvailable));
    }

    private void onUserAudioAvailableHandler(String jsonData) {
        JSONArray params = ParamsParse.StringToJSONArray(jsonData);
        String userId = ParamsParse.getParamFromJSONArray(params, 0, String.class);
        boolean isAudioAvailable = Boolean.TRUE.equals(ParamsParse.getParamFromJSONArray(params, 1, Boolean.class));
        LiteavLog.i((String)TAG, (String)("call_engine - onUserAudioAvailable userId:" + userId + ", isAudioAvailable:" + isAudioAvailable));
        this.notifyObservers(TUICallObserverProxy$$Lambda$19.lambdaFactory$(userId, isAudioAvailable));
    }

    private void onUserVoiceVolumeChangedHandler(String jsonData) {
        JSONArray params = ParamsParse.StringToJSONArray(jsonData);
        JSONObject jsonObject = ParamsParse.getParamFromJSONArray(params, 0, JSONObject.class);
        Map<String, Integer> volumeChangedMap = ParamsParse.JSONObjectToMap(jsonObject, Integer.class);
        this.notifyObservers(TUICallObserverProxy$$Lambda$20.lambdaFactory$(volumeChangedMap));
    }

    private void onUserNetworkQualityChangedHandler(String jsonData) {
        JSONArray params = ParamsParse.StringToJSONArray(jsonData);
        this.notifyObservers(TUICallObserverProxy$$Lambda$21.lambdaFactory$(params));
    }

    private void onKickedOfflineHandler(String jsonData) {
        LiteavLog.i((String)TAG, (String)"call_engine - onKickedOffline");
        this.notifyObservers(TUICallObserverProxy$$Lambda$22.lambdaFactory$());
    }

    private void onUserSigExpiredHandler(String jsonData) {
        LiteavLog.i((String)TAG, (String)"call_engine - onUserSigExpired");
        this.notifyObservers(TUICallObserverProxy$$Lambda$23.lambdaFactory$());
    }

    private void bindEventHandler(String eventName, String handlerName) {
        if (TextUtils.isEmpty((CharSequence)eventName) || TextUtils.isEmpty((CharSequence)handlerName)) {
            return;
        }
        this.mFunctionMap.put(eventName, handlerName);
    }

    @Override
    public void onReceiveEventFromPipeline(String eventName, String jsonData) {
        String handlerName = this.mFunctionMap.get(eventName);
        if (handlerName != null) {
            try {
                Method method = TUICallObserverProxy.class.getDeclaredMethod(handlerName, String.class);
                method.invoke((Object)this, jsonData);
            }
            catch (Exception e) {
                LiteavLog.e((String)TAG, (String)("call_engine - onReceiveEventFromPipeline invoke error: " + e));
            }
        }
    }

    private <R> void notifyObservers(CallBackExecutor<R> executor) {
        for (TUICallObserver observer : this.mObserverList) {
            this.runOnMainThread(TUICallObserverProxy$$Lambda$24.lambdaFactory$(executor, observer));
        }
    }

    private void runOnMainThread(Runnable runnable) {
        if (this.mMainHandler.getLooper() == Looper.myLooper()) {
            runnable.run();
        } else {
            this.mMainHandler.post(runnable);
        }
    }

    static /* synthetic */ void lambda$notifyObservers$23(CallBackExecutor executor, TUICallObserver observer) {
        executor.execute(observer, null);
    }

    static /* synthetic */ void lambda$onUserSigExpiredHandler$22(TUICallObserver observer, Object param) {
        observer.onUserSigExpired();
    }

    static /* synthetic */ void lambda$onKickedOfflineHandler$21(TUICallObserver observer, Object param) {
        observer.onKickedOffline();
    }

    static /* synthetic */ void lambda$onUserNetworkQualityChangedHandler$20(JSONArray params, TUICallObserver observer, Object param) {
        observer.onUserNetworkQualityChanged(ParamsParse.getQualityInfoListFromJSONArray(params));
    }

    static /* synthetic */ void lambda$onUserVoiceVolumeChangedHandler$19(Map volumeChangedMap, TUICallObserver observer, Object param) {
        observer.onUserVoiceVolumeChanged(volumeChangedMap);
    }

    static /* synthetic */ void lambda$onUserAudioAvailableHandler$18(String userId, boolean isAudioAvailable, TUICallObserver observer, Object param) {
        observer.onUserAudioAvailable(userId, isAudioAvailable);
    }

    static /* synthetic */ void lambda$onUserVideoAvailableHandler$17(String userId, boolean isVideoAvailable, TUICallObserver observer, Object param) {
        observer.onUserVideoAvailable(userId, isVideoAvailable);
    }

    static /* synthetic */ void lambda$onUserLeaveHandler$16(String userId, TUICallObserver observer, Object param) {
        observer.onUserLeave(userId);
    }

    static /* synthetic */ void lambda$onUserJoinHandler$15(String userId, TUICallObserver observer, Object param) {
        observer.onUserJoin(userId);
    }

    static /* synthetic */ void lambda$onUserLineBusyHandler$14(String userId, TUICallObserver observer, Object param) {
        observer.onUserLineBusy(userId);
    }

    static /* synthetic */ void lambda$onUserInvitingHandler$13(String userId, TUICallObserver observer, Object param) {
        observer.onUserInviting(userId);
    }

    static /* synthetic */ void lambda$onUserNoResponseHandler$12(String userId, TUICallObserver observer, Object param) {
        observer.onUserNoResponse(userId);
    }

    static /* synthetic */ void lambda$onUserRejectHandler$11(String userId, TUICallObserver observer, Object param) {
        observer.onUserReject(userId);
    }

    static /* synthetic */ void lambda$onCallMediaTypeChangedHandler$10(TUICallDefine.MediaType oldMediaType, TUICallDefine.MediaType newMediaType, TUICallObserver observer, Object param) {
        observer.onCallMediaTypeChanged(oldMediaType, newMediaType);
    }

    static /* synthetic */ void lambda$onCallEndHandler$9(TUICommonDefine.RoomId roomId, TUICallDefine.MediaType mediaType, TUICallDefine.Role callRole, long totalTime, TUICallObserver observer, Object param) {
        observer.onCallEnd(roomId, mediaType, callRole, totalTime);
    }

    static /* synthetic */ void lambda$onCallEndHandler$8(String callId, TUICallDefine.MediaType mediaType, TUICallDefine.CallEndReason reason, String userId, long totalTime, TUICallDefine.CallObserverExtraInfo extraInfo, TUICallObserver observer, Object param) {
        observer.onCallEnd(callId, mediaType, reason, userId, totalTime, extraInfo);
    }

    static /* synthetic */ void lambda$onCallBeginHandler$7(TUICommonDefine.RoomId roomId, TUICallDefine.MediaType mediaType, TUICallDefine.Role callRole, TUICallObserver observer, Object param) {
        observer.onCallBegin(roomId, mediaType, callRole);
    }

    static /* synthetic */ void lambda$onCallBeginHandler$6(String callId, TUICallDefine.MediaType mediaType, TUICallDefine.CallObserverExtraInfo extraInfo, TUICallObserver observer, Object param) {
        observer.onCallBegin(callId, mediaType, extraInfo);
    }

    static /* synthetic */ void lambda$onCallNotConnectedHandler$5(String userId, TUICallObserver observer, Object param) {
        observer.onCallCancelled(userId);
    }

    static /* synthetic */ void lambda$onCallNotConnectedHandler$4(String callId, TUICallDefine.MediaType mediaType, TUICallDefine.CallEndReason reason, String userId, TUICallDefine.CallObserverExtraInfo extraInfo, TUICallObserver observer, Object param) {
        observer.onCallNotConnected(callId, mediaType, reason, userId, extraInfo);
    }

    static /* synthetic */ void lambda$onCallReceivedHandler$3(String callerId, List calleeIdList, String groupId, TUICallDefine.MediaType mediaType, TUICallObserver observer, Object param) {
        observer.onCallReceived(callerId, calleeIdList, groupId, mediaType);
    }

    static /* synthetic */ void lambda$onCallReceivedHandler$2(String callerId, List calleeIdList, String groupId, TUICallDefine.MediaType mediaType, String userData, TUICallObserver observer, Object param) {
        observer.onCallReceived(callerId, calleeIdList, groupId, mediaType, userData);
    }

    static /* synthetic */ void lambda$onCallReceivedHandler$1(String callId, String callerId, List calleeIdList, TUICallDefine.MediaType mediaType, TUICallDefine.CallObserverExtraInfo extraInfo, TUICallObserver observer, Object param) {
        observer.onCallReceived(callId, callerId, calleeIdList, mediaType, extraInfo);
    }

    static /* synthetic */ void lambda$onErrorHandler$0(Integer code, String message, TUICallObserver observer, Object param) {
        observer.onError(code, message);
    }

    @FunctionalInterface
    static interface CallBackExecutor<R> {
        public void execute(TUICallObserver var1, R var2);
    }
}

