/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.extension.internal;

import com.tencent.cloud.tuikit.engine.common.TUICommonDefine;
import com.tencent.cloud.tuikit.engine.extension.TUILiveListManager;
import com.tencent.cloud.tuikit.engine.room.TUIRoomDefine;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

@JNINamespace(value="tuikit::extension")
public class TUILiveListManagerJni {
    private long mNativeTUILiveListManagerJni;
    private HashMap<String, List<Integer>> mCategoryMap = new HashMap();
    private final List<TUILiveListManager.Observer> mObserverList = new CopyOnWriteArrayList<TUILiveListManager.Observer>();

    public TUILiveListManagerJni(long nativeLiveListManagerJni) {
        this.mNativeTUILiveListManagerJni = nativeLiveListManagerJni;
        if (this.mNativeTUILiveListManagerJni != 0L) {
            TUILiveListManagerJni.nativeSetObserver(this.mNativeTUILiveListManagerJni, this);
        }
    }

    public void addObserver(TUILiveListManager.Observer observer) {
        if (observer == null || this.mObserverList.contains(observer)) {
            return;
        }
        this.mObserverList.add(observer);
    }

    public void removeObserver(TUILiveListManager.Observer observer) {
        if (observer == null) {
            return;
        }
        this.mObserverList.remove(observer);
    }

    public void setLiveInfo(TUILiveListManager.LiveInfo liveInfo, int modifyFlag, TUIRoomDefine.ActionCallback callback) {
        TUILiveListManagerJni.nativeSetLiveInfo(this.mNativeTUILiveListManagerJni, new LiveInfo(liveInfo), modifyFlag, new ActionCallback(callback));
    }

    public void getLiveInfo(String roomId, TUILiveListManager.LiveInfoCallback callback) {
        TUILiveListManagerJni.nativeGetLiveInfo(this.mNativeTUILiveListManagerJni, roomId, new LiveInfoCallback(callback));
    }

    public void fetchLiveList(String cursor, int count, TUILiveListManager.LiveInfoListCallback callback) {
        TUILiveListManagerJni.nativeFetchLiveList(this.mNativeTUILiveListManagerJni, cursor, count, new LiveInfoListCallback(callback));
    }

    private static native void nativeSetObserver(long var0, Object var2);

    private static native void nativeSetLiveInfo(long var0, LiveInfo var2, int var3, ActionCallback var4);

    private static native void nativeGetLiveInfo(long var0, String var2, LiveInfoCallback var3);

    private static native void nativeFetchLiveList(long var0, String var2, int var3, LiveInfoListCallback var4);

    private List<TUILiveListManager.Observer> copyOnReadListeners() {
        return new CopyOnWriteArrayList<TUILiveListManager.Observer>(this.mObserverList);
    }

    @CalledByNative
    public static TUILiveListManager.LiveInfo createLiveInfo(String coverUrl, String backgroundUrl, int[] categoryList, boolean isPublicVisible, int activityStatus, int viewCountStatus, String ownerId, String ownerName, String ownerAvatarUrl, long createTime, int memberCount, String roomId, int roomType, String name, boolean isCameraDisableForAllUser, boolean isMicrophoneDisableForAllUser, boolean isMessageDisableForAllUser, boolean isSeatEnabled, int seatMode, int maxSeatCount) {
        TUIRoomDefine.RoomInfo roomInfo = new TUIRoomDefine.RoomInfo();
        roomInfo.roomId = roomId;
        roomInfo.roomType = TUIRoomDefine.RoomType.fromInt(roomType);
        roomInfo.name = name;
        roomInfo.isCameraDisableForAllUser = isCameraDisableForAllUser;
        roomInfo.isMicrophoneDisableForAllUser = isMicrophoneDisableForAllUser;
        roomInfo.isMessageDisableForAllUser = isMessageDisableForAllUser;
        roomInfo.isSeatEnabled = isSeatEnabled;
        roomInfo.seatMode = TUIRoomDefine.SeatMode.fromInt(seatMode);
        roomInfo.maxSeatCount = maxSeatCount;
        roomInfo.ownerId = ownerId;
        roomInfo.ownerName = ownerName;
        roomInfo.ownerAvatarUrl = ownerAvatarUrl;
        roomInfo.memberCount = memberCount;
        roomInfo.createTime = createTime;
        TUILiveListManager.LiveInfo liveInfo = new TUILiveListManager.LiveInfo();
        liveInfo.roomInfo = roomInfo;
        liveInfo.isPublicVisible = isPublicVisible;
        liveInfo.coverUrl = coverUrl;
        liveInfo.backgroundUrl = backgroundUrl;
        liveInfo.activityStatus = activityStatus;
        liveInfo.viewCount = viewCountStatus;
        ArrayList<Integer> intList = new ArrayList<Integer>(categoryList.length);
        for (int value : categoryList) {
            intList.add(value);
        }
        liveInfo.categoryList = intList;
        return liveInfo;
    }

    @CalledByNative
    public TUILiveListManager.LiveInfoListResult createLiveInfoListResult(String cursor, String[] coverUrlArray, String[] backgroundUrlArray, boolean[] isPublicVisibleArray, int[] activityStatusArray, int[] viewCountArray, String[] ownerIdArray, String[] ownerNameArray, String[] ownerAvatarUrlArray, long[] createTimeArray, int[] memberCountArray, String[] roomIdArray, int[] roomTypeArray, String[] nameArray, boolean[] isCameraDisableForAllUserArray, boolean[] isMicrophoneDisableForAllUserArray, boolean[] isMessageDisableForAllUserArray, boolean[] isSeatEnabledArray, int[] seatModeArray, int[] maxSeatCountArray) {
        TUILiveListManager.LiveInfoListResult result = new TUILiveListManager.LiveInfoListResult();
        result.liveInfoList = new ArrayList<TUILiveListManager.LiveInfo>();
        result.cursor = cursor;
        for (int i = 0; i < roomIdArray.length; ++i) {
            TUIRoomDefine.RoomInfo roomInfo = new TUIRoomDefine.RoomInfo();
            roomInfo.roomId = roomIdArray[i];
            roomInfo.roomType = TUIRoomDefine.RoomType.fromInt(roomTypeArray[i]);
            roomInfo.name = nameArray[i];
            roomInfo.isCameraDisableForAllUser = isCameraDisableForAllUserArray[i];
            roomInfo.isMicrophoneDisableForAllUser = isMicrophoneDisableForAllUserArray[i];
            roomInfo.isMessageDisableForAllUser = isMessageDisableForAllUserArray[i];
            roomInfo.isSeatEnabled = isSeatEnabledArray[i];
            roomInfo.seatMode = TUIRoomDefine.SeatMode.fromInt(seatModeArray[i]);
            roomInfo.maxSeatCount = maxSeatCountArray[i];
            roomInfo.ownerId = ownerIdArray[i];
            roomInfo.ownerName = ownerNameArray[i];
            roomInfo.ownerAvatarUrl = ownerAvatarUrlArray[i];
            roomInfo.memberCount = memberCountArray[i];
            roomInfo.createTime = createTimeArray[i];
            TUILiveListManager.LiveInfo liveInfo = new TUILiveListManager.LiveInfo();
            liveInfo.roomInfo = roomInfo;
            liveInfo.isPublicVisible = isPublicVisibleArray[i];
            liveInfo.coverUrl = coverUrlArray[i];
            liveInfo.backgroundUrl = backgroundUrlArray[i];
            liveInfo.activityStatus = activityStatusArray[i];
            liveInfo.viewCount = viewCountArray[i];
            for (Map.Entry<String, List<Integer>> entry : this.mCategoryMap.entrySet()) {
                String key = entry.getKey();
                List<Integer> value = entry.getValue();
                if (!key.equals(roomInfo.roomId)) continue;
                liveInfo.categoryList = value;
            }
            result.liveInfoList.add(liveInfo);
            this.mCategoryMap.remove(roomInfo.roomId);
        }
        this.mCategoryMap.clear();
        return result;
    }

    @CalledByNative
    public void stashLiveInfoCategoryList(String key, int[] categoryList) {
        ArrayList<Integer> list = new ArrayList<Integer>(categoryList.length);
        for (int value : categoryList) {
            list.add(value);
        }
        this.mCategoryMap.put(key, list);
    }

    @CalledByNative
    public void onLiveInfoChanged(TUILiveListManager.LiveInfo liveInfo, int modifyFlag) {
        ArrayList<TUILiveListManager.LiveModifyFlag> modifyFlagList = new ArrayList<TUILiveListManager.LiveModifyFlag>();
        if ((modifyFlag & TUILiveListManager.LiveModifyFlag.ACTIVITY_STATUS.getValue()) != 0) {
            modifyFlagList.add(TUILiveListManager.LiveModifyFlag.ACTIVITY_STATUS);
        }
        if ((modifyFlag & TUILiveListManager.LiveModifyFlag.COVER_URL.getValue()) != 0) {
            modifyFlagList.add(TUILiveListManager.LiveModifyFlag.COVER_URL);
        }
        if ((modifyFlag & TUILiveListManager.LiveModifyFlag.BACKGROUND_URL.getValue()) != 0) {
            modifyFlagList.add(TUILiveListManager.LiveModifyFlag.BACKGROUND_URL);
        }
        if ((modifyFlag & TUILiveListManager.LiveModifyFlag.CATEGORY.getValue()) != 0) {
            modifyFlagList.add(TUILiveListManager.LiveModifyFlag.CATEGORY);
        }
        if ((modifyFlag & TUILiveListManager.LiveModifyFlag.PUBLISH.getValue()) != 0) {
            modifyFlagList.add(TUILiveListManager.LiveModifyFlag.PUBLISH);
        }
        for (TUILiveListManager.Observer observer : this.copyOnReadListeners()) {
            observer.onLiveInfoChanged(liveInfo, modifyFlagList);
        }
    }

    static class LiveInfoListCallback {
        private TUILiveListManager.LiveInfoListCallback mCallback;

        public LiveInfoListCallback(TUILiveListManager.LiveInfoListCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="LiveInfoListCallback")
        public void onSuccess(TUILiveListManager.LiveInfoListResult result) {
            if (this.mCallback != null) {
                this.mCallback.onSuccess(result);
            }
        }

        @CalledByNative(value="LiveInfoListCallback")
        public void onError(int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onError(TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }

    static class LiveInfoCallback {
        private TUILiveListManager.LiveInfoCallback mCallback;

        public LiveInfoCallback(TUILiveListManager.LiveInfoCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="LiveInfoCallback")
        public void onSuccess(TUILiveListManager.LiveInfo liveInfo) {
            if (this.mCallback != null) {
                this.mCallback.onSuccess(liveInfo);
            }
        }

        @CalledByNative(value="LiveInfoCallback")
        public void onError(int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onError(TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }

    static class ActionCallback {
        private TUIRoomDefine.ActionCallback mCallback;

        public ActionCallback(TUIRoomDefine.ActionCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="ActionCallback")
        public void onSuccess() {
            if (this.mCallback != null) {
                this.mCallback.onSuccess();
            }
        }

        @CalledByNative(value="ActionCallback")
        public void onError(int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onError(TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }

    static class LiveInfo {
        private TUILiveListManager.LiveInfo mLiveInfo;

        public LiveInfo(TUILiveListManager.LiveInfo liveInfo) {
            this.mLiveInfo = liveInfo;
        }

        @CalledByNative(value="LiveInfo")
        public String getCoverUrl() {
            return this.mLiveInfo.coverUrl;
        }

        @CalledByNative(value="LiveInfo")
        public String getBackgroundUrl() {
            return this.mLiveInfo.backgroundUrl;
        }

        @CalledByNative(value="LiveInfo")
        public int[] getCategoryList() {
            if (this.mLiveInfo.categoryList == null) {
                return new int[0];
            }
            int[] intCategoryList = new int[this.mLiveInfo.categoryList.size()];
            for (int i = 0; i < this.mLiveInfo.categoryList.size(); ++i) {
                intCategoryList[i] = this.mLiveInfo.categoryList.get(i);
            }
            return intCategoryList;
        }

        @CalledByNative(value="LiveInfo")
        public boolean getIsPublicVisible() {
            return this.mLiveInfo.isPublicVisible;
        }

        @CalledByNative(value="LiveInfo")
        public int getActivityStatus() {
            return this.mLiveInfo.activityStatus;
        }

        @CalledByNative(value="LiveInfo")
        public String getRoomInfoRoomId() {
            return this.mLiveInfo.roomInfo.roomId;
        }

        @CalledByNative(value="LiveInfo")
        public int getRoomInfoRoomType() {
            return this.mLiveInfo.roomInfo.roomType.getValue();
        }

        @CalledByNative(value="LiveInfo")
        public String getRoomInfoName() {
            return this.mLiveInfo.roomInfo.name;
        }

        @CalledByNative(value="LiveInfo")
        public boolean isRoomInfoCameraDisableForAllUser() {
            return this.mLiveInfo.roomInfo.isCameraDisableForAllUser;
        }

        @CalledByNative(value="LiveInfo")
        public boolean isRoomInfoMicrophoneDisableForAllUser() {
            return this.mLiveInfo.roomInfo.isMicrophoneDisableForAllUser;
        }

        @CalledByNative(value="LiveInfo")
        public boolean isRoomInfoMessageDisableForAllUser() {
            return this.mLiveInfo.roomInfo.isMessageDisableForAllUser;
        }

        @CalledByNative(value="LiveInfo")
        public boolean isRoomInfoSeatEnabled() {
            return this.mLiveInfo.roomInfo.isSeatEnabled;
        }

        @CalledByNative(value="LiveInfo")
        public int getRoomInfoSeatMode() {
            return this.mLiveInfo.roomInfo.seatMode.getValue();
        }

        @CalledByNative(value="LiveInfo")
        public int getRoomInfoMaxSeatCount() {
            return this.mLiveInfo.roomInfo.maxSeatCount;
        }
    }
}

