/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.extension.internal;

import android.os.Handler;
import android.os.Looper;
import com.tencent.cloud.tuikit.engine.common.TUICommonDefine;
import com.tencent.cloud.tuikit.engine.common.TUIVideoView;
import com.tencent.cloud.tuikit.engine.extension.TUILiveListManager;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveListManagerImpl$$Lambda$1;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveListManagerImpl$$Lambda$2;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveListManagerImpl$$Lambda$3;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveListManagerImpl$$Lambda$4;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveListManagerImpl$$Lambda$5;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveListManagerImpl$$Lambda$6;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveListManagerImpl$$Lambda$7;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveListManagerImpl$$Lambda$8;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveListManagerJni;
import com.tencent.cloud.tuikit.engine.impl.pipelinebridge.TUIPipelineBridgeDefine;
import com.tencent.cloud.tuikit.engine.impl.room.TUIRoomEngineJni;
import com.tencent.cloud.tuikit.engine.impl.utils.ParamsParse;
import com.tencent.cloud.tuikit.engine.room.TUIRoomDefine;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;

public class TUILiveListManagerImpl
extends TUILiveListManager {
    private TUILiveListManagerJni mTUILiveListManagerJni;
    private final Handler mMainHandler = new Handler(Looper.getMainLooper());
    private TUIRoomEngineJni mRoomEngineJni;

    public TUILiveListManagerImpl(TUIRoomEngineJni roomEngineJni, long nativeLiveListManagerJni) {
        this.runOnMainThread(TUILiveListManagerImpl$$Lambda$1.lambdaFactory$(this, nativeLiveListManagerJni, roomEngineJni));
    }

    @Override
    public void addObserver(TUILiveListManager.Observer observer) {
        this.runOnMainThread(TUILiveListManagerImpl$$Lambda$2.lambdaFactory$(this, observer));
    }

    @Override
    public void removeObserver(TUILiveListManager.Observer observer) {
        this.runOnMainThread(TUILiveListManagerImpl$$Lambda$3.lambdaFactory$(this, observer));
    }

    @Override
    public void setLiveInfo(TUILiveListManager.LiveInfo liveInfo, List<TUILiveListManager.LiveModifyFlag> modifyFlagList, TUIRoomDefine.ActionCallback callback) {
        if (modifyFlagList == null) {
            callback.onError(TUICommonDefine.Error.INVALID_PARAMETER, "modifyFlagList is null");
            return;
        }
        int modifyFlag = 0;
        for (TUILiveListManager.LiveModifyFlag flag : modifyFlagList) {
            modifyFlag |= flag.getValue();
        }
        int flag = modifyFlag;
        this.runOnMainThread(TUILiveListManagerImpl$$Lambda$4.lambdaFactory$(this, liveInfo, flag, callback));
    }

    @Override
    public void getLiveInfo(String roomId, TUILiveListManager.LiveInfoCallback callback) {
        this.runOnMainThread(TUILiveListManagerImpl$$Lambda$5.lambdaFactory$(this, roomId, callback));
    }

    @Override
    public void fetchLiveList(String cursor, int count, TUILiveListManager.LiveInfoListCallback callback) {
        this.runOnMainThread(TUILiveListManagerImpl$$Lambda$6.lambdaFactory$(this, cursor, count, callback));
    }

    @Override
    public void startPreloadVideoStream(String roomId, boolean isMuteAudio, TUIVideoView view, TUIRoomDefine.PlayCallback callback) {
        this.runOnMainThread(TUILiveListManagerImpl$$Lambda$7.lambdaFactory$(this, roomId, isMuteAudio, view, callback));
    }

    @Override
    public void stopPreloadVideoStream(String roomId) {
        ArrayList<Object> paramsList = new ArrayList<Object>();
        paramsList.add(roomId);
        this.callAPI("stopPreloadVideoStream", paramsList, null);
    }

    private void runOnMainThread(Runnable runnable) {
        if (this.mMainHandler.getLooper() == Looper.myLooper()) {
            runnable.run();
        } else {
            this.mMainHandler.post(runnable);
        }
    }

    private void startPreloadVideoStreamResponse(TUIRoomDefine.PlayCallback callback, TUICommonDefine.Error error, String message, String jsonData) {
        if (callback == null) {
            return;
        }
        JSONArray params = ParamsParse.StringToJSONArray(jsonData);
        String userId = ParamsParse.getParamFromJSONArray(params, 0, String.class);
        if (error == TUICommonDefine.Error.SUCCESS) {
            callback.onPlaying(userId);
        } else {
            callback.onPlayError(userId, error, message);
        }
    }

    private void callAPI(String methodName, List<Object> paramsList, TUIPipelineBridgeDefine.APICallRespondCallback callback) {
        JSONArray jsonArray = new JSONArray(paramsList);
        this.mRoomEngineJni.getPipelineBridge().callAPI(methodName, jsonArray.toString(), callback);
    }

    private void handleCallback(TUIRoomDefine.ActionCallback callback, TUICommonDefine.Error error, String message) {
        if (callback == null) {
            return;
        }
        if (error == TUICommonDefine.Error.SUCCESS) {
            callback.onSuccess();
        } else {
            callback.onError(error, message);
        }
    }

    static /* synthetic */ void lambda$startPreloadVideoStream$7(TUILiveListManagerImpl this_, String roomId, boolean isMuteAudio, TUIVideoView view, TUIRoomDefine.PlayCallback callback) {
        ArrayList<Object> paramsList = new ArrayList<Object>();
        paramsList.add(roomId);
        paramsList.add(isMuteAudio);
        paramsList.add(TUIRoomEngineJni.getJObjectAddress((Object)view));
        this_.callAPI("startPreloadVideoStream", paramsList, TUILiveListManagerImpl$$Lambda$8.lambdaFactory$(this_, callback));
    }

    static /* synthetic */ void lambda$null$6(TUILiveListManagerImpl this_, TUIRoomDefine.PlayCallback callback, TUICommonDefine.Error error, String message, String jsonData) {
        this_.startPreloadVideoStreamResponse(callback, error, message, jsonData);
    }

    static /* synthetic */ void lambda$fetchLiveList$5(TUILiveListManagerImpl this_, String cursor, int count, TUILiveListManager.LiveInfoListCallback callback) {
        this_.mTUILiveListManagerJni.fetchLiveList(cursor, count, callback);
    }

    static /* synthetic */ void lambda$getLiveInfo$4(TUILiveListManagerImpl this_, String roomId, TUILiveListManager.LiveInfoCallback callback) {
        this_.mTUILiveListManagerJni.getLiveInfo(roomId, callback);
    }

    static /* synthetic */ void lambda$setLiveInfo$3(TUILiveListManagerImpl this_, TUILiveListManager.LiveInfo liveInfo, int flag, TUIRoomDefine.ActionCallback callback) {
        this_.mTUILiveListManagerJni.setLiveInfo(liveInfo, flag, callback);
    }

    static /* synthetic */ void lambda$removeObserver$2(TUILiveListManagerImpl this_, TUILiveListManager.Observer observer) {
        this_.mTUILiveListManagerJni.removeObserver(observer);
    }

    static /* synthetic */ void lambda$addObserver$1(TUILiveListManagerImpl this_, TUILiveListManager.Observer observer) {
        this_.mTUILiveListManagerJni.addObserver(observer);
    }

    static /* synthetic */ void lambda$new$0(TUILiveListManagerImpl this_, long nativeLiveListManagerJni, TUIRoomEngineJni roomEngineJni) {
        this_.mTUILiveListManagerJni = new TUILiveListManagerJni(nativeLiveListManagerJni);
        this_.mRoomEngineJni = roomEngineJni;
    }
}

