/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.extension.internal;

import android.os.Handler;
import android.os.Looper;
import com.tencent.cloud.tuikit.engine.common.TUICommonDefine;
import com.tencent.cloud.tuikit.engine.extension.TUILiveLayoutManager;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveLayoutManagerImpl$$Lambda$1;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveLayoutManagerImpl$$Lambda$2;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveLayoutManagerImpl$$Lambda$3;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveLayoutManagerImpl$$Lambda$4;
import com.tencent.cloud.tuikit.engine.room.TUIRoomDefine;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@JNINamespace(value="tuikit::extension")
public final class TUILiveLayoutManagerImpl
extends TUILiveLayoutManager {
    private static final String TAG = "TUILiveLayoutManagerImpl";
    private long mNativeLiveLayoutManagerJni;
    private final List<TUILiveLayoutManager.Observer> mObserverList = new CopyOnWriteArrayList<TUILiveLayoutManager.Observer>();
    private final Handler mMainHandler = new Handler(Looper.getMainLooper());

    public TUILiveLayoutManagerImpl(long nativeLiveLayoutManagerJni) {
        this.mNativeLiveLayoutManagerJni = nativeLiveLayoutManagerJni;
        if (this.mNativeLiveLayoutManagerJni != 0L) {
            TUILiveLayoutManagerImpl.nativeSetObserver(this.mNativeLiveLayoutManagerJni, this);
        }
    }

    @Override
    public void addObserver(TUILiveLayoutManager.Observer observer) {
        this.runOnMainThread(TUILiveLayoutManagerImpl$$Lambda$1.lambdaFactory$(this, observer));
    }

    @Override
    public void removeObserver(TUILiveLayoutManager.Observer observer) {
        this.runOnMainThread(TUILiveLayoutManagerImpl$$Lambda$2.lambdaFactory$(this, observer));
    }

    @Override
    public void setLiveStreamLayoutInfo(String roomId, String layoutInfo, TUIRoomDefine.ActionCallback callback) {
        this.runOnMainThread(TUILiveLayoutManagerImpl$$Lambda$3.lambdaFactory$(this, roomId, layoutInfo, callback));
    }

    public void destroy() {
        this.runOnMainThread(TUILiveLayoutManagerImpl$$Lambda$4.lambdaFactory$(this));
    }

    private static native void nativeSetObserver(long var0, Object var2);

    private static native void nativeSetLiveStreamLayoutInfo(long var0, String var2, String var3, ActionCallbackJni var4);

    @CalledByNative
    private void onLiveVideoLayoutChanged(String roomId, String layoutListStr) {
        List<TUILiveLayoutManager.Observer> observers = this.copyOnReadListeners();
        if (observers.isEmpty()) {
            return;
        }
        for (TUILiveLayoutManager.Observer observer : observers) {
            observer.onLiveVideoLayoutChanged(roomId, layoutListStr);
        }
    }

    private void runOnMainThread(Runnable runnable) {
        this.mMainHandler.post(runnable);
    }

    private List<TUILiveLayoutManager.Observer> copyOnReadListeners() {
        return new CopyOnWriteArrayList<TUILiveLayoutManager.Observer>(this.mObserverList);
    }

    static /* synthetic */ void lambda$destroy$3(TUILiveLayoutManagerImpl this_) {
        this_.mObserverList.clear();
        this_.mNativeLiveLayoutManagerJni = 0L;
    }

    static /* synthetic */ void lambda$setLiveStreamLayoutInfo$2(TUILiveLayoutManagerImpl this_, String roomId, String layoutInfo, TUIRoomDefine.ActionCallback callback) {
        if (this_.mNativeLiveLayoutManagerJni != 0L) {
            TUILiveLayoutManagerImpl.nativeSetLiveStreamLayoutInfo(this_.mNativeLiveLayoutManagerJni, roomId, layoutInfo, new ActionCallbackJni(callback));
        }
    }

    static /* synthetic */ void lambda$removeObserver$1(TUILiveLayoutManagerImpl this_, TUILiveLayoutManager.Observer observer) {
        this_.mObserverList.remove(observer);
    }

    static /* synthetic */ void lambda$addObserver$0(TUILiveLayoutManagerImpl this_, TUILiveLayoutManager.Observer observer) {
        if (!this_.mObserverList.contains(observer)) {
            this_.mObserverList.add(observer);
        }
    }

    private static class ActionCallbackJni {
        private final TUIRoomDefine.ActionCallback mCallback;

        public ActionCallbackJni(TUIRoomDefine.ActionCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="ActionCallbackJni")
        public void onSuccess() {
            if (this.mCallback != null) {
                this.mCallback.onSuccess();
            }
        }

        @CalledByNative(value="ActionCallbackJni")
        public void onError(int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onError(TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }
}

