/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.extension.internal;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.tencent.cloud.tuikit.engine.common.TUICommonDefine;
import com.tencent.cloud.tuikit.engine.extension.TUILiveConnectionManager;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveConnectionManagerImpl$$Lambda$1;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveConnectionManagerImpl$$Lambda$2;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveConnectionManagerImpl$$Lambda$3;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveConnectionManagerImpl$$Lambda$4;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveConnectionManagerImpl$$Lambda$5;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveConnectionManagerImpl$$Lambda$6;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveConnectionManagerImpl$$Lambda$7;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveConnectionManagerImpl$$Lambda$8;
import com.tencent.cloud.tuikit.engine.room.TUIRoomDefine;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@JNINamespace(value="tuikit::extension")
public final class TUILiveConnectionManagerImpl
extends TUILiveConnectionManager {
    private static final String TAG = "TUILiveConnectionManagerImpl";
    private long mNativeLiveConnectionManagerJni;
    private final List<TUILiveConnectionManager.Observer> mObserverList = new CopyOnWriteArrayList<TUILiveConnectionManager.Observer>();
    private final Handler mMainHandler = new Handler(Looper.getMainLooper());

    public TUILiveConnectionManagerImpl(long nativeLiveConnectionManagerJni) {
        this.mNativeLiveConnectionManagerJni = nativeLiveConnectionManagerJni;
        if (this.mNativeLiveConnectionManagerJni != 0L) {
            TUILiveConnectionManagerImpl.nativeSetObserver(this.mNativeLiveConnectionManagerJni, this);
        }
    }

    @Override
    public void addObserver(TUILiveConnectionManager.Observer observer) {
        this.runOnMainThread(TUILiveConnectionManagerImpl$$Lambda$1.lambdaFactory$(this, observer));
    }

    @Override
    public void removeObserver(TUILiveConnectionManager.Observer observer) {
        this.runOnMainThread(TUILiveConnectionManagerImpl$$Lambda$2.lambdaFactory$(this, observer));
    }

    @Override
    public void requestConnection(List<String> roomIdList, int timeout, String extensionInfo, TUILiveConnectionManager.ConnectionRequestCallback callback) {
        if (roomIdList == null) {
            if (callback != null) {
                callback.onError(TUICommonDefine.Error.INVALID_PARAMETER, "roomIdList is null");
            }
            return;
        }
        this.runOnMainThread(TUILiveConnectionManagerImpl$$Lambda$3.lambdaFactory$(this, roomIdList, timeout, extensionInfo, callback));
    }

    @Override
    public void cancelConnectionRequest(List<String> roomIdList, TUIRoomDefine.ActionCallback callback) {
        if (roomIdList == null) {
            if (callback != null) {
                callback.onError(TUICommonDefine.Error.INVALID_PARAMETER, "roomIdList is null");
            }
            return;
        }
        this.runOnMainThread(TUILiveConnectionManagerImpl$$Lambda$4.lambdaFactory$(this, roomIdList, callback));
    }

    @Override
    public void acceptConnection(String roomId, TUIRoomDefine.ActionCallback callback) {
        this.runOnMainThread(TUILiveConnectionManagerImpl$$Lambda$5.lambdaFactory$(this, roomId, callback));
    }

    @Override
    public void rejectConnection(String roomId, TUIRoomDefine.ActionCallback callback) {
        this.runOnMainThread(TUILiveConnectionManagerImpl$$Lambda$6.lambdaFactory$(this, roomId, callback));
    }

    @Override
    public void disconnect(TUIRoomDefine.ActionCallback callback) {
        this.runOnMainThread(TUILiveConnectionManagerImpl$$Lambda$7.lambdaFactory$(this, callback));
    }

    public void destroy() {
        this.runOnMainThread(TUILiveConnectionManagerImpl$$Lambda$8.lambdaFactory$(this));
    }

    private static native void nativeSetObserver(long var0, Object var2);

    private static native void nativeRequestConnection(long var0, String[] var2, int var3, String var4, ConnectionRequestCallbackJni var5);

    private static native void nativeCancelConnectionRequest(long var0, String[] var2, ActionCallbackJni var3);

    private static native void nativeAcceptConnection(long var0, String var2, ActionCallbackJni var3);

    private static native void nativeRejectConnection(long var0, String var2, ActionCallbackJni var3);

    private static native void nativeDisconnect(long var0, ActionCallbackJni var2);

    @CalledByNative
    private void onConnectionUserListChanged(String connectedListStr, String joinedListStr, String leavedListStr) {
        List<TUILiveConnectionManager.Observer> observers = this.copyOnReadListeners();
        if (observers.isEmpty()) {
            return;
        }
        List<TUILiveConnectionManager.ConnectionUser> connectedList = TUILiveConnectionManagerImpl.convertJsonToConnectionUserList(connectedListStr);
        List<TUILiveConnectionManager.ConnectionUser> joinedList = TUILiveConnectionManagerImpl.convertJsonToConnectionUserList(joinedListStr);
        List<TUILiveConnectionManager.ConnectionUser> leavedList = TUILiveConnectionManagerImpl.convertJsonToConnectionUserList(leavedListStr);
        for (TUILiveConnectionManager.Observer observer : observers) {
            observer.onConnectionUserListChanged(connectedList, joinedList, leavedList);
        }
    }

    @CalledByNative
    private void onConnectionRequestReceived(String inviterStr, String inviteeListStr, String extensionInfo) {
        List<TUILiveConnectionManager.Observer> observers = this.copyOnReadListeners();
        if (observers.isEmpty()) {
            return;
        }
        TUILiveConnectionManager.ConnectionUser inviter = TUILiveConnectionManagerImpl.convertJsonToConnectionUser(inviterStr);
        List<TUILiveConnectionManager.ConnectionUser> inviteeList = TUILiveConnectionManagerImpl.convertJsonToConnectionUserList(inviteeListStr);
        for (TUILiveConnectionManager.Observer observer : observers) {
            observer.onConnectionRequestReceived(inviter, inviteeList, extensionInfo);
        }
    }

    @CalledByNative
    private void onConnectionRequestCancelled(String inviterStr) {
        List<TUILiveConnectionManager.Observer> observers = this.copyOnReadListeners();
        if (observers.isEmpty()) {
            return;
        }
        TUILiveConnectionManager.ConnectionUser inviter = TUILiveConnectionManagerImpl.convertJsonToConnectionUser(inviterStr);
        for (TUILiveConnectionManager.Observer observer : observers) {
            observer.onConnectionRequestCancelled(inviter);
        }
    }

    @CalledByNative
    private void onConnectionRequestAccept(String inviteeStr) {
        List<TUILiveConnectionManager.Observer> observers = this.copyOnReadListeners();
        if (observers.isEmpty()) {
            return;
        }
        TUILiveConnectionManager.ConnectionUser invitee = TUILiveConnectionManagerImpl.convertJsonToConnectionUser(inviteeStr);
        for (TUILiveConnectionManager.Observer observer : observers) {
            observer.onConnectionRequestAccept(invitee);
        }
    }

    @CalledByNative
    private void onConnectionRequestReject(String inviteeStr) {
        List<TUILiveConnectionManager.Observer> observers = this.copyOnReadListeners();
        if (observers.isEmpty()) {
            return;
        }
        TUILiveConnectionManager.ConnectionUser invitee = TUILiveConnectionManagerImpl.convertJsonToConnectionUser(inviteeStr);
        for (TUILiveConnectionManager.Observer observer : observers) {
            observer.onConnectionRequestReject(invitee);
        }
    }

    @CalledByNative
    private void onConnectionRequestTimeout(String inviterStr, String inviteeStr) {
        List<TUILiveConnectionManager.Observer> observers = this.copyOnReadListeners();
        if (observers.isEmpty()) {
            return;
        }
        TUILiveConnectionManager.ConnectionUser inviter = TUILiveConnectionManagerImpl.convertJsonToConnectionUser(inviterStr);
        TUILiveConnectionManager.ConnectionUser invitee = TUILiveConnectionManagerImpl.convertJsonToConnectionUser(inviteeStr);
        for (TUILiveConnectionManager.Observer observer : observers) {
            observer.onConnectionRequestTimeout(inviter, invitee);
        }
    }

    private void runOnMainThread(Runnable runnable) {
        this.mMainHandler.post(runnable);
    }

    private List<TUILiveConnectionManager.Observer> copyOnReadListeners() {
        return new CopyOnWriteArrayList<TUILiveConnectionManager.Observer>(this.mObserverList);
    }

    private static List<TUILiveConnectionManager.ConnectionUser> convertJsonToConnectionUserList(String jsonStr) {
        ArrayList<TUILiveConnectionManager.ConnectionUser> connectionUserList = new ArrayList<TUILiveConnectionManager.ConnectionUser>();
        if (jsonStr != null) {
            try {
                JSONArray jsonArray = new JSONArray(jsonStr);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    TUILiveConnectionManager.ConnectionUser user = TUILiveConnectionManagerImpl.convertJsonToConnectionUser(jsonArray.getString(i));
                    if (user == null) continue;
                    connectionUserList.add(user);
                }
            }
            catch (JSONException e) {
                LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
            }
        }
        return connectionUserList;
    }

    private static TUILiveConnectionManager.ConnectionUser convertJsonToConnectionUser(String jsonStr) {
        if (TextUtils.isEmpty((CharSequence)jsonStr)) {
            return null;
        }
        TUILiveConnectionManager.ConnectionUser user = new TUILiveConnectionManager.ConnectionUser();
        try {
            JSONObject jsonObject = new JSONObject(jsonStr);
            user.userId = jsonObject.getString("userId");
            user.userName = jsonObject.getString("userName");
            user.avatarUrl = jsonObject.getString("avatarUrl");
            user.roomId = jsonObject.getString("roomId");
            user.joinConnectionTime = jsonObject.getLong("joinConnectionTime");
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
            return null;
        }
        return user;
    }

    static /* synthetic */ void lambda$destroy$7(TUILiveConnectionManagerImpl this_) {
        this_.mObserverList.clear();
        this_.mNativeLiveConnectionManagerJni = 0L;
    }

    static /* synthetic */ void lambda$disconnect$6(TUILiveConnectionManagerImpl this_, TUIRoomDefine.ActionCallback callback) {
        if (this_.mNativeLiveConnectionManagerJni != 0L) {
            TUILiveConnectionManagerImpl.nativeDisconnect(this_.mNativeLiveConnectionManagerJni, new ActionCallbackJni(callback));
        }
    }

    static /* synthetic */ void lambda$rejectConnection$5(TUILiveConnectionManagerImpl this_, String roomId, TUIRoomDefine.ActionCallback callback) {
        if (this_.mNativeLiveConnectionManagerJni != 0L) {
            TUILiveConnectionManagerImpl.nativeRejectConnection(this_.mNativeLiveConnectionManagerJni, roomId, new ActionCallbackJni(callback));
        }
    }

    static /* synthetic */ void lambda$acceptConnection$4(TUILiveConnectionManagerImpl this_, String roomId, TUIRoomDefine.ActionCallback callback) {
        if (this_.mNativeLiveConnectionManagerJni != 0L) {
            TUILiveConnectionManagerImpl.nativeAcceptConnection(this_.mNativeLiveConnectionManagerJni, roomId, new ActionCallbackJni(callback));
        }
    }

    static /* synthetic */ void lambda$cancelConnectionRequest$3(TUILiveConnectionManagerImpl this_, List roomIdList, TUIRoomDefine.ActionCallback callback) {
        if (this_.mNativeLiveConnectionManagerJni != 0L) {
            TUILiveConnectionManagerImpl.nativeCancelConnectionRequest(this_.mNativeLiveConnectionManagerJni, roomIdList.toArray(new String[0]), new ActionCallbackJni(callback));
        }
    }

    static /* synthetic */ void lambda$requestConnection$2(TUILiveConnectionManagerImpl this_, List roomIdList, int timeout, String extensionInfo, TUILiveConnectionManager.ConnectionRequestCallback callback) {
        if (this_.mNativeLiveConnectionManagerJni != 0L) {
            TUILiveConnectionManagerImpl.nativeRequestConnection(this_.mNativeLiveConnectionManagerJni, roomIdList.toArray(new String[0]), timeout, extensionInfo, new ConnectionRequestCallbackJni(callback));
        }
    }

    static /* synthetic */ void lambda$removeObserver$1(TUILiveConnectionManagerImpl this_, TUILiveConnectionManager.Observer observer) {
        this_.mObserverList.remove(observer);
    }

    static /* synthetic */ void lambda$addObserver$0(TUILiveConnectionManagerImpl this_, TUILiveConnectionManager.Observer observer) {
        if (!this_.mObserverList.contains(observer)) {
            this_.mObserverList.add(observer);
        }
    }

    private static class ActionCallbackJni {
        private final TUIRoomDefine.ActionCallback mCallback;

        public ActionCallbackJni(TUIRoomDefine.ActionCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="ActionCallbackJni")
        public void onSuccess() {
            if (this.mCallback != null) {
                this.mCallback.onSuccess();
            }
        }

        @CalledByNative(value="ActionCallbackJni")
        public void onError(int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onError(TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }

    private static final class ConnectionRequestCallbackJni {
        private final TUILiveConnectionManager.ConnectionRequestCallback mCallback;

        public ConnectionRequestCallbackJni(TUILiveConnectionManager.ConnectionRequestCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="ConnectionRequestCallbackJni")
        public void onSuccess(String jsonStr) {
            if (this.mCallback != null) {
                HashMap<String, TUILiveConnectionManager.ConnectionCode> resultMap = new HashMap<String, TUILiveConnectionManager.ConnectionCode>();
                try {
                    JSONArray jsonArray = new JSONArray(jsonStr);
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        JSONObject jsonObject = jsonArray.getJSONObject(i);
                        String userId = jsonObject.getString("userId");
                        int errorCode = jsonObject.getInt("errorCode");
                        TUILiveConnectionManager.ConnectionCode code = TUILiveConnectionManager.ConnectionCode.fromInt(errorCode);
                        resultMap.put(userId, code);
                    }
                }
                catch (JSONException e) {
                    LiteavLog.e((String)TUILiveConnectionManagerImpl.TAG, (String)e.getLocalizedMessage());
                }
                this.mCallback.onSuccess(resultMap);
            }
        }

        @CalledByNative(value="ConnectionRequestCallbackJni")
        public void onError(int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onError(TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }
}

