/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.extension.internal;

import com.tencent.cloud.tuikit.engine.common.TUICommonDefine;
import com.tencent.cloud.tuikit.engine.extension.TUIConferenceListManager;
import com.tencent.cloud.tuikit.engine.room.TUIRoomDefine;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@JNINamespace(value="tuikit::extension")
public class TUIConferenceListManagerJni {
    private static final String TAG = "TUIConferenceListManagerJni";
    private long mNativeTUIConferenceListManagerJni;
    private final List<TUIConferenceListManager.Observer> mObserverList = new CopyOnWriteArrayList<TUIConferenceListManager.Observer>();

    public TUIConferenceListManagerJni(long nativeConferenceListManagerJni) {
        this.mNativeTUIConferenceListManagerJni = nativeConferenceListManagerJni;
        if (this.mNativeTUIConferenceListManagerJni != 0L) {
            TUIConferenceListManagerJni.nativeSetObserver(this.mNativeTUIConferenceListManagerJni, this);
        }
    }

    public void addObserver(TUIConferenceListManager.Observer observer) {
        if (observer == null || this.mObserverList.contains(observer)) {
            return;
        }
        this.mObserverList.add(observer);
    }

    public void removeObserver(TUIConferenceListManager.Observer observer) {
        if (observer == null) {
            return;
        }
        this.mObserverList.remove(observer);
    }

    public void scheduleConference(TUIConferenceListManager.ConferenceInfo conferenceInfo, TUIRoomDefine.ActionCallback callback) {
        if (this.isConferenceListManagerNull(callback)) {
            return;
        }
        try {
            String conferenceInfoStr = TUIConferenceListManagerJni.convertConferenceInfoToJSON(conferenceInfo).toString();
            TUIConferenceListManagerJni.nativeScheduleConference(this.mNativeTUIConferenceListManagerJni, conferenceInfoStr, new ActionCallback(callback));
        }
        catch (JSONException e) {
            callback.onError(TUICommonDefine.Error.FAILED, "conferenceInfo convert error");
        }
    }

    public void cancelConference(String conferenceId, TUIRoomDefine.ActionCallback callback) {
        if (this.isConferenceListManagerNull(callback)) {
            return;
        }
        TUIConferenceListManagerJni.nativeCancelConference(this.mNativeTUIConferenceListManagerJni, conferenceId, new ActionCallback(callback));
    }

    public void updateConferenceInfo(TUIConferenceListManager.ConferenceInfo conferenceInfo, List<TUIConferenceListManager.ConferenceModifyFlag> modifyFlagList, TUIRoomDefine.ActionCallback callback) {
        if (this.isConferenceListManagerNull(callback)) {
            return;
        }
        if (modifyFlagList == null) {
            callback.onError(TUICommonDefine.Error.INVALID_PARAMETER, "modifyFlagList is null");
            return;
        }
        int flag = 0;
        for (TUIConferenceListManager.ConferenceModifyFlag conferenceModifyFlag : modifyFlagList) {
            flag |= conferenceModifyFlag.getValue();
        }
        try {
            String conferenceInfoStr = TUIConferenceListManagerJni.convertConferenceInfoToJSON(conferenceInfo).toString();
            TUIConferenceListManagerJni.nativeUpdateConferenceInfo(this.mNativeTUIConferenceListManagerJni, conferenceInfoStr, flag, new ActionCallback(callback));
        }
        catch (JSONException e) {
            callback.onError(TUICommonDefine.Error.FAILED, "conferenceInfo convert error");
        }
    }

    public void fetchScheduledConferenceList(List<TUIConferenceListManager.ConferenceStatus> statusFilter, String cursor, int count, TUIConferenceListManager.FetchScheduledConferenceListCallback callback) {
        if (this.mNativeTUIConferenceListManagerJni == 0L) {
            if (callback != null) {
                callback.onError(TUICommonDefine.Error.FAILED, "conferenceListManager is null");
            }
            return;
        }
        int status = 0;
        for (TUIConferenceListManager.ConferenceStatus conferenceStatus : statusFilter) {
            status |= conferenceStatus.getValue();
        }
        TUIConferenceListManagerJni.nativeFetchScheduledConferenceList(this.mNativeTUIConferenceListManagerJni, status, cursor, count, new FetchScheduledConferenceListCallback(callback));
    }

    public void fetchAttendeeList(String conferenceId, String cursor, int count, TUIConferenceListManager.FetchScheduledAttendeesCallback callback) {
        if (this.mNativeTUIConferenceListManagerJni == 0L) {
            if (callback != null) {
                callback.onError(TUICommonDefine.Error.FAILED, "conferenceListManager is null");
            }
            return;
        }
        TUIConferenceListManagerJni.nativeFetchAttendeeList(this.mNativeTUIConferenceListManagerJni, conferenceId, cursor, count, new FetchScheduledAttendeesCallback(callback));
    }

    public void addAttendeesByAdmin(String conferenceId, List<String> userIdList, TUIRoomDefine.ActionCallback callback) {
        if (this.isConferenceListManagerNull(callback)) {
            return;
        }
        TUIConferenceListManagerJni.nativeAddAttendeesByAdmin(this.mNativeTUIConferenceListManagerJni, conferenceId, userIdList.toArray(new String[0]), new ActionCallback(callback));
    }

    public void removeAttendeesByAdmin(String conferenceId, List<String> userIdList, TUIRoomDefine.ActionCallback callback) {
        if (this.isConferenceListManagerNull(callback)) {
            return;
        }
        TUIConferenceListManagerJni.nativeRemoveAttendeesByAdmin(this.mNativeTUIConferenceListManagerJni, conferenceId, userIdList.toArray(new String[0]), new ActionCallback(callback));
    }

    private static native void nativeSetObserver(long var0, Object var2);

    private static native void nativeScheduleConference(long var0, String var2, ActionCallback var3);

    private static native void nativeCancelConference(long var0, String var2, ActionCallback var3);

    private static native void nativeUpdateConferenceInfo(long var0, String var2, int var3, ActionCallback var4);

    private static native void nativeFetchScheduledConferenceList(long var0, int var2, String var3, int var4, FetchScheduledConferenceListCallback var5);

    private static native void nativeFetchAttendeeList(long var0, String var2, String var3, int var4, FetchScheduledAttendeesCallback var5);

    private static native void nativeAddAttendeesByAdmin(long var0, String var2, String[] var3, ActionCallback var4);

    private static native void nativeRemoveAttendeesByAdmin(long var0, String var2, String[] var3, ActionCallback var4);

    @CalledByNative
    public void onConferenceScheduled(String conferenceInfoStr) {
        for (TUIConferenceListManager.Observer observer : this.copyOnReadListeners()) {
            observer.onConferenceScheduled(this.convertToConferenceInfo(conferenceInfoStr));
        }
    }

    @CalledByNative
    public void onConferenceWillStart(String conferenceInfoStr) {
        for (TUIConferenceListManager.Observer observer : this.copyOnReadListeners()) {
            observer.onConferenceWillStart(this.convertToConferenceInfo(conferenceInfoStr));
        }
    }

    @CalledByNative
    public void onConferenceCancelled(String conferenceId, int reason, String operateUserStr) {
        for (TUIConferenceListManager.Observer observer : this.copyOnReadListeners()) {
            observer.onConferenceCancelled(conferenceId, TUIConferenceListManager.ConferenceCancelReason.fromInt(reason), this.convertToUserInfo(operateUserStr));
        }
    }

    @CalledByNative
    public void onConferenceInfoChanged(String conferenceInfoStr, int modifyFlag) {
        ArrayList<TUIConferenceListManager.ConferenceModifyFlag> modifyFlagList = new ArrayList<TUIConferenceListManager.ConferenceModifyFlag>();
        if ((modifyFlag & TUIConferenceListManager.ConferenceModifyFlag.SCHEDULE_START_TIME.getValue()) != 0) {
            modifyFlagList.add(TUIConferenceListManager.ConferenceModifyFlag.SCHEDULE_START_TIME);
        }
        if ((modifyFlag & TUIConferenceListManager.ConferenceModifyFlag.SCHEDULE_END_TIME.getValue()) != 0) {
            modifyFlagList.add(TUIConferenceListManager.ConferenceModifyFlag.SCHEDULE_END_TIME);
        }
        if ((modifyFlag & TUIConferenceListManager.ConferenceModifyFlag.ROOM_NAME.getValue()) != 0) {
            modifyFlagList.add(TUIConferenceListManager.ConferenceModifyFlag.ROOM_NAME);
        }
        for (TUIConferenceListManager.Observer observer : this.copyOnReadListeners()) {
            observer.onConferenceInfoChanged(this.convertToConferenceInfo(conferenceInfoStr), modifyFlagList);
        }
    }

    @CalledByNative
    public void onScheduleAttendeesChanged(String conferenceId, String leftUsersStr, String joinedUsersStr) {
        for (TUIConferenceListManager.Observer observer : this.copyOnReadListeners()) {
            observer.onScheduleAttendeesChanged(conferenceId, this.convertToUserInfoList(leftUsersStr), this.convertToUserInfoList(joinedUsersStr));
        }
    }

    @CalledByNative
    public void onConferenceStatusChanged(String conferenceId, int status) {
        for (TUIConferenceListManager.Observer observer : this.copyOnReadListeners()) {
            observer.onConferenceStatusChanged(conferenceId, TUIConferenceListManager.ConferenceStatus.fromInt(status));
        }
    }

    @CalledByNative
    public static TUIConferenceListManager.ScheduledAttendeesResult createAttendeesResult(int totalCount, String cursor, String userInfoListStr) {
        TUIConferenceListManager.ScheduledAttendeesResult result = new TUIConferenceListManager.ScheduledAttendeesResult();
        result.cursor = cursor;
        result.totalAttendeeCount = totalCount;
        try {
            JSONArray jsonArray = new JSONArray(userInfoListStr);
            result.scheduleAttendees = TUIConferenceListManagerJni.convertJSONToUserInfoList(jsonArray);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
            result.scheduleAttendees = new ArrayList<TUIRoomDefine.UserInfo>();
        }
        return result;
    }

    private static TUIConferenceListManager.ConferenceInfo convertJSONToConferenceInfo(JSONObject conferenceInfoObject) throws JSONException {
        TUIConferenceListManager.ConferenceInfo conferenceInfo = new TUIConferenceListManager.ConferenceInfo();
        conferenceInfo.scheduleStartTime = conferenceInfoObject.getLong("scheduleStartTime") * 1000L;
        conferenceInfo.scheduleEndTime = conferenceInfoObject.getLong("scheduleEndTime") * 1000L;
        conferenceInfo.reminderSecondsBeforeStart = conferenceInfoObject.getInt("reminderSecondsBeforeStart");
        conferenceInfo.status = TUIConferenceListManager.ConferenceStatus.fromInt(conferenceInfoObject.getInt("status"));
        TUIRoomDefine.RoomInfo roomInfo = new TUIRoomDefine.RoomInfo();
        JSONObject roomInfoObject = conferenceInfoObject.getJSONObject("basicRoomInfo");
        roomInfo.roomId = roomInfoObject.getString("roomId");
        roomInfo.ownerId = roomInfoObject.getString("ownerId");
        roomInfo.ownerName = roomInfoObject.getString("ownerName");
        roomInfo.ownerAvatarUrl = roomInfoObject.getString("ownerAvatarUrl");
        roomInfo.roomType = TUIRoomDefine.RoomType.fromInt(roomInfoObject.getInt("roomType"));
        roomInfo.name = roomInfoObject.getString("roomName");
        roomInfo.isCameraDisableForAllUser = roomInfoObject.getBoolean("cameraDisable");
        roomInfo.isMicrophoneDisableForAllUser = roomInfoObject.getBoolean("microphoneDisable");
        roomInfo.isScreenShareDisableForAllUser = roomInfoObject.getBoolean("screenShareDisable");
        roomInfo.isMessageDisableForAllUser = roomInfoObject.getBoolean("messageDisable");
        roomInfo.isSeatEnabled = roomInfoObject.getBoolean("isSeatEnabled");
        roomInfo.seatMode = TUIRoomDefine.SeatMode.fromInt(roomInfoObject.getInt("seatMode"));
        roomInfo.maxSeatCount = roomInfoObject.getInt("maxSeatCount");
        roomInfo.password = roomInfoObject.optString("password");
        roomInfo.createTime = roomInfoObject.getLong("createTime") * 1000L;
        roomInfo.memberCount = roomInfoObject.getInt("roomMemberCount");
        conferenceInfo.basicRoomInfo = roomInfo;
        return conferenceInfo;
    }

    private static List<TUIConferenceListManager.ConferenceInfo> convertJSONToConferenceList(JSONArray jsonArray) throws JSONException {
        ArrayList<TUIConferenceListManager.ConferenceInfo> conferenceInfoList = new ArrayList<TUIConferenceListManager.ConferenceInfo>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject object = new JSONObject(jsonArray.getString(i));
            TUIConferenceListManager.ConferenceInfo conferenceInfo = TUIConferenceListManagerJni.convertJSONToConferenceInfo(object);
            conferenceInfoList.add(conferenceInfo);
        }
        return conferenceInfoList;
    }

    private static JSONObject convertConferenceInfoToJSON(TUIConferenceListManager.ConferenceInfo conferenceInfo) throws JSONException {
        JSONObject conferenceInfoObject = new JSONObject();
        conferenceInfoObject.put("scheduleStartTime", conferenceInfo.scheduleStartTime / 1000L);
        conferenceInfoObject.put("scheduleEndTime", conferenceInfo.scheduleEndTime / 1000L);
        conferenceInfoObject.put("reminderSecondsBeforeStart", conferenceInfo.reminderSecondsBeforeStart);
        JSONArray attendeesArray = new JSONArray();
        for (String userId : conferenceInfo.scheduleAttendees) {
            attendeesArray.put((Object)userId);
        }
        conferenceInfoObject.put("scheduleAttendees", (Object)attendeesArray);
        if (conferenceInfo.basicRoomInfo != null) {
            JSONObject roomInfoObject = new JSONObject();
            roomInfoObject.put("roomId", (Object)conferenceInfo.basicRoomInfo.roomId);
            roomInfoObject.put("ownerId", (Object)conferenceInfo.basicRoomInfo.ownerId);
            roomInfoObject.put("ownerName", (Object)conferenceInfo.basicRoomInfo.ownerName);
            roomInfoObject.put("ownerAvatarUrl", (Object)conferenceInfo.basicRoomInfo.ownerAvatarUrl);
            roomInfoObject.put("roomType", conferenceInfo.basicRoomInfo.roomType.getValue());
            roomInfoObject.put("roomName", (Object)conferenceInfo.basicRoomInfo.name);
            roomInfoObject.put("cameraDisable", conferenceInfo.basicRoomInfo.isCameraDisableForAllUser);
            roomInfoObject.put("microphoneDisable", conferenceInfo.basicRoomInfo.isMicrophoneDisableForAllUser);
            roomInfoObject.put("screenShareDisable", conferenceInfo.basicRoomInfo.isScreenShareDisableForAllUser);
            roomInfoObject.put("messageDisable", conferenceInfo.basicRoomInfo.isMessageDisableForAllUser);
            roomInfoObject.put("isSeatEnabled", conferenceInfo.basicRoomInfo.isSeatEnabled);
            roomInfoObject.put("seatMode", conferenceInfo.basicRoomInfo.seatMode.getValue());
            roomInfoObject.put("maxSeatCount", conferenceInfo.basicRoomInfo.maxSeatCount);
            roomInfoObject.put("password", (Object)conferenceInfo.basicRoomInfo.password);
            roomInfoObject.put("createTime", conferenceInfo.basicRoomInfo.createTime);
            roomInfoObject.put("roomMemberCount", conferenceInfo.basicRoomInfo.memberCount);
            conferenceInfoObject.put("basicRoomInfo", (Object)roomInfoObject);
        }
        return conferenceInfoObject;
    }

    private static List<TUIRoomDefine.UserInfo> convertJSONToUserInfoList(JSONArray jsonArray) throws JSONException {
        ArrayList<TUIRoomDefine.UserInfo> userInfoList = new ArrayList<TUIRoomDefine.UserInfo>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            userInfoList.add(TUIConferenceListManagerJni.convertJSONToUserInfo(new JSONObject(jsonArray.getString(i))));
        }
        return userInfoList;
    }

    private static List<String> convertJSONToUserIdList(JSONArray jsonArray) throws JSONException {
        ArrayList<String> userIdList = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            userIdList.add(jsonArray.getString(i));
        }
        return userIdList;
    }

    private static TUIRoomDefine.UserInfo convertJSONToUserInfo(JSONObject jsonObject) throws JSONException {
        TUIRoomDefine.UserInfo userInfo = new TUIRoomDefine.UserInfo();
        userInfo.userId = jsonObject.getString("userId");
        userInfo.userName = jsonObject.getString("userName");
        userInfo.nameCard = jsonObject.getString("nameCard");
        userInfo.avatarUrl = jsonObject.getString("avatarUrl");
        userInfo.userRole = TUIRoomDefine.Role.fromInt(jsonObject.getInt("userRole"));
        userInfo.hasAudioStream = jsonObject.getBoolean("hasAudioStream");
        userInfo.hasVideoStream = jsonObject.getBoolean("hasVideoStream");
        userInfo.hasScreenStream = jsonObject.getBoolean("hasScreenStream");
        userInfo.isMessageDisabled = jsonObject.getBoolean("isMessageDisabled");
        return userInfo;
    }

    @CalledByNative
    public static TUIConferenceListManager.ScheduledConferenceListResult createConferenceListResult(String cursor, String conferenceListStr) {
        TUIConferenceListManager.ScheduledConferenceListResult result = new TUIConferenceListManager.ScheduledConferenceListResult();
        result.cursor = cursor;
        try {
            JSONArray jsonArray = new JSONArray(conferenceListStr);
            result.conferenceInfoList = TUIConferenceListManagerJni.convertJSONToConferenceList(jsonArray);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
            result.conferenceInfoList = new ArrayList<TUIConferenceListManager.ConferenceInfo>();
        }
        return result;
    }

    private List<TUIConferenceListManager.Observer> copyOnReadListeners() {
        return new CopyOnWriteArrayList<TUIConferenceListManager.Observer>(this.mObserverList);
    }

    private TUIConferenceListManager.ConferenceInfo convertToConferenceInfo(String jsonStr) {
        TUIConferenceListManager.ConferenceInfo conferenceInfo;
        try {
            JSONObject jsonObject = new JSONObject(jsonStr);
            conferenceInfo = TUIConferenceListManagerJni.convertJSONToConferenceInfo(jsonObject);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
            conferenceInfo = new TUIConferenceListManager.ConferenceInfo();
        }
        return conferenceInfo;
    }

    private TUIRoomDefine.UserInfo convertToUserInfo(String jsonStr) {
        TUIRoomDefine.UserInfo userInfo;
        try {
            JSONObject jsonObject = new JSONObject(jsonStr);
            userInfo = TUIConferenceListManagerJni.convertJSONToUserInfo(jsonObject);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
            userInfo = new TUIRoomDefine.UserInfo();
        }
        return userInfo;
    }

    private List<TUIRoomDefine.UserInfo> convertToUserInfoList(String jsonStr) {
        List<TUIRoomDefine.UserInfo> userInfoList;
        try {
            JSONArray jsonArray = new JSONArray(jsonStr);
            userInfoList = TUIConferenceListManagerJni.convertJSONToUserInfoList(jsonArray);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
            userInfoList = new ArrayList<TUIRoomDefine.UserInfo>();
        }
        return userInfoList;
    }

    private boolean isConferenceListManagerNull(TUIRoomDefine.ActionCallback callback) {
        if (this.mNativeTUIConferenceListManagerJni == 0L) {
            if (callback != null) {
                callback.onError(TUICommonDefine.Error.FAILED, "conferenceListManager is null");
            }
            return true;
        }
        return false;
    }

    static class FetchScheduledConferenceListCallback {
        private TUIConferenceListManager.FetchScheduledConferenceListCallback mCallback;

        public FetchScheduledConferenceListCallback(TUIConferenceListManager.FetchScheduledConferenceListCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="FetchScheduledConferenceListCallback")
        public void onSuccess(TUIConferenceListManager.ScheduledConferenceListResult result) {
            if (this.mCallback != null) {
                this.mCallback.onSuccess(result);
            }
        }

        @CalledByNative(value="FetchScheduledConferenceListCallback")
        public void onError(int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onError(TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }

    static class FetchScheduledAttendeesCallback {
        private TUIConferenceListManager.FetchScheduledAttendeesCallback mCallback;

        public FetchScheduledAttendeesCallback(TUIConferenceListManager.FetchScheduledAttendeesCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="FetchScheduledAttendeesCallback")
        public void onSuccess(TUIConferenceListManager.ScheduledAttendeesResult result) {
            if (this.mCallback != null) {
                this.mCallback.onSuccess(result);
            }
        }

        @CalledByNative(value="FetchScheduledAttendeesCallback")
        public void onError(int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onError(TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }

    static class ActionCallback {
        private TUIRoomDefine.ActionCallback mCallback;

        public ActionCallback(TUIRoomDefine.ActionCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="ActionCallback")
        public void onSuccess() {
            if (this.mCallback != null) {
                this.mCallback.onSuccess();
            }
        }

        @CalledByNative(value="ActionCallback")
        public void onError(int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onError(TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }
}

