/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.extension.internal;

import com.tencent.cloud.tuikit.engine.common.TUICommonDefine;
import com.tencent.cloud.tuikit.engine.common.internal.TUIDefineConvert;
import com.tencent.cloud.tuikit.engine.extension.TUIConferenceInvitationManager;
import com.tencent.cloud.tuikit.engine.room.TUIRoomDefine;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@JNINamespace(value="tuikit::extension")
public class TUIConferenceInvitationManagerJni {
    private static final String TAG = "TUIConferenceInvitationManagerJni";
    private long mNativeTUIConferenceInvitationManagerJni;
    private static final String INVITEE = "invitee";
    private static final String INVITER = "inviter";
    private final List<TUIConferenceInvitationManager.Observer> mObserverList = new CopyOnWriteArrayList<TUIConferenceInvitationManager.Observer>();

    public TUIConferenceInvitationManagerJni(long nativeConferenceInvitationManagerJni) {
        this.mNativeTUIConferenceInvitationManagerJni = nativeConferenceInvitationManagerJni;
        if (this.mNativeTUIConferenceInvitationManagerJni != 0L) {
            TUIConferenceInvitationManagerJni.nativeSetObserver(this.mNativeTUIConferenceInvitationManagerJni, this);
        }
    }

    public void addObserver(TUIConferenceInvitationManager.Observer observer) {
        if (observer == null || this.mObserverList.contains(observer)) {
            return;
        }
        this.mObserverList.add(observer);
    }

    public void removeObserver(TUIConferenceInvitationManager.Observer observer) {
        if (observer == null) {
            return;
        }
        this.mObserverList.remove(observer);
    }

    public void inviteUsers(String roomId, List<String> userIdList, int timeout, String extensionInfo, TUIConferenceInvitationManager.InviteUsersCallback callback) {
        if (this.mNativeTUIConferenceInvitationManagerJni == 0L) {
            if (callback != null) {
                callback.onError(TUICommonDefine.Error.FAILED, "conferenceListManager is null");
            }
            return;
        }
        TUIConferenceInvitationManagerJni.nativeInviteUsers(this.mNativeTUIConferenceInvitationManagerJni, roomId, userIdList.toArray(new String[0]), timeout, extensionInfo, new InviteUsersCallback(callback));
    }

    public void cancelInvitation(String roomId, List<String> userIdList, TUIRoomDefine.ActionCallback callback) {
        if (this.isInvitationManagerJniNull(callback)) {
            return;
        }
        TUIConferenceInvitationManagerJni.nativeCancelInvitation(this.mNativeTUIConferenceInvitationManagerJni, roomId, userIdList.toArray(new String[0]), new ActionCallback(callback));
    }

    public void accept(String roomId, TUIRoomDefine.ActionCallback callback) {
        if (this.isInvitationManagerJniNull(callback)) {
            return;
        }
        TUIConferenceInvitationManagerJni.nativeAccept(this.mNativeTUIConferenceInvitationManagerJni, roomId, new ActionCallback(callback));
    }

    public void reject(String roomId, TUIConferenceInvitationManager.RejectedReason reason, TUIRoomDefine.ActionCallback callback) {
        if (this.isInvitationManagerJniNull(callback)) {
            return;
        }
        TUIConferenceInvitationManagerJni.nativeReject(this.mNativeTUIConferenceInvitationManagerJni, roomId, reason.getValue(), new ActionCallback(callback));
    }

    public void getInvitationList(String roomId, String cursor, int count, TUIConferenceInvitationManager.GetInvitationListCallback callback) {
        if (this.mNativeTUIConferenceInvitationManagerJni == 0L) {
            if (callback != null) {
                callback.onError(TUICommonDefine.Error.FAILED, "conferenceListManager is null");
            }
            return;
        }
        TUIConferenceInvitationManagerJni.nativeGetInvitationList(this.mNativeTUIConferenceInvitationManagerJni, roomId, cursor, count, new GetInvitationListCallback(callback));
    }

    private static native void nativeSetObserver(long var0, Object var2);

    private static native void nativeInviteUsers(long var0, String var2, String[] var3, int var4, String var5, InviteUsersCallback var6);

    private static native void nativeCancelInvitation(long var0, String var2, String[] var3, ActionCallback var4);

    private static native void nativeAccept(long var0, String var2, ActionCallback var3);

    private static native void nativeReject(long var0, String var2, int var3, ActionCallback var4);

    private static native void nativeGetInvitationList(long var0, String var2, String var3, int var4, GetInvitationListCallback var5);

    @CalledByNative
    public void onReceiveInvitation(String roomInfoStr, String invitationStr, String extensionInfo) {
        TUIRoomDefine.RoomInfo roomInfo = TUIDefineConvert.convertStringToRoomInfo(roomInfoStr);
        TUIConferenceInvitationManager.Invitation invitation = TUIConferenceInvitationManagerJni.convertStringToInvitation(invitationStr);
        for (TUIConferenceInvitationManager.Observer observer : this.copyOnReadListeners()) {
            observer.onReceiveInvitation(roomInfo, invitation, extensionInfo);
        }
    }

    @CalledByNative
    public void onInvitationHandledByOtherDevice(String roomInfoStr, boolean accepted) {
        TUIRoomDefine.RoomInfo roomInfo = TUIDefineConvert.convertStringToRoomInfo(roomInfoStr);
        for (TUIConferenceInvitationManager.Observer observer : this.copyOnReadListeners()) {
            observer.onInvitationHandledByOtherDevice(roomInfo, accepted);
        }
    }

    @CalledByNative
    public void onInvitationCancelled(String roomInfoStr, String invitationStr) {
        TUIRoomDefine.RoomInfo roomInfo = TUIDefineConvert.convertStringToRoomInfo(roomInfoStr);
        TUIConferenceInvitationManager.Invitation invitation = TUIConferenceInvitationManagerJni.convertStringToInvitation(invitationStr);
        for (TUIConferenceInvitationManager.Observer observer : this.copyOnReadListeners()) {
            observer.onInvitationCancelled(roomInfo, invitation);
        }
    }

    @CalledByNative
    public void onInvitationAccepted(String roomInfoStr, String invitationStr) {
        TUIRoomDefine.RoomInfo roomInfo = TUIDefineConvert.convertStringToRoomInfo(roomInfoStr);
        TUIConferenceInvitationManager.Invitation invitation = TUIConferenceInvitationManagerJni.convertStringToInvitation(invitationStr);
        for (TUIConferenceInvitationManager.Observer observer : this.copyOnReadListeners()) {
            observer.onInvitationAccepted(roomInfo, invitation);
        }
    }

    @CalledByNative
    public void onInvitationRejected(String roomInfoStr, String invitationStr, int reason) {
        TUIRoomDefine.RoomInfo roomInfo = TUIDefineConvert.convertStringToRoomInfo(roomInfoStr);
        TUIConferenceInvitationManager.Invitation invitation = TUIConferenceInvitationManagerJni.convertStringToInvitation(invitationStr);
        for (TUIConferenceInvitationManager.Observer observer : this.copyOnReadListeners()) {
            observer.onInvitationRejected(roomInfo, invitation, TUIConferenceInvitationManager.RejectedReason.fromInt(reason));
        }
    }

    @CalledByNative
    public void onInvitationTimeout(String roomInfoStr, String invitationStr) {
        TUIRoomDefine.RoomInfo roomInfo = TUIDefineConvert.convertStringToRoomInfo(roomInfoStr);
        TUIConferenceInvitationManager.Invitation invitation = TUIConferenceInvitationManagerJni.convertStringToInvitation(invitationStr);
        for (TUIConferenceInvitationManager.Observer observer : this.copyOnReadListeners()) {
            observer.onInvitationTimeout(roomInfo, invitation);
        }
    }

    @CalledByNative
    public void onInvitationRevokedByAdmin(String roomInfoStr, String invitationStr, String adminInfoStr) {
        TUIRoomDefine.RoomInfo roomInfo = TUIDefineConvert.convertStringToRoomInfo(roomInfoStr);
        TUIConferenceInvitationManager.Invitation invitation = TUIConferenceInvitationManagerJni.convertStringToInvitation(invitationStr);
        TUIRoomDefine.UserInfo userInfo = TUIDefineConvert.convertStringToUserInfo(adminInfoStr);
        for (TUIConferenceInvitationManager.Observer observer : this.copyOnReadListeners()) {
            observer.onInvitationRevokedByAdmin(roomInfo, invitation, userInfo);
        }
    }

    @CalledByNative
    public void onInvitationAdded(String roomId, String invitationStr) {
        TUIConferenceInvitationManager.Invitation invitation = TUIConferenceInvitationManagerJni.convertStringToInvitation(invitationStr);
        for (TUIConferenceInvitationManager.Observer observer : this.copyOnReadListeners()) {
            observer.onInvitationAdded(roomId, invitation);
        }
    }

    @CalledByNative
    public void onInvitationRemoved(String roomId, String invitationStr) {
        TUIConferenceInvitationManager.Invitation invitation = TUIConferenceInvitationManagerJni.convertStringToInvitation(invitationStr);
        for (TUIConferenceInvitationManager.Observer observer : this.copyOnReadListeners()) {
            observer.onInvitationRemoved(roomId, invitation);
        }
    }

    @CalledByNative
    public void onInvitationStatusChanged(String roomId, String invitationStr) {
        TUIConferenceInvitationManager.Invitation invitation = TUIConferenceInvitationManagerJni.convertStringToInvitation(invitationStr);
        for (TUIConferenceInvitationManager.Observer observer : this.copyOnReadListeners()) {
            observer.onInvitationStatusChanged(roomId, invitation);
        }
    }

    private List<TUIConferenceInvitationManager.Observer> copyOnReadListeners() {
        return new CopyOnWriteArrayList<TUIConferenceInvitationManager.Observer>(this.mObserverList);
    }

    @CalledByNative
    public static TUIConferenceInvitationManager.InvitationListResult createInvitationListResult(String cursor, String invitationListStr) {
        TUIConferenceInvitationManager.InvitationListResult result = new TUIConferenceInvitationManager.InvitationListResult();
        result.cursor = cursor;
        result.invitationList = TUIConferenceInvitationManagerJni.convertStringToInvitationList(invitationListStr);
        return result;
    }

    private static List<TUIConferenceInvitationManager.Invitation> convertStringToInvitationList(String invitationListStr) {
        ArrayList<TUIConferenceInvitationManager.Invitation> invitationList = new ArrayList<TUIConferenceInvitationManager.Invitation>();
        try {
            JSONArray jsonArray = new JSONArray(invitationListStr);
            for (int i = 0; i < jsonArray.length(); ++i) {
                invitationList.add(TUIConferenceInvitationManagerJni.convertStringToInvitation(jsonArray.getString(i)));
            }
        }
        catch (JSONException jsonException) {
            LiteavLog.e((String)TAG, (String)("convertStringToInvitationList error:" + jsonException.getMessage()));
        }
        return invitationList;
    }

    private static TUIConferenceInvitationManager.Invitation convertStringToInvitation(String invitationStr) {
        TUIConferenceInvitationManager.Invitation invitation = new TUIConferenceInvitationManager.Invitation();
        try {
            JSONObject jsonObject = new JSONObject(invitationStr);
            invitation.status = TUIConferenceInvitationManager.InvitationStatus.fromInt(jsonObject.getInt("status"));
            invitation.invitee = TUIDefineConvert.convertStringToUserInfo(jsonObject.getString(INVITEE));
            invitation.inviter = TUIDefineConvert.convertStringToUserInfo(jsonObject.getString(INVITER));
        }
        catch (JSONException jsonException) {
            LiteavLog.e((String)TAG, (String)("convertStringToInvitation error:" + jsonException.getMessage()));
        }
        return invitation;
    }

    private boolean isInvitationManagerJniNull(TUIRoomDefine.ActionCallback callback) {
        if (this.mNativeTUIConferenceInvitationManagerJni == 0L) {
            if (callback != null) {
                callback.onError(TUICommonDefine.Error.FAILED, "conferenceListManager is null");
            }
            return true;
        }
        return false;
    }

    static class InviteUsersCallback {
        private TUIConferenceInvitationManager.InviteUsersCallback mCallback;

        public InviteUsersCallback(TUIConferenceInvitationManager.InviteUsersCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="InviteUsersCallback")
        public void onSuccess(String resultMapStr) {
            if (this.mCallback != null) {
                HashMap<String, TUIConferenceInvitationManager.InvitationCode> map = new HashMap<String, TUIConferenceInvitationManager.InvitationCode>();
                try {
                    JSONArray jsonArray = new JSONArray(resultMapStr);
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        JSONObject jsonObject = jsonArray.getJSONObject(i);
                        map.put(jsonObject.getString("userId"), TUIConferenceInvitationManager.InvitationCode.fromInt(jsonObject.getInt("errorCode")));
                    }
                }
                catch (JSONException jsonException) {
                    LiteavLog.e((String)TUIConferenceInvitationManagerJni.TAG, (String)("createInvitationCodeMap error:" + jsonException.getMessage()));
                }
                this.mCallback.onSuccess(map);
            }
        }

        @CalledByNative(value="InviteUsersCallback")
        public void onError(int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onError(TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }

    static class GetInvitationListCallback {
        private TUIConferenceInvitationManager.GetInvitationListCallback mCallback;

        public GetInvitationListCallback(TUIConferenceInvitationManager.GetInvitationListCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="GetInvitationListCallback")
        public void onSuccess(TUIConferenceInvitationManager.InvitationListResult result) {
            if (this.mCallback != null) {
                this.mCallback.onSuccess(result);
            }
        }

        @CalledByNative(value="GetInvitationListCallback")
        public void onError(int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onError(TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }

    static class ActionCallback {
        private TUIRoomDefine.ActionCallback mCallback;

        public ActionCallback(TUIRoomDefine.ActionCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="ActionCallback")
        public void onSuccess() {
            if (this.mCallback != null) {
                this.mCallback.onSuccess();
            }
        }

        @CalledByNative(value="ActionCallback")
        public void onError(int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onError(TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }
}

