/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.extension;

import com.tencent.cloud.tuikit.engine.common.TUICommonDefine;
import com.tencent.cloud.tuikit.engine.room.TUIRoomDefine;
import java.util.List;
import java.util.Map;

public abstract class TUILiveBattleManager {
    public abstract void addObserver(Observer var1);

    public abstract void removeObserver(Observer var1);

    public abstract void requestBattle(BattleConfig var1, List<String> var2, int var3, BattleRequestCallback var4);

    public abstract void cancelBattleRequest(String var1, List<String> var2, TUIRoomDefine.ActionCallback var3);

    public abstract void acceptBattle(String var1, TUIRoomDefine.ActionCallback var2);

    public abstract void rejectBattle(String var1, TUIRoomDefine.ActionCallback var2);

    public abstract void exitBattle(String var1, TUIRoomDefine.ActionCallback var2);

    public static abstract class Observer {
        public void onBattleStarted(BattleInfo battleInfo) {
        }

        public void onBattleEnded(BattleInfo battleInfo, BattleStoppedReason reason) {
        }

        public void onUserJoinBattle(String battleId, BattleUser battleUser) {
        }

        public void onUserExitBattle(String battleId, BattleUser battleUser) {
        }

        public void onBattleScoreChanged(String battleId, List<BattleUser> battleUserList) {
        }

        public void onBattleRequestReceived(BattleInfo battleInfo, BattleUser inviter, BattleUser invitee) {
        }

        public void onBattleRequestCancelled(BattleInfo battleInfo, BattleUser inviter, BattleUser invitee) {
        }

        public void onBattleRequestTimeout(BattleInfo battleInfo, BattleUser inviter, BattleUser invitee) {
        }

        public void onBattleRequestAccept(BattleInfo battleInfo, BattleUser inviter, BattleUser invitee) {
        }

        public void onBattleRequestReject(BattleInfo battleInfo, BattleUser inviter, BattleUser invitee) {
        }
    }

    public static interface BattleRequestCallback {
        public void onSuccess(BattleInfo var1, Map<String, BattleCode> var2);

        public void onError(TUICommonDefine.Error var1, String var2);
    }

    public static enum BattleStoppedReason {
        TIME_OVER(0),
        OTHER_EXIT(1);

        int mValue;

        private BattleStoppedReason(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static BattleStoppedReason fromInt(int value) {
            for (BattleStoppedReason reason : BattleStoppedReason.values()) {
                if (reason.mValue != value) continue;
                return reason;
            }
            return TIME_OVER;
        }
    }

    public static enum BattleCode {
        UNKNOWN(-1),
        SUCCESS(0),
        ROOM_NOT_EXISTS(1),
        BATTLING(2),
        BATTLING_OTHER_ROOM(3),
        ROOM_EXIT(4),
        RETRY(5);

        int mValue;

        private BattleCode(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static BattleCode fromInt(int value) {
            for (BattleCode code : BattleCode.values()) {
                if (code.mValue != value) continue;
                return code;
            }
            return SUCCESS;
        }
    }

    public static class BattleInfo {
        public String battleId;
        public BattleConfig config;
        public BattleUser inviter;
        public List<BattleUser> inviteeList;
        public long startTime;
        public long endTime;
    }

    public static class BattleConfig {
        public int duration;
        public boolean needResponse;
        public String extensionInfo;
    }

    public static class BattleUser {
        public String roomId;
        public String userId;
        public String userName;
        public String avatarUrl;
        public int score;
    }
}

