/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.extension;

import com.tencent.cloud.tuikit.engine.common.TUICommonDefine;
import com.tencent.cloud.tuikit.engine.room.TUIRoomDefine;
import java.util.ArrayList;
import java.util.List;

public abstract class TUIConferenceListManager {
    public abstract void addObserver(Observer var1);

    public abstract void removeObserver(Observer var1);

    public abstract void scheduleConference(ConferenceInfo var1, TUIRoomDefine.ActionCallback var2);

    public abstract void cancelConference(String var1, TUIRoomDefine.ActionCallback var2);

    public abstract void updateConferenceInfo(ConferenceInfo var1, List<ConferenceModifyFlag> var2, TUIRoomDefine.ActionCallback var3);

    public abstract void fetchScheduledConferenceList(List<ConferenceStatus> var1, String var2, int var3, FetchScheduledConferenceListCallback var4);

    public abstract void fetchAttendeeList(String var1, String var2, int var3, FetchScheduledAttendeesCallback var4);

    public abstract void addAttendeesByAdmin(String var1, List<String> var2, TUIRoomDefine.ActionCallback var3);

    public abstract void removeAttendeesByAdmin(String var1, List<String> var2, TUIRoomDefine.ActionCallback var3);

    public static abstract class Observer {
        public void onConferenceScheduled(ConferenceInfo conferenceInfo) {
        }

        public void onConferenceWillStart(ConferenceInfo conferenceInfo) {
        }

        public void onConferenceCancelled(String roomId, ConferenceCancelReason reason, TUIRoomDefine.UserInfo operateUser) {
        }

        public void onConferenceInfoChanged(ConferenceInfo conferenceInfo, List<ConferenceModifyFlag> modifyFlagList) {
        }

        public void onScheduleAttendeesChanged(String roomId, List<TUIRoomDefine.UserInfo> leftUsers, List<TUIRoomDefine.UserInfo> joinedUsers) {
        }

        public void onConferenceStatusChanged(String roomId, ConferenceStatus status) {
        }
    }

    public static interface FetchScheduledConferenceListCallback {
        public void onSuccess(ScheduledConferenceListResult var1);

        public void onError(TUICommonDefine.Error var1, String var2);
    }

    public static interface FetchScheduledAttendeesCallback {
        public void onSuccess(ScheduledAttendeesResult var1);

        public void onError(TUICommonDefine.Error var1, String var2);
    }

    public static class ScheduledConferenceListResult {
        public String cursor;
        public List<ConferenceInfo> conferenceInfoList;
    }

    public static class ScheduledAttendeesResult {
        public int totalAttendeeCount;
        public String cursor;
        public List<TUIRoomDefine.UserInfo> scheduleAttendees;
    }

    public static class ConferenceInfo {
        public long scheduleStartTime;
        public long scheduleEndTime;
        public List<String> scheduleAttendees = new ArrayList<String>();
        public int reminderSecondsBeforeStart;
        public ConferenceStatus status = ConferenceStatus.NONE;
        public TUIRoomDefine.RoomInfo basicRoomInfo;
    }

    public static enum ConferenceModifyFlag {
        NONE(0),
        ROOM_NAME(1),
        SCHEDULE_START_TIME(65536),
        SCHEDULE_END_TIME(131072);

        int mValue;

        private ConferenceModifyFlag(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static ConferenceModifyFlag fromInt(int value) {
            for (ConferenceModifyFlag flag : ConferenceModifyFlag.values()) {
                if (flag.mValue != value) continue;
                return flag;
            }
            return NONE;
        }
    }

    public static enum ConferenceCancelReason {
        CANCELLED_BY_ADMIN(0),
        REMOVED_FROM_ATTENDEES(1);

        int mValue;

        private ConferenceCancelReason(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static ConferenceCancelReason fromInt(int value) {
            for (ConferenceCancelReason reason : ConferenceCancelReason.values()) {
                if (reason.mValue != value) continue;
                return reason;
            }
            return CANCELLED_BY_ADMIN;
        }
    }

    public static enum ConferenceStatus {
        NONE(0),
        NOT_STARTED(1),
        RUNNING(2);

        int mValue;

        private ConferenceStatus(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static ConferenceStatus fromInt(int value) {
            for (ConferenceStatus status : ConferenceStatus.values()) {
                if (status.mValue != value) continue;
                return status;
            }
            return NONE;
        }
    }
}

