/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.common;

public class TUICommonDefine {

    public static interface PlayCallback {
        public void onPlaying(String var1);

        public void onLoading(String var1);

        public void onError(String var1, int var2, String var3);
    }

    public static interface ValueCallback<T> {
        public void onSuccess(T var1);

        public void onError(int var1, String var2);
    }

    public static interface Callback {
        public void onSuccess();

        public void onError(int var1, String var2);
    }

    public static class RoomId {
        public int intRoomId;
        public String strRoomId;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RoomId tempRoomId = (RoomId)o;
            return this.intRoomId == tempRoomId.intRoomId;
        }

        public String toString() {
            return "RoomId{intRoomId=" + this.intRoomId + ", strRoomId=" + this.strRoomId + '}';
        }
    }

    public static class VideoEncoderParams {
        public Resolution resolution;
        public ResolutionMode resolutionMode;

        public static enum Resolution {
            Resolution_640_360(1),
            Resolution_960_540(2),
            Resolution_1280_720(3),
            Resolution_1920_1080(4);

            private int value;

            public int getValue() {
                return this.value;
            }

            private Resolution(int value) {
                this.value = value;
            }
        }

        public static enum ResolutionMode {
            Landscape,
            Portrait;

        }
    }

    public static class VideoRenderParams {
        public FillMode fillMode;
        public Rotation rotation;

        public static enum Rotation {
            Rotation_0,
            Rotation_90,
            Rotation_180,
            Rotation_270;

        }

        public static enum FillMode {
            Fill,
            Fit;

        }
    }

    public static class NetworkQualityInfo {
        public String userId;
        public NetworkQuality quality;

        public String toString() {
            return "NetworkQualityInfo{userId=" + this.userId + ", quality=" + (Object)((Object)this.quality) + '}';
        }
    }

    public static enum Camera {
        Front(0),
        Back(1);

        final int mValue;

        private Camera(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static Camera fromInt(int value) {
            for (Camera type : Camera.values()) {
                if (type.mValue != value) continue;
                return type;
            }
            return Front;
        }
    }

    public static enum AudioPlaybackDevice {
        Speakerphone(0),
        Earpiece(1);

        final int mValue;

        private AudioPlaybackDevice(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static AudioPlaybackDevice fromInt(int value) {
            for (AudioPlaybackDevice type : AudioPlaybackDevice.values()) {
                if (type.mValue != value) continue;
                return type;
            }
            return Speakerphone;
        }
    }

    public static class NetworkInfo {
        public String userId;
        public NetworkQuality quality;
        public int upLoss;
        public int downLoss;
        public int delay;
    }

    public static enum ExtensionType {
        DEVICE_MANAGER(1),
        LIVE_LIST_MANAGER(2),
        CONFERENCE_LIST_MANAGER(3),
        CONFERENCE_INVITATION_MANAGER(4),
        LIVE_LAYOUT_MANAGER(5);

        int mValue;

        private ExtensionType(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static ExtensionType fromInt(int value) {
            for (ExtensionType type : ExtensionType.values()) {
                if (type.mValue != value) continue;
                return type;
            }
            return DEVICE_MANAGER;
        }
    }

    public static enum NetworkQuality {
        UNKNOWN(0),
        EXCELLENT(1),
        GOOD(2),
        POOR(3),
        BAD(4),
        VERY_BAD(5),
        DOWN(6);

        int mValue;

        private NetworkQuality(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static NetworkQuality fromInt(int value) {
            for (NetworkQuality quality : NetworkQuality.values()) {
                if (quality.mValue != value) continue;
                return quality;
            }
            return UNKNOWN;
        }
    }

    public static enum Error {
        SUCCESS(0),
        FAILED(-1),
        FREQ_LIMIT(-2),
        REPEAT_OPERATION(-3),
        ROOM_MISMATCH(-4),
        SDKAPPID_NOT_FOUND(-1000),
        INVALID_PARAMETER(-1001),
        SDK_NOT_INITIALIZED(-1002),
        PERMISSION_DENIED(-1003),
        REQUIRE_PAYMENT(-1004),
        CAMERA_START_FAIL(-1100),
        CAMERA_NOT_AUTHORIZED(-1101),
        CAMERA_OCCUPIED(-1102),
        CAMERA_DEVICE_EMPTY(-1103),
        MICROPHONE_START_FAIL(-1104),
        MICROPHONE_NOT_AUTHORIZED(-1105),
        MICROPHONE_OCCUPIED(-1106),
        MICROPHONE_DEVICE_EMPTY(-1107),
        GET_SCREEN_SHARING_TARGET_FAILED(-1108),
        START_SCREEN_SHARING_FAILED(-1109),
        OPERATION_INVALID_BEFORE_ENTER_ROOM(-2101),
        EXIT_NOT_SUPPORTED_FOR_ROOM_OWNER(-2102),
        OPERATION_NOT_SUPPORTED_IN_CURRENT_ROOM_TYPE(-2103),
        ROOM_ID_INVALID(-2105),
        ROOM_NAME_INVALID(-2107),
        ALREADY_IN_OTHER_ROOM(-2108),
        USER_NOT_EXIST(-2200),
        NEED_OWNER_PERMISSION(-2300),
        NEED_ADMIN_PERMISSION(-2301),
        REQUEST_NO_PERMISSION(-2310),
        REQUEST_ID_INVALID(-2311),
        REQUEST_ID_REPEAT(-2312),
        MAX_SEAT_COUNT_LIMIT(-2340),
        SEAT_INDEX_NOT_EXIST(-2344),
        OPEN_MICROPHONE_NEED_SEAT_UNLOCK(-2360),
        OPEN_MICROPHONE_NEED_PERMISSION_FROM_ADMIN(-2361),
        OPEN_CAMERA_NEED_SEAT_UNLOCK(-2370),
        OPEN_CAMERA_NEED_PERMISSION_FROM_ADMIN(-2371),
        OPEN_SCREEN_SHARE_NEED_SEAT_UNLOCK(-2372),
        OPEN_SCREEN_SHARE_NEED_PERMISSION_FROM_ADMIN(-2373),
        SEND_MESSAGE_DISABLED_FOR_ALL(-2380),
        SEND_MESSAGE_DISABLED_FOR_CURRENT(-2381),
        ROOM_NOT_SUPPORT_PRELOADING(-4001),
        ROOM_ID_OCCUPIED(100003),
        ROOM_ID_NOT_EXIST(100004),
        USER_NOT_ENTERED(100005),
        ROOM_USER_FULL(100008),
        NEED_PASSWORD(100018),
        WRONG_PASSWORD(100019),
        REQUEST_ID_CONFLICT(100102),
        SEAT_LOCKED(100200),
        SEAT_OCCUPIED(100210),
        ALREADY_IN_SEAT(100203),
        ALL_SEAT_OCCUPIED(100205),
        USER_NOT_IN_SEAT(100206),
        SEAT_NOT_SUPPORT_LINK_MIC(100211),
        ROOM_ALREADY_CONNECTED(100401),
        ROOM_CONNECTED_IN_OTHER(100403),
        MAX_CONNECTED_COUNT_LIMIT(100404),
        ROOM_METADATA_EXCEED_KEY_COUNT_LIMIT(100500),
        ROOM_METADATA_EXCEED_VALUE_SIZE_LIMIT(100501);

        int mValue;

        private Error(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static Error fromInt(int value) {
            for (Error error : Error.values()) {
                if (error.mValue != value) continue;
                return error;
            }
            Error result = FAILED;
            result.mValue = value;
            return result;
        }
    }
}

