/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.call;

import com.tencent.cloud.tuikit.engine.common.TUICommonDefine;
import java.util.List;
import java.util.Objects;

public class TUICallDefine {
    public static String VERSION = "0.0.0.0";
    public static int ERROR_PACKAGE_NOT_PURCHASED = -1001;
    public static int ERROR_PACKAGE_NOT_SUPPORTED = -1002;
    public static int ERROR_TIM_VERSION_OUTDATED = -1003;
    public static int ERROR_PERMISSION_DENIED = -1101;
    public static int ERROR_INIT_FAIL = -1201;
    public static int ERROR_PARAM_INVALID = -1202;
    public static int ERROR_REQUEST_REFUSED = -1203;
    public static int ERROR_REQUEST_REPEATED = -1204;
    public static int ERROR_SCENE_NOT_SUPPORTED = -1205;
    public static int ERROR_SIGNALING_SEND_FAIL = -1401;

    public static class RecentCallsFilter {
        public CallRecords.Result result = CallRecords.Result.Unknown;
    }

    public static class CallRecords {
        public String callId;
        public String inviter;
        public List<String> inviteList;
        public String groupId;
        public Scene scene;
        public MediaType mediaType;
        public Role role;
        public Result result;
        public long beginTime;
        public long totalTime;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CallRecords records = (CallRecords)o;
            return Objects.equals(this.callId, records.callId);
        }

        public String toString() {
            return "CallRecords{callId=" + this.callId + ", inviter=" + this.inviter + ", inviteList=" + this.inviteList + ", groupId=" + this.groupId + ", scene=" + (Object)((Object)this.scene) + ", mediaType=" + (Object)((Object)this.mediaType) + ", role=" + (Object)((Object)this.role) + ", result=" + (Object)((Object)this.result) + ", beginTime=" + this.beginTime + ", totalTime=" + this.totalTime + '}';
        }

        public static enum Result {
            Unknown(0),
            Missed(1),
            Incoming(2),
            Outgoing(3);

            final int mValue;

            private Result(int value) {
                this.mValue = value;
            }

            public int getValue() {
                return this.mValue;
            }

            public static Result fromInt(int value) {
                for (Result type : Result.values()) {
                    if (type.mValue != value) continue;
                    return type;
                }
                return Unknown;
            }
        }
    }

    public static class OfflinePushInfo {
        public String title;
        public String desc;
        public boolean ignoreIOSBadge;
        public String iOSSound;
        public String androidSound;
        public String androidOPPOChannelID;
        public int androidVIVOClassification = 1;
        public String androidXiaoMiChannelID;
        public String androidFCMChannelID;
        public String androidHuaWeiCategory;
        public boolean isDisablePush;
        public IOSOfflinePushType iOSPushType;
        public String extraInfo;

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public boolean isIgnoreIOSBadge() {
            return this.ignoreIOSBadge;
        }

        public void setIgnoreIOSBadge(boolean ignoreIOSBadge) {
            this.ignoreIOSBadge = ignoreIOSBadge;
        }

        public String getIOSSound() {
            return this.iOSSound;
        }

        public void setIOSSound(String iOSSound) {
            this.iOSSound = iOSSound;
        }

        public String getAndroidSound() {
            return this.androidSound;
        }

        public void setAndroidSound(String androidSound) {
            this.androidSound = androidSound;
        }

        public String getAndroidOPPOChannelID() {
            return this.androidOPPOChannelID;
        }

        public void setAndroidOPPOChannelID(String oppoChannelID) {
            this.androidOPPOChannelID = oppoChannelID;
        }

        public int getAndroidVIVOClassification() {
            return this.androidVIVOClassification;
        }

        public void setAndroidVIVOClassification(int androidVIVOClassification) {
            this.androidVIVOClassification = androidVIVOClassification;
        }

        public String getAndroidFCMChannelID() {
            return this.androidFCMChannelID;
        }

        public void setAndroidFCMChannelID(String channelID) {
            this.androidFCMChannelID = channelID;
        }

        public String getAndroidXiaoMiChannelID() {
            return this.androidXiaoMiChannelID;
        }

        public void setAndroidXiaoMiChannelID(String channelID) {
            this.androidXiaoMiChannelID = channelID;
        }

        public String getAndroidHuaWeiCategory() {
            return this.androidHuaWeiCategory;
        }

        public void setAndroidHuaWeiCategory(String category) {
            this.androidHuaWeiCategory = category;
        }

        public boolean isDisablePush() {
            return this.isDisablePush;
        }

        public void setDisablePush(boolean disablePush) {
            this.isDisablePush = disablePush;
        }

        public IOSOfflinePushType getIOSPushType() {
            return this.iOSPushType;
        }

        public void setIOSPushType(IOSOfflinePushType iOSPushType) {
            this.iOSPushType = iOSPushType;
        }

        public String toString() {
            return "OfflinePushInfo{title=" + this.title + ", desc=" + this.desc + ", ignoreIOSBadge=" + this.ignoreIOSBadge + ", iOSSound=" + this.iOSSound + ", androidSound=" + this.androidSound + ", androidOPPOChannelID=" + this.androidOPPOChannelID + ", androidVIVOClassification=" + this.androidVIVOClassification + ", androidXiaoMiChannelID=" + this.androidXiaoMiChannelID + ", androidFCMChannelID=" + this.androidFCMChannelID + ", androidHuaWeiCategory=" + this.androidHuaWeiCategory + ", isDisablePush=" + this.isDisablePush + ", iOSPushType=" + (Object)((Object)this.iOSPushType) + ", extraInfo=" + this.extraInfo + '}';
        }
    }

    public static class CallObserverExtraInfo {
        public TUICommonDefine.RoomId roomId;
        public Role role;
        public String userData;
        public String chatGroupId;

        public String toString() {
            return "CallObserverExtraInfo{roomId=" + this.roomId + ", role=" + (Object)((Object)this.role) + ", userData=" + this.userData + ", chatGroupId=" + this.chatGroupId + '}';
        }
    }

    public static class CallParams {
        public TUICommonDefine.RoomId roomId;
        public OfflinePushInfo offlinePushInfo;
        public int timeout = 30;
        public String userData;
        public String chatGroupId;

        public String toString() {
            return "CallParams{roomId=" + this.roomId + ", timeout=" + this.timeout + ", userData=" + this.userData + ", chatGroupId=" + this.chatGroupId + ", offlinePushInfo=" + this.offlinePushInfo + '}';
        }
    }

    public static enum CallEndReason {
        UNKNOWN(0),
        HANGUP(1),
        REJECT(2),
        NO_RESPONSE(3),
        OFFLINE(4),
        LINE_BUSY(5),
        CANCELED(6),
        OTHER_DEVICE_ACCEPTED(7),
        OTHER_DEVICE_REJECT(8),
        END_BY_SERVER(9);

        final int mValue;

        private CallEndReason(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static CallEndReason fromInt(int value) {
            for (CallEndReason type : CallEndReason.values()) {
                if (type.mValue != value) continue;
                return type;
            }
            return UNKNOWN;
        }
    }

    public static enum IOSOfflinePushType {
        APNs(0),
        VoIP(1);

        final int mValue;

        private IOSOfflinePushType(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static IOSOfflinePushType fromInt(int value) {
            for (IOSOfflinePushType type : IOSOfflinePushType.values()) {
                if (type.mValue != value) continue;
                return type;
            }
            return APNs;
        }
    }

    public static enum Scene {
        SINGLE_CALL(0),
        GROUP_CALL(1);

        final int mValue;

        private Scene(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static Scene fromInt(int value) {
            for (Scene type : Scene.values()) {
                if (type.mValue != value) continue;
                return type;
            }
            return SINGLE_CALL;
        }
    }

    public static enum Status {
        None(0),
        Waiting(1),
        Accept(2);

        final int mValue;

        private Status(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static Status fromInt(int value) {
            for (Status type : Status.values()) {
                if (type.mValue != value) continue;
                return type;
            }
            return None;
        }
    }

    public static enum Role {
        None(0),
        Caller(1),
        Called(2);

        final int mValue;

        private Role(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static Role fromInt(int value) {
            for (Role type : Role.values()) {
                if (type.mValue != value) continue;
                return type;
            }
            return None;
        }
    }

    public static enum MediaType {
        Unknown(0),
        Audio(1),
        Video(2);

        final int mValue;

        private MediaType(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static MediaType fromInt(int value) {
            for (MediaType type : MediaType.values()) {
                if (type.mValue != value) continue;
                return type;
            }
            return Unknown;
        }
    }
}

