/*
 * Decompiled with CFR 0.152.
 */
package com.trtc.tuikit.common.util;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import com.trtc.tuikit.common.system.ContextProvider;
import com.trtc.tuikit.common.util.TUIBuild;

public class ToastUtil {
    private static final Handler handler = new Handler(Looper.getMainLooper());
    private static Toast toast;
    private static boolean enableToast;

    public static void setEnableToast(boolean enableToast) {
        ToastUtil.enableToast = enableToast;
    }

    public static void toastLongMessage(String message) {
        ToastUtil.toastMessage(message, true, 80);
    }

    public static void toastLongMessageCenter(String message) {
        ToastUtil.toastMessage(message, true, 17);
    }

    public static void toastShortMessage(String message) {
        ToastUtil.toastMessage(message, false, 80);
    }

    public static void toastShortMessageCenter(String message) {
        ToastUtil.toastMessage(message, false, 17);
    }

    public static void show(String message, boolean isLong, int gravity) {
        ToastUtil.toastMessage(message, isLong, gravity);
    }

    private static void toastMessage(final String message, final boolean isLong, final int gravity) {
        if (!enableToast) {
            return;
        }
        handler.post(new Runnable(){

            @Override
            public void run() {
                TextView textView;
                if (toast != null) {
                    toast.cancel();
                    toast = null;
                }
                toast = Toast.makeText((Context)ContextProvider.getApplicationContext(), (CharSequence)message, (int)(isLong ? 1 : 0));
                toast.setGravity(gravity, 0, 0);
                View view = toast.getView();
                if (view != null && (textView = (TextView)view.findViewById(16908299)) != null) {
                    textView.setGravity(17);
                }
                if (TUIBuild.getVersionInt() >= 30) {
                    toast.addCallback(new Toast.Callback(){

                        public void onToastHidden() {
                            super.onToastHidden();
                            toast = null;
                        }
                    });
                }
                toast.show();
            }
        });
    }

    static {
        enableToast = true;
    }
}

