/*
 * Decompiled with CFR 0.152.
 */
package com.trtc.tuikit.common.util;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.Display;
import android.view.WindowManager;
import com.trtc.tuikit.common.system.ContextProvider;

public class ScreenUtil {
    private static final String TAG = ScreenUtil.class.getSimpleName();

    public static int getScreenHeight(Context context) {
        DisplayMetrics metric = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metric);
        return metric.heightPixels;
    }

    public static int getScreenWidth(Context context) {
        DisplayMetrics metric = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metric);
        return metric.widthPixels;
    }

    public static int getPxByDp(float dp) {
        float scale = ContextProvider.getApplicationContext().getResources().getDisplayMetrics().density;
        return (int)(dp * scale + 0.5f);
    }

    public static int getRealScreenHeight(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        DisplayMetrics dm = new DisplayMetrics();
        display.getRealMetrics(dm);
        return dm.heightPixels;
    }

    public static int getRealScreenWidth(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        DisplayMetrics dm = new DisplayMetrics();
        display.getRealMetrics(dm);
        return dm.widthPixels;
    }

    public static int getNavigationBarHeight(Context context) {
        int resourceId = context.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return context.getResources().getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    public static int[] scaledSize(int containerWidth, int containerHeight, int realWidth, int realHeight) {
        Log.i((String)TAG, (String)("scaledSize  containerWidth: " + containerWidth + " containerHeight: " + containerHeight + " realWidth: " + realWidth + " realHeight: " + realHeight));
        float deviceRate = (float)containerWidth / (float)containerHeight;
        float rate = (float)realWidth / (float)realHeight;
        int width = 0;
        int height = 0;
        if (rate < deviceRate) {
            height = containerHeight;
            width = (int)((float)containerHeight * rate);
        } else {
            width = containerWidth;
            height = (int)((float)containerWidth / rate);
        }
        return new int[]{width, height};
    }

    public static int dip2px(float dpValue) {
        float scale = ContextProvider.getApplicationContext().getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static float dp2px(float dpValue, DisplayMetrics displayMetrics) {
        return TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)displayMetrics);
    }
}

