/*
 * Decompiled with CFR 0.152.
 */
package com.trtc.tuikit.common.ui.floatwindow;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.trtc.tuikit.common.permission.PermissionRequester;
import com.trtc.tuikit.common.system.ContextProvider;
import com.trtc.tuikit.common.ui.floatwindow.FloatWindowObserver;
import com.trtc.tuikit.common.util.ScreenUtil;
import com.trtc.tuikit.common.util.TUIBuild;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class FloatWindowManager {
    private static final int CLICK_ACTION_MAX_MOVE_DISTANCE_PX = 10;
    private static final int VIEW_MARGIN_EDGE_PX = ScreenUtil.dip2px(10.0f);
    private static volatile FloatWindowManager sInstance;
    private Context mAppContext = ContextProvider.getApplicationContext();
    private FrameLayout mRootView;
    private WindowManager mWindowManager;
    private WindowManager.LayoutParams mWindowLayoutParams;
    private WindowManager.LayoutParams mOriginalLayoutParams;
    private List<FloatWindowObserver> mObserverList = new CopyOnWriteArrayList<FloatWindowObserver>();
    private OrientationReceiver mOrientationReceiver;
    private float mTouchDownPointX;
    private float mTouchDownPointY;
    private float mCurrentTouchX;
    private float mCurrentTouchY;
    private boolean mIsActionDrag;
    private boolean mIsShowing = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FloatWindowManager sharedInstance() {
        if (sInstance != null) return sInstance;
        Class<FloatWindowManager> clazz = FloatWindowManager.class;
        synchronized (FloatWindowManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new FloatWindowManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private FloatWindowManager() {
    }

    public void addObserver(FloatWindowObserver observer) {
        if (observer == null || this.mObserverList.contains(observer)) {
            return;
        }
        this.mObserverList.add(observer);
    }

    public void removeObserver(FloatWindowObserver observer) {
        if (observer == null) {
            return;
        }
        this.mObserverList.remove(observer);
    }

    public void show(View floatView) {
        if (this.mIsShowing) {
            return;
        }
        PermissionRequester requester = PermissionRequester.newInstance("PermissionOverlayWindows");
        if (!requester.has()) {
            requester.request();
            return;
        }
        this.mIsShowing = true;
        this.mRootView = new FrameLayout(this.mAppContext);
        this.mRootView.setOnTouchListener((View.OnTouchListener)new FloatRootViewTouchListener());
        this.mRootView.addView(floatView);
        this.mWindowManager = (WindowManager)this.mAppContext.getSystemService("window");
        this.updateWindowLayoutParams();
        this.mWindowManager.addView((View)this.mRootView, (ViewGroup.LayoutParams)this.mWindowLayoutParams);
        this.registerReceiver();
    }

    public void dismiss() {
        if (!this.mIsShowing) {
            return;
        }
        this.unregisterReceiver();
        this.mIsShowing = false;
        if (this.mRootView != null) {
            this.mRootView.removeAllViews();
            this.mWindowManager.removeView((View)this.mRootView);
            this.mRootView = null;
        }
    }

    public boolean isShowing() {
        return this.mIsShowing;
    }

    public boolean isPictureInPictureSupported() {
        if (Build.VERSION.SDK_INT < 26) {
            return false;
        }
        return this.mAppContext.getPackageManager().hasSystemFeature("android.software.picture_in_picture");
    }

    private void updateWindowLayoutParams() {
        this.mWindowLayoutParams = new WindowManager.LayoutParams();
        this.mWindowLayoutParams.type = TUIBuild.getVersionInt() >= 26 ? 2038 : 2002;
        this.mWindowLayoutParams.flags = 552;
        this.mWindowLayoutParams.gravity = 53;
        this.mWindowLayoutParams.x = VIEW_MARGIN_EDGE_PX;
        this.mWindowLayoutParams.y = ScreenUtil.getScreenHeight(this.mAppContext) / 4;
        this.mWindowLayoutParams.width = -2;
        this.mWindowLayoutParams.height = -2;
        this.mWindowLayoutParams.format = -2;
    }

    private void updateFlagOfDragAction(float xMovePoint, float yMovePoint) {
        float xDistance = Math.abs(xMovePoint - this.mTouchDownPointX);
        float yDistance = Math.abs(yMovePoint - this.mTouchDownPointY);
        if (xDistance >= 10.0f || yDistance >= 10.0f) {
            this.mIsActionDrag = true;
        }
    }

    private void handleClickAction() {
        for (FloatWindowObserver observer : this.mObserverList) {
            if (observer == null) continue;
            observer.onFloatWindowClick();
        }
    }

    private void moveBackToOriginalPosition() {
        this.mWindowLayoutParams = this.mOriginalLayoutParams;
        this.mWindowManager.updateViewLayout((View)this.mRootView, (ViewGroup.LayoutParams)this.mWindowLayoutParams);
    }

    private void autoMoveToScreenEdge() {
        this.mWindowLayoutParams.x = this.mWindowLayoutParams.x > this.getMaxPositionX() >> 1 ? this.getMaxPositionX() : VIEW_MARGIN_EDGE_PX;
        this.mWindowManager.updateViewLayout((View)this.mRootView, (ViewGroup.LayoutParams)this.mWindowLayoutParams);
    }

    private void updateLayout() {
        this.mWindowLayoutParams.x = Math.max(this.mWindowLayoutParams.x, VIEW_MARGIN_EDGE_PX);
        this.mWindowLayoutParams.x = Math.min(this.mWindowLayoutParams.x, this.getMaxPositionX());
        this.mWindowLayoutParams.y = Math.max(this.mWindowLayoutParams.y, VIEW_MARGIN_EDGE_PX);
        this.mWindowLayoutParams.y = Math.min(this.mWindowLayoutParams.y, this.getMaxPositionY());
        this.mWindowManager.updateViewLayout((View)this.mRootView, (ViewGroup.LayoutParams)this.mWindowLayoutParams);
    }

    private int getMaxPositionX() {
        return ScreenUtil.getScreenWidth(this.mAppContext) - this.mRootView.getWidth() - VIEW_MARGIN_EDGE_PX;
    }

    private int getMaxPositionY() {
        return ScreenUtil.getScreenHeight(this.mAppContext) - this.mRootView.getHeight() - VIEW_MARGIN_EDGE_PX;
    }

    private void registerReceiver() {
        if (this.mOrientationReceiver != null) {
            return;
        }
        this.mOrientationReceiver = new OrientationReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        this.mAppContext.registerReceiver((BroadcastReceiver)this.mOrientationReceiver, filter);
    }

    private void unregisterReceiver() {
        if (this.mOrientationReceiver != null) {
            this.mAppContext.unregisterReceiver((BroadcastReceiver)this.mOrientationReceiver);
            this.mOrientationReceiver = null;
        }
    }

    private class FloatRootViewTouchListener
    implements View.OnTouchListener {
        private FloatRootViewTouchListener() {
        }

        public boolean onTouch(View v, MotionEvent event) {
            int action = event.getAction();
            switch (action) {
                case 0: {
                    FloatWindowManager.this.mTouchDownPointX = event.getRawX();
                    FloatWindowManager.this.mTouchDownPointY = event.getRawY();
                    FloatWindowManager.this.mCurrentTouchX = FloatWindowManager.this.mTouchDownPointX;
                    FloatWindowManager.this.mCurrentTouchY = FloatWindowManager.this.mTouchDownPointY;
                    FloatWindowManager.this.mOriginalLayoutParams = FloatWindowManager.this.mWindowLayoutParams;
                    FloatWindowManager.this.mIsActionDrag = false;
                    break;
                }
                case 2: {
                    ((FloatWindowManager)FloatWindowManager.this).mWindowLayoutParams.x += (int)(FloatWindowManager.this.mCurrentTouchX - event.getRawX());
                    ((FloatWindowManager)FloatWindowManager.this).mWindowLayoutParams.y += (int)(event.getRawY() - FloatWindowManager.this.mCurrentTouchY);
                    FloatWindowManager.this.updateLayout();
                    FloatWindowManager.this.updateFlagOfDragAction(event.getRawX(), event.getRawY());
                    FloatWindowManager.this.mCurrentTouchX = (int)event.getRawX();
                    FloatWindowManager.this.mCurrentTouchY = (int)event.getRawY();
                    break;
                }
                case 1: {
                    if (FloatWindowManager.this.mIsActionDrag) {
                        FloatWindowManager.this.autoMoveToScreenEdge();
                        break;
                    }
                    FloatWindowManager.this.moveBackToOriginalPosition();
                    FloatWindowManager.this.handleClickAction();
                    break;
                }
            }
            return true;
        }
    }

    private class OrientationReceiver
    extends BroadcastReceiver {
        private OrientationReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.CONFIGURATION_CHANGED".equals(intent.getAction())) {
                FloatWindowManager.this.updateWindowLayoutParams();
                FloatWindowManager.this.updateLayout();
            }
        }
    }
}

