/*
 * Decompiled with CFR 0.152.
 */
package com.trtc.tuikit.common.ui;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.google.android.material.R;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.trtc.tuikit.common.R;

public class PopupDialog
extends BottomSheetDialog {
    private View mBaseView;
    private View mBottomSheet;

    public PopupDialog(@NonNull Context context) {
        super(context);
    }

    public PopupDialog(@NonNull Context context, int theme) {
        super(context, theme);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(this.mBaseView);
        this.mBottomSheet = this.findViewById(R.id.design_bottom_sheet);
        this.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialogInterface) {
                PopupDialog.this.mBottomSheet.setBackgroundResource(R.color.common_design_bottom_sheet_color);
            }
        });
    }

    public PopupDialog setView(View view) {
        this.mBaseView = view;
        return this;
    }

    protected void onStart() {
        super.onStart();
        Window window = this.getWindow();
        this.changeConfiguration(window);
        window.setWindowAnimations(R.style.TUICommonBottomDialoglAnim);
        BottomSheetBehavior behavior = BottomSheetBehavior.from((View)this.mBottomSheet);
        behavior.setSkipCollapsed(true);
        behavior.setState(3);
        behavior.setDraggable(false);
    }

    protected void changeConfiguration(Window window) {
        Configuration configuration = this.getContext().getResources().getConfiguration();
        window.setBackgroundDrawableResource(17170445);
        WindowManager.LayoutParams params = window.getAttributes();
        if (configuration.orientation == 2) {
            params.gravity = 0x800005;
            params.width = this.getContext().getResources().getDisplayMetrics().widthPixels / 2;
        } else {
            params.gravity = 80;
            params.width = -1;
        }
        params.height = this.getContext().getResources().getDisplayMetrics().heightPixels;
        window.setAttributes(params);
    }

    public static interface DialogActionListener {
        public void dismiss();
    }
}

