/*
 * Decompiled with CFR 0.152.
 */
package com.trtc.tuikit.common.ui;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.trtc.tuikit.common.R;
import com.trtc.tuikit.common.util.ScreenUtil;

public class ConfirmWithCheckboxDialog
extends Dialog {
    private Context mContext;
    private View mDivideLine;
    private String mTitleText;
    private String mContentText;
    private String mCheckboxText;
    private String mPositiveText;
    private String mNegativeText;
    private CompoundButton.OnCheckedChangeListener mCheckChangedListener;
    private View.OnClickListener mPositiveClickListener;
    private View.OnClickListener mNegativeClickListener;

    public ConfirmWithCheckboxDialog(@NonNull Context context) {
        super(context, R.style.TUICommonConfirmDialogTheme);
        this.mContext = context;
    }

    public ConfirmWithCheckboxDialog(@NonNull Context context, int theme) {
        super(context, theme);
        this.mContext = context;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.common_confirm_dialog);
        this.setCancelable(false);
        this.mDivideLine = this.findViewById(R.id.vertical_divider);
        this.initText();
        this.initCheckbox();
        this.initButtonPositive();
        this.initButtonNegative();
    }

    private void initText() {
        TextView title = (TextView)this.findViewById(R.id.title);
        TextView message = (TextView)this.findViewById(R.id.content);
        title.setText((CharSequence)this.mTitleText);
        message.setText((CharSequence)this.mContentText);
        if (this.mTitleText == null) {
            title.setVisibility(8);
            message.setLayoutParams((ViewGroup.LayoutParams)this.setTextLayoutParams());
        } else if (this.mContentText == null) {
            message.setVisibility(8);
            title.setLayoutParams((ViewGroup.LayoutParams)this.setTextLayoutParams());
        }
    }

    private ConstraintLayout.LayoutParams setTextLayoutParams() {
        ConstraintLayout.LayoutParams layoutParams = new ConstraintLayout.LayoutParams(-2, -2);
        int margin = (int)ScreenUtil.dp2px(37.0f, this.mContext.getResources().getDisplayMetrics());
        layoutParams.topToTop = 0;
        layoutParams.bottomToTop = this.mCheckChangedListener == null ? R.id.horizontal_divider : R.id.check;
        layoutParams.setMargins(0, margin, 0, margin);
        return layoutParams;
    }

    private void initCheckbox() {
        CheckBox checkBox = (CheckBox)this.findViewById(R.id.check);
        if (this.mCheckChangedListener == null) {
            checkBox.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mCheckboxText)) {
            checkBox.setText((CharSequence)this.mCheckboxText);
        }
        checkBox.setOnCheckedChangeListener(this.mCheckChangedListener);
    }

    private void initButtonPositive() {
        Button buttonPositive = (Button)this.findViewById(R.id.btn_positive);
        if (this.mPositiveClickListener == null) {
            buttonPositive.setVisibility(8);
            this.mDivideLine.setVisibility(8);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mPositiveText)) {
            buttonPositive.setText((CharSequence)this.mPositiveText);
        }
        buttonPositive.setOnClickListener(this.mPositiveClickListener);
    }

    private void initButtonNegative() {
        Button buttonNegative = (Button)this.findViewById(R.id.btn_negative);
        if (this.mNegativeClickListener == null) {
            buttonNegative.setVisibility(8);
            this.mDivideLine.setVisibility(8);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mNegativeText)) {
            buttonNegative.setText((CharSequence)this.mNegativeText);
        }
        buttonNegative.setOnClickListener(this.mNegativeClickListener);
    }

    public void setTitle(String title) {
        this.mTitleText = title;
    }

    public void setContent(String content) {
        this.mContentText = content;
    }

    public void setCheckboxText(String text, CompoundButton.OnCheckedChangeListener listener) {
        this.mCheckboxText = text;
        this.mCheckChangedListener = listener;
    }

    public void setPositiveText(String text, View.OnClickListener listener) {
        this.mPositiveText = text;
        this.mPositiveClickListener = listener;
    }

    public void setNegativeText(String text, View.OnClickListener listener) {
        this.mNegativeText = text;
        this.mNegativeClickListener = listener;
    }
}

