/*
 * Decompiled with CFR 0.152.
 */
package com.trtc.tuikit.common.permission;

import android.annotation.SuppressLint;
import android.app.AppOpsManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import com.trtc.tuikit.common.R;
import com.trtc.tuikit.common.event.EventManager;
import com.trtc.tuikit.common.event.INotification;
import com.trtc.tuikit.common.permission.PermissionActivity;
import com.trtc.tuikit.common.permission.PermissionCallback;
import com.trtc.tuikit.common.system.ContextProvider;
import com.trtc.tuikit.common.util.TUIBuild;
import com.trtc.tuikit.common.util.ToastUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class PermissionRequester {
    private static final String TAG = "PermissionRequester";
    public static final String PERMISSION_NOTIFY_EVENT_KEY = "PERMISSION_NOTIFY_EVENT_KEY";
    public static final String PERMISSION_NOTIFY_EVENT_SUB_KEY = "PERMISSION_NOTIFY_EVENT_SUB_KEY";
    public static final String PERMISSION_RESULT = "PERMISSION_RESULT";
    public static final String PERMISSION_REQUEST_KEY = "PERMISSION_REQUEST_KEY";
    private static final Object sLock = new Object();
    private static AtomicBoolean sIsRequesting = new AtomicBoolean(false);
    private PermissionCallback mPermissionCallback;
    private String[] mPermissions;
    private String mTitle;
    private String mDescription;
    private String mSettingsTip;
    private INotification mPermissionNotification;
    public static final String FLOAT_PERMISSION = "PermissionOverlayWindows";
    public static final String BG_START_PERMISSION = "PermissionStartActivityFromBackground";
    private List<String> mDirectPermissionList = new ArrayList<String>();
    private List<String> mIndirectPermissionList = new ArrayList<String>();

    private PermissionRequester(String ... permissions) {
        for (String permission2 : this.mPermissions = permissions) {
            if (FLOAT_PERMISSION.equals(permission2) || BG_START_PERMISSION.equals(permission2)) {
                this.mIndirectPermissionList.add(permission2);
                continue;
            }
            this.mDirectPermissionList.add(permission2);
        }
        this.mPermissionNotification = (key, subKey, param) -> {
            if (param == null) {
                return;
            }
            Object result = param.get(PERMISSION_RESULT);
            if (result == null) {
                return;
            }
            this.notifyPermissionRequestResult((Result)((Object)((Object)result)));
        };
    }

    public static PermissionRequester newInstance(String ... permissions) {
        return new PermissionRequester(permissions);
    }

    public PermissionRequester title(@NonNull String title) {
        this.mTitle = title;
        return this;
    }

    public PermissionRequester description(@NonNull String description) {
        this.mDescription = description;
        return this;
    }

    public PermissionRequester settingsTip(@NonNull String settingsTip) {
        this.mSettingsTip = settingsTip;
        return this;
    }

    public PermissionRequester callback(@NonNull PermissionCallback callback) {
        this.mPermissionCallback = callback;
        return this;
    }

    @SuppressLint(value={"NewApi"})
    public void request() {
        Log.i((String)TAG, (String)("request, directPermissionList: " + this.mDirectPermissionList + " ,indirectPermissionList:  " + this.mIndirectPermissionList));
        if (this.mDirectPermissionList != null && this.mDirectPermissionList.size() > 0) {
            this.requestDirectPermission(this.mDirectPermissionList.toArray(new String[0]));
        }
        if (this.mIndirectPermissionList != null && this.mIndirectPermissionList.size() > 0) {
            this.startAppDetailsSettingsByBrand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    private void requestDirectPermission(String[] permissions) {
        Object object = sLock;
        synchronized (object) {
            if (sIsRequesting.get()) {
                Log.e((String)TAG, (String)"can not request during requesting");
                if (this.mPermissionCallback != null) {
                    this.mPermissionCallback.onDenied();
                }
                return;
            }
            sIsRequesting.set(true);
        }
        EventManager.getInstance().registerEvent(PERMISSION_NOTIFY_EVENT_KEY, PERMISSION_NOTIFY_EVENT_SUB_KEY, this.mPermissionNotification);
        if (TUIBuild.getVersionInt() < 23) {
            Log.i((String)TAG, (String)"current version is lower than 23");
            this.notifyPermissionRequestResult(Result.Granted);
            return;
        }
        String[] unauthorizedPermissions = this.findUnauthorizedPermissions(permissions);
        if (unauthorizedPermissions.length <= 0) {
            this.notifyPermissionRequestResult(Result.Granted);
            return;
        }
        RequestData realRequest = new RequestData(this.mTitle, this.mDescription, this.mSettingsTip, unauthorizedPermissions);
        this.startPermissionActivity(realRequest);
    }

    public boolean has() {
        if (this.mIndirectPermissionList.contains(BG_START_PERMISSION)) {
            return this.hasFloatPermission() && this.hasBgStartPermission();
        }
        if (this.mIndirectPermissionList.contains(FLOAT_PERMISSION)) {
            return this.hasFloatPermission();
        }
        for (String permission2 : this.mDirectPermissionList) {
            if (this.has(permission2)) continue;
            return false;
        }
        return true;
    }

    private boolean has(String permission2) {
        return TUIBuild.getVersionInt() < 23 || 0 == ContextCompat.checkSelfPermission((Context)ContextProvider.getApplicationContext(), (String)permission2);
    }

    private void notifyPermissionRequestResult(Result result) {
        EventManager.getInstance().unRegisterEvent(PERMISSION_NOTIFY_EVENT_KEY, PERMISSION_NOTIFY_EVENT_SUB_KEY, this.mPermissionNotification);
        sIsRequesting.set(false);
        if (this.mPermissionCallback == null) {
            return;
        }
        if (Result.Granted.equals((Object)result)) {
            this.mPermissionCallback.onGranted();
        } else if (Result.Requesting.equals((Object)result)) {
            this.mPermissionCallback.onRequesting();
        } else {
            this.mPermissionCallback.onDenied();
        }
        this.mPermissionCallback = null;
    }

    private String[] findUnauthorizedPermissions(String[] permissions) {
        Context appContext = ContextProvider.getApplicationContext();
        if (appContext == null) {
            Log.e((String)TAG, (String)"findUnauthorizedPermissions appContext is null");
            return permissions;
        }
        LinkedList<String> unauthorizedList = new LinkedList<String>();
        for (String permission2 : permissions) {
            if (0 == ContextCompat.checkSelfPermission((Context)appContext, (String)permission2)) continue;
            unauthorizedList.add(permission2);
        }
        return unauthorizedList.toArray(new String[0]);
    }

    @RequiresApi(api=23)
    private void startPermissionActivity(RequestData request) {
        Context context = ContextProvider.getApplicationContext();
        if (context == null) {
            return;
        }
        Intent intent = new Intent(context, PermissionActivity.class);
        intent.putExtra(PERMISSION_REQUEST_KEY, (Parcelable)request);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    private void startAppDetailsSettingsByBrand() {
        Context context = ContextProvider.getApplicationContext();
        if (TUIBuild.isBrandVivo()) {
            this.startVivoPermissionSettings(context);
        } else if (TUIBuild.isBrandHuawei()) {
            this.startHuaweiPermissionSettings(context);
        } else if (TUIBuild.isBrandXiaoMi()) {
            this.startXiaomiPermissionSettings(context);
        } else {
            this.startCommonSettings(context);
        }
    }

    private void startCommonSettings(Context context) {
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
                intent.setData(Uri.parse((String)("package:" + context.getPackageName())));
                intent.setFlags(0x10000000);
                context.startActivity(intent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startVivoPermissionSettings(Context context) {
        try {
            Intent intent = new Intent();
            intent.setClassName("com.vivo.permissionmanager", "com.vivo.permissionmanager.activity.SoftPermissionDetailActivity");
            intent.setAction("secure.intent.action.softPermissionDetail");
            intent.putExtra("packagename", context.getPackageName());
            intent.setFlags(0x10000000);
            context.startActivity(intent);
            ToastUtil.toastShortMessage(context.getResources().getString(R.string.common_float_permission_hint));
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"startVivoPermissionSettings: open common settings");
            this.startCommonSettings(context);
        }
    }

    private void startHuaweiPermissionSettings(Context context) {
        if (!TUIBuild.isHarmonyOS()) {
            Log.i((String)TAG, (String)"The device is not Harmony or cannot get system operator");
            this.startCommonSettings(context);
            return;
        }
        try {
            Intent intent = new Intent();
            intent.putExtra("packageName", context.getPackageName());
            ComponentName comp = new ComponentName("com.huawei.systemmanager", "com.huawei.permissionmanager.ui.MainActivity");
            intent.setComponent(comp);
            intent.setFlags(0x10000000);
            context.startActivity(intent);
            ToastUtil.toastShortMessage(context.getResources().getString(R.string.common_float_permission_hint));
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"startHuaweiPermissionSettings: open common settings");
            this.startCommonSettings(context);
        }
    }

    private void startXiaomiPermissionSettings(Context context) {
        if (!TUIBuild.isMiuiOptimization()) {
            Log.i((String)TAG, (String)"The device do not open miuiOptimization or cannot get miui property");
            this.startCommonSettings(context);
            return;
        }
        try {
            Intent intent = new Intent("miui.intent.action.APP_PERM_EDITOR");
            intent.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.PermissionsEditorActivity");
            intent.putExtra("extra_pkgname", context.getPackageName());
            intent.setFlags(0x10000000);
            context.startActivity(intent);
            ToastUtil.toastShortMessage(context.getResources().getString(R.string.common_float_permission_hint));
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"startXiaomiPermissionSettings: open common settings");
            this.startCommonSettings(context);
        }
    }

    private boolean hasBgStartPermission() {
        Context context = ContextProvider.getApplicationContext();
        if (TUIBuild.isBrandHuawei() && TUIBuild.isHarmonyOS()) {
            return this.isHarmonyBgStartPermissionAllowed(context);
        }
        if (TUIBuild.isBrandVivo()) {
            return this.isVivoBgStartPermissionAllowed(context);
        }
        if (TUIBuild.isBrandXiaoMi() && TUIBuild.isMiuiOptimization()) {
            return this.isXiaomiBgStartPermissionAllowed(context);
        }
        return this.hasFloatPermission();
    }

    private boolean hasFloatPermission() {
        try {
            Context context = ContextProvider.getApplicationContext();
            if (Build.VERSION.SDK_INT >= 23) {
                return Settings.canDrawOverlays((Context)context);
            }
            if (Build.VERSION.SDK_INT >= 19) {
                AppOpsManager manager = (AppOpsManager)context.getSystemService("appops");
                if (manager == null) {
                    return false;
                }
                Method method = AppOpsManager.class.getMethod("checkOp", Integer.TYPE, Integer.TYPE, String.class);
                int result = (Integer)method.invoke((Object)manager, 24, Binder.getCallingUid(), context.getPackageName());
                Log.i((String)TAG, (String)("hasFloatPermission, result: " + (0 == result)));
                return 0 == result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean isHarmonyBgStartPermissionAllowed(Context context) {
        try {
            if (Build.VERSION.SDK_INT >= 19) {
                AppOpsManager manager = (AppOpsManager)context.getSystemService("appops");
                if (manager == null) {
                    return false;
                }
                Class<?> clz = Class.forName("com.huawei.android.app.AppOpsManagerEx");
                Method method = clz.getDeclaredMethod("checkHwOpNoThrow", AppOpsManager.class, Integer.TYPE, Integer.TYPE, String.class);
                int result = (Integer)method.invoke(clz.newInstance(), manager, 100000, Process.myUid(), context.getPackageName());
                Log.i((String)TAG, (String)("isHarmonyBgStartPermissionAllowed, result: " + (result == 0)));
                return result == 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean isVivoBgStartPermissionAllowed(Context context) {
        try {
            Uri uri = Uri.parse((String)"content://com.vivo.permissionmanager.provider.permission/start_bg_activity");
            Cursor cursor = context.getContentResolver().query(uri, null, "pkgname = ?", new String[]{context.getPackageName()}, null);
            if (cursor == null) {
                return false;
            }
            if (cursor.moveToFirst()) {
                int result = cursor.getInt(cursor.getColumnIndex("currentstate"));
                cursor.close();
                Log.i((String)TAG, (String)("isVivoBgStartPermissionAllowed, result: " + (0 == result)));
                return 0 == result;
            }
            cursor.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean isXiaomiBgStartPermissionAllowed(Context context) {
        try {
            AppOpsManager appOpsManager = null;
            if (Build.VERSION.SDK_INT >= 19) {
                appOpsManager = (AppOpsManager)context.getSystemService("appops");
            }
            if (appOpsManager == null) {
                return false;
            }
            int op = 10021;
            Method method = appOpsManager.getClass().getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
            method.setAccessible(true);
            int result = (Integer)method.invoke((Object)appOpsManager, op, Process.myUid(), context.getPackageName());
            Log.i((String)TAG, (String)("isXiaomiBgStartPermissionAllowed, result: " + (0 == result)));
            return 0 == result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static enum Result {
        Granted,
        Denied,
        Requesting;

    }

    static class RequestData
    implements Parcelable {
        private final String[] mPermissions;
        private final String mTitle;
        private final String mDescription;
        private final String mSettingsTip;
        private int mPermissionIconId;
        public static final Parcelable.Creator<RequestData> CREATOR = new Parcelable.Creator<RequestData>(){

            public RequestData createFromParcel(Parcel in) {
                return new RequestData(in);
            }

            public RequestData[] newArray(int size) {
                return new RequestData[size];
            }
        };

        public RequestData(@NonNull String title, @NonNull String description, @NonNull String settingsTip, String ... perms) {
            this.mTitle = title;
            this.mDescription = description;
            this.mSettingsTip = settingsTip;
            this.mPermissions = (String[])perms.clone();
        }

        protected RequestData(Parcel in) {
            this.mPermissions = in.createStringArray();
            this.mTitle = in.readString();
            this.mDescription = in.readString();
            this.mSettingsTip = in.readString();
            this.mPermissionIconId = in.readInt();
        }

        public boolean isPermissionsExistEmpty() {
            if (this.mPermissions == null || this.mPermissions.length <= 0) {
                return true;
            }
            for (String permission2 : this.mPermissions) {
                if (!TextUtils.isEmpty((CharSequence)permission2)) continue;
                return true;
            }
            return false;
        }

        public String[] getPermissions() {
            return (String[])this.mPermissions.clone();
        }

        public String getTitle() {
            return this.mTitle;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public String getSettingsTip() {
            return this.mSettingsTip;
        }

        public int getPermissionIconId() {
            return this.mPermissionIconId;
        }

        public void setPermissionIconId(int permissionIconId) {
            this.mPermissionIconId = permissionIconId;
        }

        public String toString() {
            return "PermissionRequest{mPermissions=" + Arrays.toString(this.mPermissions) + ", mTitle=" + this.mTitle + ", mDescription='" + this.mDescription + ", mSettingsTip='" + this.mSettingsTip + '}';
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeStringArray(this.mPermissions);
            dest.writeString(this.mTitle);
            dest.writeString(this.mDescription);
            dest.writeString(this.mSettingsTip);
            dest.writeInt(this.mPermissionIconId);
        }
    }
}

