/*
 * Decompiled with CFR 0.152.
 */
package com.trtc.tuikit.common.permission;

import android.annotation.SuppressLint;
import android.app.ActionBar;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.trtc.tuikit.common.R;
import com.trtc.tuikit.common.event.EventManager;
import com.trtc.tuikit.common.permission.PermissionRequester;
import com.trtc.tuikit.common.util.TUIBuild;
import java.util.HashMap;

@RequiresApi(api=23)
public class PermissionActivity
extends Activity {
    private static final String TAG = "PermissionActivity";
    private static final int PERMISSION_REQUEST_CODE = 100;
    private TextView mRationaleTitleTv;
    private TextView mRationaleDescriptionTv;
    private ImageView mPermissionIconIv;
    private PermissionRequester.RequestData mRequestData;
    private PermissionRequester.Result mResult = PermissionRequester.Result.Denied;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mRequestData = this.getPermissionRequest();
        if (this.mRequestData == null || this.mRequestData.isPermissionsExistEmpty()) {
            Log.e((String)TAG, (String)"onCreate mRequestData exist empty permission");
            this.finishWithResult(PermissionRequester.Result.Denied);
            return;
        }
        Log.i((String)TAG, (String)("onCreate : " + this.mRequestData.toString()));
        if (TUIBuild.getVersionInt() < 23) {
            this.finishWithResult(PermissionRequester.Result.Granted);
            return;
        }
        this.makeBackGroundTransparent();
        this.initView();
        this.showPermissionRationale();
        this.requestPermissions(this.mRequestData.getPermissions(), 100);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        this.hidePermissionRationale();
        if (this.isAllPermissionsGranted(grantResults)) {
            this.finishWithResult(PermissionRequester.Result.Granted);
            return;
        }
        this.showSettingsTip();
    }

    private void showSettingsTip() {
        if (this.mRequestData == null) {
            return;
        }
        View tipLayout = LayoutInflater.from((Context)this).inflate(R.layout.common_permission_tip_layout, null);
        TextView tipsTv = (TextView)tipLayout.findViewById(R.id.tips);
        TextView positiveBtn = (TextView)tipLayout.findViewById(R.id.positive_btn);
        TextView negativeBtn = (TextView)tipLayout.findViewById(R.id.negative_btn);
        tipsTv.setText((CharSequence)this.mRequestData.getSettingsTip());
        AlertDialog permissionTipDialog = new AlertDialog.Builder((Context)this).setView(tipLayout).setCancelable(false).create();
        positiveBtn.setOnClickListener(arg_0 -> this.lambda$showSettingsTip$0((Dialog)permissionTipDialog, arg_0));
        negativeBtn.setOnClickListener(arg_0 -> this.lambda$showSettingsTip$1((Dialog)permissionTipDialog, arg_0));
        permissionTipDialog.setOnKeyListener((arg_0, arg_1, arg_2) -> PermissionActivity.lambda$showSettingsTip$2((Dialog)permissionTipDialog, arg_0, arg_1, arg_2));
        Window dialogWindow = permissionTipDialog.getWindow();
        dialogWindow.setBackgroundDrawable((Drawable)new ColorDrawable());
        WindowManager.LayoutParams layoutParams = dialogWindow.getAttributes();
        layoutParams.width = -2;
        layoutParams.height = -2;
        dialogWindow.setAttributes(layoutParams);
        permissionTipDialog.show();
    }

    private void launchAppDetailsSettings() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + this.getPackageName())));
        intent.addFlags(0x10000000);
        if (this.getPackageManager().queryIntentActivities(intent, 65536).size() <= 0) {
            Log.e((String)TAG, (String)"launchAppDetailsSettings can not find system settings");
            return;
        }
        this.startActivity(intent);
    }

    private void finishWithResult(PermissionRequester.Result result) {
        Log.i((String)TAG, (String)("finishWithResult : " + (Object)((Object)result)));
        this.mResult = result;
        this.finish();
    }

    protected void onDestroy() {
        super.onDestroy();
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        result.put("PERMISSION_RESULT", (Object)this.mResult);
        EventManager.getInstance().notifyEvent("PERMISSION_NOTIFY_EVENT_KEY", "PERMISSION_NOTIFY_EVENT_SUB_KEY", result);
    }

    private PermissionRequester.RequestData getPermissionRequest() {
        Intent intent = this.getIntent();
        if (intent == null) {
            return null;
        }
        return (PermissionRequester.RequestData)intent.getParcelableExtra("PERMISSION_REQUEST_KEY");
    }

    @SuppressLint(value={"NewApi"})
    private void makeBackGroundTransparent() {
        ActionBar actionBar;
        if (TUIBuild.getVersionInt() >= 21) {
            View decorView = this.getWindow().getDecorView();
            decorView.setSystemUiVisibility(1280);
            this.getWindow().setStatusBarColor(0);
            this.getWindow().setNavigationBarColor(0);
        }
        if ((actionBar = this.getActionBar()) != null) {
            actionBar.hide();
        }
    }

    private void initView() {
        this.setContentView(R.layout.common_permission_activity_layout);
        this.mRationaleTitleTv = (TextView)this.findViewById(R.id.permission_reason_title);
        this.mRationaleDescriptionTv = (TextView)this.findViewById(R.id.permission_reason);
        this.mPermissionIconIv = (ImageView)this.findViewById(R.id.permission_icon);
    }

    private void showPermissionRationale() {
        if (this.mRequestData == null) {
            return;
        }
        this.mRationaleTitleTv.setText((CharSequence)this.mRequestData.getTitle());
        this.mRationaleDescriptionTv.setText((CharSequence)this.mRequestData.getDescription());
        this.mPermissionIconIv.setBackgroundResource(this.mRequestData.getPermissionIconId());
        this.mRationaleTitleTv.setVisibility(0);
        this.mRationaleDescriptionTv.setVisibility(0);
        this.mPermissionIconIv.setVisibility(0);
    }

    private void hidePermissionRationale() {
        this.mRationaleTitleTv.setVisibility(4);
        this.mRationaleDescriptionTv.setVisibility(4);
        this.mPermissionIconIv.setVisibility(4);
    }

    private boolean isAllPermissionsGranted(@NonNull int[] grantResults) {
        for (int result : grantResults) {
            if (result == 0) continue;
            return false;
        }
        return true;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return true;
    }

    private static /* synthetic */ boolean lambda$showSettingsTip$2(Dialog permissionTipDialog, DialogInterface dialog, int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.getAction() == 1) {
            permissionTipDialog.dismiss();
        }
        return true;
    }

    private /* synthetic */ void lambda$showSettingsTip$1(Dialog permissionTipDialog, View v) {
        permissionTipDialog.dismiss();
        this.finishWithResult(PermissionRequester.Result.Denied);
    }

    private /* synthetic */ void lambda$showSettingsTip$0(Dialog permissionTipDialog, View v) {
        permissionTipDialog.dismiss();
        this.launchAppDetailsSettings();
        this.finishWithResult(PermissionRequester.Result.Requesting);
    }
}

