/*
 * Decompiled with CFR 0.152.
 */
package com.trtc.tuikit.common.livedata;

import com.trtc.tuikit.common.livedata.LiveMapObserver;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class LiveMapData<K, V> {
    private final Map<K, V> mData;
    private final List<LiveMapObserver<K, V>> mObservers = new CopyOnWriteArrayList<LiveMapObserver<K, V>>();

    public LiveMapData(Map<K, V> map) {
        this.mData = map;
    }

    public void observe(LiveMapObserver<K, V> observer) {
        if (observer == null || this.mObservers.contains(observer)) {
            return;
        }
        this.mObservers.add(observer);
        observer.onDataChanged(this.mData);
    }

    public void removeObserver(LiveMapObserver<K, V> observer) {
        this.mObservers.remove(observer);
    }

    public Map<K, V> get() {
        return this.mData;
    }

    public void removeAll() {
        this.mObservers.clear();
    }

    public void put(K key, V value) {
        if (value == null) {
            return;
        }
        if (this.mData != null) {
            this.mData.put(key, value);
            for (LiveMapObserver<K, V> observer : this.mObservers) {
                observer.onItemChanged(key, value);
            }
        }
    }

    public void remove(K key) {
        if (this.mData != null) {
            V value = this.mData.remove(key);
            if (value == null) {
                return;
            }
            for (LiveMapObserver<K, V> observer : this.mObservers) {
                observer.onItemRemoved(key, value);
            }
        }
    }

    public void clear() {
        if (this.mData != null) {
            this.mData.clear();
            for (LiveMapObserver<K, V> observer : this.mObservers) {
                observer.onDataChanged(this.mData);
            }
        }
    }
}

