/*
 * Decompiled with CFR 0.152.
 */
package com.trtc.tuikit.common.livedata;

import android.util.Log;
import androidx.annotation.NonNull;
import com.trtc.tuikit.common.livedata.LiveListObserver;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class LiveListData<T> {
    private static final String TAG = "LiveListData";
    private List<T> mList;
    private final List<LiveListObserver<T>> mObservers = new CopyOnWriteArrayList<LiveListObserver<T>>();

    public LiveListData() {
        this.mList = new LinkedList<T>();
    }

    public LiveListData(@NonNull List<T> list) {
        this.mList = list;
    }

    public List<T> getList() {
        return this.mList;
    }

    public void observe(LiveListObserver<T> observer) {
        if (observer == null || this.mObservers.contains(observer)) {
            return;
        }
        this.mObservers.add(observer);
        observer.onDataChanged(this.mList);
    }

    public void removeObserver(LiveListObserver<T> observer) {
        this.mObservers.remove(observer);
    }

    public void add(T item) {
        this.insert(this.mList.size(), item);
    }

    public void insert(T item, Comparator<T> comparator) {
        int position;
        int size = this.mList.size();
        for (position = 0; position < size && comparator.compare(item, this.mList.get(position)) >= 0; ++position) {
        }
        this.insert(position, item);
    }

    public void insert(int position, T item) {
        if (this.mList.contains(item)) {
            return;
        }
        this.mList.add(position, item);
        for (LiveListObserver<T> observer : this.mObservers) {
            observer.onItemInserted(position, item);
        }
    }

    public T remove(T item) {
        int position = this.mList.indexOf(item);
        if (position == -1) {
            return null;
        }
        return this.remove(position);
    }

    public T remove(int position) {
        T item = this.mList.remove(position);
        for (LiveListObserver<T> observer : this.mObservers) {
            observer.onItemRemoved(position, item);
        }
        return item;
    }

    public void clear() {
        this.mList.clear();
        for (LiveListObserver<T> observer : this.mObservers) {
            observer.onDataChanged(this.mList);
        }
    }

    public void redirect(List<T> list) {
        this.mList = list;
        for (LiveListObserver<T> observer : this.mObservers) {
            observer.onDataChanged(this.mList);
        }
    }

    public void replaceAll(List<T> list) {
        if (this.mList == list) {
            Log.e((String)TAG, (String)"Replace the same object, you can use redirect instead.");
            return;
        }
        this.mList.clear();
        this.mList.addAll(list);
        for (LiveListObserver<T> observer : this.mObservers) {
            observer.onDataChanged(this.mList);
        }
    }

    public void change(T item) {
        int index = this.mList.indexOf(item);
        if (index == -1) {
            return;
        }
        this.mList.set(index, item);
        for (LiveListObserver<T> observer : this.mObservers) {
            observer.onItemChanged(index, item);
        }
    }

    public void move(T item, Comparator<T> comparator) {
        int toPosition;
        int fromPosition = this.mList.indexOf(item);
        if (fromPosition == -1) {
            return;
        }
        this.mList.remove(item);
        int size = this.mList.size();
        for (toPosition = 0; toPosition < size && comparator.compare(item, this.mList.get(toPosition)) >= 0; ++toPosition) {
        }
        this.mList.add(toPosition, item);
        for (LiveListObserver<T> observer : this.mObservers) {
            observer.onItemMoved(fromPosition, toPosition, item);
        }
    }

    public void move(int fromPosition, int toPosition) {
        T item = this.mList.remove(fromPosition);
        this.mList.add(toPosition, item);
        for (LiveListObserver<T> observer : this.mObservers) {
            observer.onItemMoved(fromPosition, toPosition, item);
        }
    }

    public boolean contains(T item) {
        return this.mList.contains(item);
    }

    public int indexOf(T item) {
        return this.mList.indexOf(item);
    }

    public T find(T item) {
        int index = this.mList.indexOf(item);
        if (index == -1) {
            return null;
        }
        return this.mList.get(index);
    }

    public T get(int position) {
        return this.mList.get(position);
    }

    public int size() {
        return this.mList.size();
    }

    public boolean isEmpty() {
        return this.mList.isEmpty();
    }
}

