/*
 * Decompiled with CFR 0.152.
 */
package com.trtc.tuikit.common.livedata;

import com.trtc.tuikit.common.livedata.Observer;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class LiveData<T> {
    private static final Object DEFAULT_OBJECT = new Object();
    private volatile Object mData;
    private List<Observer<? super T>> mObservers = new CopyOnWriteArrayList<Observer<? super T>>();

    public LiveData(T value) {
        this.mData = value;
    }

    public LiveData() {
        this.mData = DEFAULT_OBJECT;
    }

    public void observe(Observer<? super T> observer) {
        if (observer == null || this.mObservers.contains(observer)) {
            return;
        }
        this.mObservers.add(observer);
        if (this.mData != DEFAULT_OBJECT) {
            observer.onChanged(this.mData);
        }
    }

    public void removeObserver(Observer<? super T> observer) {
        this.mObservers.remove(observer);
    }

    public void removeAll() {
        this.mObservers.clear();
    }

    public void set(T value) {
        this.set(value, true);
    }

    public void set(T value, boolean isForceNotify) {
        if (this.mData == null) {
            return;
        }
        if (isForceNotify || !this.mData.equals(value)) {
            this.mData = value;
            this.dispatchingValue();
        }
    }

    public void add(Object item) {
        if (this.mData == null) {
            return;
        }
        if (this.mData instanceof HashSet) {
            HashSet hashSet = (HashSet)this.mData;
            int oldSize = hashSet.size();
            hashSet.add(item);
            if (oldSize != hashSet.size()) {
                this.dispatchingValue();
            }
        } else if (this.mData instanceof List) {
            ((List)this.mData).add(item);
            this.dispatchingValue();
        } else if (this.mData instanceof Set) {
            ((Set)this.mData).add(item);
            this.dispatchingValue();
        }
    }

    public void addAll(Collection item) {
        if (this.mData == null) {
            return;
        }
        if (this.mData instanceof List) {
            ((List)this.mData).addAll(item);
            this.dispatchingValue();
        } else if (this.mData instanceof Set) {
            ((Set)this.mData).addAll(item);
            this.dispatchingValue();
        }
    }

    public void remove(Object item) {
        if (this.mData == null) {
            return;
        }
        if (this.mData instanceof HashSet) {
            HashSet hashSet = (HashSet)this.mData;
            int oldSize = hashSet.size();
            hashSet.remove(item);
            if (oldSize != hashSet.size()) {
                this.dispatchingValue();
            }
        } else if (this.mData instanceof List) {
            ((List)this.mData).remove(item);
            this.dispatchingValue();
        } else if (this.mData instanceof Set) {
            ((Set)this.mData).remove(item);
            this.dispatchingValue();
        }
    }

    public void clear() {
        if (this.mData == null) {
            return;
        }
        if (this.mData instanceof List) {
            ((List)this.mData).clear();
            this.dispatchingValue();
        } else if (this.mData instanceof Set) {
            ((Set)this.mData).clear();
            this.dispatchingValue();
        }
    }

    public T get() {
        Object data = this.mData;
        if (data != DEFAULT_OBJECT) {
            return (T)data;
        }
        return null;
    }

    private void dispatchingValue() {
        for (Observer<Object> observer : this.mObservers) {
            observer.onChanged(this.mData);
        }
    }

    public void notifyDataChanged() {
        this.dispatchingValue();
    }
}

